/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPricesResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<ListPricesResponse.Builder, ListPricesResponse> {
    private static final SdkField<List<DomainPrice>> PRICES_FIELD = SdkField
            .<List<DomainPrice>> builder(MarshallingType.LIST)
            .memberName("Prices")
            .getter(getter(ListPricesResponse::prices))
            .setter(setter(Builder::prices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainPrice> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainPrice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageMarker").getter(getter(ListPricesResponse::nextPageMarker))
            .setter(setter(Builder::nextPageMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICES_FIELD,
            NEXT_PAGE_MARKER_FIELD));

    private final List<DomainPrice> prices;

    private final String nextPageMarker;

    private ListPricesResponse(BuilderImpl builder) {
        super(builder);
        this.prices = builder.prices;
        this.nextPageMarker = builder.nextPageMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Prices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrices() {
        return prices != null && !(prices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that includes all the pricing information. If you specify a TLD, this array contains only the
     * pricing for that TLD.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrices} method.
     * </p>
     * 
     * @return A complex type that includes all the pricing information. If you specify a TLD, this array contains only
     *         the pricing for that TLD.
     */
    public final List<DomainPrice> prices() {
        return prices;
    }

    /**
     * <p>
     * If there are more prices than you specified for <code>MaxItems</code> in the request, submit another request and
     * include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     * </p>
     * <p>
     * Used only for all TLDs. If you specify a TLD, don't specify a <code>NextPageMarker</code>.
     * </p>
     * 
     * @return If there are more prices than you specified for <code>MaxItems</code> in the request, submit another
     *         request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>. </p>
     *         <p>
     *         Used only for all TLDs. If you specify a TLD, don't specify a <code>NextPageMarker</code>.
     */
    public final String nextPageMarker() {
        return nextPageMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPrices() ? prices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricesResponse)) {
            return false;
        }
        ListPricesResponse other = (ListPricesResponse) obj;
        return hasPrices() == other.hasPrices() && Objects.equals(prices(), other.prices())
                && Objects.equals(nextPageMarker(), other.nextPageMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPricesResponse").add("Prices", hasPrices() ? prices() : null)
                .add("NextPageMarker", nextPageMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prices":
            return Optional.ofNullable(clazz.cast(prices()));
        case "NextPageMarker":
            return Optional.ofNullable(clazz.cast(nextPageMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPricesResponse, T> g) {
        return obj -> g.apply((ListPricesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPricesResponse> {
        /**
         * <p>
         * A complex type that includes all the pricing information. If you specify a TLD, this array contains only the
         * pricing for that TLD.
         * </p>
         * 
         * @param prices
         *        A complex type that includes all the pricing information. If you specify a TLD, this array contains
         *        only the pricing for that TLD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prices(Collection<DomainPrice> prices);

        /**
         * <p>
         * A complex type that includes all the pricing information. If you specify a TLD, this array contains only the
         * pricing for that TLD.
         * </p>
         * 
         * @param prices
         *        A complex type that includes all the pricing information. If you specify a TLD, this array contains
         *        only the pricing for that TLD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prices(DomainPrice... prices);

        /**
         * <p>
         * A complex type that includes all the pricing information. If you specify a TLD, this array contains only the
         * pricing for that TLD.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53domains.model.DomainPrice.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.route53domains.model.DomainPrice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53domains.model.DomainPrice.Builder#build()} is called
         * immediately and its result is passed to {@link #prices(List<DomainPrice>)}.
         * 
         * @param prices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53domains.model.DomainPrice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prices(java.util.Collection<DomainPrice>)
         */
        Builder prices(Consumer<DomainPrice.Builder>... prices);

        /**
         * <p>
         * If there are more prices than you specified for <code>MaxItems</code> in the request, submit another request
         * and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
         * </p>
         * <p>
         * Used only for all TLDs. If you specify a TLD, don't specify a <code>NextPageMarker</code>.
         * </p>
         * 
         * @param nextPageMarker
         *        If there are more prices than you specified for <code>MaxItems</code> in the request, submit another
         *        request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>. </p>
         *        <p>
         *        Used only for all TLDs. If you specify a TLD, don't specify a <code>NextPageMarker</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageMarker(String nextPageMarker);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private List<DomainPrice> prices = DefaultSdkAutoConstructList.getInstance();

        private String nextPageMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPricesResponse model) {
            super(model);
            prices(model.prices);
            nextPageMarker(model.nextPageMarker);
        }

        public final List<DomainPrice.Builder> getPrices() {
            List<DomainPrice.Builder> result = DomainPriceListCopier.copyToBuilder(this.prices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrices(Collection<DomainPrice.BuilderImpl> prices) {
            this.prices = DomainPriceListCopier.copyFromBuilder(prices);
        }

        @Override
        public final Builder prices(Collection<DomainPrice> prices) {
            this.prices = DomainPriceListCopier.copy(prices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prices(DomainPrice... prices) {
            prices(Arrays.asList(prices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prices(Consumer<DomainPrice.Builder>... prices) {
            prices(Stream.of(prices).map(c -> DomainPrice.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageMarker() {
            return nextPageMarker;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        @Override
        public ListPricesResponse build() {
            return new ListPricesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
