/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ExtraParam includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExtraParam implements SdkPojo, Serializable, ToCopyableBuilder<ExtraParam.Builder, ExtraParam> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ExtraParam::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(ExtraParam::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private ExtraParam(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of an additional parameter that is required by a top-level domain. Here are the top-level domains that
     * require additional parameters and the names of the parameters that they require:
     * </p>
     * <dl>
     * <dt>.com.au and .net.au</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>AU_ID_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AU_ID_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ABN</code> (Australian business number)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACN</code> (Australian company number)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TM</code> (Trademark number)
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>.ca</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>BRAND_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CA_BUSINESS_ENTITY_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BANK</code> (Bank)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMMERCIAL_COMPANY</code> (Commercial company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPANY</code> (Company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COOPERATION</code> (Cooperation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COOPERATIVE</code> (Cooperative)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COOPRIX</code> (Cooprix)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CORP</code> (Corporation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREDIT_UNION</code> (Credit union)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOMIA</code> (Federation of mutual insurance associations)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INC</code> (Incorporated)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LTD</code> (Limited)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LTEE</code> (Limitée)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LLC</code> (Limited liability corporation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LLP</code> (Limited liability partnership)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LTE</code> (Lte.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MBA</code> (Mutual benefit association)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIC</code> (Mutual insurance company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NFP</code> (Not-for-profit corporation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SA</code> (S.A.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_COMPANY</code> (Savings company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_UNION</code> (Savings union)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SARL</code> (Société à responsabilité limitée)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRUST</code> (Trust)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ULC</code> (Unlimited liability corporation)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CA_LEGAL_TYPE</code>
     * </p>
     * <p>
     * When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ABO</code> (Aboriginal Peoples indigenous to Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CCT</code> (Canadian citizen)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RES</code> (Permanent resident of Canada)
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASS</code> (Canadian unincorporated association)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CCO</code> (Canadian corporation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EDU</code> (Canadian educational institution)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOV</code> (Government or government entity in Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOP</code> (Canadian Hospital)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INB</code> (Indian Band recognized by the Indian Act of Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAM</code> (Canadian Library, Archive, or Museum)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MAJ</code> (Her/His Majesty the Queen/King)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OMK</code> (Official mark registered in Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLT</code> (Canadian Political Party)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PRT</code> (Partnership Registered in Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TDM</code> (Trademark registered in Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRD</code> (Canadian Trade Union)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRS</code> (Trust established in Canada)
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>.es</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>ES_IDENTIFICATION</code>
     * </p>
     * <p>
     * The value of <code>ES_IDENTIFICATION</code> depends on the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The value of <code>ES_LEGAL_FORM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The value of <code>ES_IDENTIFICATION_TYPE</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>If <code>ES_LEGAL_FORM</code> is any value other than <code>INDIVIDUAL</code>:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify 1 letter + 8 numbers (CIF [Certificado de Identificación Fiscal])
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: B12345678
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>If <code>ES_LEGAL_FORM</code> is <code>INDIVIDUAL</code>, the value that you specify for
     * <code>ES_IDENTIFICATION</code> depends on the value of <code>ES_IDENTIFICATION_TYPE</code>:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>ES_IDENTIFICATION_TYPE</code> is <code>DNI_AND_NIF</code> (for Spanish contacts):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify 8 numbers + 1 letter (DNI [Documento Nacional de Identidad], NIF [Número de Identificación Fiscal])
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: 12345678M
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * If <code>ES_IDENTIFICATION_TYPE</code> is <code>NIE</code> (for foreigners with legal residence):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify 1 letter + 7 numbers + 1 letter ( NIE [Número de Identidad de Extranjero])
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: Y1234567X
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * If <code>ES_IDENTIFICATION_TYPE</code> is <code>OTHER</code> (for contacts outside of Spain):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify a passport number, drivers license number, or national identity card number
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ES_IDENTIFICATION_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DNI_AND_NIF</code> (For Spanish contacts)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NIE</code> (For foreigners with legal residence)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OTHER</code> (For contacts outside of Spain)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ES_LEGAL_FORM</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASSOCIATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CENTRAL_GOVERNMENT_BODY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CIVIL_SOCIETY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMMUNITY_OF_OWNERS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMMUNITY_PROPERTY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONSULATE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COOPERATIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ECONOMIC_INTEREST_GROUP</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EMBASSY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENTITY_MANAGING_NATURAL_AREAS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FARM_PARTNERSHIP</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOUNDATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GENERAL_PARTNERSHIP</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INDIVIDUAL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LIMITED_COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOCAL_AUTHORITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOCAL_PUBLIC_ENTITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MUTUAL_INSURANCE_COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NATIONAL_PUBLIC_ENTITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OTHERS (Only for contacts outside of Spain)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>POLITICAL_PARTY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROFESSIONAL_ASSOCIATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_LAW_ASSOCIATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_LIMITED_COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGIONAL_GOVERNMENT_BODY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGIONAL_PUBLIC_ENTITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_BANK</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPANISH_OFFICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPORTS_ASSOCIATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPORTS_FEDERATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPORTS_LIMITED_COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRADE_UNION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WORKER_OWNED_COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WORKER_OWNED_LIMITED_COMPANY</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>.eu</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code> EU_COUNTRY_OF_CITIZENSHIP</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>.fi</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FI_BUSINESS_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FI_ID_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FI_NATIONALITY</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FINNISH</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_FINNISH</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>FI_ORGANIZATION_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CORPORATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOVERNMENT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTITUTION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>POLITICAL_PARTY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_COMMUNITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOWNSHIP</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>.it</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>IT_NATIONALITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IT_PIN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IT_REGISTRANT_ENTITY_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FOREIGNERS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_PROFIT_ORGANIZATIONS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OTHER_SUBJECTS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_ORGANIZATIONS</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>.ru</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RU_PASSPORT_DATA</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>.se</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>BIRTH_COUNTRY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SE_ID_NUMBER</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>.sg</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>SG_ID_NUMBER</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>.uk, .co.uk, .me.uk, and .org.uk</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>UK_CONTACT_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CRC</code> (UK Corporation by Royal Charter)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FCORP</code> (Non-UK Corporation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FIND</code> (Non-UK Individual, representing self)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOV</code> (UK Government Body)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IND</code> (UK Individual (representing self))
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IP</code> (UK Industrial/Provident Registered Company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LLP</code> (UK Limited Liability Partnership)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LTD</code> (UK Limited Company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OTHER</code> (UK Entity that does not fit into any other category)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLC</code> (UK Public Limited Company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PTNR</code> (UK Partnership)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RCHAR</code> (UK Registered Charity)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCH</code> (UK School)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STAT</code> (UK Statutory Body)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STRA</code> (UK Sole Trader)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>UK_COMPANY_NUMBER</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * In addition, many TLDs require a <code>VAT_NUMBER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ExtraParamName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of an additional parameter that is required by a top-level domain. Here are the top-level
     *         domains that require additional parameters and the names of the parameters that they require:</p>
     *         <dl>
     *         <dt>.com.au and .net.au</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AU_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AU_ID_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ABN</code> (Australian business number)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACN</code> (Australian company number)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TM</code> (Trademark number)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.ca</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BRAND_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CA_BUSINESS_ENTITY_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BANK</code> (Bank)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMMERCIAL_COMPANY</code> (Commercial company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPANY</code> (Company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COOPERATION</code> (Cooperation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COOPERATIVE</code> (Cooperative)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COOPRIX</code> (Cooprix)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CORP</code> (Corporation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREDIT_UNION</code> (Credit union)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOMIA</code> (Federation of mutual insurance associations)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INC</code> (Incorporated)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LTD</code> (Limited)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LTEE</code> (Limitée)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LLC</code> (Limited liability corporation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LLP</code> (Limited liability partnership)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LTE</code> (Lte.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MBA</code> (Mutual benefit association)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIC</code> (Mutual insurance company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NFP</code> (Not-for-profit corporation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SA</code> (S.A.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_COMPANY</code> (Savings company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_UNION</code> (Savings union)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SARL</code> (Société à responsabilité limitée)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRUST</code> (Trust)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ULC</code> (Unlimited liability corporation)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CA_LEGAL_TYPE</code>
     *         </p>
     *         <p>
     *         When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ABO</code> (Aboriginal Peoples indigenous to Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CCT</code> (Canadian citizen)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RES</code> (Permanent resident of Canada)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the
     *         following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASS</code> (Canadian unincorporated association)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CCO</code> (Canadian corporation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EDU</code> (Canadian educational institution)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOV</code> (Government or government entity in Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOP</code> (Canadian Hospital)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INB</code> (Indian Band recognized by the Indian Act of Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAM</code> (Canadian Library, Archive, or Museum)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MAJ</code> (Her/His Majesty the Queen/King)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OMK</code> (Official mark registered in Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLT</code> (Canadian Political Party)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PRT</code> (Partnership Registered in Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TDM</code> (Trademark registered in Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRD</code> (Canadian Trade Union)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRS</code> (Trust established in Canada)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.es</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ES_IDENTIFICATION</code>
     *         </p>
     *         <p>
     *         The value of <code>ES_IDENTIFICATION</code> depends on the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The value of <code>ES_LEGAL_FORM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The value of <code>ES_IDENTIFICATION_TYPE</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>If <code>ES_LEGAL_FORM</code> is any value other than <code>INDIVIDUAL</code>:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify 1 letter + 8 numbers (CIF [Certificado de Identificación Fiscal])
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Example: B12345678
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>If <code>ES_LEGAL_FORM</code> is <code>INDIVIDUAL</code>, the value that you specify for
     *         <code>ES_IDENTIFICATION</code> depends on the value of <code>ES_IDENTIFICATION_TYPE</code>:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>ES_IDENTIFICATION_TYPE</code> is <code>DNI_AND_NIF</code> (for Spanish contacts):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify 8 numbers + 1 letter (DNI [Documento Nacional de Identidad], NIF [Número de Identificación
     *         Fiscal])
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Example: 12345678M
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>ES_IDENTIFICATION_TYPE</code> is <code>NIE</code> (for foreigners with legal residence):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify 1 letter + 7 numbers + 1 letter ( NIE [Número de Identidad de Extranjero])
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Example: Y1234567X
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>ES_IDENTIFICATION_TYPE</code> is <code>OTHER</code> (for contacts outside of Spain):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a passport number, drivers license number, or national identity card number
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ES_IDENTIFICATION_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DNI_AND_NIF</code> (For Spanish contacts)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NIE</code> (For foreigners with legal residence)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OTHER</code> (For contacts outside of Spain)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ES_LEGAL_FORM</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASSOCIATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CENTRAL_GOVERNMENT_BODY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CIVIL_SOCIETY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMMUNITY_OF_OWNERS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMMUNITY_PROPERTY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONSULATE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COOPERATIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ECONOMIC_INTEREST_GROUP</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EMBASSY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENTITY_MANAGING_NATURAL_AREAS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FARM_PARTNERSHIP</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOUNDATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GENERAL_PARTNERSHIP</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INDIVIDUAL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LIMITED_COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOCAL_AUTHORITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOCAL_PUBLIC_ENTITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MUTUAL_INSURANCE_COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NATIONAL_PUBLIC_ENTITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OTHERS (Only for contacts outside of Spain)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>POLITICAL_PARTY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROFESSIONAL_ASSOCIATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_LAW_ASSOCIATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_LIMITED_COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGIONAL_GOVERNMENT_BODY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGIONAL_PUBLIC_ENTITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_BANK</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPANISH_OFFICE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPORTS_ASSOCIATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPORTS_FEDERATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPORTS_LIMITED_COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRADE_UNION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WORKER_OWNED_COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WORKER_OWNED_LIMITED_COMPANY</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.eu</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code> EU_COUNTRY_OF_CITIZENSHIP</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.fi</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FI_BUSINESS_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FI_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FI_NATIONALITY</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FINNISH</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_FINNISH</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FI_ORGANIZATION_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CORPORATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOVERNMENT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTITUTION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>POLITICAL_PARTY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_COMMUNITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOWNSHIP</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.it</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IT_NATIONALITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IT_PIN</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IT_REGISTRANT_ENTITY_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FOREIGNERS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_PROFIT_ORGANIZATIONS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OTHER_SUBJECTS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_ORGANIZATIONS</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.ru</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RU_PASSPORT_DATA</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.se</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BIRTH_COUNTRY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SE_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.sg</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SG_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.uk, .co.uk, .me.uk, and .org.uk</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UK_CONTACT_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CRC</code> (UK Corporation by Royal Charter)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FCORP</code> (Non-UK Corporation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FIND</code> (Non-UK Individual, representing self)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOV</code> (UK Government Body)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IND</code> (UK Individual (representing self))
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IP</code> (UK Industrial/Provident Registered Company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LLP</code> (UK Limited Liability Partnership)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LTD</code> (UK Limited Company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OTHER</code> (UK Entity that does not fit into any other category)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLC</code> (UK Public Limited Company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PTNR</code> (UK Partnership)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RCHAR</code> (UK Registered Charity)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCH</code> (UK School)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STAT</code> (UK Statutory Body)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STRA</code> (UK Sole Trader)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UK_COMPANY_NUMBER</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         </dl>
     *         <p>
     *         In addition, many TLDs require a <code>VAT_NUMBER</code>.
     * @see ExtraParamName
     */
    public final ExtraParamName name() {
        return ExtraParamName.fromValue(name);
    }

    /**
     * <p>
     * The name of an additional parameter that is required by a top-level domain. Here are the top-level domains that
     * require additional parameters and the names of the parameters that they require:
     * </p>
     * <dl>
     * <dt>.com.au and .net.au</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>AU_ID_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AU_ID_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ABN</code> (Australian business number)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACN</code> (Australian company number)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TM</code> (Trademark number)
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>.ca</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>BRAND_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CA_BUSINESS_ENTITY_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BANK</code> (Bank)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMMERCIAL_COMPANY</code> (Commercial company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPANY</code> (Company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COOPERATION</code> (Cooperation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COOPERATIVE</code> (Cooperative)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COOPRIX</code> (Cooprix)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CORP</code> (Corporation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREDIT_UNION</code> (Credit union)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOMIA</code> (Federation of mutual insurance associations)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INC</code> (Incorporated)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LTD</code> (Limited)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LTEE</code> (Limitée)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LLC</code> (Limited liability corporation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LLP</code> (Limited liability partnership)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LTE</code> (Lte.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MBA</code> (Mutual benefit association)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIC</code> (Mutual insurance company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NFP</code> (Not-for-profit corporation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SA</code> (S.A.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_COMPANY</code> (Savings company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_UNION</code> (Savings union)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SARL</code> (Société à responsabilité limitée)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRUST</code> (Trust)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ULC</code> (Unlimited liability corporation)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CA_LEGAL_TYPE</code>
     * </p>
     * <p>
     * When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ABO</code> (Aboriginal Peoples indigenous to Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CCT</code> (Canadian citizen)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RES</code> (Permanent resident of Canada)
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASS</code> (Canadian unincorporated association)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CCO</code> (Canadian corporation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EDU</code> (Canadian educational institution)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOV</code> (Government or government entity in Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOP</code> (Canadian Hospital)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INB</code> (Indian Band recognized by the Indian Act of Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAM</code> (Canadian Library, Archive, or Museum)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MAJ</code> (Her/His Majesty the Queen/King)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OMK</code> (Official mark registered in Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLT</code> (Canadian Political Party)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PRT</code> (Partnership Registered in Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TDM</code> (Trademark registered in Canada)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRD</code> (Canadian Trade Union)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRS</code> (Trust established in Canada)
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>.es</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>ES_IDENTIFICATION</code>
     * </p>
     * <p>
     * The value of <code>ES_IDENTIFICATION</code> depends on the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The value of <code>ES_LEGAL_FORM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The value of <code>ES_IDENTIFICATION_TYPE</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>If <code>ES_LEGAL_FORM</code> is any value other than <code>INDIVIDUAL</code>:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify 1 letter + 8 numbers (CIF [Certificado de Identificación Fiscal])
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: B12345678
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>If <code>ES_LEGAL_FORM</code> is <code>INDIVIDUAL</code>, the value that you specify for
     * <code>ES_IDENTIFICATION</code> depends on the value of <code>ES_IDENTIFICATION_TYPE</code>:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>ES_IDENTIFICATION_TYPE</code> is <code>DNI_AND_NIF</code> (for Spanish contacts):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify 8 numbers + 1 letter (DNI [Documento Nacional de Identidad], NIF [Número de Identificación Fiscal])
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: 12345678M
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * If <code>ES_IDENTIFICATION_TYPE</code> is <code>NIE</code> (for foreigners with legal residence):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify 1 letter + 7 numbers + 1 letter ( NIE [Número de Identidad de Extranjero])
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: Y1234567X
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * If <code>ES_IDENTIFICATION_TYPE</code> is <code>OTHER</code> (for contacts outside of Spain):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify a passport number, drivers license number, or national identity card number
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ES_IDENTIFICATION_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DNI_AND_NIF</code> (For Spanish contacts)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NIE</code> (For foreigners with legal residence)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OTHER</code> (For contacts outside of Spain)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ES_LEGAL_FORM</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASSOCIATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CENTRAL_GOVERNMENT_BODY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CIVIL_SOCIETY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMMUNITY_OF_OWNERS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMMUNITY_PROPERTY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONSULATE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COOPERATIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ECONOMIC_INTEREST_GROUP</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EMBASSY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENTITY_MANAGING_NATURAL_AREAS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FARM_PARTNERSHIP</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOUNDATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GENERAL_PARTNERSHIP</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INDIVIDUAL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LIMITED_COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOCAL_AUTHORITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOCAL_PUBLIC_ENTITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MUTUAL_INSURANCE_COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NATIONAL_PUBLIC_ENTITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OTHERS (Only for contacts outside of Spain)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>POLITICAL_PARTY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROFESSIONAL_ASSOCIATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_LAW_ASSOCIATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_LIMITED_COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGIONAL_GOVERNMENT_BODY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGIONAL_PUBLIC_ENTITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_BANK</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPANISH_OFFICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPORTS_ASSOCIATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPORTS_FEDERATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPORTS_LIMITED_COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRADE_UNION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WORKER_OWNED_COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WORKER_OWNED_LIMITED_COMPANY</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>.eu</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code> EU_COUNTRY_OF_CITIZENSHIP</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>.fi</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FI_BUSINESS_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FI_ID_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FI_NATIONALITY</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FINNISH</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_FINNISH</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>FI_ORGANIZATION_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPANY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CORPORATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOVERNMENT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTITUTION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>POLITICAL_PARTY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_COMMUNITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOWNSHIP</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>.it</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>IT_NATIONALITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IT_PIN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IT_REGISTRANT_ENTITY_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FOREIGNERS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_PROFIT_ORGANIZATIONS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OTHER_SUBJECTS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC_ORGANIZATIONS</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>.ru</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RU_PASSPORT_DATA</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>.se</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>BIRTH_COUNTRY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SE_ID_NUMBER</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>.sg</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>SG_ID_NUMBER</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>.uk, .co.uk, .me.uk, and .org.uk</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>UK_CONTACT_TYPE</code>
     * </p>
     * <p>
     * Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CRC</code> (UK Corporation by Royal Charter)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FCORP</code> (Non-UK Corporation)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FIND</code> (Non-UK Individual, representing self)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOV</code> (UK Government Body)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IND</code> (UK Individual (representing self))
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IP</code> (UK Industrial/Provident Registered Company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LLP</code> (UK Limited Liability Partnership)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LTD</code> (UK Limited Company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OTHER</code> (UK Entity that does not fit into any other category)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLC</code> (UK Public Limited Company)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PTNR</code> (UK Partnership)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RCHAR</code> (UK Registered Charity)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCH</code> (UK School)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STAT</code> (UK Statutory Body)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STRA</code> (UK Sole Trader)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>UK_COMPANY_NUMBER</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * In addition, many TLDs require a <code>VAT_NUMBER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ExtraParamName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of an additional parameter that is required by a top-level domain. Here are the top-level
     *         domains that require additional parameters and the names of the parameters that they require:</p>
     *         <dl>
     *         <dt>.com.au and .net.au</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AU_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AU_ID_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ABN</code> (Australian business number)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACN</code> (Australian company number)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TM</code> (Trademark number)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.ca</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BRAND_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CA_BUSINESS_ENTITY_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BANK</code> (Bank)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMMERCIAL_COMPANY</code> (Commercial company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPANY</code> (Company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COOPERATION</code> (Cooperation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COOPERATIVE</code> (Cooperative)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COOPRIX</code> (Cooprix)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CORP</code> (Corporation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREDIT_UNION</code> (Credit union)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOMIA</code> (Federation of mutual insurance associations)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INC</code> (Incorporated)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LTD</code> (Limited)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LTEE</code> (Limitée)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LLC</code> (Limited liability corporation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LLP</code> (Limited liability partnership)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LTE</code> (Lte.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MBA</code> (Mutual benefit association)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIC</code> (Mutual insurance company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NFP</code> (Not-for-profit corporation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SA</code> (S.A.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_COMPANY</code> (Savings company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_UNION</code> (Savings union)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SARL</code> (Société à responsabilité limitée)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRUST</code> (Trust)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ULC</code> (Unlimited liability corporation)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CA_LEGAL_TYPE</code>
     *         </p>
     *         <p>
     *         When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ABO</code> (Aboriginal Peoples indigenous to Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CCT</code> (Canadian citizen)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RES</code> (Permanent resident of Canada)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the
     *         following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASS</code> (Canadian unincorporated association)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CCO</code> (Canadian corporation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EDU</code> (Canadian educational institution)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOV</code> (Government or government entity in Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOP</code> (Canadian Hospital)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INB</code> (Indian Band recognized by the Indian Act of Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAM</code> (Canadian Library, Archive, or Museum)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MAJ</code> (Her/His Majesty the Queen/King)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OMK</code> (Official mark registered in Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLT</code> (Canadian Political Party)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PRT</code> (Partnership Registered in Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TDM</code> (Trademark registered in Canada)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRD</code> (Canadian Trade Union)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRS</code> (Trust established in Canada)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.es</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ES_IDENTIFICATION</code>
     *         </p>
     *         <p>
     *         The value of <code>ES_IDENTIFICATION</code> depends on the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The value of <code>ES_LEGAL_FORM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The value of <code>ES_IDENTIFICATION_TYPE</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>If <code>ES_LEGAL_FORM</code> is any value other than <code>INDIVIDUAL</code>:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify 1 letter + 8 numbers (CIF [Certificado de Identificación Fiscal])
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Example: B12345678
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>If <code>ES_LEGAL_FORM</code> is <code>INDIVIDUAL</code>, the value that you specify for
     *         <code>ES_IDENTIFICATION</code> depends on the value of <code>ES_IDENTIFICATION_TYPE</code>:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>ES_IDENTIFICATION_TYPE</code> is <code>DNI_AND_NIF</code> (for Spanish contacts):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify 8 numbers + 1 letter (DNI [Documento Nacional de Identidad], NIF [Número de Identificación
     *         Fiscal])
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Example: 12345678M
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>ES_IDENTIFICATION_TYPE</code> is <code>NIE</code> (for foreigners with legal residence):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify 1 letter + 7 numbers + 1 letter ( NIE [Número de Identidad de Extranjero])
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Example: Y1234567X
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>ES_IDENTIFICATION_TYPE</code> is <code>OTHER</code> (for contacts outside of Spain):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a passport number, drivers license number, or national identity card number
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ES_IDENTIFICATION_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DNI_AND_NIF</code> (For Spanish contacts)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NIE</code> (For foreigners with legal residence)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OTHER</code> (For contacts outside of Spain)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ES_LEGAL_FORM</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASSOCIATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CENTRAL_GOVERNMENT_BODY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CIVIL_SOCIETY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMMUNITY_OF_OWNERS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMMUNITY_PROPERTY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONSULATE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COOPERATIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ECONOMIC_INTEREST_GROUP</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EMBASSY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENTITY_MANAGING_NATURAL_AREAS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FARM_PARTNERSHIP</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOUNDATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GENERAL_PARTNERSHIP</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INDIVIDUAL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LIMITED_COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOCAL_AUTHORITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOCAL_PUBLIC_ENTITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MUTUAL_INSURANCE_COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NATIONAL_PUBLIC_ENTITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OTHERS (Only for contacts outside of Spain)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>POLITICAL_PARTY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROFESSIONAL_ASSOCIATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_LAW_ASSOCIATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_LIMITED_COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGIONAL_GOVERNMENT_BODY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGIONAL_PUBLIC_ENTITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_BANK</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPANISH_OFFICE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPORTS_ASSOCIATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPORTS_FEDERATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPORTS_LIMITED_COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRADE_UNION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WORKER_OWNED_COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WORKER_OWNED_LIMITED_COMPANY</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.eu</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code> EU_COUNTRY_OF_CITIZENSHIP</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.fi</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FI_BUSINESS_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FI_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FI_NATIONALITY</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FINNISH</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_FINNISH</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FI_ORGANIZATION_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPANY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CORPORATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOVERNMENT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTITUTION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>POLITICAL_PARTY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_COMMUNITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOWNSHIP</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.it</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IT_NATIONALITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IT_PIN</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IT_REGISTRANT_ENTITY_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FOREIGNERS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_PROFIT_ORGANIZATIONS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OTHER_SUBJECTS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC_ORGANIZATIONS</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.ru</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RU_PASSPORT_DATA</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.se</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BIRTH_COUNTRY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SE_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.sg</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SG_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>.uk, .co.uk, .me.uk, and .org.uk</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UK_CONTACT_TYPE</code>
     *         </p>
     *         <p>
     *         Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CRC</code> (UK Corporation by Royal Charter)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FCORP</code> (Non-UK Corporation)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FIND</code> (Non-UK Individual, representing self)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOV</code> (UK Government Body)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IND</code> (UK Individual (representing self))
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IP</code> (UK Industrial/Provident Registered Company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LLP</code> (UK Limited Liability Partnership)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LTD</code> (UK Limited Company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OTHER</code> (UK Entity that does not fit into any other category)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLC</code> (UK Public Limited Company)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PTNR</code> (UK Partnership)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RCHAR</code> (UK Registered Charity)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCH</code> (UK School)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STAT</code> (UK Statutory Body)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STRA</code> (UK Sole Trader)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UK_COMPANY_NUMBER</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         </dl>
     *         <p>
     *         In addition, many TLDs require a <code>VAT_NUMBER</code>.
     * @see ExtraParamName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The value that corresponds with the name of an extra parameter.
     * </p>
     * 
     * @return The value that corresponds with the name of an extra parameter.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtraParam)) {
            return false;
        }
        ExtraParam other = (ExtraParam) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExtraParam").add("Name", nameAsString())
                .add("Value", value() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExtraParam, T> g) {
        return obj -> g.apply((ExtraParam) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExtraParam> {
        /**
         * <p>
         * The name of an additional parameter that is required by a top-level domain. Here are the top-level domains
         * that require additional parameters and the names of the parameters that they require:
         * </p>
         * <dl>
         * <dt>.com.au and .net.au</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>AU_ID_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AU_ID_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ABN</code> (Australian business number)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACN</code> (Australian company number)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TM</code> (Trademark number)
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>.ca</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>BRAND_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CA_BUSINESS_ENTITY_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BANK</code> (Bank)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMMERCIAL_COMPANY</code> (Commercial company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPANY</code> (Company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COOPERATION</code> (Cooperation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COOPERATIVE</code> (Cooperative)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COOPRIX</code> (Cooprix)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CORP</code> (Corporation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREDIT_UNION</code> (Credit union)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOMIA</code> (Federation of mutual insurance associations)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INC</code> (Incorporated)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LTD</code> (Limited)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LTEE</code> (Limitée)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LLC</code> (Limited liability corporation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LLP</code> (Limited liability partnership)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LTE</code> (Lte.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MBA</code> (Mutual benefit association)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIC</code> (Mutual insurance company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NFP</code> (Not-for-profit corporation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SA</code> (S.A.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_COMPANY</code> (Savings company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_UNION</code> (Savings union)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SARL</code> (Société à responsabilité limitée)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRUST</code> (Trust)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ULC</code> (Unlimited liability corporation)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CA_LEGAL_TYPE</code>
         * </p>
         * <p>
         * When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ABO</code> (Aboriginal Peoples indigenous to Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CCT</code> (Canadian citizen)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RES</code> (Permanent resident of Canada)
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASS</code> (Canadian unincorporated association)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CCO</code> (Canadian corporation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EDU</code> (Canadian educational institution)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOV</code> (Government or government entity in Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOP</code> (Canadian Hospital)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INB</code> (Indian Band recognized by the Indian Act of Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAM</code> (Canadian Library, Archive, or Museum)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MAJ</code> (Her/His Majesty the Queen/King)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OMK</code> (Official mark registered in Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLT</code> (Canadian Political Party)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PRT</code> (Partnership Registered in Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TDM</code> (Trademark registered in Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRD</code> (Canadian Trade Union)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRS</code> (Trust established in Canada)
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>.es</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>ES_IDENTIFICATION</code>
         * </p>
         * <p>
         * The value of <code>ES_IDENTIFICATION</code> depends on the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The value of <code>ES_LEGAL_FORM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The value of <code>ES_IDENTIFICATION_TYPE</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>If <code>ES_LEGAL_FORM</code> is any value other than <code>INDIVIDUAL</code>:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specify 1 letter + 8 numbers (CIF [Certificado de Identificación Fiscal])
         * </p>
         * </li>
         * <li>
         * <p>
         * Example: B12345678
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>If <code>ES_LEGAL_FORM</code> is <code>INDIVIDUAL</code>, the value that you specify for
         * <code>ES_IDENTIFICATION</code> depends on the value of <code>ES_IDENTIFICATION_TYPE</code>:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * If <code>ES_IDENTIFICATION_TYPE</code> is <code>DNI_AND_NIF</code> (for Spanish contacts):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specify 8 numbers + 1 letter (DNI [Documento Nacional de Identidad], NIF [Número de Identificación Fiscal])
         * </p>
         * </li>
         * <li>
         * <p>
         * Example: 12345678M
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * If <code>ES_IDENTIFICATION_TYPE</code> is <code>NIE</code> (for foreigners with legal residence):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specify 1 letter + 7 numbers + 1 letter ( NIE [Número de Identidad de Extranjero])
         * </p>
         * </li>
         * <li>
         * <p>
         * Example: Y1234567X
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * If <code>ES_IDENTIFICATION_TYPE</code> is <code>OTHER</code> (for contacts outside of Spain):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specify a passport number, drivers license number, or national identity card number
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ES_IDENTIFICATION_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DNI_AND_NIF</code> (For Spanish contacts)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NIE</code> (For foreigners with legal residence)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OTHER</code> (For contacts outside of Spain)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ES_LEGAL_FORM</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASSOCIATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CENTRAL_GOVERNMENT_BODY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CIVIL_SOCIETY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMMUNITY_OF_OWNERS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMMUNITY_PROPERTY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONSULATE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COOPERATIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ECONOMIC_INTEREST_GROUP</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EMBASSY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENTITY_MANAGING_NATURAL_AREAS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FARM_PARTNERSHIP</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOUNDATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GENERAL_PARTNERSHIP</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INDIVIDUAL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LIMITED_COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOCAL_AUTHORITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOCAL_PUBLIC_ENTITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MUTUAL_INSURANCE_COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NATIONAL_PUBLIC_ENTITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OTHERS (Only for contacts outside of Spain)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>POLITICAL_PARTY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROFESSIONAL_ASSOCIATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_LAW_ASSOCIATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_LIMITED_COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGIONAL_GOVERNMENT_BODY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGIONAL_PUBLIC_ENTITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_BANK</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPANISH_OFFICE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPORTS_ASSOCIATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPORTS_FEDERATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPORTS_LIMITED_COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRADE_UNION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WORKER_OWNED_COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WORKER_OWNED_LIMITED_COMPANY</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>.eu</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code> EU_COUNTRY_OF_CITIZENSHIP</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>.fi</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FI_BUSINESS_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FI_ID_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FI_NATIONALITY</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FINNISH</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_FINNISH</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>FI_ORGANIZATION_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CORPORATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOVERNMENT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTITUTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>POLITICAL_PARTY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_COMMUNITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOWNSHIP</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>.it</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>IT_NATIONALITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IT_PIN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IT_REGISTRANT_ENTITY_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FOREIGNERS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_PROFIT_ORGANIZATIONS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OTHER_SUBJECTS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_ORGANIZATIONS</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>.ru</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RU_PASSPORT_DATA</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>.se</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>BIRTH_COUNTRY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SE_ID_NUMBER</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>.sg</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>SG_ID_NUMBER</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>.uk, .co.uk, .me.uk, and .org.uk</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>UK_CONTACT_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CRC</code> (UK Corporation by Royal Charter)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FCORP</code> (Non-UK Corporation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIND</code> (Non-UK Individual, representing self)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOV</code> (UK Government Body)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IND</code> (UK Individual (representing self))
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IP</code> (UK Industrial/Provident Registered Company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LLP</code> (UK Limited Liability Partnership)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LTD</code> (UK Limited Company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OTHER</code> (UK Entity that does not fit into any other category)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLC</code> (UK Public Limited Company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PTNR</code> (UK Partnership)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RCHAR</code> (UK Registered Charity)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCH</code> (UK School)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STAT</code> (UK Statutory Body)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STRA</code> (UK Sole Trader)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>UK_COMPANY_NUMBER</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * <p>
         * In addition, many TLDs require a <code>VAT_NUMBER</code>.
         * </p>
         * 
         * @param name
         *        The name of an additional parameter that is required by a top-level domain. Here are the top-level
         *        domains that require additional parameters and the names of the parameters that they require:</p>
         *        <dl>
         *        <dt>.com.au and .net.au</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AU_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AU_ID_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ABN</code> (Australian business number)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACN</code> (Australian company number)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TM</code> (Trademark number)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.ca</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BRAND_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CA_BUSINESS_ENTITY_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BANK</code> (Bank)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMMERCIAL_COMPANY</code> (Commercial company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPANY</code> (Company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COOPERATION</code> (Cooperation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COOPERATIVE</code> (Cooperative)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COOPRIX</code> (Cooprix)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CORP</code> (Corporation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREDIT_UNION</code> (Credit union)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOMIA</code> (Federation of mutual insurance associations)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INC</code> (Incorporated)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LTD</code> (Limited)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LTEE</code> (Limitée)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LLC</code> (Limited liability corporation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LLP</code> (Limited liability partnership)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LTE</code> (Lte.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MBA</code> (Mutual benefit association)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIC</code> (Mutual insurance company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NFP</code> (Not-for-profit corporation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SA</code> (S.A.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_COMPANY</code> (Savings company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_UNION</code> (Savings union)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SARL</code> (Société à responsabilité limitée)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRUST</code> (Trust)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ULC</code> (Unlimited liability corporation)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CA_LEGAL_TYPE</code>
         *        </p>
         *        <p>
         *        When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ABO</code> (Aboriginal Peoples indigenous to Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CCT</code> (Canadian citizen)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RES</code> (Permanent resident of Canada)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the
         *        following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASS</code> (Canadian unincorporated association)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CCO</code> (Canadian corporation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EDU</code> (Canadian educational institution)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOV</code> (Government or government entity in Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOP</code> (Canadian Hospital)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INB</code> (Indian Band recognized by the Indian Act of Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAM</code> (Canadian Library, Archive, or Museum)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MAJ</code> (Her/His Majesty the Queen/King)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OMK</code> (Official mark registered in Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLT</code> (Canadian Political Party)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PRT</code> (Partnership Registered in Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TDM</code> (Trademark registered in Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRD</code> (Canadian Trade Union)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRS</code> (Trust established in Canada)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.es</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ES_IDENTIFICATION</code>
         *        </p>
         *        <p>
         *        The value of <code>ES_IDENTIFICATION</code> depends on the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The value of <code>ES_LEGAL_FORM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value of <code>ES_IDENTIFICATION_TYPE</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>If <code>ES_LEGAL_FORM</code> is any value other than <code>INDIVIDUAL</code>:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specify 1 letter + 8 numbers (CIF [Certificado de Identificación Fiscal])
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Example: B12345678
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>If <code>ES_LEGAL_FORM</code> is <code>INDIVIDUAL</code>, the value that you specify for
         *        <code>ES_IDENTIFICATION</code> depends on the value of <code>ES_IDENTIFICATION_TYPE</code>:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If <code>ES_IDENTIFICATION_TYPE</code> is <code>DNI_AND_NIF</code> (for Spanish contacts):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specify 8 numbers + 1 letter (DNI [Documento Nacional de Identidad], NIF [Número de Identificación
         *        Fiscal])
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Example: 12345678M
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>ES_IDENTIFICATION_TYPE</code> is <code>NIE</code> (for foreigners with legal residence):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specify 1 letter + 7 numbers + 1 letter ( NIE [Número de Identidad de Extranjero])
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Example: Y1234567X
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>ES_IDENTIFICATION_TYPE</code> is <code>OTHER</code> (for contacts outside of Spain):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specify a passport number, drivers license number, or national identity card number
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ES_IDENTIFICATION_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DNI_AND_NIF</code> (For Spanish contacts)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NIE</code> (For foreigners with legal residence)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OTHER</code> (For contacts outside of Spain)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ES_LEGAL_FORM</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASSOCIATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CENTRAL_GOVERNMENT_BODY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CIVIL_SOCIETY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMMUNITY_OF_OWNERS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMMUNITY_PROPERTY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONSULATE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COOPERATIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ECONOMIC_INTEREST_GROUP</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMBASSY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENTITY_MANAGING_NATURAL_AREAS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FARM_PARTNERSHIP</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOUNDATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GENERAL_PARTNERSHIP</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INDIVIDUAL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LIMITED_COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOCAL_AUTHORITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOCAL_PUBLIC_ENTITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MUTUAL_INSURANCE_COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NATIONAL_PUBLIC_ENTITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OTHERS (Only for contacts outside of Spain)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>POLITICAL_PARTY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROFESSIONAL_ASSOCIATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_LAW_ASSOCIATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_LIMITED_COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGIONAL_GOVERNMENT_BODY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGIONAL_PUBLIC_ENTITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_BANK</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPANISH_OFFICE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPORTS_ASSOCIATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPORTS_FEDERATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPORTS_LIMITED_COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRADE_UNION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WORKER_OWNED_COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WORKER_OWNED_LIMITED_COMPANY</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.eu</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code> EU_COUNTRY_OF_CITIZENSHIP</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.fi</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FI_BUSINESS_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FI_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FI_NATIONALITY</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FINNISH</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_FINNISH</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FI_ORGANIZATION_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CORPORATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOVERNMENT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTITUTION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>POLITICAL_PARTY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_COMMUNITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOWNSHIP</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.it</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IT_NATIONALITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IT_PIN</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IT_REGISTRANT_ENTITY_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FOREIGNERS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_PROFIT_ORGANIZATIONS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OTHER_SUBJECTS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_ORGANIZATIONS</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.ru</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RU_PASSPORT_DATA</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.se</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BIRTH_COUNTRY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SE_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.sg</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SG_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.uk, .co.uk, .me.uk, and .org.uk</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UK_CONTACT_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CRC</code> (UK Corporation by Royal Charter)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FCORP</code> (Non-UK Corporation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIND</code> (Non-UK Individual, representing self)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOV</code> (UK Government Body)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IND</code> (UK Individual (representing self))
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IP</code> (UK Industrial/Provident Registered Company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LLP</code> (UK Limited Liability Partnership)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LTD</code> (UK Limited Company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OTHER</code> (UK Entity that does not fit into any other category)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLC</code> (UK Public Limited Company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PTNR</code> (UK Partnership)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RCHAR</code> (UK Registered Charity)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCH</code> (UK School)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STAT</code> (UK Statutory Body)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STRA</code> (UK Sole Trader)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UK_COMPANY_NUMBER</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        </dl>
         *        <p>
         *        In addition, many TLDs require a <code>VAT_NUMBER</code>.
         * @see ExtraParamName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExtraParamName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of an additional parameter that is required by a top-level domain. Here are the top-level domains
         * that require additional parameters and the names of the parameters that they require:
         * </p>
         * <dl>
         * <dt>.com.au and .net.au</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>AU_ID_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AU_ID_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ABN</code> (Australian business number)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACN</code> (Australian company number)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TM</code> (Trademark number)
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>.ca</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>BRAND_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CA_BUSINESS_ENTITY_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BANK</code> (Bank)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMMERCIAL_COMPANY</code> (Commercial company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPANY</code> (Company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COOPERATION</code> (Cooperation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COOPERATIVE</code> (Cooperative)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COOPRIX</code> (Cooprix)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CORP</code> (Corporation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREDIT_UNION</code> (Credit union)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOMIA</code> (Federation of mutual insurance associations)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INC</code> (Incorporated)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LTD</code> (Limited)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LTEE</code> (Limitée)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LLC</code> (Limited liability corporation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LLP</code> (Limited liability partnership)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LTE</code> (Lte.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MBA</code> (Mutual benefit association)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIC</code> (Mutual insurance company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NFP</code> (Not-for-profit corporation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SA</code> (S.A.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_COMPANY</code> (Savings company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_UNION</code> (Savings union)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SARL</code> (Société à responsabilité limitée)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRUST</code> (Trust)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ULC</code> (Unlimited liability corporation)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CA_LEGAL_TYPE</code>
         * </p>
         * <p>
         * When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ABO</code> (Aboriginal Peoples indigenous to Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CCT</code> (Canadian citizen)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RES</code> (Permanent resident of Canada)
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASS</code> (Canadian unincorporated association)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CCO</code> (Canadian corporation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EDU</code> (Canadian educational institution)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOV</code> (Government or government entity in Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOP</code> (Canadian Hospital)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INB</code> (Indian Band recognized by the Indian Act of Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAM</code> (Canadian Library, Archive, or Museum)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MAJ</code> (Her/His Majesty the Queen/King)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OMK</code> (Official mark registered in Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLT</code> (Canadian Political Party)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PRT</code> (Partnership Registered in Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TDM</code> (Trademark registered in Canada)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRD</code> (Canadian Trade Union)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRS</code> (Trust established in Canada)
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>.es</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>ES_IDENTIFICATION</code>
         * </p>
         * <p>
         * The value of <code>ES_IDENTIFICATION</code> depends on the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The value of <code>ES_LEGAL_FORM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The value of <code>ES_IDENTIFICATION_TYPE</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>If <code>ES_LEGAL_FORM</code> is any value other than <code>INDIVIDUAL</code>:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specify 1 letter + 8 numbers (CIF [Certificado de Identificación Fiscal])
         * </p>
         * </li>
         * <li>
         * <p>
         * Example: B12345678
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>If <code>ES_LEGAL_FORM</code> is <code>INDIVIDUAL</code>, the value that you specify for
         * <code>ES_IDENTIFICATION</code> depends on the value of <code>ES_IDENTIFICATION_TYPE</code>:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * If <code>ES_IDENTIFICATION_TYPE</code> is <code>DNI_AND_NIF</code> (for Spanish contacts):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specify 8 numbers + 1 letter (DNI [Documento Nacional de Identidad], NIF [Número de Identificación Fiscal])
         * </p>
         * </li>
         * <li>
         * <p>
         * Example: 12345678M
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * If <code>ES_IDENTIFICATION_TYPE</code> is <code>NIE</code> (for foreigners with legal residence):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specify 1 letter + 7 numbers + 1 letter ( NIE [Número de Identidad de Extranjero])
         * </p>
         * </li>
         * <li>
         * <p>
         * Example: Y1234567X
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * If <code>ES_IDENTIFICATION_TYPE</code> is <code>OTHER</code> (for contacts outside of Spain):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specify a passport number, drivers license number, or national identity card number
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ES_IDENTIFICATION_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DNI_AND_NIF</code> (For Spanish contacts)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NIE</code> (For foreigners with legal residence)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OTHER</code> (For contacts outside of Spain)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ES_LEGAL_FORM</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASSOCIATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CENTRAL_GOVERNMENT_BODY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CIVIL_SOCIETY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMMUNITY_OF_OWNERS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMMUNITY_PROPERTY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONSULATE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COOPERATIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ECONOMIC_INTEREST_GROUP</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EMBASSY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENTITY_MANAGING_NATURAL_AREAS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FARM_PARTNERSHIP</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOUNDATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GENERAL_PARTNERSHIP</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INDIVIDUAL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LIMITED_COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOCAL_AUTHORITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOCAL_PUBLIC_ENTITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MUTUAL_INSURANCE_COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NATIONAL_PUBLIC_ENTITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OTHERS (Only for contacts outside of Spain)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>POLITICAL_PARTY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROFESSIONAL_ASSOCIATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_LAW_ASSOCIATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_LIMITED_COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGIONAL_GOVERNMENT_BODY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGIONAL_PUBLIC_ENTITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_BANK</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPANISH_OFFICE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPORTS_ASSOCIATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPORTS_FEDERATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPORTS_LIMITED_COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRADE_UNION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WORKER_OWNED_COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WORKER_OWNED_LIMITED_COMPANY</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>.eu</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code> EU_COUNTRY_OF_CITIZENSHIP</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>.fi</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FI_BUSINESS_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FI_ID_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FI_NATIONALITY</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FINNISH</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_FINNISH</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>FI_ORGANIZATION_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPANY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CORPORATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOVERNMENT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTITUTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>POLITICAL_PARTY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_COMMUNITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOWNSHIP</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>.it</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>IT_NATIONALITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IT_PIN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IT_REGISTRANT_ENTITY_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FOREIGNERS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_PROFIT_ORGANIZATIONS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OTHER_SUBJECTS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC_ORGANIZATIONS</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>.ru</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RU_PASSPORT_DATA</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>.se</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>BIRTH_COUNTRY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SE_ID_NUMBER</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>.sg</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>SG_ID_NUMBER</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>.uk, .co.uk, .me.uk, and .org.uk</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>UK_CONTACT_TYPE</code>
         * </p>
         * <p>
         * Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CRC</code> (UK Corporation by Royal Charter)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FCORP</code> (Non-UK Corporation)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIND</code> (Non-UK Individual, representing self)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOV</code> (UK Government Body)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IND</code> (UK Individual (representing self))
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IP</code> (UK Industrial/Provident Registered Company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LLP</code> (UK Limited Liability Partnership)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LTD</code> (UK Limited Company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OTHER</code> (UK Entity that does not fit into any other category)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLC</code> (UK Public Limited Company)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PTNR</code> (UK Partnership)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RCHAR</code> (UK Registered Charity)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCH</code> (UK School)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STAT</code> (UK Statutory Body)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STRA</code> (UK Sole Trader)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>UK_COMPANY_NUMBER</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * <p>
         * In addition, many TLDs require a <code>VAT_NUMBER</code>.
         * </p>
         * 
         * @param name
         *        The name of an additional parameter that is required by a top-level domain. Here are the top-level
         *        domains that require additional parameters and the names of the parameters that they require:</p>
         *        <dl>
         *        <dt>.com.au and .net.au</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AU_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AU_ID_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ABN</code> (Australian business number)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACN</code> (Australian company number)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TM</code> (Trademark number)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.ca</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BRAND_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CA_BUSINESS_ENTITY_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BANK</code> (Bank)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMMERCIAL_COMPANY</code> (Commercial company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPANY</code> (Company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COOPERATION</code> (Cooperation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COOPERATIVE</code> (Cooperative)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COOPRIX</code> (Cooprix)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CORP</code> (Corporation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREDIT_UNION</code> (Credit union)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOMIA</code> (Federation of mutual insurance associations)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INC</code> (Incorporated)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LTD</code> (Limited)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LTEE</code> (Limitée)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LLC</code> (Limited liability corporation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LLP</code> (Limited liability partnership)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LTE</code> (Lte.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MBA</code> (Mutual benefit association)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIC</code> (Mutual insurance company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NFP</code> (Not-for-profit corporation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SA</code> (S.A.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_COMPANY</code> (Savings company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_UNION</code> (Savings union)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SARL</code> (Société à responsabilité limitée)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRUST</code> (Trust)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ULC</code> (Unlimited liability corporation)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CA_LEGAL_TYPE</code>
         *        </p>
         *        <p>
         *        When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ABO</code> (Aboriginal Peoples indigenous to Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CCT</code> (Canadian citizen)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RES</code> (Permanent resident of Canada)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the
         *        following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASS</code> (Canadian unincorporated association)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CCO</code> (Canadian corporation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EDU</code> (Canadian educational institution)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOV</code> (Government or government entity in Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOP</code> (Canadian Hospital)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INB</code> (Indian Band recognized by the Indian Act of Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAM</code> (Canadian Library, Archive, or Museum)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MAJ</code> (Her/His Majesty the Queen/King)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OMK</code> (Official mark registered in Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLT</code> (Canadian Political Party)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PRT</code> (Partnership Registered in Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TDM</code> (Trademark registered in Canada)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRD</code> (Canadian Trade Union)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRS</code> (Trust established in Canada)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.es</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ES_IDENTIFICATION</code>
         *        </p>
         *        <p>
         *        The value of <code>ES_IDENTIFICATION</code> depends on the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The value of <code>ES_LEGAL_FORM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value of <code>ES_IDENTIFICATION_TYPE</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>If <code>ES_LEGAL_FORM</code> is any value other than <code>INDIVIDUAL</code>:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specify 1 letter + 8 numbers (CIF [Certificado de Identificación Fiscal])
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Example: B12345678
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>If <code>ES_LEGAL_FORM</code> is <code>INDIVIDUAL</code>, the value that you specify for
         *        <code>ES_IDENTIFICATION</code> depends on the value of <code>ES_IDENTIFICATION_TYPE</code>:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If <code>ES_IDENTIFICATION_TYPE</code> is <code>DNI_AND_NIF</code> (for Spanish contacts):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specify 8 numbers + 1 letter (DNI [Documento Nacional de Identidad], NIF [Número de Identificación
         *        Fiscal])
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Example: 12345678M
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>ES_IDENTIFICATION_TYPE</code> is <code>NIE</code> (for foreigners with legal residence):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specify 1 letter + 7 numbers + 1 letter ( NIE [Número de Identidad de Extranjero])
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Example: Y1234567X
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>ES_IDENTIFICATION_TYPE</code> is <code>OTHER</code> (for contacts outside of Spain):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specify a passport number, drivers license number, or national identity card number
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ES_IDENTIFICATION_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DNI_AND_NIF</code> (For Spanish contacts)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NIE</code> (For foreigners with legal residence)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OTHER</code> (For contacts outside of Spain)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ES_LEGAL_FORM</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASSOCIATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CENTRAL_GOVERNMENT_BODY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CIVIL_SOCIETY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMMUNITY_OF_OWNERS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMMUNITY_PROPERTY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONSULATE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COOPERATIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ECONOMIC_INTEREST_GROUP</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMBASSY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENTITY_MANAGING_NATURAL_AREAS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FARM_PARTNERSHIP</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOUNDATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GENERAL_PARTNERSHIP</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INDIVIDUAL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LIMITED_COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOCAL_AUTHORITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOCAL_PUBLIC_ENTITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MUTUAL_INSURANCE_COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NATIONAL_PUBLIC_ENTITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OTHERS (Only for contacts outside of Spain)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>POLITICAL_PARTY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROFESSIONAL_ASSOCIATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_LAW_ASSOCIATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_LIMITED_COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGIONAL_GOVERNMENT_BODY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGIONAL_PUBLIC_ENTITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_BANK</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPANISH_OFFICE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPORTS_ASSOCIATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPORTS_FEDERATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPORTS_LIMITED_COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRADE_UNION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WORKER_OWNED_COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WORKER_OWNED_LIMITED_COMPANY</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.eu</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code> EU_COUNTRY_OF_CITIZENSHIP</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.fi</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FI_BUSINESS_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FI_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FI_NATIONALITY</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FINNISH</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_FINNISH</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FI_ORGANIZATION_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPANY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CORPORATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOVERNMENT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTITUTION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>POLITICAL_PARTY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_COMMUNITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOWNSHIP</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.it</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IT_NATIONALITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IT_PIN</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IT_REGISTRANT_ENTITY_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FOREIGNERS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_PROFIT_ORGANIZATIONS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OTHER_SUBJECTS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC_ORGANIZATIONS</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.ru</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RU_PASSPORT_DATA</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.se</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BIRTH_COUNTRY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SE_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.sg</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SG_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>.uk, .co.uk, .me.uk, and .org.uk</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UK_CONTACT_TYPE</code>
         *        </p>
         *        <p>
         *        Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CRC</code> (UK Corporation by Royal Charter)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FCORP</code> (Non-UK Corporation)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIND</code> (Non-UK Individual, representing self)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOV</code> (UK Government Body)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IND</code> (UK Individual (representing self))
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IP</code> (UK Industrial/Provident Registered Company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LLP</code> (UK Limited Liability Partnership)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LTD</code> (UK Limited Company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OTHER</code> (UK Entity that does not fit into any other category)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLC</code> (UK Public Limited Company)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PTNR</code> (UK Partnership)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RCHAR</code> (UK Registered Charity)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCH</code> (UK School)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STAT</code> (UK Statutory Body)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STRA</code> (UK Sole Trader)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UK_COMPANY_NUMBER</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        </dl>
         *        <p>
         *        In addition, many TLDs require a <code>VAT_NUMBER</code>.
         * @see ExtraParamName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExtraParamName
         */
        Builder name(ExtraParamName name);

        /**
         * <p>
         * The value that corresponds with the name of an extra parameter.
         * </p>
         * 
         * @param value
         *        The value that corresponds with the name of an extra parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtraParam model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ExtraParamName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public ExtraParam build() {
            return new ExtraParam(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
