/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53domains.Route53DomainsClient;
import software.amazon.awssdk.services.route53domains.model.DomainPrice;
import software.amazon.awssdk.services.route53domains.model.ListPricesRequest;
import software.amazon.awssdk.services.route53domains.model.ListPricesResponse;

public class ListPricesIterable
implements SdkIterable<ListPricesResponse> {
    private final Route53DomainsClient client;
    private final ListPricesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPricesIterable(Route53DomainsClient client, ListPricesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPricesResponseFetcher();
    }

    public Iterator<ListPricesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DomainPrice> prices() {
        Function<ListPricesResponse, Iterator> getIterator = response -> {
            if (response != null && response.prices() != null) {
                return response.prices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPricesResponseFetcher
    implements SyncPageFetcher<ListPricesResponse> {
        private ListPricesResponseFetcher() {
        }

        public boolean hasNextPage(ListPricesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageMarker());
        }

        public ListPricesResponse nextPage(ListPricesResponse previousPage) {
            if (previousPage == null) {
                return ListPricesIterable.this.client.listPrices(ListPricesIterable.this.firstRequest);
            }
            return ListPricesIterable.this.client.listPrices((ListPricesRequest)((Object)ListPricesIterable.this.firstRequest.toBuilder().marker(previousPage.nextPageMarker()).build()));
        }
    }
}

