/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object that is specified in resource record set object when you are linking a resource record set to a CIDR
 * location.
 * </p>
 * <p>
 * A <code>LocationName</code> with an asterisk “*” can be used to create a default CIDR record.
 * <code>CollectionId</code> is still required for default record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CidrRoutingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CidrRoutingConfig.Builder, CidrRoutingConfig> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CollectionId")
            .getter(getter(CidrRoutingConfig::collectionId))
            .setter(setter(Builder::collectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId")
                    .unmarshallLocationName("CollectionId").build()).build();

    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocationName")
            .getter(getter(CidrRoutingConfig::locationName))
            .setter(setter(Builder::locationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationName")
                    .unmarshallLocationName("LocationName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD,
            LOCATION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String collectionId;

    private final String locationName;

    private CidrRoutingConfig(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.locationName = builder.locationName;
    }

    /**
     * <p>
     * The CIDR collection ID.
     * </p>
     * 
     * @return The CIDR collection ID.
     */
    public final String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * The CIDR collection location name.
     * </p>
     * 
     * @return The CIDR collection location name.
     */
    public final String locationName() {
        return locationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(locationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CidrRoutingConfig)) {
            return false;
        }
        CidrRoutingConfig other = (CidrRoutingConfig) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(locationName(), other.locationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CidrRoutingConfig").add("CollectionId", collectionId()).add("LocationName", locationName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.ofNullable(clazz.cast(collectionId()));
        case "LocationName":
            return Optional.ofNullable(clazz.cast(locationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CidrRoutingConfig, T> g) {
        return obj -> g.apply((CidrRoutingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CidrRoutingConfig> {
        /**
         * <p>
         * The CIDR collection ID.
         * </p>
         * 
         * @param collectionId
         *        The CIDR collection ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * The CIDR collection location name.
         * </p>
         * 
         * @param locationName
         *        The CIDR collection location name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationName(String locationName);
    }

    static final class BuilderImpl implements Builder {
        private String collectionId;

        private String locationName;

        private BuilderImpl() {
        }

        private BuilderImpl(CidrRoutingConfig model) {
            collectionId(model.collectionId);
            locationName(model.locationName);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final String getLocationName() {
            return locationName;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        @Override
        public CidrRoutingConfig build() {
            return new CidrRoutingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
