/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * (Private hosted zones only) A complex type that contains information about an Amazon VPC.
 * </p>
 * <p>
 * If you associate a private hosted zone with an Amazon VPC when you make a <a
 * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html">CreateHostedZone</a>
 * request, the following parameters are also required.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VPC implements SdkPojo, Serializable, ToCopyableBuilder<VPC.Builder, VPC> {
    private static final SdkField<String> VPC_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VPCRegion")
            .getter(getter(VPC::vpcRegionAsString))
            .setter(setter(Builder::vpcRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCRegion")
                    .unmarshallLocationName("VPCRegion").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VPCId")
            .getter(getter(VPC::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCId")
                    .unmarshallLocationName("VPCId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VPC_REGION_FIELD, VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vpcRegion;

    private final String vpcId;

    private VPC(BuilderImpl builder) {
        this.vpcRegion = builder.vpcRegion;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * (Private hosted zones only) The region that an Amazon VPC was created in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcRegion} will
     * return {@link VPCRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vpcRegionAsString}.
     * </p>
     * 
     * @return (Private hosted zones only) The region that an Amazon VPC was created in.
     * @see VPCRegion
     */
    public final VPCRegion vpcRegion() {
        return VPCRegion.fromValue(vpcRegion);
    }

    /**
     * <p>
     * (Private hosted zones only) The region that an Amazon VPC was created in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcRegion} will
     * return {@link VPCRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vpcRegionAsString}.
     * </p>
     * 
     * @return (Private hosted zones only) The region that an Amazon VPC was created in.
     * @see VPCRegion
     */
    public final String vpcRegionAsString() {
        return vpcRegion;
    }

    /**
     * Returns the value of the VPCId property for this object.
     * 
     * @return The value of the VPCId property for this object.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPC)) {
            return false;
        }
        VPC other = (VPC) obj;
        return Objects.equals(vpcRegionAsString(), other.vpcRegionAsString()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VPC").add("VPCRegion", vpcRegionAsString()).add("VPCId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VPCRegion":
            return Optional.ofNullable(clazz.cast(vpcRegionAsString()));
        case "VPCId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VPC, T> g) {
        return obj -> g.apply((VPC) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VPC> {
        /**
         * <p>
         * (Private hosted zones only) The region that an Amazon VPC was created in.
         * </p>
         * 
         * @param vpcRegion
         *        (Private hosted zones only) The region that an Amazon VPC was created in.
         * @see VPCRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCRegion
         */
        Builder vpcRegion(String vpcRegion);

        /**
         * <p>
         * (Private hosted zones only) The region that an Amazon VPC was created in.
         * </p>
         * 
         * @param vpcRegion
         *        (Private hosted zones only) The region that an Amazon VPC was created in.
         * @see VPCRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCRegion
         */
        Builder vpcRegion(VPCRegion vpcRegion);

        /**
         * Sets the value of the VPCId property for this object.
         *
         * @param vpcId
         *        The new value for the VPCId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String vpcRegion;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VPC model) {
            vpcRegion(model.vpcRegion);
            vpcId(model.vpcId);
        }

        public final String getVpcRegion() {
            return vpcRegion;
        }

        public final void setVpcRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
        }

        @Override
        public final Builder vpcRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
            return this;
        }

        @Override
        public final Builder vpcRegion(VPCRegion vpcRegion) {
            this.vpcRegion(vpcRegion == null ? null : vpcRegion.toString());
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public VPC build() {
            return new VPC(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
