/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the resource record set to create or delete.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceRecordSet implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceRecordSet.Builder, ResourceRecordSet> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(ResourceRecordSet::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(ResourceRecordSet::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<String> SET_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SetIdentifier")
            .getter(getter(ResourceRecordSet::setIdentifier))
            .setter(setter(Builder::setIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetIdentifier")
                    .unmarshallLocationName("SetIdentifier").build()).build();

    private static final SdkField<Long> WEIGHT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("Weight")
            .getter(getter(ResourceRecordSet::weight))
            .setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight")
                    .unmarshallLocationName("Weight").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Region")
            .getter(getter(ResourceRecordSet::regionAsString))
            .setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region")
                    .unmarshallLocationName("Region").build()).build();

    private static final SdkField<GeoLocation> GEO_LOCATION_FIELD = SdkField
            .<GeoLocation> builder(MarshallingType.SDK_POJO)
            .memberName("GeoLocation")
            .getter(getter(ResourceRecordSet::geoLocation))
            .setter(setter(Builder::geoLocation))
            .constructor(GeoLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoLocation")
                    .unmarshallLocationName("GeoLocation").build()).build();

    private static final SdkField<String> FAILOVER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Failover")
            .getter(getter(ResourceRecordSet::failoverAsString))
            .setter(setter(Builder::failover))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failover")
                    .unmarshallLocationName("Failover").build()).build();

    private static final SdkField<Boolean> MULTI_VALUE_ANSWER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiValueAnswer")
            .getter(getter(ResourceRecordSet::multiValueAnswer))
            .setter(setter(Builder::multiValueAnswer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiValueAnswer")
                    .unmarshallLocationName("MultiValueAnswer").build()).build();

    private static final SdkField<Long> TTL_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TTL")
            .getter(getter(ResourceRecordSet::ttl))
            .setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TTL").unmarshallLocationName("TTL")
                    .build()).build();

    private static final SdkField<List<ResourceRecord>> RESOURCE_RECORDS_FIELD = SdkField
            .<List<ResourceRecord>> builder(MarshallingType.LIST)
            .memberName("ResourceRecords")
            .getter(getter(ResourceRecordSet::resourceRecords))
            .setter(setter(Builder::resourceRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecords")
                    .unmarshallLocationName("ResourceRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ResourceRecord")
                            .memberFieldInfo(
                                    SdkField.<ResourceRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ResourceRecord").unmarshallLocationName("ResourceRecord")
                                                    .build()).build()).build()).build();

    private static final SdkField<AliasTarget> ALIAS_TARGET_FIELD = SdkField
            .<AliasTarget> builder(MarshallingType.SDK_POJO)
            .memberName("AliasTarget")
            .getter(getter(ResourceRecordSet::aliasTarget))
            .setter(setter(Builder::aliasTarget))
            .constructor(AliasTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasTarget")
                    .unmarshallLocationName("AliasTarget").build()).build();

    private static final SdkField<String> HEALTH_CHECK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckId")
            .getter(getter(ResourceRecordSet::healthCheckId))
            .setter(setter(Builder::healthCheckId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckId")
                    .unmarshallLocationName("HealthCheckId").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyInstanceId")
            .getter(getter(ResourceRecordSet::trafficPolicyInstanceId))
            .setter(setter(Builder::trafficPolicyInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstanceId")
                    .unmarshallLocationName("TrafficPolicyInstanceId").build()).build();

    private static final SdkField<CidrRoutingConfig> CIDR_ROUTING_CONFIG_FIELD = SdkField
            .<CidrRoutingConfig> builder(MarshallingType.SDK_POJO)
            .memberName("CidrRoutingConfig")
            .getter(getter(ResourceRecordSet::cidrRoutingConfig))
            .setter(setter(Builder::cidrRoutingConfig))
            .constructor(CidrRoutingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrRoutingConfig")
                    .unmarshallLocationName("CidrRoutingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            SET_IDENTIFIER_FIELD, WEIGHT_FIELD, REGION_FIELD, GEO_LOCATION_FIELD, FAILOVER_FIELD, MULTI_VALUE_ANSWER_FIELD,
            TTL_FIELD, RESOURCE_RECORDS_FIELD, ALIAS_TARGET_FIELD, HEALTH_CHECK_ID_FIELD, TRAFFIC_POLICY_INSTANCE_ID_FIELD,
            CIDR_ROUTING_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String setIdentifier;

    private final Long weight;

    private final String region;

    private final GeoLocation geoLocation;

    private final String failover;

    private final Boolean multiValueAnswer;

    private final Long ttl;

    private final List<ResourceRecord> resourceRecords;

    private final AliasTarget aliasTarget;

    private final String healthCheckId;

    private final String trafficPolicyInstanceId;

    private final CidrRoutingConfig cidrRoutingConfig;

    private ResourceRecordSet(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.setIdentifier = builder.setIdentifier;
        this.weight = builder.weight;
        this.region = builder.region;
        this.geoLocation = builder.geoLocation;
        this.failover = builder.failover;
        this.multiValueAnswer = builder.multiValueAnswer;
        this.ttl = builder.ttl;
        this.resourceRecords = builder.resourceRecords;
        this.aliasTarget = builder.aliasTarget;
        this.healthCheckId = builder.healthCheckId;
        this.trafficPolicyInstanceId = builder.trafficPolicyInstanceId;
        this.cidrRoutingConfig = builder.cidrRoutingConfig;
    }

    /**
     * <p>
     * For <code>ChangeResourceRecordSets</code> requests, the name of the record that you want to create, update, or
     * delete. For <code>ListResourceRecordSets</code> responses, the name of a record in the specified hosted zone.
     * </p>
     * <p>
     * <b>ChangeResourceRecordSets Only</b>
     * </p>
     * <p>
     * Enter a fully qualified domain name, for example, <code>www.example.com</code>. You can optionally include a
     * trailing dot. If you omit the trailing dot, Amazon Route 53 assumes that the domain name that you specify is
     * fully qualified. This means that Route 53 treats <code>www.example.com</code> (without a trailing dot) and
     * <code>www.example.com.</code> (with a trailing dot) as identical.
     * </p>
     * <p>
     * For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and <code>-</code>
     * (hyphen) and how to specify internationalized domain names, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
     * in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * You can use the asterisk (*) wildcard to replace the leftmost label in a domain name, for example,
     * <code>*.example.com</code>. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The * must replace the entire label. For example, you can't specify <code>*prod.example.com</code> or
     * <code>prod*.example.com</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The * can't replace any of the middle labels, for example, marketing.*.example.com.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you include * in any position other than the leftmost label in a domain name, DNS treats it as an * character
     * (ASCII 42), not as a wildcard.
     * </p>
     * <important>
     * <p>
     * You can't use the * wildcard for resource records sets that have a type of NS.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * You can use the * wildcard as the leftmost label in a domain name, for example, <code>*.example.com</code>. You
     * can't use an * for one of the middle labels, for example, <code>marketing.*.example.com</code>. In addition, the
     * * must replace the entire label; for example, you can't specify <code>prod*.example.com</code>.
     * </p>
     * 
     * @return For <code>ChangeResourceRecordSets</code> requests, the name of the record that you want to create,
     *         update, or delete. For <code>ListResourceRecordSets</code> responses, the name of a record in the
     *         specified hosted zone.</p>
     *         <p>
     *         <b>ChangeResourceRecordSets Only</b>
     *         </p>
     *         <p>
     *         Enter a fully qualified domain name, for example, <code>www.example.com</code>. You can optionally
     *         include a trailing dot. If you omit the trailing dot, Amazon Route 53 assumes that the domain name that
     *         you specify is fully qualified. This means that Route 53 treats <code>www.example.com</code> (without a
     *         trailing dot) and <code>www.example.com.</code> (with a trailing dot) as identical.
     *         </p>
     *         <p>
     *         For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
     *         <code>-</code> (hyphen) and how to specify internationalized domain names, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name
     *         Format</a> in the <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         You can use the asterisk (*) wildcard to replace the leftmost label in a domain name, for example,
     *         <code>*.example.com</code>. Note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The * must replace the entire label. For example, you can't specify <code>*prod.example.com</code> or
     *         <code>prod*.example.com</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The * can't replace any of the middle labels, for example, marketing.*.example.com.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you include * in any position other than the leftmost label in a domain name, DNS treats it as an *
     *         character (ASCII 42), not as a wildcard.
     *         </p>
     *         <important>
     *         <p>
     *         You can't use the * wildcard for resource records sets that have a type of NS.
     *         </p>
     *         </important></li>
     *         </ul>
     *         <p>
     *         You can use the * wildcard as the leftmost label in a domain name, for example,
     *         <code>*.example.com</code>. You can't use an * for one of the middle labels, for example,
     *         <code>marketing.*.example.com</code>. In addition, the * must replace the entire label; for example, you
     *         can't specify <code>prod*.example.com</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The DNS record type. For information about different record types and how data is encoded for them, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource
     * Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
     * <code>CNAME</code> | <code>DS</code> |<code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> |
     * <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * </p>
     * <p>
     * Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code>
     * | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> |
     * <code>SPF</code> | <code>SRV</code> | <code>TXT</code>. When creating a group of weighted, latency, geolocation,
     * or failover resource record sets, specify the same value for all of the resource record sets in the group.
     * </p>
     * <p>
     * Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> | <code>MX</code> |
     * <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * </p>
     * <note>
     * <p>
     * SPF records were formerly used to verify the identity of the sender of email messages. However, we no longer
     * recommend that you create resource record sets for which the value of <code>Type</code> is <code>SPF</code>. RFC
     * 7208, <i>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email, Version 1</i>, has been updated
     * to say,
     * "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it."
     * In RFC 7208, see section 14.1, <a href="http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS Record
     * Type</a>.
     * </p>
     * </note>
     * <p>
     * Values for alias resource record sets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Amazon API Gateway custom regional APIs and edge-optimized APIs:</b> <code>A</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CloudFront distributions:</b> <code>A</code>
     * </p>
     * <p>
     * If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your distribution,
     * one with a value of <code>A</code> and one with a value of <code>AAAA</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon API Gateway environment that has a regionalized subdomain</b>: <code>A</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ELB load balancers:</b> <code>A</code> | <code>AAAA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon S3 buckets:</b> <code>A</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon Virtual Private Cloud interface VPC endpoints</b> <code>A</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Another resource record set in this hosted zone:</b> Specify the type of the resource record set that you're
     * creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code>.
     * </p>
     * <note>
     * <p>
     * If you're creating an alias record that has the same name as the hosted zone (known as the zone apex), you can't
     * route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code>. This is because the
     * alias record must have the same type as the record you're routing traffic to, and creating a CNAME record for the
     * zone apex isn't supported even for an alias record.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The DNS record type. For information about different record types and how data is encoded for them, see
     *         <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported
     *         DNS Resource Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
     *         <p>
     *         Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
     *         <code>CNAME</code> | <code>DS</code> |<code>MX</code> | <code>NAPTR</code> | <code>NS</code> |
     *         <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     *         </p>
     *         <p>
     *         Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> |
     *         <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> |
     *         <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>. When creating a group of
     *         weighted, latency, geolocation, or failover resource record sets, specify the same value for all of the
     *         resource record sets in the group.
     *         </p>
     *         <p>
     *         Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> |
     *         <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> |
     *         <code>TXT</code>
     *         </p>
     *         <note>
     *         <p>
     *         SPF records were formerly used to verify the identity of the sender of email messages. However, we no
     *         longer recommend that you create resource record sets for which the value of <code>Type</code> is
     *         <code>SPF</code>. RFC 7208, <i>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email,
     *         Version 1</i>, has been updated to say,
     *         "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it."
     *         In RFC 7208, see section 14.1, <a href="http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS
     *         Record Type</a>.
     *         </p>
     *         </note>
     *         <p>
     *         Values for alias resource record sets:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Amazon API Gateway custom regional APIs and edge-optimized APIs:</b> <code>A</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CloudFront distributions:</b> <code>A</code>
     *         </p>
     *         <p>
     *         If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your
     *         distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon API Gateway environment that has a regionalized subdomain</b>: <code>A</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ELB load balancers:</b> <code>A</code> | <code>AAAA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon S3 buckets:</b> <code>A</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon Virtual Private Cloud interface VPC endpoints</b> <code>A</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Another resource record set in this hosted zone:</b> Specify the type of the resource record set that
     *         you're creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code>.
     *         </p>
     *         <note>
     *         <p>
     *         If you're creating an alias record that has the same name as the hosted zone (known as the zone apex),
     *         you can't route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code>. This
     *         is because the alias record must have the same type as the record you're routing traffic to, and creating
     *         a CNAME record for the zone apex isn't supported even for an alias record.
     *         </p>
     *         </note></li>
     * @see RRType
     */
    public final RRType type() {
        return RRType.fromValue(type);
    }

    /**
     * <p>
     * The DNS record type. For information about different record types and how data is encoded for them, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource
     * Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
     * <code>CNAME</code> | <code>DS</code> |<code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> |
     * <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * </p>
     * <p>
     * Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code>
     * | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> |
     * <code>SPF</code> | <code>SRV</code> | <code>TXT</code>. When creating a group of weighted, latency, geolocation,
     * or failover resource record sets, specify the same value for all of the resource record sets in the group.
     * </p>
     * <p>
     * Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> | <code>MX</code> |
     * <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * </p>
     * <note>
     * <p>
     * SPF records were formerly used to verify the identity of the sender of email messages. However, we no longer
     * recommend that you create resource record sets for which the value of <code>Type</code> is <code>SPF</code>. RFC
     * 7208, <i>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email, Version 1</i>, has been updated
     * to say,
     * "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it."
     * In RFC 7208, see section 14.1, <a href="http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS Record
     * Type</a>.
     * </p>
     * </note>
     * <p>
     * Values for alias resource record sets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Amazon API Gateway custom regional APIs and edge-optimized APIs:</b> <code>A</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CloudFront distributions:</b> <code>A</code>
     * </p>
     * <p>
     * If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your distribution,
     * one with a value of <code>A</code> and one with a value of <code>AAAA</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon API Gateway environment that has a regionalized subdomain</b>: <code>A</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ELB load balancers:</b> <code>A</code> | <code>AAAA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon S3 buckets:</b> <code>A</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon Virtual Private Cloud interface VPC endpoints</b> <code>A</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Another resource record set in this hosted zone:</b> Specify the type of the resource record set that you're
     * creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code>.
     * </p>
     * <note>
     * <p>
     * If you're creating an alias record that has the same name as the hosted zone (known as the zone apex), you can't
     * route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code>. This is because the
     * alias record must have the same type as the record you're routing traffic to, and creating a CNAME record for the
     * zone apex isn't supported even for an alias record.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The DNS record type. For information about different record types and how data is encoded for them, see
     *         <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported
     *         DNS Resource Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
     *         <p>
     *         Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
     *         <code>CNAME</code> | <code>DS</code> |<code>MX</code> | <code>NAPTR</code> | <code>NS</code> |
     *         <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     *         </p>
     *         <p>
     *         Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> |
     *         <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> |
     *         <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>. When creating a group of
     *         weighted, latency, geolocation, or failover resource record sets, specify the same value for all of the
     *         resource record sets in the group.
     *         </p>
     *         <p>
     *         Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> |
     *         <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> |
     *         <code>TXT</code>
     *         </p>
     *         <note>
     *         <p>
     *         SPF records were formerly used to verify the identity of the sender of email messages. However, we no
     *         longer recommend that you create resource record sets for which the value of <code>Type</code> is
     *         <code>SPF</code>. RFC 7208, <i>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email,
     *         Version 1</i>, has been updated to say,
     *         "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it."
     *         In RFC 7208, see section 14.1, <a href="http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS
     *         Record Type</a>.
     *         </p>
     *         </note>
     *         <p>
     *         Values for alias resource record sets:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Amazon API Gateway custom regional APIs and edge-optimized APIs:</b> <code>A</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CloudFront distributions:</b> <code>A</code>
     *         </p>
     *         <p>
     *         If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your
     *         distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon API Gateway environment that has a regionalized subdomain</b>: <code>A</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ELB load balancers:</b> <code>A</code> | <code>AAAA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon S3 buckets:</b> <code>A</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon Virtual Private Cloud interface VPC endpoints</b> <code>A</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Another resource record set in this hosted zone:</b> Specify the type of the resource record set that
     *         you're creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code>.
     *         </p>
     *         <note>
     *         <p>
     *         If you're creating an alias record that has the same name as the hosted zone (known as the zone apex),
     *         you can't route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code>. This
     *         is because the alias record must have the same type as the record you're routing traffic to, and creating
     *         a CNAME record for the zone apex isn't supported even for an alias record.
     *         </p>
     *         </note></li>
     * @see RRType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * <i>Resource record sets that have a routing policy other than simple:</i> An identifier that differentiates among
     * multiple resource record sets that have the same combination of name and type, such as multiple weighted resource
     * record sets named acme.example.com that have a type of A. In a group of resource record sets that have the same
     * name and type, the value of <code>SetIdentifier</code> must be unique for each resource record set.
     * </p>
     * <p>
     * For information about routing policies, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing
     * Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * 
     * @return <i>Resource record sets that have a routing policy other than simple:</i> An identifier that
     *         differentiates among multiple resource record sets that have the same combination of name and type, such
     *         as multiple weighted resource record sets named acme.example.com that have a type of A. In a group of
     *         resource record sets that have the same name and type, the value of <code>SetIdentifier</code> must be
     *         unique for each resource record set. </p>
     *         <p>
     *         For information about routing policies, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing
     *         Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.
     */
    public final String setIdentifier() {
        return setIdentifier;
    }

    /**
     * <p>
     * <i>Weighted resource record sets only:</i> Among resource record sets that have the same combination of DNS name
     * and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using the
     * current resource record set. Route 53 calculates the sum of the weights for the resource record sets that have
     * the same combination of DNS name and type. Route 53 then responds to queries based on the ratio of a resource's
     * weight to the total. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify a value for the <code>Weight</code> element for every weighted resource record set.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can only specify one <code>ResourceRecord</code> per weighted resource record set.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't create latency, failover, or geolocation resource record sets that have the same values for the
     * <code>Name</code> and <code>Type</code> elements as weighted resource record sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can create a maximum of 100 weighted resource record sets that have the same values for the <code>Name</code>
     * and <code>Type</code> elements.
     * </p>
     * </li>
     * <li>
     * <p>
     * For weighted (but not weighted alias) resource record sets, if you set <code>Weight</code> to <code>0</code> for
     * a resource record set, Route 53 never responds to queries with the applicable value for that resource record set.
     * However, if you set <code>Weight</code> to <code>0</code> for all resource record sets that have the same
     * combination of DNS name and type, traffic is routed to all resources with equal probability.
     * </p>
     * <p>
     * The effect of setting <code>Weight</code> to <code>0</code> is different when you associate health checks with
     * weighted resource record sets. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html">Options
     * for Configuring Route 53 Active-Active and Active-Passive Failover</a> in the <i>Amazon Route 53 Developer
     * Guide</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return <i>Weighted resource record sets only:</i> Among resource record sets that have the same combination of
     *         DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to
     *         using the current resource record set. Route 53 calculates the sum of the weights for the resource record
     *         sets that have the same combination of DNS name and type. Route 53 then responds to queries based on the
     *         ratio of a resource's weight to the total. Note the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You must specify a value for the <code>Weight</code> element for every weighted resource record set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can only specify one <code>ResourceRecord</code> per weighted resource record set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can't create latency, failover, or geolocation resource record sets that have the same values for the
     *         <code>Name</code> and <code>Type</code> elements as weighted resource record sets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can create a maximum of 100 weighted resource record sets that have the same values for the
     *         <code>Name</code> and <code>Type</code> elements.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For weighted (but not weighted alias) resource record sets, if you set <code>Weight</code> to
     *         <code>0</code> for a resource record set, Route 53 never responds to queries with the applicable value
     *         for that resource record set. However, if you set <code>Weight</code> to <code>0</code> for all resource
     *         record sets that have the same combination of DNS name and type, traffic is routed to all resources with
     *         equal probability.
     *         </p>
     *         <p>
     *         The effect of setting <code>Weight</code> to <code>0</code> is different when you associate health checks
     *         with weighted resource record sets. For more information, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html"
     *         >Options for Configuring Route 53 Active-Active and Active-Passive Failover</a> in the <i>Amazon Route 53
     *         Developer Guide</i>.
     *         </p>
     *         </li>
     */
    public final Long weight() {
        return weight;
    }

    /**
     * <p>
     * <i>Latency-based resource record sets only:</i> The Amazon EC2 Region where you created the resource that this
     * resource record set refers to. The resource typically is an Amazon Web Services resource, such as an EC2 instance
     * or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending on the record type.
     * </p>
     * <p>
     * When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency resource
     * record sets, Route 53 selects the latency resource record set that has the lowest latency between the end user
     * and the associated Amazon EC2 Region. Route 53 then returns the value that is associated with the selected
     * resource record set.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can only specify one <code>ResourceRecord</code> per latency resource record set.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can only create one latency resource record set for each Amazon EC2 Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will choose the
     * region with the best latency from among the regions that you create latency resource record sets for.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't create non-latency resource record sets that have the same values for the <code>Name</code> and
     * <code>Type</code> elements as latency resource record sets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link ResourceRecordSetRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #regionAsString}.
     * </p>
     * 
     * @return <i>Latency-based resource record sets only:</i> The Amazon EC2 Region where you created the resource that
     *         this resource record set refers to. The resource typically is an Amazon Web Services resource, such as an
     *         EC2 instance or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending
     *         on the record type.</p>
     *         <p>
     *         When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency
     *         resource record sets, Route 53 selects the latency resource record set that has the lowest latency
     *         between the end user and the associated Amazon EC2 Region. Route 53 then returns the value that is
     *         associated with the selected resource record set.
     *         </p>
     *         <p>
     *         Note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You can only specify one <code>ResourceRecord</code> per latency resource record set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can only create one latency resource record set for each Amazon EC2 Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will
     *         choose the region with the best latency from among the regions that you create latency resource record
     *         sets for.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can't create non-latency resource record sets that have the same values for the <code>Name</code> and
     *         <code>Type</code> elements as latency resource record sets.
     *         </p>
     *         </li>
     * @see ResourceRecordSetRegion
     */
    public final ResourceRecordSetRegion region() {
        return ResourceRecordSetRegion.fromValue(region);
    }

    /**
     * <p>
     * <i>Latency-based resource record sets only:</i> The Amazon EC2 Region where you created the resource that this
     * resource record set refers to. The resource typically is an Amazon Web Services resource, such as an EC2 instance
     * or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending on the record type.
     * </p>
     * <p>
     * When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency resource
     * record sets, Route 53 selects the latency resource record set that has the lowest latency between the end user
     * and the associated Amazon EC2 Region. Route 53 then returns the value that is associated with the selected
     * resource record set.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can only specify one <code>ResourceRecord</code> per latency resource record set.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can only create one latency resource record set for each Amazon EC2 Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will choose the
     * region with the best latency from among the regions that you create latency resource record sets for.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't create non-latency resource record sets that have the same values for the <code>Name</code> and
     * <code>Type</code> elements as latency resource record sets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link ResourceRecordSetRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #regionAsString}.
     * </p>
     * 
     * @return <i>Latency-based resource record sets only:</i> The Amazon EC2 Region where you created the resource that
     *         this resource record set refers to. The resource typically is an Amazon Web Services resource, such as an
     *         EC2 instance or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending
     *         on the record type.</p>
     *         <p>
     *         When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency
     *         resource record sets, Route 53 selects the latency resource record set that has the lowest latency
     *         between the end user and the associated Amazon EC2 Region. Route 53 then returns the value that is
     *         associated with the selected resource record set.
     *         </p>
     *         <p>
     *         Note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You can only specify one <code>ResourceRecord</code> per latency resource record set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can only create one latency resource record set for each Amazon EC2 Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will
     *         choose the region with the best latency from among the regions that you create latency resource record
     *         sets for.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can't create non-latency resource record sets that have the same values for the <code>Name</code> and
     *         <code>Type</code> elements as latency resource record sets.
     *         </p>
     *         </li>
     * @see ResourceRecordSetRegion
     */
    public final String regionAsString() {
        return region;
    }

    /**
     * <p>
     * <i>Geolocation resource record sets only:</i> A complex type that lets you control how Amazon Route 53 responds
     * to DNS queries based on the geographic origin of the query. For example, if you want all queries from Africa to
     * be routed to a web server with an IP address of <code>192.0.2.111</code>, create a resource record set with a
     * <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code>.
     * </p>
     * <note>
     * <p>
     * Although creating geolocation and geolocation alias resource record sets in a private hosted zone is allowed,
     * it's not supported.
     * </p>
     * </note>
     * <p>
     * If you create separate resource record sets for overlapping geographic regions (for example, one resource record
     * set for a continent and one for a country on the same continent), priority goes to the smallest geographic
     * region. This allows you to route most queries for a continent to one resource and to route queries for a country
     * on that continent to a different resource.
     * </p>
     * <p>
     * You can't create two geolocation resource record sets that specify the same geographic location.
     * </p>
     * <p>
     * The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren't
     * specified in other geolocation resource record sets that have the same values for the <code>Name</code> and
     * <code>Type</code> elements.
     * </p>
     * <important>
     * <p>
     * Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to geographic
     * locations, so even if you create geolocation resource record sets that cover all seven continents, Route 53 will
     * receive some DNS queries from locations that it can't identify. We recommend that you create a resource record
     * set for which the value of <code>CountryCode</code> is <code>*</code>. Two groups of queries are routed to the
     * resource that you specify in this record: queries that come from locations for which you haven't created
     * geolocation resource record sets and queries from IP addresses that aren't mapped to a location. If you don't
     * create a <code>*</code> resource record set, Route 53 returns a "no answer" response for queries from those
     * locations.
     * </p>
     * </important>
     * <p>
     * You can't create non-geolocation resource record sets that have the same values for the <code>Name</code> and
     * <code>Type</code> elements as geolocation resource record sets.
     * </p>
     * 
     * @return <i>Geolocation resource record sets only:</i> A complex type that lets you control how Amazon Route 53
     *         responds to DNS queries based on the geographic origin of the query. For example, if you want all queries
     *         from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code>, create a
     *         resource record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of
     *         <code>AF</code>.</p> <note>
     *         <p>
     *         Although creating geolocation and geolocation alias resource record sets in a private hosted zone is
     *         allowed, it's not supported.
     *         </p>
     *         </note>
     *         <p>
     *         If you create separate resource record sets for overlapping geographic regions (for example, one resource
     *         record set for a continent and one for a country on the same continent), priority goes to the smallest
     *         geographic region. This allows you to route most queries for a continent to one resource and to route
     *         queries for a country on that continent to a different resource.
     *         </p>
     *         <p>
     *         You can't create two geolocation resource record sets that specify the same geographic location.
     *         </p>
     *         <p>
     *         The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that
     *         aren't specified in other geolocation resource record sets that have the same values for the
     *         <code>Name</code> and <code>Type</code> elements.
     *         </p>
     *         <important>
     *         <p>
     *         Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to
     *         geographic locations, so even if you create geolocation resource record sets that cover all seven
     *         continents, Route 53 will receive some DNS queries from locations that it can't identify. We recommend
     *         that you create a resource record set for which the value of <code>CountryCode</code> is <code>*</code>.
     *         Two groups of queries are routed to the resource that you specify in this record: queries that come from
     *         locations for which you haven't created geolocation resource record sets and queries from IP addresses
     *         that aren't mapped to a location. If you don't create a <code>*</code> resource record set, Route 53
     *         returns a "no answer" response for queries from those locations.
     *         </p>
     *         </important>
     *         <p>
     *         You can't create non-geolocation resource record sets that have the same values for the <code>Name</code>
     *         and <code>Type</code> elements as geolocation resource record sets.
     */
    public final GeoLocation geoLocation() {
        return geoLocation;
    }

    /**
     * <p>
     * <i>Failover resource record sets only:</i> To configure failover, you add the <code>Failover</code> element to
     * two resource record sets. For one resource record set, you specify <code>PRIMARY</code> as the value for
     * <code>Failover</code>; for the other resource record set, you specify <code>SECONDARY</code>. In addition, you
     * include the <code>HealthCheckId</code> element and specify the health check that you want Amazon Route 53 to
     * perform for each resource record set.
     * </p>
     * <p>
     * Except where noted, the following failover behaviors assume that you have included the <code>HealthCheckId</code>
     * element in both resource record sets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from
     * the primary resource record set regardless of the health of the secondary resource record set.
     * </p>
     * </li>
     * <li>
     * <p>
     * When the primary resource record set is unhealthy and the secondary resource record set is healthy, Route 53
     * responds to DNS queries with the applicable value from the secondary resource record set.
     * </p>
     * </li>
     * <li>
     * <p>
     * When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the applicable value
     * from the primary resource record set regardless of the health of the primary resource record set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the primary
     * resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable value from the
     * secondary resource record set. This is true regardless of the health of the associated endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't create non-failover resource record sets that have the same values for the <code>Name</code> and
     * <code>Type</code> elements as failover resource record sets.
     * </p>
     * <p>
     * For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code> element and
     * set the value to true.
     * </p>
     * <p>
     * For more information about configuring failover for Route 53, see the following topics in the <i>Amazon Route 53
     * Developer Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and
     * DNS Failover</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">
     * Configuring Failover in a Private Hosted Zone</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failover} will
     * return {@link ResourceRecordSetFailover#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failoverAsString}.
     * </p>
     * 
     * @return <i>Failover resource record sets only:</i> To configure failover, you add the <code>Failover</code>
     *         element to two resource record sets. For one resource record set, you specify <code>PRIMARY</code> as the
     *         value for <code>Failover</code>; for the other resource record set, you specify <code>SECONDARY</code>.
     *         In addition, you include the <code>HealthCheckId</code> element and specify the health check that you
     *         want Amazon Route 53 to perform for each resource record set.</p>
     *         <p>
     *         Except where noted, the following failover behaviors assume that you have included the
     *         <code>HealthCheckId</code> element in both resource record sets:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable
     *         value from the primary resource record set regardless of the health of the secondary resource record set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the primary resource record set is unhealthy and the secondary resource record set is healthy, Route
     *         53 responds to DNS queries with the applicable value from the secondary resource record set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the applicable
     *         value from the primary resource record set regardless of the health of the primary resource record set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the
     *         primary resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable
     *         value from the secondary resource record set. This is true regardless of the health of the associated
     *         endpoint.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can't create non-failover resource record sets that have the same values for the <code>Name</code>
     *         and <code>Type</code> elements as failover resource record sets.
     *         </p>
     *         <p>
     *         For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code>
     *         element and set the value to true.
     *         </p>
     *         <p>
     *         For more information about configuring failover for Route 53, see the following topics in the <i>Amazon
     *         Route 53 Developer Guide</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health
     *         Checks and DNS Failover</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html"
     *         >Configuring Failover in a Private Hosted Zone</a>
     *         </p>
     *         </li>
     * @see ResourceRecordSetFailover
     */
    public final ResourceRecordSetFailover failover() {
        return ResourceRecordSetFailover.fromValue(failover);
    }

    /**
     * <p>
     * <i>Failover resource record sets only:</i> To configure failover, you add the <code>Failover</code> element to
     * two resource record sets. For one resource record set, you specify <code>PRIMARY</code> as the value for
     * <code>Failover</code>; for the other resource record set, you specify <code>SECONDARY</code>. In addition, you
     * include the <code>HealthCheckId</code> element and specify the health check that you want Amazon Route 53 to
     * perform for each resource record set.
     * </p>
     * <p>
     * Except where noted, the following failover behaviors assume that you have included the <code>HealthCheckId</code>
     * element in both resource record sets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from
     * the primary resource record set regardless of the health of the secondary resource record set.
     * </p>
     * </li>
     * <li>
     * <p>
     * When the primary resource record set is unhealthy and the secondary resource record set is healthy, Route 53
     * responds to DNS queries with the applicable value from the secondary resource record set.
     * </p>
     * </li>
     * <li>
     * <p>
     * When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the applicable value
     * from the primary resource record set regardless of the health of the primary resource record set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the primary
     * resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable value from the
     * secondary resource record set. This is true regardless of the health of the associated endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't create non-failover resource record sets that have the same values for the <code>Name</code> and
     * <code>Type</code> elements as failover resource record sets.
     * </p>
     * <p>
     * For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code> element and
     * set the value to true.
     * </p>
     * <p>
     * For more information about configuring failover for Route 53, see the following topics in the <i>Amazon Route 53
     * Developer Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and
     * DNS Failover</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">
     * Configuring Failover in a Private Hosted Zone</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failover} will
     * return {@link ResourceRecordSetFailover#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failoverAsString}.
     * </p>
     * 
     * @return <i>Failover resource record sets only:</i> To configure failover, you add the <code>Failover</code>
     *         element to two resource record sets. For one resource record set, you specify <code>PRIMARY</code> as the
     *         value for <code>Failover</code>; for the other resource record set, you specify <code>SECONDARY</code>.
     *         In addition, you include the <code>HealthCheckId</code> element and specify the health check that you
     *         want Amazon Route 53 to perform for each resource record set.</p>
     *         <p>
     *         Except where noted, the following failover behaviors assume that you have included the
     *         <code>HealthCheckId</code> element in both resource record sets:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable
     *         value from the primary resource record set regardless of the health of the secondary resource record set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the primary resource record set is unhealthy and the secondary resource record set is healthy, Route
     *         53 responds to DNS queries with the applicable value from the secondary resource record set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the applicable
     *         value from the primary resource record set regardless of the health of the primary resource record set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the
     *         primary resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable
     *         value from the secondary resource record set. This is true regardless of the health of the associated
     *         endpoint.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can't create non-failover resource record sets that have the same values for the <code>Name</code>
     *         and <code>Type</code> elements as failover resource record sets.
     *         </p>
     *         <p>
     *         For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code>
     *         element and set the value to true.
     *         </p>
     *         <p>
     *         For more information about configuring failover for Route 53, see the following topics in the <i>Amazon
     *         Route 53 Developer Guide</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health
     *         Checks and DNS Failover</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html"
     *         >Configuring Failover in a Private Hosted Zone</a>
     *         </p>
     *         </li>
     * @see ResourceRecordSetFailover
     */
    public final String failoverAsString() {
        return failover;
    }

    /**
     * <p>
     * <i>Multivalue answer resource record sets only</i>: To route traffic approximately randomly to multiple
     * resources, such as web servers, create one multivalue answer record for each resource and specify
     * <code>true</code> for <code>MultiValueAnswer</code>. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to DNS
     * queries with the corresponding IP address only when the health check is healthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't associate a health check with a multivalue answer record, Route 53 always considers the record to be
     * healthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy records,
     * Route 53 responds to all DNS queries with all the healthy records.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have more than eight healthy records, Route 53 responds to different DNS resolvers with different
     * combinations of healthy records.
     * </p>
     * </li>
     * <li>
     * <p>
     * When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.
     * </p>
     * </li>
     * <li>
     * <p>
     * If a resource becomes unavailable after a resolver caches a response, client software typically tries another of
     * the IP addresses in the response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't create multivalue answer alias records.
     * </p>
     * 
     * @return <i>Multivalue answer resource record sets only</i>: To route traffic approximately randomly to multiple
     *         resources, such as web servers, create one multivalue answer record for each resource and specify
     *         <code>true</code> for <code>MultiValueAnswer</code>. Note the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to
     *         DNS queries with the corresponding IP address only when the health check is healthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't associate a health check with a multivalue answer record, Route 53 always considers the
     *         record to be healthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy
     *         records, Route 53 responds to all DNS queries with all the healthy records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have more than eight healthy records, Route 53 responds to different DNS resolvers with different
     *         combinations of healthy records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If a resource becomes unavailable after a resolver caches a response, client software typically tries
     *         another of the IP addresses in the response.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can't create multivalue answer alias records.
     */
    public final Boolean multiValueAnswer() {
        return multiValueAnswer;
    }

    /**
     * <p>
     * The resource record cache time to live (TTL), in seconds. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you're creating or updating an alias resource record set, omit <code>TTL</code>. Amazon Route 53 uses the
     * value of <code>TTL</code> for the alias target.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you're associating this resource record set with a health check (if you're adding a <code>HealthCheckId</code>
     * element), we recommend that you specify a <code>TTL</code> of 60 seconds or less so clients respond quickly to
     * changes in health status.
     * </p>
     * </li>
     * <li>
     * <p>
     * All of the resource record sets in a group of weighted resource record sets must have the same value for
     * <code>TTL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If a group of weighted resource record sets includes one or more weighted alias resource record sets for which
     * the alias target is an ELB load balancer, we recommend that you specify a <code>TTL</code> of 60 seconds for all
     * of the non-alias weighted resource record sets that have the same name and type. Values other than 60 seconds
     * (the TTL for load balancers) will change the effect of the values that you specify for <code>Weight</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The resource record cache time to live (TTL), in seconds. Note the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you're creating or updating an alias resource record set, omit <code>TTL</code>. Amazon Route 53 uses
     *         the value of <code>TTL</code> for the alias target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you're associating this resource record set with a health check (if you're adding a
     *         <code>HealthCheckId</code> element), we recommend that you specify a <code>TTL</code> of 60 seconds or
     *         less so clients respond quickly to changes in health status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         All of the resource record sets in a group of weighted resource record sets must have the same value for
     *         <code>TTL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If a group of weighted resource record sets includes one or more weighted alias resource record sets for
     *         which the alias target is an ELB load balancer, we recommend that you specify a <code>TTL</code> of 60
     *         seconds for all of the non-alias weighted resource record sets that have the same name and type. Values
     *         other than 60 seconds (the TTL for load balancers) will change the effect of the values that you specify
     *         for <code>Weight</code>.
     *         </p>
     *         </li>
     */
    public final Long ttl() {
        return ttl;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceRecords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceRecords() {
        return resourceRecords != null && !(resourceRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resource records to act upon.
     * </p>
     * <note>
     * <p>
     * If you're creating an alias resource record set, omit <code>ResourceRecords</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceRecords} method.
     * </p>
     * 
     * @return Information about the resource records to act upon.</p> <note>
     *         <p>
     *         If you're creating an alias resource record set, omit <code>ResourceRecords</code>.
     *         </p>
     */
    public final List<ResourceRecord> resourceRecords() {
        return resourceRecords;
    }

    /**
     * <p>
     * <i>Alias resource record sets only:</i> Information about the Amazon Web Services resource, such as a CloudFront
     * distribution or an Amazon S3 bucket, that you want to route traffic to.
     * </p>
     * <p>
     * If you're creating resource records sets for a private hosted zone, note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront
     * distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * For information about creating failover resource record sets in a private hosted zone, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html"
     * >Configuring Failover in a Private Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return <i>Alias resource record sets only:</i> Information about the Amazon Web Services resource, such as a
     *         CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to. </p>
     *         <p>
     *         If you're creating resource records sets for a private hosted zone, note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront
     *         distribution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For information about creating failover resource record sets in a private hosted zone, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html"
     *         >Configuring Failover in a Private Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         </li>
     */
    public final AliasTarget aliasTarget() {
        return aliasTarget;
    }

    /**
     * <p>
     * If you want Amazon Route 53 to return this resource record set in response to a DNS query only when the status of
     * a health check is healthy, include the <code>HealthCheckId</code> element and specify the ID of the applicable
     * health check.
     * </p>
     * <p>
     * Route 53 determines whether a resource record set is healthy based on one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * By periodically sending a request to the endpoint that is specified in the health check
     * </p>
     * </li>
     * <li>
     * <p>
     * By aggregating the status of a specified group of health checks (calculated health checks)
     * </p>
     * </li>
     * <li>
     * <p>
     * By determining the current state of a CloudWatch alarm (CloudWatch metric health checks)
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Route 53 doesn't check the health of the endpoint that is specified in the resource record set, for example, the
     * endpoint specified by the IP address in the <code>Value</code> element. When you add a <code>HealthCheckId</code>
     * element to a resource record set, Route 53 checks the health of the endpoint that you specified in the health
     * check.
     * </p>
     * </important>
     * <p>
     * For more information, see the following topics in the <i>Amazon Route 53 Developer Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How
     * Amazon Route 53 Determines Whether an Endpoint Is Healthy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and
     * DNS Failover</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">
     * Configuring Failover in a Private Hosted Zone</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>When to Specify HealthCheckId</b>
     * </p>
     * <p>
     * Specifying a value for <code>HealthCheckId</code> is useful only when Route 53 is choosing between two or more
     * resource record sets to respond to a DNS query, and you want Route 53 to base the choice in part on the status of
     * a health check. Configuring health checks makes sense only in the following configurations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Non-alias resource record sets</b>: You're checking the health of a group of non-alias resource record sets
     * that have the same routing policy, name, and type (such as multiple weighted records named www.example.com with a
     * type of A) and you specify health check IDs for all the resource record sets.
     * </p>
     * <p>
     * If the health check status for a resource record set is healthy, Route 53 includes the record among the records
     * that it responds to DNS queries with.
     * </p>
     * <p>
     * If the health check status for a resource record set is unhealthy, Route 53 stops responding to DNS queries using
     * the value for that resource record set.
     * </p>
     * <p>
     * If the health check status for all resource record sets in the group is unhealthy, Route 53 considers all
     * resource record sets in the group healthy and responds to DNS queries accordingly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Alias resource record sets</b>: You specify the following settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You set <code>EvaluateTargetHealth</code> to true for an alias resource record set in a group of resource record
     * sets that have the same routing policy, name, and type (such as multiple weighted records named www.example.com
     * with a type of A).
     * </p>
     * </li>
     * <li>
     * <p>
     * You configure the alias resource record set to route traffic to a non-alias resource record set in the same
     * hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * You specify a health check ID for the non-alias resource record set.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the health check status is healthy, Route 53 considers the alias resource record set to be healthy and
     * includes the alias record among the records that it responds to DNS queries with.
     * </p>
     * <p>
     * If the health check status is unhealthy, Route 53 stops responding to DNS queries using the alias resource record
     * set.
     * </p>
     * <note>
     * <p>
     * The alias resource record set can also route traffic to a <i>group</i> of non-alias resource record sets that
     * have the same routing policy, name, and type. In that configuration, associate health checks with all of the
     * resource record sets in the group of non-alias resource record sets.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * <b>Geolocation Routing</b>
     * </p>
     * <p>
     * For geolocation resource record sets, if an endpoint is unhealthy, Route 53 looks for a resource record set for
     * the larger, associated geographic region. For example, suppose you have resource record sets for a state in the
     * United States, for the entire United States, for North America, and a resource record set that has <code>*</code>
     * for <code>CountryCode</code> is <code>*</code>, which applies to all locations. If the endpoint for the state
     * resource record set is unhealthy, Route 53 checks for healthy resource record sets in the following order until
     * it finds a resource record set for which the endpoint is healthy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The United States
     * </p>
     * </li>
     * <li>
     * <p>
     * North America
     * </p>
     * </li>
     * <li>
     * <p>
     * The default resource record set
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Specifying the Health Check Endpoint by Domain Name</b>
     * </p>
     * <p>
     * If your health checks specify the endpoint only by domain name, we recommend that you create a separate health
     * check for each endpoint. For example, create a health check for each <code>HTTP</code> server that is serving
     * content for <code>www.example.com</code>. For the value of <code>FullyQualifiedDomainName</code>, specify the
     * domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record
     * sets (<code>www.example.com</code>).
     * </p>
     * <important>
     * <p>
     * Health check results will be unpredictable if you do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a health check that has the same value for <code>FullyQualifiedDomainName</code> as the name of a resource
     * record set.
     * </p>
     * </li>
     * <li>
     * <p>
     * Associate that health check with the resource record set.
     * </p>
     * </li>
     * </ul>
     * </important>
     * 
     * @return If you want Amazon Route 53 to return this resource record set in response to a DNS query only when the
     *         status of a health check is healthy, include the <code>HealthCheckId</code> element and specify the ID of
     *         the applicable health check.</p>
     *         <p>
     *         Route 53 determines whether a resource record set is healthy based on one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         By periodically sending a request to the endpoint that is specified in the health check
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         By aggregating the status of a specified group of health checks (calculated health checks)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         By determining the current state of a CloudWatch alarm (CloudWatch metric health checks)
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         Route 53 doesn't check the health of the endpoint that is specified in the resource record set, for
     *         example, the endpoint specified by the IP address in the <code>Value</code> element. When you add a
     *         <code>HealthCheckId</code> element to a resource record set, Route 53 checks the health of the endpoint
     *         that you specified in the health check.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see the following topics in the <i>Amazon Route 53 Developer Guide</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
     *         >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health
     *         Checks and DNS Failover</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html"
     *         >Configuring Failover in a Private Hosted Zone</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>When to Specify HealthCheckId</b>
     *         </p>
     *         <p>
     *         Specifying a value for <code>HealthCheckId</code> is useful only when Route 53 is choosing between two or
     *         more resource record sets to respond to a DNS query, and you want Route 53 to base the choice in part on
     *         the status of a health check. Configuring health checks makes sense only in the following configurations:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Non-alias resource record sets</b>: You're checking the health of a group of non-alias resource record
     *         sets that have the same routing policy, name, and type (such as multiple weighted records named
     *         www.example.com with a type of A) and you specify health check IDs for all the resource record sets.
     *         </p>
     *         <p>
     *         If the health check status for a resource record set is healthy, Route 53 includes the record among the
     *         records that it responds to DNS queries with.
     *         </p>
     *         <p>
     *         If the health check status for a resource record set is unhealthy, Route 53 stops responding to DNS
     *         queries using the value for that resource record set.
     *         </p>
     *         <p>
     *         If the health check status for all resource record sets in the group is unhealthy, Route 53 considers all
     *         resource record sets in the group healthy and responds to DNS queries accordingly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Alias resource record sets</b>: You specify the following settings:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You set <code>EvaluateTargetHealth</code> to true for an alias resource record set in a group of resource
     *         record sets that have the same routing policy, name, and type (such as multiple weighted records named
     *         www.example.com with a type of A).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You configure the alias resource record set to route traffic to a non-alias resource record set in the
     *         same hosted zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You specify a health check ID for the non-alias resource record set.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the health check status is healthy, Route 53 considers the alias resource record set to be healthy and
     *         includes the alias record among the records that it responds to DNS queries with.
     *         </p>
     *         <p>
     *         If the health check status is unhealthy, Route 53 stops responding to DNS queries using the alias
     *         resource record set.
     *         </p>
     *         <note>
     *         <p>
     *         The alias resource record set can also route traffic to a <i>group</i> of non-alias resource record sets
     *         that have the same routing policy, name, and type. In that configuration, associate health checks with
     *         all of the resource record sets in the group of non-alias resource record sets.
     *         </p>
     *         </note></li>
     *         </ul>
     *         <p>
     *         <b>Geolocation Routing</b>
     *         </p>
     *         <p>
     *         For geolocation resource record sets, if an endpoint is unhealthy, Route 53 looks for a resource record
     *         set for the larger, associated geographic region. For example, suppose you have resource record sets for
     *         a state in the United States, for the entire United States, for North America, and a resource record set
     *         that has <code>*</code> for <code>CountryCode</code> is <code>*</code>, which applies to all locations.
     *         If the endpoint for the state resource record set is unhealthy, Route 53 checks for healthy resource
     *         record sets in the following order until it finds a resource record set for which the endpoint is
     *         healthy:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The United States
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         North America
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The default resource record set
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Specifying the Health Check Endpoint by Domain Name</b>
     *         </p>
     *         <p>
     *         If your health checks specify the endpoint only by domain name, we recommend that you create a separate
     *         health check for each endpoint. For example, create a health check for each <code>HTTP</code> server that
     *         is serving content for <code>www.example.com</code>. For the value of
     *         <code>FullyQualifiedDomainName</code>, specify the domain name of the server (such as
     *         <code>us-east-2-www.example.com</code>), not the name of the resource record sets (
     *         <code>www.example.com</code>).
     *         </p>
     *         <important>
     *         <p>
     *         Health check results will be unpredictable if you do the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Create a health check that has the same value for <code>FullyQualifiedDomainName</code> as the name of a
     *         resource record set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Associate that health check with the resource record set.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String healthCheckId() {
        return healthCheckId;
    }

    /**
     * <p>
     * When you create a traffic policy instance, Amazon Route 53 automatically creates a resource record set.
     * <code>TrafficPolicyInstanceId</code> is the ID of the traffic policy instance that Route 53 created this resource
     * record set for.
     * </p>
     * <important>
     * <p>
     * To delete the resource record set that is associated with a traffic policy instance, use
     * <code>DeleteTrafficPolicyInstance</code>. Route 53 will delete the resource record set automatically. If you
     * delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't automatically
     * delete the traffic policy instance, and you'll continue to be charged for it even though it's no longer in use.
     * </p>
     * </important>
     * 
     * @return When you create a traffic policy instance, Amazon Route 53 automatically creates a resource record set.
     *         <code>TrafficPolicyInstanceId</code> is the ID of the traffic policy instance that Route 53 created this
     *         resource record set for.</p> <important>
     *         <p>
     *         To delete the resource record set that is associated with a traffic policy instance, use
     *         <code>DeleteTrafficPolicyInstance</code>. Route 53 will delete the resource record set automatically. If
     *         you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't
     *         automatically delete the traffic policy instance, and you'll continue to be charged for it even though
     *         it's no longer in use.
     *         </p>
     */
    public final String trafficPolicyInstanceId() {
        return trafficPolicyInstanceId;
    }

    /**
     * Returns the value of the CidrRoutingConfig property for this object.
     * 
     * @return The value of the CidrRoutingConfig property for this object.
     */
    public final CidrRoutingConfig cidrRoutingConfig() {
        return cidrRoutingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(setIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        hashCode = 31 * hashCode + Objects.hashCode(regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(geoLocation());
        hashCode = 31 * hashCode + Objects.hashCode(failoverAsString());
        hashCode = 31 * hashCode + Objects.hashCode(multiValueAnswer());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceRecords() ? resourceRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(aliasTarget());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(cidrRoutingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceRecordSet)) {
            return false;
        }
        ResourceRecordSet other = (ResourceRecordSet) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(setIdentifier(), other.setIdentifier()) && Objects.equals(weight(), other.weight())
                && Objects.equals(regionAsString(), other.regionAsString()) && Objects.equals(geoLocation(), other.geoLocation())
                && Objects.equals(failoverAsString(), other.failoverAsString())
                && Objects.equals(multiValueAnswer(), other.multiValueAnswer()) && Objects.equals(ttl(), other.ttl())
                && hasResourceRecords() == other.hasResourceRecords()
                && Objects.equals(resourceRecords(), other.resourceRecords())
                && Objects.equals(aliasTarget(), other.aliasTarget()) && Objects.equals(healthCheckId(), other.healthCheckId())
                && Objects.equals(trafficPolicyInstanceId(), other.trafficPolicyInstanceId())
                && Objects.equals(cidrRoutingConfig(), other.cidrRoutingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceRecordSet").add("Name", name()).add("Type", typeAsString())
                .add("SetIdentifier", setIdentifier()).add("Weight", weight()).add("Region", regionAsString())
                .add("GeoLocation", geoLocation()).add("Failover", failoverAsString())
                .add("MultiValueAnswer", multiValueAnswer()).add("TTL", ttl())
                .add("ResourceRecords", hasResourceRecords() ? resourceRecords() : null).add("AliasTarget", aliasTarget())
                .add("HealthCheckId", healthCheckId()).add("TrafficPolicyInstanceId", trafficPolicyInstanceId())
                .add("CidrRoutingConfig", cidrRoutingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SetIdentifier":
            return Optional.ofNullable(clazz.cast(setIdentifier()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        case "Region":
            return Optional.ofNullable(clazz.cast(regionAsString()));
        case "GeoLocation":
            return Optional.ofNullable(clazz.cast(geoLocation()));
        case "Failover":
            return Optional.ofNullable(clazz.cast(failoverAsString()));
        case "MultiValueAnswer":
            return Optional.ofNullable(clazz.cast(multiValueAnswer()));
        case "TTL":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "ResourceRecords":
            return Optional.ofNullable(clazz.cast(resourceRecords()));
        case "AliasTarget":
            return Optional.ofNullable(clazz.cast(aliasTarget()));
        case "HealthCheckId":
            return Optional.ofNullable(clazz.cast(healthCheckId()));
        case "TrafficPolicyInstanceId":
            return Optional.ofNullable(clazz.cast(trafficPolicyInstanceId()));
        case "CidrRoutingConfig":
            return Optional.ofNullable(clazz.cast(cidrRoutingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceRecordSet, T> g) {
        return obj -> g.apply((ResourceRecordSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceRecordSet> {
        /**
         * <p>
         * For <code>ChangeResourceRecordSets</code> requests, the name of the record that you want to create, update,
         * or delete. For <code>ListResourceRecordSets</code> responses, the name of a record in the specified hosted
         * zone.
         * </p>
         * <p>
         * <b>ChangeResourceRecordSets Only</b>
         * </p>
         * <p>
         * Enter a fully qualified domain name, for example, <code>www.example.com</code>. You can optionally include a
         * trailing dot. If you omit the trailing dot, Amazon Route 53 assumes that the domain name that you specify is
         * fully qualified. This means that Route 53 treats <code>www.example.com</code> (without a trailing dot) and
         * <code>www.example.com.</code> (with a trailing dot) as identical.
         * </p>
         * <p>
         * For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
         * <code>-</code> (hyphen) and how to specify internationalized domain names, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name
         * Format</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * <p>
         * You can use the asterisk (*) wildcard to replace the leftmost label in a domain name, for example,
         * <code>*.example.com</code>. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The * must replace the entire label. For example, you can't specify <code>*prod.example.com</code> or
         * <code>prod*.example.com</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The * can't replace any of the middle labels, for example, marketing.*.example.com.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you include * in any position other than the leftmost label in a domain name, DNS treats it as an *
         * character (ASCII 42), not as a wildcard.
         * </p>
         * <important>
         * <p>
         * You can't use the * wildcard for resource records sets that have a type of NS.
         * </p>
         * </important></li>
         * </ul>
         * <p>
         * You can use the * wildcard as the leftmost label in a domain name, for example, <code>*.example.com</code>.
         * You can't use an * for one of the middle labels, for example, <code>marketing.*.example.com</code>. In
         * addition, the * must replace the entire label; for example, you can't specify <code>prod*.example.com</code>.
         * </p>
         * 
         * @param name
         *        For <code>ChangeResourceRecordSets</code> requests, the name of the record that you want to create,
         *        update, or delete. For <code>ListResourceRecordSets</code> responses, the name of a record in the
         *        specified hosted zone.</p>
         *        <p>
         *        <b>ChangeResourceRecordSets Only</b>
         *        </p>
         *        <p>
         *        Enter a fully qualified domain name, for example, <code>www.example.com</code>. You can optionally
         *        include a trailing dot. If you omit the trailing dot, Amazon Route 53 assumes that the domain name
         *        that you specify is fully qualified. This means that Route 53 treats <code>www.example.com</code>
         *        (without a trailing dot) and <code>www.example.com.</code> (with a trailing dot) as identical.
         *        </p>
         *        <p>
         *        For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
         *        <code>-</code> (hyphen) and how to specify internationalized domain names, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name
         *        Format</a> in the <i>Amazon Route 53 Developer Guide</i>.
         *        </p>
         *        <p>
         *        You can use the asterisk (*) wildcard to replace the leftmost label in a domain name, for example,
         *        <code>*.example.com</code>. Note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The * must replace the entire label. For example, you can't specify <code>*prod.example.com</code> or
         *        <code>prod*.example.com</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The * can't replace any of the middle labels, for example, marketing.*.example.com.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you include * in any position other than the leftmost label in a domain name, DNS treats it as an *
         *        character (ASCII 42), not as a wildcard.
         *        </p>
         *        <important>
         *        <p>
         *        You can't use the * wildcard for resource records sets that have a type of NS.
         *        </p>
         *        </important></li>
         *        </ul>
         *        <p>
         *        You can use the * wildcard as the leftmost label in a domain name, for example,
         *        <code>*.example.com</code>. You can't use an * for one of the middle labels, for example,
         *        <code>marketing.*.example.com</code>. In addition, the * must replace the entire label; for example,
         *        you can't specify <code>prod*.example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The DNS record type. For information about different record types and how data is encoded for them, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS
         * Resource Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * <p>
         * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
         * <code>CNAME</code> | <code>DS</code> |<code>MX</code> | <code>NAPTR</code> | <code>NS</code> |
         * <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         * </p>
         * <p>
         * Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> |
         * <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> |
         * <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>. When creating a group of weighted,
         * latency, geolocation, or failover resource record sets, specify the same value for all of the resource record
         * sets in the group.
         * </p>
         * <p>
         * Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> | <code>MX</code>
         * | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         * </p>
         * <note>
         * <p>
         * SPF records were formerly used to verify the identity of the sender of email messages. However, we no longer
         * recommend that you create resource record sets for which the value of <code>Type</code> is <code>SPF</code>.
         * RFC 7208, <i>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email, Version 1</i>, has been
         * updated to say,
         * "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it."
         * In RFC 7208, see section 14.1, <a href="http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS Record
         * Type</a>.
         * </p>
         * </note>
         * <p>
         * Values for alias resource record sets:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Amazon API Gateway custom regional APIs and edge-optimized APIs:</b> <code>A</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CloudFront distributions:</b> <code>A</code>
         * </p>
         * <p>
         * If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your
         * distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon API Gateway environment that has a regionalized subdomain</b>: <code>A</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ELB load balancers:</b> <code>A</code> | <code>AAAA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon S3 buckets:</b> <code>A</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon Virtual Private Cloud interface VPC endpoints</b> <code>A</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Another resource record set in this hosted zone:</b> Specify the type of the resource record set that
         * you're creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code>.
         * </p>
         * <note>
         * <p>
         * If you're creating an alias record that has the same name as the hosted zone (known as the zone apex), you
         * can't route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code>. This is
         * because the alias record must have the same type as the record you're routing traffic to, and creating a
         * CNAME record for the zone apex isn't supported even for an alias record.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param type
         *        The DNS record type. For information about different record types and how data is encoded for them,
         *        see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported
         *        DNS Resource Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
         *        <p>
         *        Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
         *        <code>CNAME</code> | <code>DS</code> |<code>MX</code> | <code>NAPTR</code> | <code>NS</code> |
         *        <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         *        </p>
         *        <p>
         *        Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> |
         *        <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> |
         *        <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>. When creating a group of
         *        weighted, latency, geolocation, or failover resource record sets, specify the same value for all of
         *        the resource record sets in the group.
         *        </p>
         *        <p>
         *        Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> |
         *        <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> |
         *        <code>TXT</code>
         *        </p>
         *        <note>
         *        <p>
         *        SPF records were formerly used to verify the identity of the sender of email messages. However, we no
         *        longer recommend that you create resource record sets for which the value of <code>Type</code> is
         *        <code>SPF</code>. RFC 7208, <i>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email,
         *        Version 1</i>, has been updated to say,
         *        "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it."
         *        In RFC 7208, see section 14.1, <a href="http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS
         *        Record Type</a>.
         *        </p>
         *        </note>
         *        <p>
         *        Values for alias resource record sets:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Amazon API Gateway custom regional APIs and edge-optimized APIs:</b> <code>A</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CloudFront distributions:</b> <code>A</code>
         *        </p>
         *        <p>
         *        If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your
         *        distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon API Gateway environment that has a regionalized subdomain</b>: <code>A</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ELB load balancers:</b> <code>A</code> | <code>AAAA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon S3 buckets:</b> <code>A</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon Virtual Private Cloud interface VPC endpoints</b> <code>A</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Another resource record set in this hosted zone:</b> Specify the type of the resource record set
         *        that you're creating the alias for. All values are supported except <code>NS</code> and
         *        <code>SOA</code>.
         *        </p>
         *        <note>
         *        <p>
         *        If you're creating an alias record that has the same name as the hosted zone (known as the zone apex),
         *        you can't route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code>.
         *        This is because the alias record must have the same type as the record you're routing traffic to, and
         *        creating a CNAME record for the zone apex isn't supported even for an alias record.
         *        </p>
         *        </note></li>
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder type(String type);

        /**
         * <p>
         * The DNS record type. For information about different record types and how data is encoded for them, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS
         * Resource Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * <p>
         * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
         * <code>CNAME</code> | <code>DS</code> |<code>MX</code> | <code>NAPTR</code> | <code>NS</code> |
         * <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         * </p>
         * <p>
         * Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> |
         * <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> |
         * <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>. When creating a group of weighted,
         * latency, geolocation, or failover resource record sets, specify the same value for all of the resource record
         * sets in the group.
         * </p>
         * <p>
         * Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> | <code>MX</code>
         * | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         * </p>
         * <note>
         * <p>
         * SPF records were formerly used to verify the identity of the sender of email messages. However, we no longer
         * recommend that you create resource record sets for which the value of <code>Type</code> is <code>SPF</code>.
         * RFC 7208, <i>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email, Version 1</i>, has been
         * updated to say,
         * "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it."
         * In RFC 7208, see section 14.1, <a href="http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS Record
         * Type</a>.
         * </p>
         * </note>
         * <p>
         * Values for alias resource record sets:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Amazon API Gateway custom regional APIs and edge-optimized APIs:</b> <code>A</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CloudFront distributions:</b> <code>A</code>
         * </p>
         * <p>
         * If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your
         * distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon API Gateway environment that has a regionalized subdomain</b>: <code>A</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ELB load balancers:</b> <code>A</code> | <code>AAAA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon S3 buckets:</b> <code>A</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon Virtual Private Cloud interface VPC endpoints</b> <code>A</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Another resource record set in this hosted zone:</b> Specify the type of the resource record set that
         * you're creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code>.
         * </p>
         * <note>
         * <p>
         * If you're creating an alias record that has the same name as the hosted zone (known as the zone apex), you
         * can't route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code>. This is
         * because the alias record must have the same type as the record you're routing traffic to, and creating a
         * CNAME record for the zone apex isn't supported even for an alias record.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param type
         *        The DNS record type. For information about different record types and how data is encoded for them,
         *        see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported
         *        DNS Resource Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
         *        <p>
         *        Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
         *        <code>CNAME</code> | <code>DS</code> |<code>MX</code> | <code>NAPTR</code> | <code>NS</code> |
         *        <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         *        </p>
         *        <p>
         *        Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> |
         *        <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> |
         *        <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>. When creating a group of
         *        weighted, latency, geolocation, or failover resource record sets, specify the same value for all of
         *        the resource record sets in the group.
         *        </p>
         *        <p>
         *        Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> |
         *        <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> |
         *        <code>TXT</code>
         *        </p>
         *        <note>
         *        <p>
         *        SPF records were formerly used to verify the identity of the sender of email messages. However, we no
         *        longer recommend that you create resource record sets for which the value of <code>Type</code> is
         *        <code>SPF</code>. RFC 7208, <i>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email,
         *        Version 1</i>, has been updated to say,
         *        "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it."
         *        In RFC 7208, see section 14.1, <a href="http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS
         *        Record Type</a>.
         *        </p>
         *        </note>
         *        <p>
         *        Values for alias resource record sets:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Amazon API Gateway custom regional APIs and edge-optimized APIs:</b> <code>A</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CloudFront distributions:</b> <code>A</code>
         *        </p>
         *        <p>
         *        If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your
         *        distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon API Gateway environment that has a regionalized subdomain</b>: <code>A</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ELB load balancers:</b> <code>A</code> | <code>AAAA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon S3 buckets:</b> <code>A</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon Virtual Private Cloud interface VPC endpoints</b> <code>A</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Another resource record set in this hosted zone:</b> Specify the type of the resource record set
         *        that you're creating the alias for. All values are supported except <code>NS</code> and
         *        <code>SOA</code>.
         *        </p>
         *        <note>
         *        <p>
         *        If you're creating an alias record that has the same name as the hosted zone (known as the zone apex),
         *        you can't route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code>.
         *        This is because the alias record must have the same type as the record you're routing traffic to, and
         *        creating a CNAME record for the zone apex isn't supported even for an alias record.
         *        </p>
         *        </note></li>
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder type(RRType type);

        /**
         * <p>
         * <i>Resource record sets that have a routing policy other than simple:</i> An identifier that differentiates
         * among multiple resource record sets that have the same combination of name and type, such as multiple
         * weighted resource record sets named acme.example.com that have a type of A. In a group of resource record
         * sets that have the same name and type, the value of <code>SetIdentifier</code> must be unique for each
         * resource record set.
         * </p>
         * <p>
         * For information about routing policies, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing
         * Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * 
         * @param setIdentifier
         *        <i>Resource record sets that have a routing policy other than simple:</i> An identifier that
         *        differentiates among multiple resource record sets that have the same combination of name and type,
         *        such as multiple weighted resource record sets named acme.example.com that have a type of A. In a
         *        group of resource record sets that have the same name and type, the value of
         *        <code>SetIdentifier</code> must be unique for each resource record set. </p>
         *        <p>
         *        For information about routing policies, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a
         *        Routing Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setIdentifier(String setIdentifier);

        /**
         * <p>
         * <i>Weighted resource record sets only:</i> Among resource record sets that have the same combination of DNS
         * name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using
         * the current resource record set. Route 53 calculates the sum of the weights for the resource record sets that
         * have the same combination of DNS name and type. Route 53 then responds to queries based on the ratio of a
         * resource's weight to the total. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You must specify a value for the <code>Weight</code> element for every weighted resource record set.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can only specify one <code>ResourceRecord</code> per weighted resource record set.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can't create latency, failover, or geolocation resource record sets that have the same values for the
         * <code>Name</code> and <code>Type</code> elements as weighted resource record sets.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can create a maximum of 100 weighted resource record sets that have the same values for the
         * <code>Name</code> and <code>Type</code> elements.
         * </p>
         * </li>
         * <li>
         * <p>
         * For weighted (but not weighted alias) resource record sets, if you set <code>Weight</code> to <code>0</code>
         * for a resource record set, Route 53 never responds to queries with the applicable value for that resource
         * record set. However, if you set <code>Weight</code> to <code>0</code> for all resource record sets that have
         * the same combination of DNS name and type, traffic is routed to all resources with equal probability.
         * </p>
         * <p>
         * The effect of setting <code>Weight</code> to <code>0</code> is different when you associate health checks
         * with weighted resource record sets. For more information, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html"
         * >Options for Configuring Route 53 Active-Active and Active-Passive Failover</a> in the <i>Amazon Route 53
         * Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param weight
         *        <i>Weighted resource record sets only:</i> Among resource record sets that have the same combination
         *        of DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53
         *        responds to using the current resource record set. Route 53 calculates the sum of the weights for the
         *        resource record sets that have the same combination of DNS name and type. Route 53 then responds to
         *        queries based on the ratio of a resource's weight to the total. Note the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        You must specify a value for the <code>Weight</code> element for every weighted resource record set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can only specify one <code>ResourceRecord</code> per weighted resource record set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can't create latency, failover, or geolocation resource record sets that have the same values for
         *        the <code>Name</code> and <code>Type</code> elements as weighted resource record sets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can create a maximum of 100 weighted resource record sets that have the same values for the
         *        <code>Name</code> and <code>Type</code> elements.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For weighted (but not weighted alias) resource record sets, if you set <code>Weight</code> to
         *        <code>0</code> for a resource record set, Route 53 never responds to queries with the applicable value
         *        for that resource record set. However, if you set <code>Weight</code> to <code>0</code> for all
         *        resource record sets that have the same combination of DNS name and type, traffic is routed to all
         *        resources with equal probability.
         *        </p>
         *        <p>
         *        The effect of setting <code>Weight</code> to <code>0</code> is different when you associate health
         *        checks with weighted resource record sets. For more information, see <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html"
         *        >Options for Configuring Route 53 Active-Active and Active-Passive Failover</a> in the <i>Amazon Route
         *        53 Developer Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Long weight);

        /**
         * <p>
         * <i>Latency-based resource record sets only:</i> The Amazon EC2 Region where you created the resource that
         * this resource record set refers to. The resource typically is an Amazon Web Services resource, such as an EC2
         * instance or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending on the
         * record type.
         * </p>
         * <p>
         * When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency
         * resource record sets, Route 53 selects the latency resource record set that has the lowest latency between
         * the end user and the associated Amazon EC2 Region. Route 53 then returns the value that is associated with
         * the selected resource record set.
         * </p>
         * <p>
         * Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can only specify one <code>ResourceRecord</code> per latency resource record set.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can only create one latency resource record set for each Amazon EC2 Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will choose
         * the region with the best latency from among the regions that you create latency resource record sets for.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can't create non-latency resource record sets that have the same values for the <code>Name</code> and
         * <code>Type</code> elements as latency resource record sets.
         * </p>
         * </li>
         * </ul>
         * 
         * @param region
         *        <i>Latency-based resource record sets only:</i> The Amazon EC2 Region where you created the resource
         *        that this resource record set refers to. The resource typically is an Amazon Web Services resource,
         *        such as an EC2 instance or an ELB load balancer, and is referred to by an IP address or a DNS domain
         *        name, depending on the record type.</p>
         *        <p>
         *        When Amazon Route 53 receives a DNS query for a domain name and type for which you have created
         *        latency resource record sets, Route 53 selects the latency resource record set that has the lowest
         *        latency between the end user and the associated Amazon EC2 Region. Route 53 then returns the value
         *        that is associated with the selected resource record set.
         *        </p>
         *        <p>
         *        Note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You can only specify one <code>ResourceRecord</code> per latency resource record set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can only create one latency resource record set for each Amazon EC2 Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will
         *        choose the region with the best latency from among the regions that you create latency resource record
         *        sets for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can't create non-latency resource record sets that have the same values for the <code>Name</code>
         *        and <code>Type</code> elements as latency resource record sets.
         *        </p>
         *        </li>
         * @see ResourceRecordSetRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceRecordSetRegion
         */
        Builder region(String region);

        /**
         * <p>
         * <i>Latency-based resource record sets only:</i> The Amazon EC2 Region where you created the resource that
         * this resource record set refers to. The resource typically is an Amazon Web Services resource, such as an EC2
         * instance or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending on the
         * record type.
         * </p>
         * <p>
         * When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency
         * resource record sets, Route 53 selects the latency resource record set that has the lowest latency between
         * the end user and the associated Amazon EC2 Region. Route 53 then returns the value that is associated with
         * the selected resource record set.
         * </p>
         * <p>
         * Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can only specify one <code>ResourceRecord</code> per latency resource record set.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can only create one latency resource record set for each Amazon EC2 Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will choose
         * the region with the best latency from among the regions that you create latency resource record sets for.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can't create non-latency resource record sets that have the same values for the <code>Name</code> and
         * <code>Type</code> elements as latency resource record sets.
         * </p>
         * </li>
         * </ul>
         * 
         * @param region
         *        <i>Latency-based resource record sets only:</i> The Amazon EC2 Region where you created the resource
         *        that this resource record set refers to. The resource typically is an Amazon Web Services resource,
         *        such as an EC2 instance or an ELB load balancer, and is referred to by an IP address or a DNS domain
         *        name, depending on the record type.</p>
         *        <p>
         *        When Amazon Route 53 receives a DNS query for a domain name and type for which you have created
         *        latency resource record sets, Route 53 selects the latency resource record set that has the lowest
         *        latency between the end user and the associated Amazon EC2 Region. Route 53 then returns the value
         *        that is associated with the selected resource record set.
         *        </p>
         *        <p>
         *        Note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You can only specify one <code>ResourceRecord</code> per latency resource record set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can only create one latency resource record set for each Amazon EC2 Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will
         *        choose the region with the best latency from among the regions that you create latency resource record
         *        sets for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can't create non-latency resource record sets that have the same values for the <code>Name</code>
         *        and <code>Type</code> elements as latency resource record sets.
         *        </p>
         *        </li>
         * @see ResourceRecordSetRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceRecordSetRegion
         */
        Builder region(ResourceRecordSetRegion region);

        /**
         * <p>
         * <i>Geolocation resource record sets only:</i> A complex type that lets you control how Amazon Route 53
         * responds to DNS queries based on the geographic origin of the query. For example, if you want all queries
         * from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code>, create a resource
         * record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code>.
         * </p>
         * <note>
         * <p>
         * Although creating geolocation and geolocation alias resource record sets in a private hosted zone is allowed,
         * it's not supported.
         * </p>
         * </note>
         * <p>
         * If you create separate resource record sets for overlapping geographic regions (for example, one resource
         * record set for a continent and one for a country on the same continent), priority goes to the smallest
         * geographic region. This allows you to route most queries for a continent to one resource and to route queries
         * for a country on that continent to a different resource.
         * </p>
         * <p>
         * You can't create two geolocation resource record sets that specify the same geographic location.
         * </p>
         * <p>
         * The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren't
         * specified in other geolocation resource record sets that have the same values for the <code>Name</code> and
         * <code>Type</code> elements.
         * </p>
         * <important>
         * <p>
         * Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to
         * geographic locations, so even if you create geolocation resource record sets that cover all seven continents,
         * Route 53 will receive some DNS queries from locations that it can't identify. We recommend that you create a
         * resource record set for which the value of <code>CountryCode</code> is <code>*</code>. Two groups of queries
         * are routed to the resource that you specify in this record: queries that come from locations for which you
         * haven't created geolocation resource record sets and queries from IP addresses that aren't mapped to a
         * location. If you don't create a <code>*</code> resource record set, Route 53 returns a "no answer" response
         * for queries from those locations.
         * </p>
         * </important>
         * <p>
         * You can't create non-geolocation resource record sets that have the same values for the <code>Name</code> and
         * <code>Type</code> elements as geolocation resource record sets.
         * </p>
         * 
         * @param geoLocation
         *        <i>Geolocation resource record sets only:</i> A complex type that lets you control how Amazon Route 53
         *        responds to DNS queries based on the geographic origin of the query. For example, if you want all
         *        queries from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code>,
         *        create a resource record set with a <code>Type</code> of <code>A</code> and a
         *        <code>ContinentCode</code> of <code>AF</code>.</p> <note>
         *        <p>
         *        Although creating geolocation and geolocation alias resource record sets in a private hosted zone is
         *        allowed, it's not supported.
         *        </p>
         *        </note>
         *        <p>
         *        If you create separate resource record sets for overlapping geographic regions (for example, one
         *        resource record set for a continent and one for a country on the same continent), priority goes to the
         *        smallest geographic region. This allows you to route most queries for a continent to one resource and
         *        to route queries for a country on that continent to a different resource.
         *        </p>
         *        <p>
         *        You can't create two geolocation resource record sets that specify the same geographic location.
         *        </p>
         *        <p>
         *        The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that
         *        aren't specified in other geolocation resource record sets that have the same values for the
         *        <code>Name</code> and <code>Type</code> elements.
         *        </p>
         *        <important>
         *        <p>
         *        Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to
         *        geographic locations, so even if you create geolocation resource record sets that cover all seven
         *        continents, Route 53 will receive some DNS queries from locations that it can't identify. We recommend
         *        that you create a resource record set for which the value of <code>CountryCode</code> is
         *        <code>*</code>. Two groups of queries are routed to the resource that you specify in this record:
         *        queries that come from locations for which you haven't created geolocation resource record sets and
         *        queries from IP addresses that aren't mapped to a location. If you don't create a <code>*</code>
         *        resource record set, Route 53 returns a "no answer" response for queries from those locations.
         *        </p>
         *        </important>
         *        <p>
         *        You can't create non-geolocation resource record sets that have the same values for the
         *        <code>Name</code> and <code>Type</code> elements as geolocation resource record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoLocation(GeoLocation geoLocation);

        /**
         * <p>
         * <i>Geolocation resource record sets only:</i> A complex type that lets you control how Amazon Route 53
         * responds to DNS queries based on the geographic origin of the query. For example, if you want all queries
         * from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code>, create a resource
         * record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code>.
         * </p>
         * <note>
         * <p>
         * Although creating geolocation and geolocation alias resource record sets in a private hosted zone is allowed,
         * it's not supported.
         * </p>
         * </note>
         * <p>
         * If you create separate resource record sets for overlapping geographic regions (for example, one resource
         * record set for a continent and one for a country on the same continent), priority goes to the smallest
         * geographic region. This allows you to route most queries for a continent to one resource and to route queries
         * for a country on that continent to a different resource.
         * </p>
         * <p>
         * You can't create two geolocation resource record sets that specify the same geographic location.
         * </p>
         * <p>
         * The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren't
         * specified in other geolocation resource record sets that have the same values for the <code>Name</code> and
         * <code>Type</code> elements.
         * </p>
         * <important>
         * <p>
         * Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to
         * geographic locations, so even if you create geolocation resource record sets that cover all seven continents,
         * Route 53 will receive some DNS queries from locations that it can't identify. We recommend that you create a
         * resource record set for which the value of <code>CountryCode</code> is <code>*</code>. Two groups of queries
         * are routed to the resource that you specify in this record: queries that come from locations for which you
         * haven't created geolocation resource record sets and queries from IP addresses that aren't mapped to a
         * location. If you don't create a <code>*</code> resource record set, Route 53 returns a "no answer" response
         * for queries from those locations.
         * </p>
         * </important>
         * <p>
         * You can't create non-geolocation resource record sets that have the same values for the <code>Name</code> and
         * <code>Type</code> elements as geolocation resource record sets.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeoLocation.Builder} avoiding the need to
         * create one manually via {@link GeoLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeoLocation.Builder#build()} is called immediately and its result
         * is passed to {@link #geoLocation(GeoLocation)}.
         * 
         * @param geoLocation
         *        a consumer that will call methods on {@link GeoLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoLocation(GeoLocation)
         */
        default Builder geoLocation(Consumer<GeoLocation.Builder> geoLocation) {
            return geoLocation(GeoLocation.builder().applyMutation(geoLocation).build());
        }

        /**
         * <p>
         * <i>Failover resource record sets only:</i> To configure failover, you add the <code>Failover</code> element
         * to two resource record sets. For one resource record set, you specify <code>PRIMARY</code> as the value for
         * <code>Failover</code>; for the other resource record set, you specify <code>SECONDARY</code>. In addition,
         * you include the <code>HealthCheckId</code> element and specify the health check that you want Amazon Route 53
         * to perform for each resource record set.
         * </p>
         * <p>
         * Except where noted, the following failover behaviors assume that you have included the
         * <code>HealthCheckId</code> element in both resource record sets:
         * </p>
         * <ul>
         * <li>
         * <p>
         * When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable value
         * from the primary resource record set regardless of the health of the secondary resource record set.
         * </p>
         * </li>
         * <li>
         * <p>
         * When the primary resource record set is unhealthy and the secondary resource record set is healthy, Route 53
         * responds to DNS queries with the applicable value from the secondary resource record set.
         * </p>
         * </li>
         * <li>
         * <p>
         * When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the applicable
         * value from the primary resource record set regardless of the health of the primary resource record set.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the primary
         * resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable value from the
         * secondary resource record set. This is true regardless of the health of the associated endpoint.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can't create non-failover resource record sets that have the same values for the <code>Name</code> and
         * <code>Type</code> elements as failover resource record sets.
         * </p>
         * <p>
         * For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code> element
         * and set the value to true.
         * </p>
         * <p>
         * For more information about configuring failover for Route 53, see the following topics in the <i>Amazon Route
         * 53 Developer Guide</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks
         * and DNS Failover</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">
         * Configuring Failover in a Private Hosted Zone</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param failover
         *        <i>Failover resource record sets only:</i> To configure failover, you add the <code>Failover</code>
         *        element to two resource record sets. For one resource record set, you specify <code>PRIMARY</code> as
         *        the value for <code>Failover</code>; for the other resource record set, you specify
         *        <code>SECONDARY</code>. In addition, you include the <code>HealthCheckId</code> element and specify
         *        the health check that you want Amazon Route 53 to perform for each resource record set.</p>
         *        <p>
         *        Except where noted, the following failover behaviors assume that you have included the
         *        <code>HealthCheckId</code> element in both resource record sets:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable
         *        value from the primary resource record set regardless of the health of the secondary resource record
         *        set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When the primary resource record set is unhealthy and the secondary resource record set is healthy,
         *        Route 53 responds to DNS queries with the applicable value from the secondary resource record set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the
         *        applicable value from the primary resource record set regardless of the health of the primary resource
         *        record set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the
         *        primary resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable
         *        value from the secondary resource record set. This is true regardless of the health of the associated
         *        endpoint.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can't create non-failover resource record sets that have the same values for the <code>Name</code>
         *        and <code>Type</code> elements as failover resource record sets.
         *        </p>
         *        <p>
         *        For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code>
         *        element and set the value to true.
         *        </p>
         *        <p>
         *        For more information about configuring failover for Route 53, see the following topics in the
         *        <i>Amazon Route 53 Developer Guide</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health
         *        Checks and DNS Failover</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html"
         *        >Configuring Failover in a Private Hosted Zone</a>
         *        </p>
         *        </li>
         * @see ResourceRecordSetFailover
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceRecordSetFailover
         */
        Builder failover(String failover);

        /**
         * <p>
         * <i>Failover resource record sets only:</i> To configure failover, you add the <code>Failover</code> element
         * to two resource record sets. For one resource record set, you specify <code>PRIMARY</code> as the value for
         * <code>Failover</code>; for the other resource record set, you specify <code>SECONDARY</code>. In addition,
         * you include the <code>HealthCheckId</code> element and specify the health check that you want Amazon Route 53
         * to perform for each resource record set.
         * </p>
         * <p>
         * Except where noted, the following failover behaviors assume that you have included the
         * <code>HealthCheckId</code> element in both resource record sets:
         * </p>
         * <ul>
         * <li>
         * <p>
         * When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable value
         * from the primary resource record set regardless of the health of the secondary resource record set.
         * </p>
         * </li>
         * <li>
         * <p>
         * When the primary resource record set is unhealthy and the secondary resource record set is healthy, Route 53
         * responds to DNS queries with the applicable value from the secondary resource record set.
         * </p>
         * </li>
         * <li>
         * <p>
         * When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the applicable
         * value from the primary resource record set regardless of the health of the primary resource record set.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the primary
         * resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable value from the
         * secondary resource record set. This is true regardless of the health of the associated endpoint.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can't create non-failover resource record sets that have the same values for the <code>Name</code> and
         * <code>Type</code> elements as failover resource record sets.
         * </p>
         * <p>
         * For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code> element
         * and set the value to true.
         * </p>
         * <p>
         * For more information about configuring failover for Route 53, see the following topics in the <i>Amazon Route
         * 53 Developer Guide</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks
         * and DNS Failover</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">
         * Configuring Failover in a Private Hosted Zone</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param failover
         *        <i>Failover resource record sets only:</i> To configure failover, you add the <code>Failover</code>
         *        element to two resource record sets. For one resource record set, you specify <code>PRIMARY</code> as
         *        the value for <code>Failover</code>; for the other resource record set, you specify
         *        <code>SECONDARY</code>. In addition, you include the <code>HealthCheckId</code> element and specify
         *        the health check that you want Amazon Route 53 to perform for each resource record set.</p>
         *        <p>
         *        Except where noted, the following failover behaviors assume that you have included the
         *        <code>HealthCheckId</code> element in both resource record sets:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable
         *        value from the primary resource record set regardless of the health of the secondary resource record
         *        set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When the primary resource record set is unhealthy and the secondary resource record set is healthy,
         *        Route 53 responds to DNS queries with the applicable value from the secondary resource record set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the
         *        applicable value from the primary resource record set regardless of the health of the primary resource
         *        record set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the
         *        primary resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable
         *        value from the secondary resource record set. This is true regardless of the health of the associated
         *        endpoint.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can't create non-failover resource record sets that have the same values for the <code>Name</code>
         *        and <code>Type</code> elements as failover resource record sets.
         *        </p>
         *        <p>
         *        For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code>
         *        element and set the value to true.
         *        </p>
         *        <p>
         *        For more information about configuring failover for Route 53, see the following topics in the
         *        <i>Amazon Route 53 Developer Guide</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health
         *        Checks and DNS Failover</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html"
         *        >Configuring Failover in a Private Hosted Zone</a>
         *        </p>
         *        </li>
         * @see ResourceRecordSetFailover
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceRecordSetFailover
         */
        Builder failover(ResourceRecordSetFailover failover);

        /**
         * <p>
         * <i>Multivalue answer resource record sets only</i>: To route traffic approximately randomly to multiple
         * resources, such as web servers, create one multivalue answer record for each resource and specify
         * <code>true</code> for <code>MultiValueAnswer</code>. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to DNS
         * queries with the corresponding IP address only when the health check is healthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't associate a health check with a multivalue answer record, Route 53 always considers the record
         * to be healthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy
         * records, Route 53 responds to all DNS queries with all the healthy records.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have more than eight healthy records, Route 53 responds to different DNS resolvers with different
         * combinations of healthy records.
         * </p>
         * </li>
         * <li>
         * <p>
         * When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.
         * </p>
         * </li>
         * <li>
         * <p>
         * If a resource becomes unavailable after a resolver caches a response, client software typically tries another
         * of the IP addresses in the response.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can't create multivalue answer alias records.
         * </p>
         * 
         * @param multiValueAnswer
         *        <i>Multivalue answer resource record sets only</i>: To route traffic approximately randomly to
         *        multiple resources, such as web servers, create one multivalue answer record for each resource and
         *        specify <code>true</code> for <code>MultiValueAnswer</code>. Note the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds
         *        to DNS queries with the corresponding IP address only when the health check is healthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't associate a health check with a multivalue answer record, Route 53 always considers the
         *        record to be healthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy
         *        records, Route 53 responds to all DNS queries with all the healthy records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have more than eight healthy records, Route 53 responds to different DNS resolvers with
         *        different combinations of healthy records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If a resource becomes unavailable after a resolver caches a response, client software typically tries
         *        another of the IP addresses in the response.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can't create multivalue answer alias records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiValueAnswer(Boolean multiValueAnswer);

        /**
         * <p>
         * The resource record cache time to live (TTL), in seconds. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you're creating or updating an alias resource record set, omit <code>TTL</code>. Amazon Route 53 uses the
         * value of <code>TTL</code> for the alias target.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you're associating this resource record set with a health check (if you're adding a
         * <code>HealthCheckId</code> element), we recommend that you specify a <code>TTL</code> of 60 seconds or less
         * so clients respond quickly to changes in health status.
         * </p>
         * </li>
         * <li>
         * <p>
         * All of the resource record sets in a group of weighted resource record sets must have the same value for
         * <code>TTL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If a group of weighted resource record sets includes one or more weighted alias resource record sets for
         * which the alias target is an ELB load balancer, we recommend that you specify a <code>TTL</code> of 60
         * seconds for all of the non-alias weighted resource record sets that have the same name and type. Values other
         * than 60 seconds (the TTL for load balancers) will change the effect of the values that you specify for
         * <code>Weight</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param ttl
         *        The resource record cache time to live (TTL), in seconds. Note the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you're creating or updating an alias resource record set, omit <code>TTL</code>. Amazon Route 53
         *        uses the value of <code>TTL</code> for the alias target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you're associating this resource record set with a health check (if you're adding a
         *        <code>HealthCheckId</code> element), we recommend that you specify a <code>TTL</code> of 60 seconds or
         *        less so clients respond quickly to changes in health status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        All of the resource record sets in a group of weighted resource record sets must have the same value
         *        for <code>TTL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If a group of weighted resource record sets includes one or more weighted alias resource record sets
         *        for which the alias target is an ELB load balancer, we recommend that you specify a <code>TTL</code>
         *        of 60 seconds for all of the non-alias weighted resource record sets that have the same name and type.
         *        Values other than 60 seconds (the TTL for load balancers) will change the effect of the values that
         *        you specify for <code>Weight</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);

        /**
         * <p>
         * Information about the resource records to act upon.
         * </p>
         * <note>
         * <p>
         * If you're creating an alias resource record set, omit <code>ResourceRecords</code>.
         * </p>
         * </note>
         * 
         * @param resourceRecords
         *        Information about the resource records to act upon.</p> <note>
         *        <p>
         *        If you're creating an alias resource record set, omit <code>ResourceRecords</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecords(Collection<ResourceRecord> resourceRecords);

        /**
         * <p>
         * Information about the resource records to act upon.
         * </p>
         * <note>
         * <p>
         * If you're creating an alias resource record set, omit <code>ResourceRecords</code>.
         * </p>
         * </note>
         * 
         * @param resourceRecords
         *        Information about the resource records to act upon.</p> <note>
         *        <p>
         *        If you're creating an alias resource record set, omit <code>ResourceRecords</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecords(ResourceRecord... resourceRecords);

        /**
         * <p>
         * Information about the resource records to act upon.
         * </p>
         * <note>
         * <p>
         * If you're creating an alias resource record set, omit <code>ResourceRecords</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53.model.ResourceRecord.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.route53.model.ResourceRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53.model.ResourceRecord.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceRecords(List<ResourceRecord>)}.
         * 
         * @param resourceRecords
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53.model.ResourceRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRecords(java.util.Collection<ResourceRecord>)
         */
        Builder resourceRecords(Consumer<ResourceRecord.Builder>... resourceRecords);

        /**
         * <p>
         * <i>Alias resource record sets only:</i> Information about the Amazon Web Services resource, such as a
         * CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to.
         * </p>
         * <p>
         * If you're creating resource records sets for a private hosted zone, note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront
         * distribution.
         * </p>
         * </li>
         * <li>
         * <p>
         * For information about creating failover resource record sets in a private hosted zone, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html"
         * >Configuring Failover in a Private Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aliasTarget
         *        <i>Alias resource record sets only:</i> Information about the Amazon Web Services resource, such as a
         *        CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to. </p>
         *        <p>
         *        If you're creating resource records sets for a private hosted zone, note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You can't create an alias resource record set in a private hosted zone to route traffic to a
         *        CloudFront distribution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For information about creating failover resource record sets in a private hosted zone, see <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html"
         *        >Configuring Failover in a Private Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasTarget(AliasTarget aliasTarget);

        /**
         * <p>
         * <i>Alias resource record sets only:</i> Information about the Amazon Web Services resource, such as a
         * CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to.
         * </p>
         * <p>
         * If you're creating resource records sets for a private hosted zone, note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront
         * distribution.
         * </p>
         * </li>
         * <li>
         * <p>
         * For information about creating failover resource record sets in a private hosted zone, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html"
         * >Configuring Failover in a Private Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link AliasTarget.Builder} avoiding the need to
         * create one manually via {@link AliasTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AliasTarget.Builder#build()} is called immediately and its result
         * is passed to {@link #aliasTarget(AliasTarget)}.
         * 
         * @param aliasTarget
         *        a consumer that will call methods on {@link AliasTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliasTarget(AliasTarget)
         */
        default Builder aliasTarget(Consumer<AliasTarget.Builder> aliasTarget) {
            return aliasTarget(AliasTarget.builder().applyMutation(aliasTarget).build());
        }

        /**
         * <p>
         * If you want Amazon Route 53 to return this resource record set in response to a DNS query only when the
         * status of a health check is healthy, include the <code>HealthCheckId</code> element and specify the ID of the
         * applicable health check.
         * </p>
         * <p>
         * Route 53 determines whether a resource record set is healthy based on one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * By periodically sending a request to the endpoint that is specified in the health check
         * </p>
         * </li>
         * <li>
         * <p>
         * By aggregating the status of a specified group of health checks (calculated health checks)
         * </p>
         * </li>
         * <li>
         * <p>
         * By determining the current state of a CloudWatch alarm (CloudWatch metric health checks)
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * Route 53 doesn't check the health of the endpoint that is specified in the resource record set, for example,
         * the endpoint specified by the IP address in the <code>Value</code> element. When you add a
         * <code>HealthCheckId</code> element to a resource record set, Route 53 checks the health of the endpoint that
         * you specified in the health check.
         * </p>
         * </important>
         * <p>
         * For more information, see the following topics in the <i>Amazon Route 53 Developer Guide</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         * >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks
         * and DNS Failover</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">
         * Configuring Failover in a Private Hosted Zone</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>When to Specify HealthCheckId</b>
         * </p>
         * <p>
         * Specifying a value for <code>HealthCheckId</code> is useful only when Route 53 is choosing between two or
         * more resource record sets to respond to a DNS query, and you want Route 53 to base the choice in part on the
         * status of a health check. Configuring health checks makes sense only in the following configurations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Non-alias resource record sets</b>: You're checking the health of a group of non-alias resource record
         * sets that have the same routing policy, name, and type (such as multiple weighted records named
         * www.example.com with a type of A) and you specify health check IDs for all the resource record sets.
         * </p>
         * <p>
         * If the health check status for a resource record set is healthy, Route 53 includes the record among the
         * records that it responds to DNS queries with.
         * </p>
         * <p>
         * If the health check status for a resource record set is unhealthy, Route 53 stops responding to DNS queries
         * using the value for that resource record set.
         * </p>
         * <p>
         * If the health check status for all resource record sets in the group is unhealthy, Route 53 considers all
         * resource record sets in the group healthy and responds to DNS queries accordingly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Alias resource record sets</b>: You specify the following settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You set <code>EvaluateTargetHealth</code> to true for an alias resource record set in a group of resource
         * record sets that have the same routing policy, name, and type (such as multiple weighted records named
         * www.example.com with a type of A).
         * </p>
         * </li>
         * <li>
         * <p>
         * You configure the alias resource record set to route traffic to a non-alias resource record set in the same
         * hosted zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * You specify a health check ID for the non-alias resource record set.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the health check status is healthy, Route 53 considers the alias resource record set to be healthy and
         * includes the alias record among the records that it responds to DNS queries with.
         * </p>
         * <p>
         * If the health check status is unhealthy, Route 53 stops responding to DNS queries using the alias resource
         * record set.
         * </p>
         * <note>
         * <p>
         * The alias resource record set can also route traffic to a <i>group</i> of non-alias resource record sets that
         * have the same routing policy, name, and type. In that configuration, associate health checks with all of the
         * resource record sets in the group of non-alias resource record sets.
         * </p>
         * </note></li>
         * </ul>
         * <p>
         * <b>Geolocation Routing</b>
         * </p>
         * <p>
         * For geolocation resource record sets, if an endpoint is unhealthy, Route 53 looks for a resource record set
         * for the larger, associated geographic region. For example, suppose you have resource record sets for a state
         * in the United States, for the entire United States, for North America, and a resource record set that has
         * <code>*</code> for <code>CountryCode</code> is <code>*</code>, which applies to all locations. If the
         * endpoint for the state resource record set is unhealthy, Route 53 checks for healthy resource record sets in
         * the following order until it finds a resource record set for which the endpoint is healthy:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The United States
         * </p>
         * </li>
         * <li>
         * <p>
         * North America
         * </p>
         * </li>
         * <li>
         * <p>
         * The default resource record set
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Specifying the Health Check Endpoint by Domain Name</b>
         * </p>
         * <p>
         * If your health checks specify the endpoint only by domain name, we recommend that you create a separate
         * health check for each endpoint. For example, create a health check for each <code>HTTP</code> server that is
         * serving content for <code>www.example.com</code>. For the value of <code>FullyQualifiedDomainName</code>,
         * specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the
         * resource record sets (<code>www.example.com</code>).
         * </p>
         * <important>
         * <p>
         * Health check results will be unpredictable if you do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Create a health check that has the same value for <code>FullyQualifiedDomainName</code> as the name of a
         * resource record set.
         * </p>
         * </li>
         * <li>
         * <p>
         * Associate that health check with the resource record set.
         * </p>
         * </li>
         * </ul>
         * </important>
         * 
         * @param healthCheckId
         *        If you want Amazon Route 53 to return this resource record set in response to a DNS query only when
         *        the status of a health check is healthy, include the <code>HealthCheckId</code> element and specify
         *        the ID of the applicable health check.</p>
         *        <p>
         *        Route 53 determines whether a resource record set is healthy based on one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        By periodically sending a request to the endpoint that is specified in the health check
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        By aggregating the status of a specified group of health checks (calculated health checks)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        By determining the current state of a CloudWatch alarm (CloudWatch metric health checks)
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        Route 53 doesn't check the health of the endpoint that is specified in the resource record set, for
         *        example, the endpoint specified by the IP address in the <code>Value</code> element. When you add a
         *        <code>HealthCheckId</code> element to a resource record set, Route 53 checks the health of the
         *        endpoint that you specified in the health check.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see the following topics in the <i>Amazon Route 53 Developer Guide</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         *        >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health
         *        Checks and DNS Failover</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html"
         *        >Configuring Failover in a Private Hosted Zone</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>When to Specify HealthCheckId</b>
         *        </p>
         *        <p>
         *        Specifying a value for <code>HealthCheckId</code> is useful only when Route 53 is choosing between two
         *        or more resource record sets to respond to a DNS query, and you want Route 53 to base the choice in
         *        part on the status of a health check. Configuring health checks makes sense only in the following
         *        configurations:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Non-alias resource record sets</b>: You're checking the health of a group of non-alias resource
         *        record sets that have the same routing policy, name, and type (such as multiple weighted records named
         *        www.example.com with a type of A) and you specify health check IDs for all the resource record sets.
         *        </p>
         *        <p>
         *        If the health check status for a resource record set is healthy, Route 53 includes the record among
         *        the records that it responds to DNS queries with.
         *        </p>
         *        <p>
         *        If the health check status for a resource record set is unhealthy, Route 53 stops responding to DNS
         *        queries using the value for that resource record set.
         *        </p>
         *        <p>
         *        If the health check status for all resource record sets in the group is unhealthy, Route 53 considers
         *        all resource record sets in the group healthy and responds to DNS queries accordingly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Alias resource record sets</b>: You specify the following settings:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You set <code>EvaluateTargetHealth</code> to true for an alias resource record set in a group of
         *        resource record sets that have the same routing policy, name, and type (such as multiple weighted
         *        records named www.example.com with a type of A).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You configure the alias resource record set to route traffic to a non-alias resource record set in the
         *        same hosted zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You specify a health check ID for the non-alias resource record set.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the health check status is healthy, Route 53 considers the alias resource record set to be healthy
         *        and includes the alias record among the records that it responds to DNS queries with.
         *        </p>
         *        <p>
         *        If the health check status is unhealthy, Route 53 stops responding to DNS queries using the alias
         *        resource record set.
         *        </p>
         *        <note>
         *        <p>
         *        The alias resource record set can also route traffic to a <i>group</i> of non-alias resource record
         *        sets that have the same routing policy, name, and type. In that configuration, associate health checks
         *        with all of the resource record sets in the group of non-alias resource record sets.
         *        </p>
         *        </note></li>
         *        </ul>
         *        <p>
         *        <b>Geolocation Routing</b>
         *        </p>
         *        <p>
         *        For geolocation resource record sets, if an endpoint is unhealthy, Route 53 looks for a resource
         *        record set for the larger, associated geographic region. For example, suppose you have resource record
         *        sets for a state in the United States, for the entire United States, for North America, and a resource
         *        record set that has <code>*</code> for <code>CountryCode</code> is <code>*</code>, which applies to
         *        all locations. If the endpoint for the state resource record set is unhealthy, Route 53 checks for
         *        healthy resource record sets in the following order until it finds a resource record set for which the
         *        endpoint is healthy:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The United States
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        North America
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The default resource record set
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Specifying the Health Check Endpoint by Domain Name</b>
         *        </p>
         *        <p>
         *        If your health checks specify the endpoint only by domain name, we recommend that you create a
         *        separate health check for each endpoint. For example, create a health check for each <code>HTTP</code>
         *        server that is serving content for <code>www.example.com</code>. For the value of
         *        <code>FullyQualifiedDomainName</code>, specify the domain name of the server (such as
         *        <code>us-east-2-www.example.com</code>), not the name of the resource record sets (
         *        <code>www.example.com</code>).
         *        </p>
         *        <important>
         *        <p>
         *        Health check results will be unpredictable if you do the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Create a health check that has the same value for <code>FullyQualifiedDomainName</code> as the name of
         *        a resource record set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Associate that health check with the resource record set.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckId(String healthCheckId);

        /**
         * <p>
         * When you create a traffic policy instance, Amazon Route 53 automatically creates a resource record set.
         * <code>TrafficPolicyInstanceId</code> is the ID of the traffic policy instance that Route 53 created this
         * resource record set for.
         * </p>
         * <important>
         * <p>
         * To delete the resource record set that is associated with a traffic policy instance, use
         * <code>DeleteTrafficPolicyInstance</code>. Route 53 will delete the resource record set automatically. If you
         * delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't automatically
         * delete the traffic policy instance, and you'll continue to be charged for it even though it's no longer in
         * use.
         * </p>
         * </important>
         * 
         * @param trafficPolicyInstanceId
         *        When you create a traffic policy instance, Amazon Route 53 automatically creates a resource record
         *        set. <code>TrafficPolicyInstanceId</code> is the ID of the traffic policy instance that Route 53
         *        created this resource record set for.</p> <important>
         *        <p>
         *        To delete the resource record set that is associated with a traffic policy instance, use
         *        <code>DeleteTrafficPolicyInstance</code>. Route 53 will delete the resource record set automatically.
         *        If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't
         *        automatically delete the traffic policy instance, and you'll continue to be charged for it even though
         *        it's no longer in use.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstanceId(String trafficPolicyInstanceId);

        /**
         * Sets the value of the CidrRoutingConfig property for this object.
         *
         * @param cidrRoutingConfig
         *        The new value for the CidrRoutingConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrRoutingConfig(CidrRoutingConfig cidrRoutingConfig);

        /**
         * Sets the value of the CidrRoutingConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CidrRoutingConfig.Builder} avoiding the
         * need to create one manually via {@link CidrRoutingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CidrRoutingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cidrRoutingConfig(CidrRoutingConfig)}.
         * 
         * @param cidrRoutingConfig
         *        a consumer that will call methods on {@link CidrRoutingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrRoutingConfig(CidrRoutingConfig)
         */
        default Builder cidrRoutingConfig(Consumer<CidrRoutingConfig.Builder> cidrRoutingConfig) {
            return cidrRoutingConfig(CidrRoutingConfig.builder().applyMutation(cidrRoutingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String setIdentifier;

        private Long weight;

        private String region;

        private GeoLocation geoLocation;

        private String failover;

        private Boolean multiValueAnswer;

        private Long ttl;

        private List<ResourceRecord> resourceRecords = DefaultSdkAutoConstructList.getInstance();

        private AliasTarget aliasTarget;

        private String healthCheckId;

        private String trafficPolicyInstanceId;

        private CidrRoutingConfig cidrRoutingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceRecordSet model) {
            name(model.name);
            type(model.type);
            setIdentifier(model.setIdentifier);
            weight(model.weight);
            region(model.region);
            geoLocation(model.geoLocation);
            failover(model.failover);
            multiValueAnswer(model.multiValueAnswer);
            ttl(model.ttl);
            resourceRecords(model.resourceRecords);
            aliasTarget(model.aliasTarget);
            healthCheckId(model.healthCheckId);
            trafficPolicyInstanceId(model.trafficPolicyInstanceId);
            cidrRoutingConfig(model.cidrRoutingConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RRType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSetIdentifier() {
            return setIdentifier;
        }

        public final void setSetIdentifier(String setIdentifier) {
            this.setIdentifier = setIdentifier;
        }

        @Override
        @Transient
        public final Builder setIdentifier(String setIdentifier) {
            this.setIdentifier = setIdentifier;
            return this;
        }

        public final Long getWeight() {
            return weight;
        }

        public final void setWeight(Long weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Long weight) {
            this.weight = weight;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(ResourceRecordSetRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final GeoLocation.Builder getGeoLocation() {
            return geoLocation != null ? geoLocation.toBuilder() : null;
        }

        public final void setGeoLocation(GeoLocation.BuilderImpl geoLocation) {
            this.geoLocation = geoLocation != null ? geoLocation.build() : null;
        }

        @Override
        public final Builder geoLocation(GeoLocation geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        public final String getFailover() {
            return failover;
        }

        public final void setFailover(String failover) {
            this.failover = failover;
        }

        @Override
        public final Builder failover(String failover) {
            this.failover = failover;
            return this;
        }

        @Override
        public final Builder failover(ResourceRecordSetFailover failover) {
            this.failover(failover == null ? null : failover.toString());
            return this;
        }

        public final Boolean getMultiValueAnswer() {
            return multiValueAnswer;
        }

        public final void setMultiValueAnswer(Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
        }

        @Override
        public final Builder multiValueAnswer(Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
            return this;
        }

        public final Long getTtl() {
            return ttl;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final List<ResourceRecord.Builder> getResourceRecords() {
            List<ResourceRecord.Builder> result = ResourceRecordsCopier.copyToBuilder(this.resourceRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRecords(Collection<ResourceRecord.BuilderImpl> resourceRecords) {
            this.resourceRecords = ResourceRecordsCopier.copyFromBuilder(resourceRecords);
        }

        @Override
        public final Builder resourceRecords(Collection<ResourceRecord> resourceRecords) {
            this.resourceRecords = ResourceRecordsCopier.copy(resourceRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecords(ResourceRecord... resourceRecords) {
            resourceRecords(Arrays.asList(resourceRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecords(Consumer<ResourceRecord.Builder>... resourceRecords) {
            resourceRecords(Stream.of(resourceRecords).map(c -> ResourceRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AliasTarget.Builder getAliasTarget() {
            return aliasTarget != null ? aliasTarget.toBuilder() : null;
        }

        public final void setAliasTarget(AliasTarget.BuilderImpl aliasTarget) {
            this.aliasTarget = aliasTarget != null ? aliasTarget.build() : null;
        }

        @Override
        public final Builder aliasTarget(AliasTarget aliasTarget) {
            this.aliasTarget = aliasTarget;
            return this;
        }

        public final String getHealthCheckId() {
            return healthCheckId;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final String getTrafficPolicyInstanceId() {
            return trafficPolicyInstanceId;
        }

        public final void setTrafficPolicyInstanceId(String trafficPolicyInstanceId) {
            this.trafficPolicyInstanceId = trafficPolicyInstanceId;
        }

        @Override
        public final Builder trafficPolicyInstanceId(String trafficPolicyInstanceId) {
            this.trafficPolicyInstanceId = trafficPolicyInstanceId;
            return this;
        }

        public final CidrRoutingConfig.Builder getCidrRoutingConfig() {
            return cidrRoutingConfig != null ? cidrRoutingConfig.toBuilder() : null;
        }

        public final void setCidrRoutingConfig(CidrRoutingConfig.BuilderImpl cidrRoutingConfig) {
            this.cidrRoutingConfig = cidrRoutingConfig != null ? cidrRoutingConfig.build() : null;
        }

        @Override
        public final Builder cidrRoutingConfig(CidrRoutingConfig cidrRoutingConfig) {
            this.cidrRoutingConfig = cidrRoutingConfig;
            return this;
        }

        @Override
        public ResourceRecordSet build() {
            return new ResourceRecordSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
