/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourcegroups.model.ResourceQuery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupQuery> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(GroupQuery.getter(GroupQuery::groupName)).setter(GroupQuery.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceQuery").getter(GroupQuery.getter(GroupQuery::resourceQuery)).setter(GroupQuery.setter(Builder::resourceQuery)).constructor(ResourceQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, RESOURCE_QUERY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final ResourceQuery resourceQuery;

    private GroupQuery(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.resourceQuery = builder.resourceQuery;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final ResourceQuery resourceQuery() {
        return this.resourceQuery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceQuery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupQuery)) {
            return false;
        }
        GroupQuery other = (GroupQuery)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.resourceQuery(), other.resourceQuery());
    }

    public final String toString() {
        return ToString.builder((String)"GroupQuery").add("GroupName", (Object)this.groupName()).add("ResourceQuery", (Object)this.resourceQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "ResourceQuery": {
                return Optional.ofNullable(clazz.cast(this.resourceQuery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupQuery, T> g) {
        return obj -> g.apply((GroupQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private ResourceQuery resourceQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupQuery model) {
            this.groupName(model.groupName);
            this.resourceQuery(model.resourceQuery);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return this.resourceQuery != null ? this.resourceQuery.toBuilder() : null;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public GroupQuery build() {
            return new GroupQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupQuery> {
        public Builder groupName(String var1);

        public Builder resourceQuery(ResourceQuery var1);

        default public Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return this.resourceQuery((ResourceQuery)((ResourceQuery.Builder)ResourceQuery.builder().applyMutation(resourceQuery)).build());
        }
    }
}

