/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecommendationTemplatesResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<ListRecommendationTemplatesResponse.Builder, ListRecommendationTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRecommendationTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<RecommendationTemplate>> RECOMMENDATION_TEMPLATES_FIELD = SdkField
            .<List<RecommendationTemplate>> builder(MarshallingType.LIST)
            .memberName("recommendationTemplates")
            .getter(getter(ListRecommendationTemplatesResponse::recommendationTemplates))
            .setter(setter(Builder::recommendationTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationTemplates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RECOMMENDATION_TEMPLATES_FIELD));

    private final String nextToken;

    private final List<RecommendationTemplate> recommendationTemplates;

    private ListRecommendationTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recommendationTemplates = builder.recommendationTemplates;
    }

    /**
     * <p>
     * Token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return Token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendationTemplates property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRecommendationTemplates() {
        return recommendationTemplates != null && !(recommendationTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recommendation templates for the Resilience Hub applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationTemplates} method.
     * </p>
     * 
     * @return The recommendation templates for the Resilience Hub applications.
     */
    public final List<RecommendationTemplate> recommendationTemplates() {
        return recommendationTemplates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendationTemplates() ? recommendationTemplates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationTemplatesResponse)) {
            return false;
        }
        ListRecommendationTemplatesResponse other = (ListRecommendationTemplatesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasRecommendationTemplates() == other.hasRecommendationTemplates()
                && Objects.equals(recommendationTemplates(), other.recommendationTemplates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecommendationTemplatesResponse").add("NextToken", nextToken())
                .add("RecommendationTemplates", hasRecommendationTemplates() ? recommendationTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "recommendationTemplates":
            return Optional.ofNullable(clazz.cast(recommendationTemplates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationTemplatesResponse, T> g) {
        return obj -> g.apply((ListRecommendationTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRecommendationTemplatesResponse> {
        /**
         * <p>
         * Token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The recommendation templates for the Resilience Hub applications.
         * </p>
         * 
         * @param recommendationTemplates
         *        The recommendation templates for the Resilience Hub applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTemplates(Collection<RecommendationTemplate> recommendationTemplates);

        /**
         * <p>
         * The recommendation templates for the Resilience Hub applications.
         * </p>
         * 
         * @param recommendationTemplates
         *        The recommendation templates for the Resilience Hub applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTemplates(RecommendationTemplate... recommendationTemplates);

        /**
         * <p>
         * The recommendation templates for the Resilience Hub applications.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.RecommendationTemplate.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.RecommendationTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.RecommendationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #recommendationTemplates(List<RecommendationTemplate>)}.
         * 
         * @param recommendationTemplates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.RecommendationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationTemplates(java.util.Collection<RecommendationTemplate>)
         */
        Builder recommendationTemplates(Consumer<RecommendationTemplate.Builder>... recommendationTemplates);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RecommendationTemplate> recommendationTemplates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationTemplatesResponse model) {
            super(model);
            nextToken(model.nextToken);
            recommendationTemplates(model.recommendationTemplates);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RecommendationTemplate.Builder> getRecommendationTemplates() {
            List<RecommendationTemplate.Builder> result = RecommendationTemplateListCopier
                    .copyToBuilder(this.recommendationTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendationTemplates(Collection<RecommendationTemplate.BuilderImpl> recommendationTemplates) {
            this.recommendationTemplates = RecommendationTemplateListCopier.copyFromBuilder(recommendationTemplates);
        }

        @Override
        public final Builder recommendationTemplates(Collection<RecommendationTemplate> recommendationTemplates) {
            this.recommendationTemplates = RecommendationTemplateListCopier.copy(recommendationTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationTemplates(RecommendationTemplate... recommendationTemplates) {
            recommendationTemplates(Arrays.asList(recommendationTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationTemplates(Consumer<RecommendationTemplate.Builder>... recommendationTemplates) {
            recommendationTemplates(Stream.of(recommendationTemplates)
                    .map(c -> RecommendationTemplate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRecommendationTemplatesResponse build() {
            return new ListRecommendationTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
