/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.resiliencehub.internal.ResiliencehubServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.resiliencehub.model.AccessDeniedException;
import software.amazon.awssdk.services.resiliencehub.model.AddDraftAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.AddDraftAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusRequest;
import software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusResponse;
import software.amazon.awssdk.services.resiliencehub.model.ConflictException;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppVersionAppComponentRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppVersionAppComponentResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppVersionResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppVersionResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateRecommendationTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateRecommendationTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppInputSourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppInputSourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppVersionAppComponentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppVersionAppComponentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppVersionResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppVersionResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteRecommendationTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteRecommendationTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionAppComponentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionAppComponentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.ImportResourcesToDraftAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.ImportResourcesToDraftAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.InternalServerException;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentComplianceDriftsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentComplianceDriftsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppInputSourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppInputSourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionAppComponentsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionAppComponentsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.PublishAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.PublishAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.PutDraftAppVersionTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.PutDraftAppVersionTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubException;
import software.amazon.awssdk.services.resiliencehub.model.ResolveAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ResolveAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.resiliencehub.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.resiliencehub.model.StartAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.StartAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.TagResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.TagResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.ThrottlingException;
import software.amazon.awssdk.services.resiliencehub.model.UntagResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.UntagResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionAppComponentRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionAppComponentResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.ValidationException;
import software.amazon.awssdk.services.resiliencehub.transform.AddDraftAppVersionResourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.BatchUpdateRecommendationStatusRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateAppVersionAppComponentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateAppVersionResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateRecommendationTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppAssessmentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppInputSourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppVersionAppComponentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppVersionResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteRecommendationTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppAssessmentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionAppComponentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionResourcesResolutionStatusRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeDraftAppVersionResourcesImportStatusRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ImportResourcesToDraftAppVersionRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAlarmRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppAssessmentComplianceDriftsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppComponentCompliancesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppComponentRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppInputSourcesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppVersionAppComponentsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppVersionResourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppVersionResourcesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppVersionsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListRecommendationTemplatesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListResiliencyPoliciesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListSopRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListSuggestedResiliencyPoliciesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListTestRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListUnsupportedAppVersionResourcesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.PublishAppVersionRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.PutDraftAppVersionTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.RemoveDraftAppVersionResourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ResolveAppVersionResourcesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.StartAppAssessmentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateAppVersionAppComponentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateAppVersionRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateAppVersionResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ResiliencehubClient}.
 *
 * @see ResiliencehubClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultResiliencehubClient implements ResiliencehubClient {
    private static final Logger log = Logger.loggerFor(DefaultResiliencehubClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ResiliencehubServiceClientConfiguration serviceClientConfiguration;

    protected DefaultResiliencehubClient(ResiliencehubServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds the source of resource-maps to the draft version of an application. During assessment, Resilience Hub will
     * use these resource-maps to resolve the latest physical ID for each resource in the application template. For more
     * information about different types of resources suported by Resilience Hub and how to add them in your
     * application, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/how-app-manage.html">Step
     * 2: How is your application managed?</a> in the Resilience Hub User Guide.
     * </p>
     *
     * @param addDraftAppVersionResourceMappingsRequest
     * @return Result of the AddDraftAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.AddDraftAppVersionResourceMappings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/AddDraftAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddDraftAppVersionResourceMappingsResponse addDraftAppVersionResourceMappings(
            AddDraftAppVersionResourceMappingsRequest addDraftAppVersionResourceMappingsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddDraftAppVersionResourceMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddDraftAppVersionResourceMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addDraftAppVersionResourceMappingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                addDraftAppVersionResourceMappingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddDraftAppVersionResourceMappings");

            return clientHandler
                    .execute(new ClientExecutionParams<AddDraftAppVersionResourceMappingsRequest, AddDraftAppVersionResourceMappingsResponse>()
                            .withOperationName("AddDraftAppVersionResourceMappings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(addDraftAppVersionResourceMappingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddDraftAppVersionResourceMappingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables you to include or exclude one or more operational recommendations.
     * </p>
     *
     * @param batchUpdateRecommendationStatusRequest
     * @return Result of the BatchUpdateRecommendationStatus operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.BatchUpdateRecommendationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/BatchUpdateRecommendationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchUpdateRecommendationStatusResponse batchUpdateRecommendationStatus(
            BatchUpdateRecommendationStatusRequest batchUpdateRecommendationStatusRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdateRecommendationStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchUpdateRecommendationStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateRecommendationStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchUpdateRecommendationStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateRecommendationStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateRecommendationStatusRequest, BatchUpdateRecommendationStatusResponse>()
                            .withOperationName("BatchUpdateRecommendationStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchUpdateRecommendationStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchUpdateRecommendationStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Resilience Hub application. An Resilience Hub application is a collection of Amazon Web Services
     * resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience
     * Hub application, you provide an application name, resources from one or more CloudFormation stacks, Resource
     * Groups, Terraform state files, AppRegistry applications, and an appropriate resiliency policy. In addition, you
     * can also add resources that are located on Amazon Elastic Kubernetes Service (Amazon EKS) clusters as optional
     * resources. For more information about the number of resources supported per application, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/resiliencehub.html#limits_resiliencehub">Service quotas</a>.
     * </p>
     * <p>
     * After you create an Resilience Hub application, you publish it so that you can run a resiliency assessment on it.
     * You can then use recommendations from the assessment to improve resiliency by running another assessment,
     * comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO)
     * and recovery point objective (RPO).
     * </p>
     *
     * @param createAppRequest
     * @return Result of the CreateApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         This exception occurs when you have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAppResponse createApp(CreateAppRequest createAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApp");

            return clientHandler.execute(new ClientExecutionParams<CreateAppRequest, CreateAppResponse>()
                    .withOperationName("CreateApp").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createAppRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Application Component in the Resilience Hub application.
     * </p>
     * <note>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this Application Component for running
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </note>
     *
     * @param createAppVersionAppComponentRequest
     * @return Result of the CreateAppVersionAppComponent operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         This exception occurs when you have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateAppVersionAppComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateAppVersionAppComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAppVersionAppComponentResponse createAppVersionAppComponent(
            CreateAppVersionAppComponentRequest createAppVersionAppComponentRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppVersionAppComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAppVersionAppComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppVersionAppComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppVersionAppComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppVersionAppComponent");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAppVersionAppComponentRequest, CreateAppVersionAppComponentResponse>()
                            .withOperationName("CreateAppVersionAppComponent").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAppVersionAppComponentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAppVersionAppComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a resource to the Resilience Hub application and assigns it to the specified Application Components. If you
     * specify a new Application Component, Resilience Hub will automatically create the Application Component.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * This action has no effect outside Resilience Hub.
     * </p>
     * </li>
     * <li>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this resource for running resiliency
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * To update application version with new <code>physicalResourceID</code>, you must call
     * <code>ResolveAppVersionResources</code> API.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createAppVersionResourceRequest
     * @return Result of the CreateAppVersionResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         This exception occurs when you have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateAppVersionResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateAppVersionResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAppVersionResourceResponse createAppVersionResource(
            CreateAppVersionResourceRequest createAppVersionResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppVersionResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAppVersionResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppVersionResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppVersionResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppVersionResource");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAppVersionResourceRequest, CreateAppVersionResourceResponse>()
                            .withOperationName("CreateAppVersionResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAppVersionResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAppVersionResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new recommendation template for the Resilience Hub application.
     * </p>
     *
     * @param createRecommendationTemplateRequest
     * @return Result of the CreateRecommendationTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         This exception occurs when you have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateRecommendationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateRecommendationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRecommendationTemplateResponse createRecommendationTemplate(
            CreateRecommendationTemplateRequest createRecommendationTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRecommendationTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRecommendationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRecommendationTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRecommendationTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRecommendationTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRecommendationTemplateRequest, CreateRecommendationTemplateResponse>()
                            .withOperationName("CreateRecommendationTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createRecommendationTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateRecommendationTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a resiliency policy for an application.
     * </p>
     * <note>
     * <p>
     * Resilience Hub allows you to provide a value of zero for <code>rtoInSecs</code> and <code>rpoInSecs</code> of
     * your resiliency policy. But, while assessing your application, the lowest possible assessment result is near
     * zero. Hence, if you provide value zero for <code>rtoInSecs</code> and <code>rpoInSecs</code>, the estimated
     * workload RTO and estimated workload RPO result will be near zero and the <b>Compliance status</b> for your
     * application will be set to <b>Policy breached</b>.
     * </p>
     * </note>
     *
     * @param createResiliencyPolicyRequest
     * @return Result of the CreateResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         This exception occurs when you have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResiliencyPolicyResponse createResiliencyPolicy(CreateResiliencyPolicyRequest createResiliencyPolicyRequest)
            throws InternalServerException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResiliencyPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResiliencyPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResiliencyPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateResiliencyPolicyRequest, CreateResiliencyPolicyResponse>()
                            .withOperationName("CreateResiliencyPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createResiliencyPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateResiliencyPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Resilience Hub application. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteAppRequest
     * @return Result of the DeleteApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApp");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppRequest, DeleteAppResponse>()
                    .withOperationName("DeleteApp").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteAppRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Resilience Hub application assessment. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteAppAssessmentRequest
     * @return Result of the DeleteAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAppAssessmentResponse deleteAppAssessment(DeleteAppAssessmentRequest deleteAppAssessmentRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAppAssessmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppAssessment");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppAssessmentRequest, DeleteAppAssessmentResponse>()
                    .withOperationName("DeleteAppAssessment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAppAssessmentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAppAssessmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the input source and all of its imported resources from the Resilience Hub application.
     * </p>
     *
     * @param deleteAppInputSourceRequest
     * @return Result of the DeleteAppInputSource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteAppInputSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppInputSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAppInputSourceResponse deleteAppInputSource(DeleteAppInputSourceRequest deleteAppInputSourceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppInputSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAppInputSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppInputSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppInputSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppInputSource");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppInputSourceRequest, DeleteAppInputSourceResponse>()
                    .withOperationName("DeleteAppInputSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAppInputSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAppInputSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Application Component from the Resilience Hub application.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this Application Component for running
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * You will not be able to delete an Application Component if it has resources associated with it.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteAppVersionAppComponentRequest
     * @return Result of the DeleteAppVersionAppComponent operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteAppVersionAppComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppVersionAppComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAppVersionAppComponentResponse deleteAppVersionAppComponent(
            DeleteAppVersionAppComponentRequest deleteAppVersionAppComponentRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppVersionAppComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAppVersionAppComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppVersionAppComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppVersionAppComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppVersionAppComponent");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAppVersionAppComponentRequest, DeleteAppVersionAppComponentResponse>()
                            .withOperationName("DeleteAppVersionAppComponent").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAppVersionAppComponentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAppVersionAppComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a resource from the Resilience Hub application.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You can only delete a manually added resource. To exclude non-manually added resources, use the
     * <code>UpdateAppVersionResource</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * This action has no effect outside Resilience Hub.
     * </p>
     * </li>
     * <li>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this resource for running resiliency
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteAppVersionResourceRequest
     * @return Result of the DeleteAppVersionResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteAppVersionResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppVersionResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAppVersionResourceResponse deleteAppVersionResource(
            DeleteAppVersionResourceRequest deleteAppVersionResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppVersionResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAppVersionResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppVersionResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppVersionResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppVersionResource");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAppVersionResourceRequest, DeleteAppVersionResourceResponse>()
                            .withOperationName("DeleteAppVersionResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAppVersionResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAppVersionResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a recommendation template. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteRecommendationTemplateRequest
     * @return Result of the DeleteRecommendationTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteRecommendationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteRecommendationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRecommendationTemplateResponse deleteRecommendationTemplate(
            DeleteRecommendationTemplateRequest deleteRecommendationTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRecommendationTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRecommendationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRecommendationTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRecommendationTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRecommendationTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRecommendationTemplateRequest, DeleteRecommendationTemplateResponse>()
                            .withOperationName("DeleteRecommendationTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteRecommendationTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRecommendationTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a resiliency policy. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteResiliencyPolicyRequest
     * @return Result of the DeleteResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResiliencyPolicyResponse deleteResiliencyPolicy(DeleteResiliencyPolicyRequest deleteResiliencyPolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResiliencyPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResiliencyPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResiliencyPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteResiliencyPolicyRequest, DeleteResiliencyPolicyResponse>()
                            .withOperationName("DeleteResiliencyPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteResiliencyPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteResiliencyPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an Resilience Hub application.
     * </p>
     *
     * @param describeAppRequest
     * @return Result of the DescribeApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeAppResponse describeApp(DescribeAppRequest describeAppRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApp");

            return clientHandler.execute(new ClientExecutionParams<DescribeAppRequest, DescribeAppResponse>()
                    .withOperationName("DescribeApp").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(describeAppRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an assessment for an Resilience Hub application.
     * </p>
     *
     * @param describeAppAssessmentRequest
     * @return Result of the DescribeAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppAssessmentResponse describeAppAssessment(DescribeAppAssessmentRequest describeAppAssessmentRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppAssessmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppAssessment");

            return clientHandler.execute(new ClientExecutionParams<DescribeAppAssessmentRequest, DescribeAppAssessmentResponse>()
                    .withOperationName("DescribeAppAssessment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAppAssessmentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAppAssessmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the Resilience Hub application version.
     * </p>
     *
     * @param describeAppVersionRequest
     * @return Result of the DescribeAppVersion operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppVersionResponse describeAppVersion(DescribeAppVersionRequest describeAppVersionRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersion");

            return clientHandler.execute(new ClientExecutionParams<DescribeAppVersionRequest, DescribeAppVersionResponse>()
                    .withOperationName("DescribeAppVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAppVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAppVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an Application Component in the Resilience Hub application.
     * </p>
     *
     * @param describeAppVersionAppComponentRequest
     * @return Result of the DescribeAppVersionAppComponent operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppVersionAppComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionAppComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppVersionAppComponentResponse describeAppVersionAppComponent(
            DescribeAppVersionAppComponentRequest describeAppVersionAppComponentRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppVersionAppComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppVersionAppComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppVersionAppComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAppVersionAppComponentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersionAppComponent");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAppVersionAppComponentRequest, DescribeAppVersionAppComponentResponse>()
                            .withOperationName("DescribeAppVersionAppComponent").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAppVersionAppComponentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAppVersionAppComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a resource of the Resilience Hub application.
     * </p>
     * <note>
     * <p>
     * This API accepts only one of the following parameters to descibe the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resourceName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logicalResourceId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>physicalResourceId</code> (Along with <code>physicalResourceId</code>, you can also provide
     * <code>awsAccountId</code>, and <code>awsRegion</code>)
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeAppVersionResourceRequest
     * @return Result of the DescribeAppVersionResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppVersionResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppVersionResourceResponse describeAppVersionResource(
            DescribeAppVersionResourceRequest describeAppVersionResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppVersionResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppVersionResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppVersionResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppVersionResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersionResource");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAppVersionResourceRequest, DescribeAppVersionResourceResponse>()
                            .withOperationName("DescribeAppVersionResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAppVersionResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAppVersionResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the resolution status for the specified resolution identifier for an application version. If
     * <code>resolutionId</code> is not specified, the current resolution status is returned.
     * </p>
     *
     * @param describeAppVersionResourcesResolutionStatusRequest
     * @return Result of the DescribeAppVersionResourcesResolutionStatus operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppVersionResourcesResolutionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionResourcesResolutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppVersionResourcesResolutionStatusResponse describeAppVersionResourcesResolutionStatus(
            DescribeAppVersionResourcesResolutionStatusRequest describeAppVersionResourcesResolutionStatusRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppVersionResourcesResolutionStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeAppVersionResourcesResolutionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeAppVersionResourcesResolutionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAppVersionResourcesResolutionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersionResourcesResolutionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAppVersionResourcesResolutionStatusRequest, DescribeAppVersionResourcesResolutionStatusResponse>()
                            .withOperationName("DescribeAppVersionResourcesResolutionStatus")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(describeAppVersionResourcesResolutionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAppVersionResourcesResolutionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes details about an Resilience Hub application.
     * </p>
     *
     * @param describeAppVersionTemplateRequest
     * @return Result of the DescribeAppVersionTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppVersionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppVersionTemplateResponse describeAppVersionTemplate(
            DescribeAppVersionTemplateRequest describeAppVersionTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppVersionTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppVersionTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppVersionTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppVersionTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersionTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAppVersionTemplateRequest, DescribeAppVersionTemplateResponse>()
                            .withOperationName("DescribeAppVersionTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAppVersionTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAppVersionTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the status of importing resources to an application version.
     * </p>
     * <note>
     * <p>
     * If you get a 404 error with <code>ResourceImportStatusNotFoundAppMetadataException</code>, you must call
     * <code>importResourcesToDraftAppVersion</code> after creating the application and before calling
     * <code>describeDraftAppVersionResourcesImportStatus</code> to obtain the status.
     * </p>
     * </note>
     *
     * @param describeDraftAppVersionResourcesImportStatusRequest
     * @return Result of the DescribeDraftAppVersionResourcesImportStatus operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeDraftAppVersionResourcesImportStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeDraftAppVersionResourcesImportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDraftAppVersionResourcesImportStatusResponse describeDraftAppVersionResourcesImportStatus(
            DescribeDraftAppVersionResourcesImportStatusRequest describeDraftAppVersionResourcesImportStatusRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDraftAppVersionResourcesImportStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeDraftAppVersionResourcesImportStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeDraftAppVersionResourcesImportStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDraftAppVersionResourcesImportStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDraftAppVersionResourcesImportStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDraftAppVersionResourcesImportStatusRequest, DescribeDraftAppVersionResourcesImportStatusResponse>()
                            .withOperationName("DescribeDraftAppVersionResourcesImportStatus")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(describeDraftAppVersionResourcesImportStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDraftAppVersionResourcesImportStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a specified resiliency policy for an Resilience Hub application. The returned policy object includes
     * creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.
     * </p>
     *
     * @param describeResiliencyPolicyRequest
     * @return Result of the DescribeResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeResiliencyPolicyResponse describeResiliencyPolicy(
            DescribeResiliencyPolicyRequest describeResiliencyPolicyRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeResiliencyPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResiliencyPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResiliencyPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeResiliencyPolicyRequest, DescribeResiliencyPolicyResponse>()
                            .withOperationName("DescribeResiliencyPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeResiliencyPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeResiliencyPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports resources to Resilience Hub application draft version from different input sources. For more information
     * about the input sources supported by Resilience Hub, see <a
     * href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html">Discover the structure
     * and describe your Resilience Hub application</a>.
     * </p>
     *
     * @param importResourcesToDraftAppVersionRequest
     * @return Result of the ImportResourcesToDraftAppVersion operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         This exception occurs when you have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ImportResourcesToDraftAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ImportResourcesToDraftAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportResourcesToDraftAppVersionResponse importResourcesToDraftAppVersion(
            ImportResourcesToDraftAppVersionRequest importResourcesToDraftAppVersionRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportResourcesToDraftAppVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportResourcesToDraftAppVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importResourcesToDraftAppVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                importResourcesToDraftAppVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportResourcesToDraftAppVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<ImportResourcesToDraftAppVersionRequest, ImportResourcesToDraftAppVersionResponse>()
                            .withOperationName("ImportResourcesToDraftAppVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(importResourcesToDraftAppVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ImportResourcesToDraftAppVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the alarm recommendations for an Resilience Hub application.
     * </p>
     *
     * @param listAlarmRecommendationsRequest
     * @return Result of the ListAlarmRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAlarmRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAlarmRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAlarmRecommendationsResponse listAlarmRecommendations(
            ListAlarmRecommendationsRequest listAlarmRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAlarmRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAlarmRecommendationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAlarmRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAlarmRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAlarmRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAlarmRecommendationsRequest, ListAlarmRecommendationsResponse>()
                            .withOperationName("ListAlarmRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAlarmRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAlarmRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List of compliance drifts that were detected while running an assessment.
     * </p>
     *
     * @param listAppAssessmentComplianceDriftsRequest
     * @return Result of the ListAppAssessmentComplianceDrifts operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppAssessmentComplianceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessmentComplianceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppAssessmentComplianceDriftsResponse listAppAssessmentComplianceDrifts(
            ListAppAssessmentComplianceDriftsRequest listAppAssessmentComplianceDriftsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppAssessmentComplianceDriftsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppAssessmentComplianceDriftsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppAssessmentComplianceDriftsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAppAssessmentComplianceDriftsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppAssessmentComplianceDrifts");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAppAssessmentComplianceDriftsRequest, ListAppAssessmentComplianceDriftsResponse>()
                            .withOperationName("ListAppAssessmentComplianceDrifts").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAppAssessmentComplianceDriftsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAppAssessmentComplianceDriftsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the assessments for an Resilience Hub application. You can use request parameters to refine the results for
     * the response object.
     * </p>
     *
     * @param listAppAssessmentsRequest
     * @return Result of the ListAppAssessments operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppAssessmentsResponse listAppAssessments(ListAppAssessmentsRequest listAppAssessmentsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppAssessmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppAssessmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppAssessmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppAssessmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppAssessments");

            return clientHandler.execute(new ClientExecutionParams<ListAppAssessmentsRequest, ListAppAssessmentsResponse>()
                    .withOperationName("ListAppAssessments").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAppAssessmentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAppAssessmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the compliances for an Resilience Hub Application Component.
     * </p>
     *
     * @param listAppComponentCompliancesRequest
     * @return Result of the ListAppComponentCompliances operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentCompliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentCompliances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppComponentCompliancesResponse listAppComponentCompliances(
            ListAppComponentCompliancesRequest listAppComponentCompliancesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppComponentCompliancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppComponentCompliancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppComponentCompliancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppComponentCompliancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppComponentCompliances");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAppComponentCompliancesRequest, ListAppComponentCompliancesResponse>()
                            .withOperationName("ListAppComponentCompliances").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAppComponentCompliancesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAppComponentCompliancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the recommendations for an Resilience Hub Application Component.
     * </p>
     *
     * @param listAppComponentRecommendationsRequest
     * @return Result of the ListAppComponentRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppComponentRecommendationsResponse listAppComponentRecommendations(
            ListAppComponentRecommendationsRequest listAppComponentRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppComponentRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppComponentRecommendationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppComponentRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAppComponentRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppComponentRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAppComponentRecommendationsRequest, ListAppComponentRecommendationsResponse>()
                            .withOperationName("ListAppComponentRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAppComponentRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAppComponentRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the input sources of the Resilience Hub application. For more information about the input sources
     * supported by Resilience Hub, see <a
     * href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html">Discover the structure
     * and describe your Resilience Hub application</a>.
     * </p>
     *
     * @param listAppInputSourcesRequest
     * @return Result of the ListAppInputSources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppInputSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppInputSources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppInputSourcesResponse listAppInputSources(ListAppInputSourcesRequest listAppInputSourcesRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppInputSourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppInputSourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppInputSourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppInputSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppInputSources");

            return clientHandler.execute(new ClientExecutionParams<ListAppInputSourcesRequest, ListAppInputSourcesResponse>()
                    .withOperationName("ListAppInputSources").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAppInputSourcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAppInputSourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the Application Components in the Resilience Hub application.
     * </p>
     *
     * @param listAppVersionAppComponentsRequest
     * @return Result of the ListAppVersionAppComponents operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionAppComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionAppComponents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppVersionAppComponentsResponse listAppVersionAppComponents(
            ListAppVersionAppComponentsRequest listAppVersionAppComponentsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppVersionAppComponentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppVersionAppComponentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppVersionAppComponentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppVersionAppComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppVersionAppComponents");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAppVersionAppComponentsRequest, ListAppVersionAppComponentsResponse>()
                            .withOperationName("ListAppVersionAppComponents").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAppVersionAppComponentsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAppVersionAppComponentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource
     * identifiers, CloudFormation stacks, resource-groups, or an application registry app.
     * </p>
     *
     * @param listAppVersionResourceMappingsRequest
     * @return Result of the ListAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppVersionResourceMappingsResponse listAppVersionResourceMappings(
            ListAppVersionResourceMappingsRequest listAppVersionResourceMappingsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppVersionResourceMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppVersionResourceMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppVersionResourceMappingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAppVersionResourceMappingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppVersionResourceMappings");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAppVersionResourceMappingsRequest, ListAppVersionResourceMappingsResponse>()
                            .withOperationName("ListAppVersionResourceMappings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAppVersionResourceMappingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAppVersionResourceMappingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the resources in an Resilience Hub application.
     * </p>
     *
     * @param listAppVersionResourcesRequest
     * @return Result of the ListAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppVersionResourcesResponse listAppVersionResources(ListAppVersionResourcesRequest listAppVersionResourcesRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppVersionResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppVersionResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppVersionResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppVersionResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppVersionResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAppVersionResourcesRequest, ListAppVersionResourcesResponse>()
                            .withOperationName("ListAppVersionResources").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAppVersionResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAppVersionResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the different versions for the Resilience Hub applications.
     * </p>
     *
     * @param listAppVersionsRequest
     * @return Result of the ListAppVersions operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAppVersionsResponse listAppVersions(ListAppVersionsRequest listAppVersionsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAppVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppVersions");

            return clientHandler.execute(new ClientExecutionParams<ListAppVersionsRequest, ListAppVersionsResponse>()
                    .withOperationName("ListAppVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAppVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAppVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists your Resilience Hub applications.
     * </p>
     * <note>
     * <p>
     * You can filter applications using only one filter at a time or without using any filter. If you try to filter
     * applications using multiple filters, you will get the following error:
     * </p>
     * <p>
     * <code>An error occurred (ValidationException) when calling the ListApps operation: Only one filter is supported for this operation.</code>
     * </p>
     * </note>
     *
     * @param listAppsRequest
     * @return Result of the ListApps operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAppsResponse listApps(ListAppsRequest listAppsRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAppsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApps");

            return clientHandler.execute(new ClientExecutionParams<ListAppsRequest, ListAppsResponse>()
                    .withOperationName("ListApps").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listAppsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAppsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the recommendation templates for the Resilience Hub applications.
     * </p>
     *
     * @param listRecommendationTemplatesRequest
     * @return Result of the ListRecommendationTemplates operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListRecommendationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListRecommendationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRecommendationTemplatesResponse listRecommendationTemplates(
            ListRecommendationTemplatesRequest listRecommendationTemplatesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRecommendationTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRecommendationTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecommendationTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecommendationTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecommendationTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRecommendationTemplatesRequest, ListRecommendationTemplatesResponse>()
                            .withOperationName("ListRecommendationTemplates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRecommendationTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRecommendationTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the resiliency policies for the Resilience Hub applications.
     * </p>
     *
     * @param listResiliencyPoliciesRequest
     * @return Result of the ListResiliencyPolicies operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResiliencyPoliciesResponse listResiliencyPolicies(ListResiliencyPoliciesRequest listResiliencyPoliciesRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResiliencyPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResiliencyPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResiliencyPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResiliencyPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResiliencyPolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResiliencyPoliciesRequest, ListResiliencyPoliciesResponse>()
                            .withOperationName("ListResiliencyPolicies").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listResiliencyPoliciesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListResiliencyPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
     * </p>
     *
     * @param listSopRecommendationsRequest
     * @return Result of the ListSopRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSopRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSopRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSopRecommendationsResponse listSopRecommendations(ListSopRecommendationsRequest listSopRecommendationsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSopRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSopRecommendationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSopRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSopRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSopRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSopRecommendationsRequest, ListSopRecommendationsResponse>()
                            .withOperationName("ListSopRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listSopRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSopRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the suggested resiliency policies for the Resilience Hub applications.
     * </p>
     *
     * @param listSuggestedResiliencyPoliciesRequest
     * @return Result of the ListSuggestedResiliencyPolicies operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSuggestedResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSuggestedResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSuggestedResiliencyPoliciesResponse listSuggestedResiliencyPolicies(
            ListSuggestedResiliencyPoliciesRequest listSuggestedResiliencyPoliciesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSuggestedResiliencyPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSuggestedResiliencyPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSuggestedResiliencyPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listSuggestedResiliencyPoliciesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSuggestedResiliencyPolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSuggestedResiliencyPoliciesRequest, ListSuggestedResiliencyPoliciesResponse>()
                            .withOperationName("ListSuggestedResiliencyPolicies").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listSuggestedResiliencyPoliciesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSuggestedResiliencyPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags for your resources in your Resilience Hub applications.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the test recommendations for the Resilience Hub application.
     * </p>
     *
     * @param listTestRecommendationsRequest
     * @return Result of the ListTestRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListTestRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTestRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestRecommendationsResponse listTestRecommendations(ListTestRecommendationsRequest listTestRecommendationsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTestRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTestRecommendationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTestRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTestRecommendationsRequest, ListTestRecommendationsResponse>()
                            .withOperationName("ListTestRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listTestRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTestRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the resources that are not currently supported in Resilience Hub. An unsupported resource is a resource
     * that exists in the object that was used to create an app, but is not supported by Resilience Hub.
     * </p>
     *
     * @param listUnsupportedAppVersionResourcesRequest
     * @return Result of the ListUnsupportedAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListUnsupportedAppVersionResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListUnsupportedAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListUnsupportedAppVersionResourcesResponse listUnsupportedAppVersionResources(
            ListUnsupportedAppVersionResourcesRequest listUnsupportedAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUnsupportedAppVersionResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListUnsupportedAppVersionResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUnsupportedAppVersionResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listUnsupportedAppVersionResourcesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUnsupportedAppVersionResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ListUnsupportedAppVersionResourcesRequest, ListUnsupportedAppVersionResourcesResponse>()
                            .withOperationName("ListUnsupportedAppVersionResources").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listUnsupportedAppVersionResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListUnsupportedAppVersionResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Publishes a new version of a specific Resilience Hub application.
     * </p>
     *
     * @param publishAppVersionRequest
     * @return Result of the PublishAppVersion operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.PublishAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PublishAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PublishAppVersionResponse publishAppVersion(PublishAppVersionRequest publishAppVersionRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PublishAppVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PublishAppVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(publishAppVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, publishAppVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PublishAppVersion");

            return clientHandler.execute(new ClientExecutionParams<PublishAppVersionRequest, PublishAppVersionResponse>()
                    .withOperationName("PublishAppVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(publishAppVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PublishAppVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates the app template for an Resilience Hub application draft version.
     * </p>
     *
     * @param putDraftAppVersionTemplateRequest
     * @return Result of the PutDraftAppVersionTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.PutDraftAppVersionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PutDraftAppVersionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutDraftAppVersionTemplateResponse putDraftAppVersionTemplate(
            PutDraftAppVersionTemplateRequest putDraftAppVersionTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDraftAppVersionTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutDraftAppVersionTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDraftAppVersionTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDraftAppVersionTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDraftAppVersionTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<PutDraftAppVersionTemplateRequest, PutDraftAppVersionTemplateResponse>()
                            .withOperationName("PutDraftAppVersionTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putDraftAppVersionTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutDraftAppVersionTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes resource mappings from a draft application version.
     * </p>
     *
     * @param removeDraftAppVersionResourceMappingsRequest
     * @return Result of the RemoveDraftAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.RemoveDraftAppVersionResourceMappings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/RemoveDraftAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveDraftAppVersionResourceMappingsResponse removeDraftAppVersionResourceMappings(
            RemoveDraftAppVersionResourceMappingsRequest removeDraftAppVersionResourceMappingsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveDraftAppVersionResourceMappingsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, RemoveDraftAppVersionResourceMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeDraftAppVersionResourceMappingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeDraftAppVersionResourceMappingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveDraftAppVersionResourceMappings");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveDraftAppVersionResourceMappingsRequest, RemoveDraftAppVersionResourceMappingsResponse>()
                            .withOperationName("RemoveDraftAppVersionResourceMappings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(removeDraftAppVersionResourceMappingsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveDraftAppVersionResourceMappingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Resolves the resources for an application version.
     * </p>
     *
     * @param resolveAppVersionResourcesRequest
     * @return Result of the ResolveAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ResolveAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ResolveAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ResolveAppVersionResourcesResponse resolveAppVersionResources(
            ResolveAppVersionResourcesRequest resolveAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResolveAppVersionResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ResolveAppVersionResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resolveAppVersionResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resolveAppVersionResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResolveAppVersionResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ResolveAppVersionResourcesRequest, ResolveAppVersionResourcesResponse>()
                            .withOperationName("ResolveAppVersionResources").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(resolveAppVersionResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ResolveAppVersionResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new application assessment for an application.
     * </p>
     *
     * @param startAppAssessmentRequest
     * @return Result of the StartAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         This exception occurs when you have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.StartAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/StartAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartAppAssessmentResponse startAppAssessment(StartAppAssessmentRequest startAppAssessmentRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ServiceQuotaExceededException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartAppAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartAppAssessmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAppAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAppAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAppAssessment");

            return clientHandler.execute(new ClientExecutionParams<StartAppAssessmentRequest, StartAppAssessmentResponse>()
                    .withOperationName("StartAppAssessment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startAppAssessmentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartAppAssessmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an application.
     * </p>
     *
     * @param updateAppRequest
     * @return Result of the UpdateApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UpdateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAppResponse updateApp(UpdateAppRequest updateAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApp");

            return clientHandler.execute(new ClientExecutionParams<UpdateAppRequest, UpdateAppResponse>()
                    .withOperationName("UpdateApp").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateAppRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the Resilience Hub application version.
     * </p>
     * <note>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this information for running resiliency
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </note>
     *
     * @param updateAppVersionRequest
     * @return Result of the UpdateAppVersion operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UpdateAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAppVersionResponse updateAppVersion(UpdateAppVersionRequest updateAppVersionRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAppVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAppVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAppVersion");

            return clientHandler.execute(new ClientExecutionParams<UpdateAppVersionRequest, UpdateAppVersionResponse>()
                    .withOperationName("UpdateAppVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAppVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAppVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing Application Component in the Resilience Hub application.
     * </p>
     * <note>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this Application Component for running
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </note>
     *
     * @param updateAppVersionAppComponentRequest
     * @return Result of the UpdateAppVersionAppComponent operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UpdateAppVersionAppComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersionAppComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAppVersionAppComponentResponse updateAppVersionAppComponent(
            UpdateAppVersionAppComponentRequest updateAppVersionAppComponentRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAppVersionAppComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAppVersionAppComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppVersionAppComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppVersionAppComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAppVersionAppComponent");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAppVersionAppComponentRequest, UpdateAppVersionAppComponentResponse>()
                            .withOperationName("UpdateAppVersionAppComponent").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateAppVersionAppComponentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAppVersionAppComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the resource details in the Resilience Hub application.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * This action has no effect outside Resilience Hub.
     * </p>
     * </li>
     * <li>
     * <p>
     * This API updates the Resilience Hub application draft version. To use this resource for running resiliency
     * assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * To update application version with new <code>physicalResourceID</code>, you must call
     * <code>ResolveAppVersionResources</code> API.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateAppVersionResourceRequest
     * @return Result of the UpdateAppVersionResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         This exception occurs when you have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UpdateAppVersionResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateAppVersionResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAppVersionResourceResponse updateAppVersionResource(
            UpdateAppVersionResourceRequest updateAppVersionResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAppVersionResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAppVersionResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppVersionResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppVersionResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAppVersionResource");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAppVersionResourceRequest, UpdateAppVersionResourceResponse>()
                            .withOperationName("UpdateAppVersionResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateAppVersionResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAppVersionResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a resiliency policy.
     * </p>
     * <note>
     * <p>
     * Resilience Hub allows you to provide a value of zero for <code>rtoInSecs</code> and <code>rpoInSecs</code> of
     * your resiliency policy. But, while assessing your application, the lowest possible assessment result is near
     * zero. Hence, if you provide value zero for <code>rtoInSecs</code> and <code>rpoInSecs</code>, the estimated
     * workload RTO and estimated workload RPO result will be near zero and the <b>Compliance status</b> for your
     * application will be set to <b>Policy breached</b>.
     * </p>
     * </note>
     *
     * @param updateResiliencyPolicyRequest
     * @return Result of the UpdateResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Resilience Hub service.
     * @throws ResourceNotFoundException
     *         This exception occurs when the specified resource could not be found.
     * @throws ConflictException
     *         This exception occurs when a conflict with a previous successful write is detected. This generally occurs
     *         when the previous write did not have time to propagate to the host serving the current request. A retry
     *         (with appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         This exception occurs when you have exceeded the limit on the number of requests per second.
     * @throws ValidationException
     *         This exception occurs when a request is not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UpdateResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateResiliencyPolicyResponse updateResiliencyPolicy(UpdateResiliencyPolicyRequest updateResiliencyPolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateResiliencyPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResiliencyPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResiliencyPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateResiliencyPolicyRequest, UpdateResiliencyPolicyResponse>()
                            .withOperationName("UpdateResiliencyPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateResiliencyPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateResiliencyPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        ResiliencehubServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = ResiliencehubServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ResiliencehubException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    @Override
    public final ResiliencehubServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
