/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAppVersionResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<UpdateAppVersionResponse.Builder, UpdateAppVersionResponse> {
    private static final SdkField<Map<String, List<String>>> ADDITIONAL_INFO_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("additionalInfo")
            .getter(getter(UpdateAppVersionResponse::additionalInfo))
            .setter(setter(Builder::additionalInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInfo").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(UpdateAppVersionResponse::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(UpdateAppVersionResponse::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_INFO_FIELD,
            APP_ARN_FIELD, APP_VERSION_FIELD));

    private final Map<String, List<String>> additionalInfo;

    private final String appArn;

    private final String appVersion;

    private UpdateAppVersionResponse(BuilderImpl builder) {
        super(builder);
        this.additionalInfo = builder.additionalInfo;
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalInfo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalInfo() {
        return additionalInfo != null && !(additionalInfo instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional configuration parameters for an Resilience Hub application. If you want to implement
     * <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a
     * href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the
     * application configuration parameters</a>.
     * </p>
     * <note>
     * <p>
     * Currently, this parameter supports only failover region and account.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalInfo} method.
     * </p>
     * 
     * @return Additional configuration parameters for an Resilience Hub application. If you want to implement
     *         <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a
     *         href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the
     *         application configuration parameters</a>.</p> <note>
     *         <p>
     *         Currently, this parameter supports only failover region and account.
     *         </p>
     */
    public final Map<String, List<String>> additionalInfo() {
        return additionalInfo;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * Resilience Hub application version.
     * </p>
     * 
     * @return Resilience Hub application version.
     */
    public final String appVersion() {
        return appVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalInfo() ? additionalInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppVersionResponse)) {
            return false;
        }
        UpdateAppVersionResponse other = (UpdateAppVersionResponse) obj;
        return hasAdditionalInfo() == other.hasAdditionalInfo() && Objects.equals(additionalInfo(), other.additionalInfo())
                && Objects.equals(appArn(), other.appArn()) && Objects.equals(appVersion(), other.appVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAppVersionResponse").add("AdditionalInfo", hasAdditionalInfo() ? additionalInfo() : null)
                .add("AppArn", appArn()).add("AppVersion", appVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalInfo":
            return Optional.ofNullable(clazz.cast(additionalInfo()));
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppVersionResponse, T> g) {
        return obj -> g.apply((UpdateAppVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAppVersionResponse> {
        /**
         * <p>
         * Additional configuration parameters for an Resilience Hub application. If you want to implement
         * <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a
         * href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the
         * application configuration parameters</a>.
         * </p>
         * <note>
         * <p>
         * Currently, this parameter supports only failover region and account.
         * </p>
         * </note>
         * 
         * @param additionalInfo
         *        Additional configuration parameters for an Resilience Hub application. If you want to implement
         *        <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a
         *        href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the
         *        application configuration parameters</a>.</p> <note>
         *        <p>
         *        Currently, this parameter supports only failover region and account.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(Map<String, ? extends Collection<String>> additionalInfo);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * Resilience Hub application version.
         * </p>
         * 
         * @param appVersion
         *        Resilience Hub application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private Map<String, List<String>> additionalInfo = DefaultSdkAutoConstructMap.getInstance();

        private String appArn;

        private String appVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppVersionResponse model) {
            super(model);
            additionalInfo(model.additionalInfo);
            appArn(model.appArn);
            appVersion(model.appVersion);
        }

        public final Map<String, ? extends Collection<String>> getAdditionalInfo() {
            if (additionalInfo instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalInfo;
        }

        public final void setAdditionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
        }

        @Override
        public final Builder additionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
            return this;
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        @Override
        public UpdateAppVersionResponse build() {
            return new UpdateAppVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
