/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a disruption compliance recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationDisruptionCompliance implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationDisruptionCompliance.Builder, RecommendationDisruptionCompliance> {
    private static final SdkField<String> EXPECTED_COMPLIANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedComplianceStatus")
            .getter(getter(RecommendationDisruptionCompliance::expectedComplianceStatusAsString))
            .setter(setter(Builder::expectedComplianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedComplianceStatus").build())
            .build();

    private static final SdkField<String> EXPECTED_RPO_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedRpoDescription").getter(getter(RecommendationDisruptionCompliance::expectedRpoDescription))
            .setter(setter(Builder::expectedRpoDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedRpoDescription").build())
            .build();

    private static final SdkField<Integer> EXPECTED_RPO_IN_SECS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("expectedRpoInSecs").getter(getter(RecommendationDisruptionCompliance::expectedRpoInSecs))
            .setter(setter(Builder::expectedRpoInSecs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedRpoInSecs").build()).build();

    private static final SdkField<String> EXPECTED_RTO_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedRtoDescription").getter(getter(RecommendationDisruptionCompliance::expectedRtoDescription))
            .setter(setter(Builder::expectedRtoDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedRtoDescription").build())
            .build();

    private static final SdkField<Integer> EXPECTED_RTO_IN_SECS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("expectedRtoInSecs").getter(getter(RecommendationDisruptionCompliance::expectedRtoInSecs))
            .setter(setter(Builder::expectedRtoInSecs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedRtoInSecs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXPECTED_COMPLIANCE_STATUS_FIELD, EXPECTED_RPO_DESCRIPTION_FIELD, EXPECTED_RPO_IN_SECS_FIELD,
            EXPECTED_RTO_DESCRIPTION_FIELD, EXPECTED_RTO_IN_SECS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String expectedComplianceStatus;

    private final String expectedRpoDescription;

    private final Integer expectedRpoInSecs;

    private final String expectedRtoDescription;

    private final Integer expectedRtoInSecs;

    private RecommendationDisruptionCompliance(BuilderImpl builder) {
        this.expectedComplianceStatus = builder.expectedComplianceStatus;
        this.expectedRpoDescription = builder.expectedRpoDescription;
        this.expectedRpoInSecs = builder.expectedRpoInSecs;
        this.expectedRtoDescription = builder.expectedRtoDescription;
        this.expectedRtoInSecs = builder.expectedRtoInSecs;
    }

    /**
     * <p>
     * The expected compliance status after applying the recommended configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expectedComplianceStatus} will return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #expectedComplianceStatusAsString}.
     * </p>
     * 
     * @return The expected compliance status after applying the recommended configuration change.
     * @see ComplianceStatus
     */
    public final ComplianceStatus expectedComplianceStatus() {
        return ComplianceStatus.fromValue(expectedComplianceStatus);
    }

    /**
     * <p>
     * The expected compliance status after applying the recommended configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expectedComplianceStatus} will return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #expectedComplianceStatusAsString}.
     * </p>
     * 
     * @return The expected compliance status after applying the recommended configuration change.
     * @see ComplianceStatus
     */
    public final String expectedComplianceStatusAsString() {
        return expectedComplianceStatus;
    }

    /**
     * <p>
     * The expected Recovery Point Objective (RPO) description after applying the recommended configuration change.
     * </p>
     * 
     * @return The expected Recovery Point Objective (RPO) description after applying the recommended configuration
     *         change.
     */
    public final String expectedRpoDescription() {
        return expectedRpoDescription;
    }

    /**
     * <p>
     * The expected RPO after applying the recommended configuration change.
     * </p>
     * 
     * @return The expected RPO after applying the recommended configuration change.
     */
    public final Integer expectedRpoInSecs() {
        return expectedRpoInSecs;
    }

    /**
     * <p>
     * The expected Recovery Time Objective (RTO) description after applying the recommended configuration change.
     * </p>
     * 
     * @return The expected Recovery Time Objective (RTO) description after applying the recommended configuration
     *         change.
     */
    public final String expectedRtoDescription() {
        return expectedRtoDescription;
    }

    /**
     * <p>
     * The expected RTO after applying the recommended configuration change.
     * </p>
     * 
     * @return The expected RTO after applying the recommended configuration change.
     */
    public final Integer expectedRtoInSecs() {
        return expectedRtoInSecs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expectedComplianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(expectedRpoDescription());
        hashCode = 31 * hashCode + Objects.hashCode(expectedRpoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(expectedRtoDescription());
        hashCode = 31 * hashCode + Objects.hashCode(expectedRtoInSecs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationDisruptionCompliance)) {
            return false;
        }
        RecommendationDisruptionCompliance other = (RecommendationDisruptionCompliance) obj;
        return Objects.equals(expectedComplianceStatusAsString(), other.expectedComplianceStatusAsString())
                && Objects.equals(expectedRpoDescription(), other.expectedRpoDescription())
                && Objects.equals(expectedRpoInSecs(), other.expectedRpoInSecs())
                && Objects.equals(expectedRtoDescription(), other.expectedRtoDescription())
                && Objects.equals(expectedRtoInSecs(), other.expectedRtoInSecs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationDisruptionCompliance")
                .add("ExpectedComplianceStatus", expectedComplianceStatusAsString())
                .add("ExpectedRpoDescription", expectedRpoDescription()).add("ExpectedRpoInSecs", expectedRpoInSecs())
                .add("ExpectedRtoDescription", expectedRtoDescription()).add("ExpectedRtoInSecs", expectedRtoInSecs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expectedComplianceStatus":
            return Optional.ofNullable(clazz.cast(expectedComplianceStatusAsString()));
        case "expectedRpoDescription":
            return Optional.ofNullable(clazz.cast(expectedRpoDescription()));
        case "expectedRpoInSecs":
            return Optional.ofNullable(clazz.cast(expectedRpoInSecs()));
        case "expectedRtoDescription":
            return Optional.ofNullable(clazz.cast(expectedRtoDescription()));
        case "expectedRtoInSecs":
            return Optional.ofNullable(clazz.cast(expectedRtoInSecs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationDisruptionCompliance, T> g) {
        return obj -> g.apply((RecommendationDisruptionCompliance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationDisruptionCompliance> {
        /**
         * <p>
         * The expected compliance status after applying the recommended configuration change.
         * </p>
         * 
         * @param expectedComplianceStatus
         *        The expected compliance status after applying the recommended configuration change.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder expectedComplianceStatus(String expectedComplianceStatus);

        /**
         * <p>
         * The expected compliance status after applying the recommended configuration change.
         * </p>
         * 
         * @param expectedComplianceStatus
         *        The expected compliance status after applying the recommended configuration change.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder expectedComplianceStatus(ComplianceStatus expectedComplianceStatus);

        /**
         * <p>
         * The expected Recovery Point Objective (RPO) description after applying the recommended configuration change.
         * </p>
         * 
         * @param expectedRpoDescription
         *        The expected Recovery Point Objective (RPO) description after applying the recommended configuration
         *        change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRpoDescription(String expectedRpoDescription);

        /**
         * <p>
         * The expected RPO after applying the recommended configuration change.
         * </p>
         * 
         * @param expectedRpoInSecs
         *        The expected RPO after applying the recommended configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRpoInSecs(Integer expectedRpoInSecs);

        /**
         * <p>
         * The expected Recovery Time Objective (RTO) description after applying the recommended configuration change.
         * </p>
         * 
         * @param expectedRtoDescription
         *        The expected Recovery Time Objective (RTO) description after applying the recommended configuration
         *        change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRtoDescription(String expectedRtoDescription);

        /**
         * <p>
         * The expected RTO after applying the recommended configuration change.
         * </p>
         * 
         * @param expectedRtoInSecs
         *        The expected RTO after applying the recommended configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRtoInSecs(Integer expectedRtoInSecs);
    }

    static final class BuilderImpl implements Builder {
        private String expectedComplianceStatus;

        private String expectedRpoDescription;

        private Integer expectedRpoInSecs;

        private String expectedRtoDescription;

        private Integer expectedRtoInSecs;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationDisruptionCompliance model) {
            expectedComplianceStatus(model.expectedComplianceStatus);
            expectedRpoDescription(model.expectedRpoDescription);
            expectedRpoInSecs(model.expectedRpoInSecs);
            expectedRtoDescription(model.expectedRtoDescription);
            expectedRtoInSecs(model.expectedRtoInSecs);
        }

        public final String getExpectedComplianceStatus() {
            return expectedComplianceStatus;
        }

        public final void setExpectedComplianceStatus(String expectedComplianceStatus) {
            this.expectedComplianceStatus = expectedComplianceStatus;
        }

        @Override
        public final Builder expectedComplianceStatus(String expectedComplianceStatus) {
            this.expectedComplianceStatus = expectedComplianceStatus;
            return this;
        }

        @Override
        public final Builder expectedComplianceStatus(ComplianceStatus expectedComplianceStatus) {
            this.expectedComplianceStatus(expectedComplianceStatus == null ? null : expectedComplianceStatus.toString());
            return this;
        }

        public final String getExpectedRpoDescription() {
            return expectedRpoDescription;
        }

        public final void setExpectedRpoDescription(String expectedRpoDescription) {
            this.expectedRpoDescription = expectedRpoDescription;
        }

        @Override
        public final Builder expectedRpoDescription(String expectedRpoDescription) {
            this.expectedRpoDescription = expectedRpoDescription;
            return this;
        }

        public final Integer getExpectedRpoInSecs() {
            return expectedRpoInSecs;
        }

        public final void setExpectedRpoInSecs(Integer expectedRpoInSecs) {
            this.expectedRpoInSecs = expectedRpoInSecs;
        }

        @Override
        public final Builder expectedRpoInSecs(Integer expectedRpoInSecs) {
            this.expectedRpoInSecs = expectedRpoInSecs;
            return this;
        }

        public final String getExpectedRtoDescription() {
            return expectedRtoDescription;
        }

        public final void setExpectedRtoDescription(String expectedRtoDescription) {
            this.expectedRtoDescription = expectedRtoDescription;
        }

        @Override
        public final Builder expectedRtoDescription(String expectedRtoDescription) {
            this.expectedRtoDescription = expectedRtoDescription;
            return this;
        }

        public final Integer getExpectedRtoInSecs() {
            return expectedRtoInSecs;
        }

        public final void setExpectedRtoInSecs(Integer expectedRtoInSecs) {
            this.expectedRtoInSecs = expectedRtoInSecs;
        }

        @Override
        public final Builder expectedRtoInSecs(Integer expectedRtoInSecs) {
            this.expectedRtoInSecs = expectedRtoInSecs;
            return this;
        }

        @Override
        public RecommendationDisruptionCompliance build() {
            return new RecommendationDisruptionCompliance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
