/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppAssessmentComplianceDriftsResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<ListAppAssessmentComplianceDriftsResponse.Builder, ListAppAssessmentComplianceDriftsResponse> {
    private static final SdkField<List<ComplianceDrift>> COMPLIANCE_DRIFTS_FIELD = SdkField
            .<List<ComplianceDrift>> builder(MarshallingType.LIST)
            .memberName("complianceDrifts")
            .getter(getter(ListAppAssessmentComplianceDriftsResponse::complianceDrifts))
            .setter(setter(Builder::complianceDrifts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceDrifts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComplianceDrift> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComplianceDrift::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAppAssessmentComplianceDriftsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_DRIFTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ComplianceDrift> complianceDrifts;

    private final String nextToken;

    private ListAppAssessmentComplianceDriftsResponse(BuilderImpl builder) {
        super(builder);
        this.complianceDrifts = builder.complianceDrifts;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComplianceDrifts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComplianceDrifts() {
        return complianceDrifts != null && !(complianceDrifts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates compliance drifts (recovery time objective (RTO) and recovery point objective (RPO)) detected for an
     * assessed entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComplianceDrifts} method.
     * </p>
     * 
     * @return Indicates compliance drifts (recovery time objective (RTO) and recovery point objective (RPO)) detected
     *         for an assessed entity.
     */
    public final List<ComplianceDrift> complianceDrifts() {
        return complianceDrifts;
    }

    /**
     * <p>
     * Token number of the next application to be checked for compliance and regulatory requirements from the list of
     * applications.
     * </p>
     * 
     * @return Token number of the next application to be checked for compliance and regulatory requirements from the
     *         list of applications.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasComplianceDrifts() ? complianceDrifts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppAssessmentComplianceDriftsResponse)) {
            return false;
        }
        ListAppAssessmentComplianceDriftsResponse other = (ListAppAssessmentComplianceDriftsResponse) obj;
        return hasComplianceDrifts() == other.hasComplianceDrifts()
                && Objects.equals(complianceDrifts(), other.complianceDrifts()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppAssessmentComplianceDriftsResponse")
                .add("ComplianceDrifts", hasComplianceDrifts() ? complianceDrifts() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "complianceDrifts":
            return Optional.ofNullable(clazz.cast(complianceDrifts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppAssessmentComplianceDriftsResponse, T> g) {
        return obj -> g.apply((ListAppAssessmentComplianceDriftsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAppAssessmentComplianceDriftsResponse> {
        /**
         * <p>
         * Indicates compliance drifts (recovery time objective (RTO) and recovery point objective (RPO)) detected for
         * an assessed entity.
         * </p>
         * 
         * @param complianceDrifts
         *        Indicates compliance drifts (recovery time objective (RTO) and recovery point objective (RPO))
         *        detected for an assessed entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceDrifts(Collection<ComplianceDrift> complianceDrifts);

        /**
         * <p>
         * Indicates compliance drifts (recovery time objective (RTO) and recovery point objective (RPO)) detected for
         * an assessed entity.
         * </p>
         * 
         * @param complianceDrifts
         *        Indicates compliance drifts (recovery time objective (RTO) and recovery point objective (RPO))
         *        detected for an assessed entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceDrifts(ComplianceDrift... complianceDrifts);

        /**
         * <p>
         * Indicates compliance drifts (recovery time objective (RTO) and recovery point objective (RPO)) detected for
         * an assessed entity.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.ComplianceDrift.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.resiliencehub.model.ComplianceDrift#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.ComplianceDrift.Builder#build()} is called
         * immediately and its result is passed to {@link #complianceDrifts(List<ComplianceDrift>)}.
         * 
         * @param complianceDrifts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.ComplianceDrift.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceDrifts(java.util.Collection<ComplianceDrift>)
         */
        Builder complianceDrifts(Consumer<ComplianceDrift.Builder>... complianceDrifts);

        /**
         * <p>
         * Token number of the next application to be checked for compliance and regulatory requirements from the list
         * of applications.
         * </p>
         * 
         * @param nextToken
         *        Token number of the next application to be checked for compliance and regulatory requirements from the
         *        list of applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private List<ComplianceDrift> complianceDrifts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppAssessmentComplianceDriftsResponse model) {
            super(model);
            complianceDrifts(model.complianceDrifts);
            nextToken(model.nextToken);
        }

        public final List<ComplianceDrift.Builder> getComplianceDrifts() {
            List<ComplianceDrift.Builder> result = ComplianceDriftListCopier.copyToBuilder(this.complianceDrifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComplianceDrifts(Collection<ComplianceDrift.BuilderImpl> complianceDrifts) {
            this.complianceDrifts = ComplianceDriftListCopier.copyFromBuilder(complianceDrifts);
        }

        @Override
        public final Builder complianceDrifts(Collection<ComplianceDrift> complianceDrifts) {
            this.complianceDrifts = ComplianceDriftListCopier.copy(complianceDrifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceDrifts(ComplianceDrift... complianceDrifts) {
            complianceDrifts(Arrays.asList(complianceDrifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceDrifts(Consumer<ComplianceDrift.Builder>... complianceDrifts) {
            complianceDrifts(Stream.of(complianceDrifts).map(c -> ComplianceDrift.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppAssessmentComplianceDriftsResponse build() {
            return new ListAppAssessmentComplianceDriftsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
