/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a recommendation for a CloudWatch alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlarmRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<AlarmRecommendation.Builder, AlarmRecommendation> {
    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appComponentName").getter(getter(AlarmRecommendation::appComponentName))
            .setter(setter(Builder::appComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()).build();

    private static final SdkField<List<String>> APP_COMPONENT_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("appComponentNames")
            .getter(getter(AlarmRecommendation::appComponentNames))
            .setter(setter(Builder::appComponentNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AlarmRecommendation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<RecommendationItem>> ITEMS_FIELD = SdkField
            .<List<RecommendationItem>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(AlarmRecommendation::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AlarmRecommendation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PREREQUISITE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("prerequisite").getter(getter(AlarmRecommendation::prerequisite)).setter(setter(Builder::prerequisite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prerequisite").build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationId").getter(getter(AlarmRecommendation::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()).build();

    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceId").getter(getter(AlarmRecommendation::referenceId)).setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AlarmRecommendation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_NAME_FIELD,
            APP_COMPONENT_NAMES_FIELD, DESCRIPTION_FIELD, ITEMS_FIELD, NAME_FIELD, PREREQUISITE_FIELD, RECOMMENDATION_ID_FIELD,
            REFERENCE_ID_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appComponentName;

    private final List<String> appComponentNames;

    private final String description;

    private final List<RecommendationItem> items;

    private final String name;

    private final String prerequisite;

    private final String recommendationId;

    private final String referenceId;

    private final String type;

    private AlarmRecommendation(BuilderImpl builder) {
        this.appComponentName = builder.appComponentName;
        this.appComponentNames = builder.appComponentNames;
        this.description = builder.description;
        this.items = builder.items;
        this.name = builder.name;
        this.prerequisite = builder.prerequisite;
        this.recommendationId = builder.recommendationId;
        this.referenceId = builder.referenceId;
        this.type = builder.type;
    }

    /**
     * <p>
     * Application Component name for the CloudWatch alarm recommendation. This name is saved as the first item in the
     * <code>appComponentNames</code> list.
     * </p>
     * 
     * @return Application Component name for the CloudWatch alarm recommendation. This name is saved as the first item
     *         in the <code>appComponentNames</code> list.
     * @deprecated An alarm recommendation can be attached to multiple Application Components, hence this property will
     *             be replaced by the new property 'appComponentNames'.
     */
    @Deprecated
    public final String appComponentName() {
        return appComponentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppComponentNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppComponentNames() {
        return appComponentNames != null && !(appComponentNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Application Component names for the CloudWatch alarm recommendation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppComponentNames} method.
     * </p>
     * 
     * @return List of Application Component names for the CloudWatch alarm recommendation.
     */
    public final List<String> appComponentNames() {
        return appComponentNames;
    }

    /**
     * <p>
     * Description of the alarm recommendation.
     * </p>
     * 
     * @return Description of the alarm recommendation.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of CloudWatch alarm recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return List of CloudWatch alarm recommendations.
     */
    public final List<RecommendationItem> items() {
        return items;
    }

    /**
     * <p>
     * Name of the alarm recommendation.
     * </p>
     * 
     * @return Name of the alarm recommendation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The prerequisite for the alarm recommendation.
     * </p>
     * 
     * @return The prerequisite for the alarm recommendation.
     */
    public final String prerequisite() {
        return prerequisite;
    }

    /**
     * <p>
     * Identifier of the alarm recommendation.
     * </p>
     * 
     * @return Identifier of the alarm recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * Reference identifier of the alarm recommendation.
     * </p>
     * 
     * @return Reference identifier of the alarm recommendation.
     */
    public final String referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * Type of alarm recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AlarmType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of alarm recommendation.
     * @see AlarmType
     */
    public final AlarmType type() {
        return AlarmType.fromValue(type);
    }

    /**
     * <p>
     * Type of alarm recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AlarmType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of alarm recommendation.
     * @see AlarmType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppComponentNames() ? appComponentNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(prerequisite());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmRecommendation)) {
            return false;
        }
        AlarmRecommendation other = (AlarmRecommendation) obj;
        return Objects.equals(appComponentName(), other.appComponentName())
                && hasAppComponentNames() == other.hasAppComponentNames()
                && Objects.equals(appComponentNames(), other.appComponentNames())
                && Objects.equals(description(), other.description()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && Objects.equals(name(), other.name())
                && Objects.equals(prerequisite(), other.prerequisite())
                && Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(referenceId(), other.referenceId()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlarmRecommendation").add("AppComponentName", appComponentName())
                .add("AppComponentNames", hasAppComponentNames() ? appComponentNames() : null).add("Description", description())
                .add("Items", hasItems() ? items() : null).add("Name", name()).add("Prerequisite", prerequisite())
                .add("RecommendationId", recommendationId()).add("ReferenceId", referenceId()).add("Type", typeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appComponentName":
            return Optional.ofNullable(clazz.cast(appComponentName()));
        case "appComponentNames":
            return Optional.ofNullable(clazz.cast(appComponentNames()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "prerequisite":
            return Optional.ofNullable(clazz.cast(prerequisite()));
        case "recommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "referenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmRecommendation, T> g) {
        return obj -> g.apply((AlarmRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlarmRecommendation> {
        /**
         * <p>
         * Application Component name for the CloudWatch alarm recommendation. This name is saved as the first item in
         * the <code>appComponentNames</code> list.
         * </p>
         * 
         * @param appComponentName
         *        Application Component name for the CloudWatch alarm recommendation. This name is saved as the first
         *        item in the <code>appComponentNames</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated An alarm recommendation can be attached to multiple Application Components, hence this property
         *             will be replaced by the new property 'appComponentNames'.
         */
        @Deprecated
        Builder appComponentName(String appComponentName);

        /**
         * <p>
         * List of Application Component names for the CloudWatch alarm recommendation.
         * </p>
         * 
         * @param appComponentNames
         *        List of Application Component names for the CloudWatch alarm recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponentNames(Collection<String> appComponentNames);

        /**
         * <p>
         * List of Application Component names for the CloudWatch alarm recommendation.
         * </p>
         * 
         * @param appComponentNames
         *        List of Application Component names for the CloudWatch alarm recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponentNames(String... appComponentNames);

        /**
         * <p>
         * Description of the alarm recommendation.
         * </p>
         * 
         * @param description
         *        Description of the alarm recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * List of CloudWatch alarm recommendations.
         * </p>
         * 
         * @param items
         *        List of CloudWatch alarm recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<RecommendationItem> items);

        /**
         * <p>
         * List of CloudWatch alarm recommendations.
         * </p>
         * 
         * @param items
         *        List of CloudWatch alarm recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(RecommendationItem... items);

        /**
         * <p>
         * List of CloudWatch alarm recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.RecommendationItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.RecommendationItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.RecommendationItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<RecommendationItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.RecommendationItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<RecommendationItem>)
         */
        Builder items(Consumer<RecommendationItem.Builder>... items);

        /**
         * <p>
         * Name of the alarm recommendation.
         * </p>
         * 
         * @param name
         *        Name of the alarm recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The prerequisite for the alarm recommendation.
         * </p>
         * 
         * @param prerequisite
         *        The prerequisite for the alarm recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prerequisite(String prerequisite);

        /**
         * <p>
         * Identifier of the alarm recommendation.
         * </p>
         * 
         * @param recommendationId
         *        Identifier of the alarm recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * Reference identifier of the alarm recommendation.
         * </p>
         * 
         * @param referenceId
         *        Reference identifier of the alarm recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);

        /**
         * <p>
         * Type of alarm recommendation.
         * </p>
         * 
         * @param type
         *        Type of alarm recommendation.
         * @see AlarmType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of alarm recommendation.
         * </p>
         * 
         * @param type
         *        Type of alarm recommendation.
         * @see AlarmType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmType
         */
        Builder type(AlarmType type);
    }

    static final class BuilderImpl implements Builder {
        private String appComponentName;

        private List<String> appComponentNames = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private List<RecommendationItem> items = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String prerequisite;

        private String recommendationId;

        private String referenceId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmRecommendation model) {
            appComponentName(model.appComponentName);
            appComponentNames(model.appComponentNames);
            description(model.description);
            items(model.items);
            name(model.name);
            prerequisite(model.prerequisite);
            recommendationId(model.recommendationId);
            referenceId(model.referenceId);
            type(model.type);
        }

        @Deprecated
        public final String getAppComponentName() {
            return appComponentName;
        }

        @Deprecated
        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        @Deprecated
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final Collection<String> getAppComponentNames() {
            if (appComponentNames instanceof SdkAutoConstructList) {
                return null;
            }
            return appComponentNames;
        }

        public final void setAppComponentNames(Collection<String> appComponentNames) {
            this.appComponentNames = AppComponentNameListCopier.copy(appComponentNames);
        }

        @Override
        public final Builder appComponentNames(Collection<String> appComponentNames) {
            this.appComponentNames = AppComponentNameListCopier.copy(appComponentNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponentNames(String... appComponentNames) {
            appComponentNames(Arrays.asList(appComponentNames));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<RecommendationItem.Builder> getItems() {
            List<RecommendationItem.Builder> result = RecommendationItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<RecommendationItem.BuilderImpl> items) {
            this.items = RecommendationItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<RecommendationItem> items) {
            this.items = RecommendationItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(RecommendationItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<RecommendationItem.Builder>... items) {
            items(Stream.of(items).map(c -> RecommendationItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPrerequisite() {
            return prerequisite;
        }

        public final void setPrerequisite(String prerequisite) {
            this.prerequisite = prerequisite;
        }

        @Override
        public final Builder prerequisite(String prerequisite) {
            this.prerequisite = prerequisite;
            return this;
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getReferenceId() {
            return referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AlarmType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public AlarmRecommendation build() {
            return new AlarmRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
