/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsResponse;

public class ListSopRecommendationsIterable
implements SdkIterable<ListSopRecommendationsResponse> {
    private final ResiliencehubClient client;
    private final ListSopRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSopRecommendationsIterable(ResiliencehubClient client, ListSopRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSopRecommendationsResponseFetcher();
    }

    public Iterator<ListSopRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSopRecommendationsResponseFetcher
    implements SyncPageFetcher<ListSopRecommendationsResponse> {
        private ListSopRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSopRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSopRecommendationsResponse nextPage(ListSopRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListSopRecommendationsIterable.this.client.listSopRecommendations(ListSopRecommendationsIterable.this.firstRequest);
            }
            return ListSopRecommendationsIterable.this.client.listSopRecommendations((ListSopRecommendationsRequest)((Object)ListSopRecommendationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

