/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsResponse;

public class ListAppComponentRecommendationsPublisher
implements SdkPublisher<ListAppComponentRecommendationsResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListAppComponentRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppComponentRecommendationsPublisher(ResiliencehubAsyncClient client, ListAppComponentRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppComponentRecommendationsPublisher(ResiliencehubAsyncClient client, ListAppComponentRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppComponentRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppComponentRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppComponentRecommendationsResponseFetcher
    implements AsyncPageFetcher<ListAppComponentRecommendationsResponse> {
        private ListAppComponentRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppComponentRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppComponentRecommendationsResponse> nextPage(ListAppComponentRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListAppComponentRecommendationsPublisher.this.client.listAppComponentRecommendations(ListAppComponentRecommendationsPublisher.this.firstRequest);
            }
            return ListAppComponentRecommendationsPublisher.this.client.listAppComponentRecommendations((ListAppComponentRecommendationsRequest)((Object)ListAppComponentRecommendationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

