/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AppVersionListCopier;
import software.amazon.awssdk.services.resiliencehub.model.AppVersionSummary;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppVersionsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListAppVersionsResponse> {
    private static final SdkField<List<AppVersionSummary>> APP_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appVersions").getter(ListAppVersionsResponse.getter(ListAppVersionsResponse::appVersions)).setter(ListAppVersionsResponse.setter(Builder::appVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppVersionsResponse.getter(ListAppVersionsResponse::nextToken)).setter(ListAppVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AppVersionSummary> appVersions;
    private final String nextToken;

    private ListAppVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.appVersions = builder.appVersions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAppVersions() {
        return this.appVersions != null && !(this.appVersions instanceof SdkAutoConstructList);
    }

    public final List<AppVersionSummary> appVersions() {
        return this.appVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppVersions() ? this.appVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppVersionsResponse)) {
            return false;
        }
        ListAppVersionsResponse other = (ListAppVersionsResponse)((Object)obj);
        return this.hasAppVersions() == other.hasAppVersions() && Objects.equals(this.appVersions(), other.appVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppVersionsResponse").add("AppVersions", this.hasAppVersions() ? this.appVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appVersions": {
                return Optional.ofNullable(clazz.cast(this.appVersions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppVersionsResponse, T> g) {
        return obj -> g.apply((ListAppVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private List<AppVersionSummary> appVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppVersionsResponse model) {
            super(model);
            this.appVersions(model.appVersions);
            this.nextToken(model.nextToken);
        }

        public final List<AppVersionSummary.Builder> getAppVersions() {
            List<AppVersionSummary.Builder> result = AppVersionListCopier.copyToBuilder(this.appVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppVersions(Collection<AppVersionSummary.BuilderImpl> appVersions) {
            this.appVersions = AppVersionListCopier.copyFromBuilder(appVersions);
        }

        @Override
        public final Builder appVersions(Collection<AppVersionSummary> appVersions) {
            this.appVersions = AppVersionListCopier.copy(appVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appVersions(AppVersionSummary ... appVersions) {
            this.appVersions(Arrays.asList(appVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appVersions(Consumer<AppVersionSummary.Builder> ... appVersions) {
            this.appVersions(Stream.of(appVersions).map(c -> (AppVersionSummary)((AppVersionSummary.Builder)AppVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppVersionsResponse build() {
            return new ListAppVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppVersionsResponse> {
        public Builder appVersions(Collection<AppVersionSummary> var1);

        public Builder appVersions(AppVersionSummary ... var1);

        public Builder appVersions(Consumer<AppVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

