/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigRecommendationOptimizationType {
    LEAST_COST("LeastCost"),
    LEAST_CHANGE("LeastChange"),
    BEST_AZ_RECOVERY("BestAZRecovery"),
    LEAST_ERRORS("LeastErrors"),
    BEST_ATTAINABLE("BestAttainable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigRecommendationOptimizationType> VALUE_MAP;
    private final String value;

    private ConfigRecommendationOptimizationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigRecommendationOptimizationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigRecommendationOptimizationType> knownValues() {
        EnumSet<ConfigRecommendationOptimizationType> knownValues = EnumSet.allOf(ConfigRecommendationOptimizationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigRecommendationOptimizationType.class, ConfigRecommendationOptimizationType::toString);
    }
}

