/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration options for a media analysis job. Configuration is operation-specific.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaAnalysisOperationsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaAnalysisOperationsConfig.Builder, MediaAnalysisOperationsConfig> {
    private static final SdkField<MediaAnalysisDetectModerationLabelsConfig> DETECT_MODERATION_LABELS_FIELD = SdkField
            .<MediaAnalysisDetectModerationLabelsConfig> builder(MarshallingType.SDK_POJO).memberName("DetectModerationLabels")
            .getter(getter(MediaAnalysisOperationsConfig::detectModerationLabels))
            .setter(setter(Builder::detectModerationLabels)).constructor(MediaAnalysisDetectModerationLabelsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectModerationLabels").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DETECT_MODERATION_LABELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final MediaAnalysisDetectModerationLabelsConfig detectModerationLabels;

    private MediaAnalysisOperationsConfig(BuilderImpl builder) {
        this.detectModerationLabels = builder.detectModerationLabels;
    }

    /**
     * <p>
     * Contains configuration options for a DetectModerationLabels job.
     * </p>
     * 
     * @return Contains configuration options for a DetectModerationLabels job.
     */
    public final MediaAnalysisDetectModerationLabelsConfig detectModerationLabels() {
        return detectModerationLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detectModerationLabels());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaAnalysisOperationsConfig)) {
            return false;
        }
        MediaAnalysisOperationsConfig other = (MediaAnalysisOperationsConfig) obj;
        return Objects.equals(detectModerationLabels(), other.detectModerationLabels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaAnalysisOperationsConfig").add("DetectModerationLabels", detectModerationLabels()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectModerationLabels":
            return Optional.ofNullable(clazz.cast(detectModerationLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaAnalysisOperationsConfig, T> g) {
        return obj -> g.apply((MediaAnalysisOperationsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaAnalysisOperationsConfig> {
        /**
         * <p>
         * Contains configuration options for a DetectModerationLabels job.
         * </p>
         * 
         * @param detectModerationLabels
         *        Contains configuration options for a DetectModerationLabels job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectModerationLabels(MediaAnalysisDetectModerationLabelsConfig detectModerationLabels);

        /**
         * <p>
         * Contains configuration options for a DetectModerationLabels job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MediaAnalysisDetectModerationLabelsConfig.Builder} avoiding the need to create one manually via
         * {@link MediaAnalysisDetectModerationLabelsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaAnalysisDetectModerationLabelsConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #detectModerationLabels(MediaAnalysisDetectModerationLabelsConfig)}.
         * 
         * @param detectModerationLabels
         *        a consumer that will call methods on {@link MediaAnalysisDetectModerationLabelsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectModerationLabels(MediaAnalysisDetectModerationLabelsConfig)
         */
        default Builder detectModerationLabels(Consumer<MediaAnalysisDetectModerationLabelsConfig.Builder> detectModerationLabels) {
            return detectModerationLabels(MediaAnalysisDetectModerationLabelsConfig.builder()
                    .applyMutation(detectModerationLabels).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MediaAnalysisDetectModerationLabelsConfig detectModerationLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaAnalysisOperationsConfig model) {
            detectModerationLabels(model.detectModerationLabels);
        }

        public final MediaAnalysisDetectModerationLabelsConfig.Builder getDetectModerationLabels() {
            return detectModerationLabels != null ? detectModerationLabels.toBuilder() : null;
        }

        public final void setDetectModerationLabels(MediaAnalysisDetectModerationLabelsConfig.BuilderImpl detectModerationLabels) {
            this.detectModerationLabels = detectModerationLabels != null ? detectModerationLabels.build() : null;
        }

        @Override
        public final Builder detectModerationLabels(MediaAnalysisDetectModerationLabelsConfig detectModerationLabels) {
            this.detectModerationLabels = detectModerationLabels;
            return this;
        }

        @Override
        public MediaAnalysisOperationsConfig build() {
            return new MediaAnalysisOperationsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
