/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLabelDetectionResponse extends RekognitionResponse implements
        ToCopyableBuilder<GetLabelDetectionResponse.Builder, GetLabelDetectionResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(GetLabelDetectionResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetLabelDetectionResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<VideoMetadata> VIDEO_METADATA_FIELD = SdkField
            .<VideoMetadata> builder(MarshallingType.SDK_POJO).memberName("VideoMetadata")
            .getter(getter(GetLabelDetectionResponse::videoMetadata)).setter(setter(Builder::videoMetadata))
            .constructor(VideoMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetLabelDetectionResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<LabelDetection>> LABELS_FIELD = SdkField
            .<List<LabelDetection>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(GetLabelDetectionResponse::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LabelDetection> builder(MarshallingType.SDK_POJO)
                                            .constructor(LabelDetection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LABEL_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelModelVersion").getter(getter(GetLabelDetectionResponse::labelModelVersion))
            .setter(setter(Builder::labelModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelModelVersion").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(GetLabelDetectionResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<Video> VIDEO_FIELD = SdkField.<Video> builder(MarshallingType.SDK_POJO).memberName("Video")
            .getter(getter(GetLabelDetectionResponse::video)).setter(setter(Builder::video)).constructor(Video::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()).build();

    private static final SdkField<String> JOB_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobTag")
            .getter(getter(GetLabelDetectionResponse::jobTag)).setter(setter(Builder::jobTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()).build();

    private static final SdkField<GetLabelDetectionRequestMetadata> GET_REQUEST_METADATA_FIELD = SdkField
            .<GetLabelDetectionRequestMetadata> builder(MarshallingType.SDK_POJO).memberName("GetRequestMetadata")
            .getter(getter(GetLabelDetectionResponse::getRequestMetadata)).setter(setter(Builder::getRequestMetadata))
            .constructor(GetLabelDetectionRequestMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GetRequestMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD,
            STATUS_MESSAGE_FIELD, VIDEO_METADATA_FIELD, NEXT_TOKEN_FIELD, LABELS_FIELD, LABEL_MODEL_VERSION_FIELD, JOB_ID_FIELD,
            VIDEO_FIELD, JOB_TAG_FIELD, GET_REQUEST_METADATA_FIELD));

    private final String jobStatus;

    private final String statusMessage;

    private final VideoMetadata videoMetadata;

    private final String nextToken;

    private final List<LabelDetection> labels;

    private final String labelModelVersion;

    private final String jobId;

    private final Video video;

    private final String jobTag;

    private final GetLabelDetectionRequestMetadata getRequestMetadata;

    private GetLabelDetectionResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.nextToken = builder.nextToken;
        this.labels = builder.labels;
        this.labelModelVersion = builder.labelModelVersion;
        this.jobId = builder.jobId;
        this.video = builder.video;
        this.jobTag = builder.jobTag;
        this.getRequestMetadata = builder.getRequestMetadata;
    }

    /**
     * <p>
     * The current status of the label detection job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the label detection job.
     * @see VideoJobStatus
     */
    public final VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the label detection job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the label detection job.
     * @see VideoJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     * </p>
     * 
     * @return If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in every
     * page of paginated responses from a Amazon Rekognition video operation.
     * </p>
     * 
     * @return Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned
     *         in every page of paginated responses from a Amazon Rekognition video operation.
     */
    public final VideoMetadata videoMetadata() {
        return videoMetadata;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
     * request to retrieve the next set of labels.
     * </p>
     * 
     * @return If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
     *         subsequent request to retrieve the next set of labels.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of labels detected in the video. Each element contains the detected label and the time, in milliseconds
     * from the start of the video, that the label was detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return An array of labels detected in the video. Each element contains the detected label and the time, in
     *         milliseconds from the start of the video, that the label was detected.
     */
    public final List<LabelDetection> labels() {
        return labels;
    }

    /**
     * <p>
     * Version number of the label detection model that was used to detect labels.
     * </p>
     * 
     * @return Version number of the label detection model that was used to detect labels.
     */
    public final String labelModelVersion() {
        return labelModelVersion;
    }

    /**
     * <p>
     * Job identifier for the label detection operation for which you want to obtain results. The job identifer is
     * returned by an initial call to StartLabelDetection.
     * </p>
     * 
     * @return Job identifier for the label detection operation for which you want to obtain results. The job identifer
     *         is returned by an initial call to StartLabelDetection.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * Returns the value of the Video property for this object.
     * 
     * @return The value of the Video property for this object.
     */
    public final Video video() {
        return video;
    }

    /**
     * <p>
     * A job identifier specified in the call to StartLabelDetection and returned in the job completion notification
     * sent to your Amazon Simple Notification Service topic.
     * </p>
     * 
     * @return A job identifier specified in the call to StartLabelDetection and returned in the job completion
     *         notification sent to your Amazon Simple Notification Service topic.
     */
    public final String jobTag() {
        return jobTag;
    }

    /**
     * <p>
     * Information about the paramters used when getting a response. Includes information on aggregation and sorting
     * methods.
     * </p>
     * 
     * @return Information about the paramters used when getting a response. Includes information on aggregation and
     *         sorting methods.
     */
    public final GetLabelDetectionRequestMetadata getRequestMetadata() {
        return getRequestMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(labelModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(jobTag());
        hashCode = 31 * hashCode + Objects.hashCode(getRequestMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLabelDetectionResponse)) {
            return false;
        }
        GetLabelDetectionResponse other = (GetLabelDetectionResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(videoMetadata(), other.videoMetadata()) && Objects.equals(nextToken(), other.nextToken())
                && hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels())
                && Objects.equals(labelModelVersion(), other.labelModelVersion()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(video(), other.video()) && Objects.equals(jobTag(), other.jobTag())
                && Objects.equals(getRequestMetadata(), other.getRequestMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLabelDetectionResponse").add("JobStatus", jobStatusAsString())
                .add("StatusMessage", statusMessage()).add("VideoMetadata", videoMetadata()).add("NextToken", nextToken())
                .add("Labels", hasLabels() ? labels() : null).add("LabelModelVersion", labelModelVersion()).add("JobId", jobId())
                .add("Video", video()).add("JobTag", jobTag()).add("GetRequestMetadata", getRequestMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "VideoMetadata":
            return Optional.ofNullable(clazz.cast(videoMetadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "LabelModelVersion":
            return Optional.ofNullable(clazz.cast(labelModelVersion()));
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "Video":
            return Optional.ofNullable(clazz.cast(video()));
        case "JobTag":
            return Optional.ofNullable(clazz.cast(jobTag()));
        case "GetRequestMetadata":
            return Optional.ofNullable(clazz.cast(getRequestMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLabelDetectionResponse, T> g) {
        return obj -> g.apply((GetLabelDetectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLabelDetectionResponse> {
        /**
         * <p>
         * The current status of the label detection job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the label detection job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the label detection job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the label detection job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(VideoJobStatus jobStatus);

        /**
         * <p>
         * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * </p>
         * 
         * @param statusMessage
         *        If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in
         * every page of paginated responses from a Amazon Rekognition video operation.
         * </p>
         * 
         * @param videoMetadata
         *        Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is
         *        returned in every page of paginated responses from a Amazon Rekognition video operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoMetadata(VideoMetadata videoMetadata);

        /**
         * <p>
         * Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in
         * every page of paginated responses from a Amazon Rekognition video operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoMetadata.Builder} avoiding the need
         * to create one manually via {@link VideoMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #videoMetadata(VideoMetadata)}.
         * 
         * @param videoMetadata
         *        a consumer that will call methods on {@link VideoMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoMetadata(VideoMetadata)
         */
        default Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return videoMetadata(VideoMetadata.builder().applyMutation(videoMetadata).build());
        }

        /**
         * <p>
         * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
         * request to retrieve the next set of labels.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
         *        subsequent request to retrieve the next set of labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of labels detected in the video. Each element contains the detected label and the time, in
         * milliseconds from the start of the video, that the label was detected.
         * </p>
         * 
         * @param labels
         *        An array of labels detected in the video. Each element contains the detected label and the time, in
         *        milliseconds from the start of the video, that the label was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<LabelDetection> labels);

        /**
         * <p>
         * An array of labels detected in the video. Each element contains the detected label and the time, in
         * milliseconds from the start of the video, that the label was detected.
         * </p>
         * 
         * @param labels
         *        An array of labels detected in the video. Each element contains the detected label and the time, in
         *        milliseconds from the start of the video, that the label was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(LabelDetection... labels);

        /**
         * <p>
         * An array of labels detected in the video. Each element contains the detected label and the time, in
         * milliseconds from the start of the video, that the label was detected.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.LabelDetection.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rekognition.model.LabelDetection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.LabelDetection.Builder#build()} is called
         * immediately and its result is passed to {@link #labels(List<LabelDetection>)}.
         * 
         * @param labels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.LabelDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labels(java.util.Collection<LabelDetection>)
         */
        Builder labels(Consumer<LabelDetection.Builder>... labels);

        /**
         * <p>
         * Version number of the label detection model that was used to detect labels.
         * </p>
         * 
         * @param labelModelVersion
         *        Version number of the label detection model that was used to detect labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelModelVersion(String labelModelVersion);

        /**
         * <p>
         * Job identifier for the label detection operation for which you want to obtain results. The job identifer is
         * returned by an initial call to StartLabelDetection.
         * </p>
         * 
         * @param jobId
         *        Job identifier for the label detection operation for which you want to obtain results. The job
         *        identifer is returned by an initial call to StartLabelDetection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * Sets the value of the Video property for this object.
         *
         * @param video
         *        The new value for the Video property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(Video video);

        /**
         * Sets the value of the Video property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Video.Builder} avoiding the need to
         * create one manually via {@link Video#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Video.Builder#build()} is called immediately and its result is
         * passed to {@link #video(Video)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link Video.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(Video)
         */
        default Builder video(Consumer<Video.Builder> video) {
            return video(Video.builder().applyMutation(video).build());
        }

        /**
         * <p>
         * A job identifier specified in the call to StartLabelDetection and returned in the job completion notification
         * sent to your Amazon Simple Notification Service topic.
         * </p>
         * 
         * @param jobTag
         *        A job identifier specified in the call to StartLabelDetection and returned in the job completion
         *        notification sent to your Amazon Simple Notification Service topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTag(String jobTag);

        /**
         * <p>
         * Information about the paramters used when getting a response. Includes information on aggregation and sorting
         * methods.
         * </p>
         * 
         * @param getRequestMetadata
         *        Information about the paramters used when getting a response. Includes information on aggregation and
         *        sorting methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder getRequestMetadata(GetLabelDetectionRequestMetadata getRequestMetadata);

        /**
         * <p>
         * Information about the paramters used when getting a response. Includes information on aggregation and sorting
         * methods.
         * </p>
         * This is a convenience method that creates an instance of the {@link GetLabelDetectionRequestMetadata.Builder}
         * avoiding the need to create one manually via {@link GetLabelDetectionRequestMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GetLabelDetectionRequestMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #getRequestMetadata(GetLabelDetectionRequestMetadata)}.
         * 
         * @param getRequestMetadata
         *        a consumer that will call methods on {@link GetLabelDetectionRequestMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #getRequestMetadata(GetLabelDetectionRequestMetadata)
         */
        default Builder getRequestMetadata(Consumer<GetLabelDetectionRequestMetadata.Builder> getRequestMetadata) {
            return getRequestMetadata(GetLabelDetectionRequestMetadata.builder().applyMutation(getRequestMetadata).build());
        }
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private String statusMessage;

        private VideoMetadata videoMetadata;

        private String nextToken;

        private List<LabelDetection> labels = DefaultSdkAutoConstructList.getInstance();

        private String labelModelVersion;

        private String jobId;

        private Video video;

        private String jobTag;

        private GetLabelDetectionRequestMetadata getRequestMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLabelDetectionResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            statusMessage(model.statusMessage);
            videoMetadata(model.videoMetadata);
            nextToken(model.nextToken);
            labels(model.labels);
            labelModelVersion(model.labelModelVersion);
            jobId(model.jobId);
            video(model.video);
            jobTag(model.jobTag);
            getRequestMetadata(model.getRequestMetadata);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return videoMetadata != null ? videoMetadata.toBuilder() : null;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<LabelDetection.Builder> getLabels() {
            List<LabelDetection.Builder> result = LabelDetectionsCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabels(Collection<LabelDetection.BuilderImpl> labels) {
            this.labels = LabelDetectionsCopier.copyFromBuilder(labels);
        }

        @Override
        public final Builder labels(Collection<LabelDetection> labels) {
            this.labels = LabelDetectionsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(LabelDetection... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<LabelDetection.Builder>... labels) {
            labels(Stream.of(labels).map(c -> LabelDetection.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLabelModelVersion() {
            return labelModelVersion;
        }

        public final void setLabelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
        }

        @Override
        public final Builder labelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Video.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        public final void setVideo(Video.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(Video video) {
            this.video = video;
            return this;
        }

        public final String getJobTag() {
            return jobTag;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final GetLabelDetectionRequestMetadata.Builder getGetRequestMetadata() {
            return getRequestMetadata != null ? getRequestMetadata.toBuilder() : null;
        }

        public final void setGetRequestMetadata(GetLabelDetectionRequestMetadata.BuilderImpl getRequestMetadata) {
            this.getRequestMetadata = getRequestMetadata != null ? getRequestMetadata.build() : null;
        }

        @Override
        public final Builder getRequestMetadata(GetLabelDetectionRequestMetadata getRequestMetadata) {
            this.getRequestMetadata = getRequestMetadata;
            return this;
        }

        @Override
        public GetLabelDetectionResponse build() {
            return new GetLabelDetectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
