/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectRequest extends RekognitionRequest implements
        ToCopyableBuilder<CreateProjectRequest.Builder, CreateProjectRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(CreateProjectRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Feature")
            .getter(getter(CreateProjectRequest::featureAsString)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feature").build()).build();

    private static final SdkField<String> AUTO_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoUpdate").getter(getter(CreateProjectRequest::autoUpdateAsString))
            .setter(setter(Builder::autoUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            FEATURE_FIELD, AUTO_UPDATE_FIELD));

    private final String projectName;

    private final String feature;

    private final String autoUpdate;

    private CreateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.feature = builder.feature;
        this.autoUpdate = builder.autoUpdate;
    }

    /**
     * <p>
     * The name of the project to create.
     * </p>
     * 
     * @return The name of the project to create.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * Specifies feature that is being customized. If no value is provided CUSTOM_LABELS is used as a default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link CustomizationFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureAsString}.
     * </p>
     * 
     * @return Specifies feature that is being customized. If no value is provided CUSTOM_LABELS is used as a default.
     * @see CustomizationFeature
     */
    public final CustomizationFeature feature() {
        return CustomizationFeature.fromValue(feature);
    }

    /**
     * <p>
     * Specifies feature that is being customized. If no value is provided CUSTOM_LABELS is used as a default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link CustomizationFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureAsString}.
     * </p>
     * 
     * @return Specifies feature that is being customized. If no value is provided CUSTOM_LABELS is used as a default.
     * @see CustomizationFeature
     */
    public final String featureAsString() {
        return feature;
    }

    /**
     * <p>
     * Specifies whether automatic retraining should be attempted for the versions of the project. Automatic retraining
     * is done as a best effort. Required argument for Content Moderation. Applicable only to adapters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoUpdate} will
     * return {@link ProjectAutoUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoUpdateAsString}.
     * </p>
     * 
     * @return Specifies whether automatic retraining should be attempted for the versions of the project. Automatic
     *         retraining is done as a best effort. Required argument for Content Moderation. Applicable only to
     *         adapters.
     * @see ProjectAutoUpdate
     */
    public final ProjectAutoUpdate autoUpdate() {
        return ProjectAutoUpdate.fromValue(autoUpdate);
    }

    /**
     * <p>
     * Specifies whether automatic retraining should be attempted for the versions of the project. Automatic retraining
     * is done as a best effort. Required argument for Content Moderation. Applicable only to adapters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoUpdate} will
     * return {@link ProjectAutoUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoUpdateAsString}.
     * </p>
     * 
     * @return Specifies whether automatic retraining should be attempted for the versions of the project. Automatic
     *         retraining is done as a best effort. Required argument for Content Moderation. Applicable only to
     *         adapters.
     * @see ProjectAutoUpdate
     */
    public final String autoUpdateAsString() {
        return autoUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(featureAsString(), other.featureAsString())
                && Objects.equals(autoUpdateAsString(), other.autoUpdateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProjectRequest").add("ProjectName", projectName()).add("Feature", featureAsString())
                .add("AutoUpdate", autoUpdateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "Feature":
            return Optional.ofNullable(clazz.cast(featureAsString()));
        case "AutoUpdate":
            return Optional.ofNullable(clazz.cast(autoUpdateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectRequest, T> g) {
        return obj -> g.apply((CreateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProjectRequest> {
        /**
         * <p>
         * The name of the project to create.
         * </p>
         * 
         * @param projectName
         *        The name of the project to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * Specifies feature that is being customized. If no value is provided CUSTOM_LABELS is used as a default.
         * </p>
         * 
         * @param feature
         *        Specifies feature that is being customized. If no value is provided CUSTOM_LABELS is used as a
         *        default.
         * @see CustomizationFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationFeature
         */
        Builder feature(String feature);

        /**
         * <p>
         * Specifies feature that is being customized. If no value is provided CUSTOM_LABELS is used as a default.
         * </p>
         * 
         * @param feature
         *        Specifies feature that is being customized. If no value is provided CUSTOM_LABELS is used as a
         *        default.
         * @see CustomizationFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationFeature
         */
        Builder feature(CustomizationFeature feature);

        /**
         * <p>
         * Specifies whether automatic retraining should be attempted for the versions of the project. Automatic
         * retraining is done as a best effort. Required argument for Content Moderation. Applicable only to adapters.
         * </p>
         * 
         * @param autoUpdate
         *        Specifies whether automatic retraining should be attempted for the versions of the project. Automatic
         *        retraining is done as a best effort. Required argument for Content Moderation. Applicable only to
         *        adapters.
         * @see ProjectAutoUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectAutoUpdate
         */
        Builder autoUpdate(String autoUpdate);

        /**
         * <p>
         * Specifies whether automatic retraining should be attempted for the versions of the project. Automatic
         * retraining is done as a best effort. Required argument for Content Moderation. Applicable only to adapters.
         * </p>
         * 
         * @param autoUpdate
         *        Specifies whether automatic retraining should be attempted for the versions of the project. Automatic
         *        retraining is done as a best effort. Required argument for Content Moderation. Applicable only to
         *        adapters.
         * @see ProjectAutoUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectAutoUpdate
         */
        Builder autoUpdate(ProjectAutoUpdate autoUpdate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String projectName;

        private String feature;

        private String autoUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectRequest model) {
            super(model);
            projectName(model.projectName);
            feature(model.feature);
            autoUpdate(model.autoUpdate);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(CustomizationFeature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final String getAutoUpdate() {
            return autoUpdate;
        }

        public final void setAutoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        @Override
        public final Builder autoUpdate(ProjectAutoUpdate autoUpdate) {
            this.autoUpdate(autoUpdate == null ? null : autoUpdate.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectRequest build() {
            return new CreateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
