/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchUsersByImageRequest extends RekognitionRequest implements
        ToCopyableBuilder<SearchUsersByImageRequest.Builder, SearchUsersByImageRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionId").getter(getter(SearchUsersByImageRequest::collectionId))
            .setter(setter(Builder::collectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()).build();

    private static final SdkField<Image> IMAGE_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO).memberName("Image")
            .getter(getter(SearchUsersByImageRequest::image)).setter(setter(Builder::image)).constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<Float> USER_MATCH_THRESHOLD_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("UserMatchThreshold").getter(getter(SearchUsersByImageRequest::userMatchThreshold))
            .setter(setter(Builder::userMatchThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMatchThreshold").build())
            .build();

    private static final SdkField<Integer> MAX_USERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxUsers").getter(getter(SearchUsersByImageRequest::maxUsers)).setter(setter(Builder::maxUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUsers").build()).build();

    private static final SdkField<String> QUALITY_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualityFilter").getter(getter(SearchUsersByImageRequest::qualityFilterAsString))
            .setter(setter(Builder::qualityFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualityFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD,
            IMAGE_FIELD, USER_MATCH_THRESHOLD_FIELD, MAX_USERS_FIELD, QUALITY_FILTER_FIELD));

    private final String collectionId;

    private final Image image;

    private final Float userMatchThreshold;

    private final Integer maxUsers;

    private final String qualityFilter;

    private SearchUsersByImageRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.userMatchThreshold = builder.userMatchThreshold;
        this.maxUsers = builder.maxUsers;
        this.qualityFilter = builder.qualityFilter;
    }

    /**
     * <p>
     * The ID of an existing collection containing the UserID.
     * </p>
     * 
     * @return The ID of an existing collection containing the UserID.
     */
    public final String collectionId() {
        return collectionId;
    }

    /**
     * Returns the value of the Image property for this object.
     * 
     * @return The value of the Image property for this object.
     */
    public final Image image() {
        return image;
    }

    /**
     * <p>
     * Specifies the minimum confidence in the UserID match to return. Default value is 80.
     * </p>
     * 
     * @return Specifies the minimum confidence in the UserID match to return. Default value is 80.
     */
    public final Float userMatchThreshold() {
        return userMatchThreshold;
    }

    /**
     * <p>
     * Maximum number of UserIDs to return.
     * </p>
     * 
     * @return Maximum number of UserIDs to return.
     */
    public final Integer maxUsers() {
        return maxUsers;
    }

    /**
     * <p>
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
     * searched for in the collection. The default value is NONE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qualityFilter}
     * will return {@link QualityFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityFilterAsString}.
     * </p>
     * 
     * @return A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
     *         aren't searched for in the collection. The default value is NONE.
     * @see QualityFilter
     */
    public final QualityFilter qualityFilter() {
        return QualityFilter.fromValue(qualityFilter);
    }

    /**
     * <p>
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
     * searched for in the collection. The default value is NONE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qualityFilter}
     * will return {@link QualityFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityFilterAsString}.
     * </p>
     * 
     * @return A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
     *         aren't searched for in the collection. The default value is NONE.
     * @see QualityFilter
     */
    public final String qualityFilterAsString() {
        return qualityFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(userMatchThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(maxUsers());
        hashCode = 31 * hashCode + Objects.hashCode(qualityFilterAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersByImageRequest)) {
            return false;
        }
        SearchUsersByImageRequest other = (SearchUsersByImageRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(image(), other.image())
                && Objects.equals(userMatchThreshold(), other.userMatchThreshold())
                && Objects.equals(maxUsers(), other.maxUsers())
                && Objects.equals(qualityFilterAsString(), other.qualityFilterAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchUsersByImageRequest").add("CollectionId", collectionId()).add("Image", image())
                .add("UserMatchThreshold", userMatchThreshold()).add("MaxUsers", maxUsers())
                .add("QualityFilter", qualityFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.ofNullable(clazz.cast(collectionId()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "UserMatchThreshold":
            return Optional.ofNullable(clazz.cast(userMatchThreshold()));
        case "MaxUsers":
            return Optional.ofNullable(clazz.cast(maxUsers()));
        case "QualityFilter":
            return Optional.ofNullable(clazz.cast(qualityFilterAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchUsersByImageRequest, T> g) {
        return obj -> g.apply((SearchUsersByImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchUsersByImageRequest> {
        /**
         * <p>
         * The ID of an existing collection containing the UserID.
         * </p>
         * 
         * @param collectionId
         *        The ID of an existing collection containing the UserID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * Sets the value of the Image property for this object.
         *
         * @param image
         *        The new value for the Image property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * Sets the value of the Image property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Image.Builder} avoiding the need to
         * create one manually via {@link Image#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #image(Image)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(Image)
         */
        default Builder image(Consumer<Image.Builder> image) {
            return image(Image.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * Specifies the minimum confidence in the UserID match to return. Default value is 80.
         * </p>
         * 
         * @param userMatchThreshold
         *        Specifies the minimum confidence in the UserID match to return. Default value is 80.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMatchThreshold(Float userMatchThreshold);

        /**
         * <p>
         * Maximum number of UserIDs to return.
         * </p>
         * 
         * @param maxUsers
         *        Maximum number of UserIDs to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUsers(Integer maxUsers);

        /**
         * <p>
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
         * searched for in the collection. The default value is NONE.
         * </p>
         * 
         * @param qualityFilter
         *        A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
         *        aren't searched for in the collection. The default value is NONE.
         * @see QualityFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualityFilter
         */
        Builder qualityFilter(String qualityFilter);

        /**
         * <p>
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
         * searched for in the collection. The default value is NONE.
         * </p>
         * 
         * @param qualityFilter
         *        A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
         *        aren't searched for in the collection. The default value is NONE.
         * @see QualityFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualityFilter
         */
        Builder qualityFilter(QualityFilter qualityFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String collectionId;

        private Image image;

        private Float userMatchThreshold;

        private Integer maxUsers;

        private String qualityFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUsersByImageRequest model) {
            super(model);
            collectionId(model.collectionId);
            image(model.image);
            userMatchThreshold(model.userMatchThreshold);
            maxUsers(model.maxUsers);
            qualityFilter(model.qualityFilter);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final Float getUserMatchThreshold() {
            return userMatchThreshold;
        }

        public final void setUserMatchThreshold(Float userMatchThreshold) {
            this.userMatchThreshold = userMatchThreshold;
        }

        @Override
        public final Builder userMatchThreshold(Float userMatchThreshold) {
            this.userMatchThreshold = userMatchThreshold;
            return this;
        }

        public final Integer getMaxUsers() {
            return maxUsers;
        }

        public final void setMaxUsers(Integer maxUsers) {
            this.maxUsers = maxUsers;
        }

        @Override
        public final Builder maxUsers(Integer maxUsers) {
            this.maxUsers = maxUsers;
            return this;
        }

        public final String getQualityFilter() {
            return qualityFilter;
        }

        public final void setQualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
        }

        @Override
        public final Builder qualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
            return this;
        }

        @Override
        public final Builder qualityFilter(QualityFilter qualityFilter) {
            this.qualityFilter(qualityFilter == null ? null : qualityFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchUsersByImageRequest build() {
            return new SearchUsersByImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
