/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectionFilter> {
    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MinConfidence").getter(DetectionFilter.getter(DetectionFilter::minConfidence)).setter(DetectionFilter.setter(Builder::minConfidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()}).build();
    private static final SdkField<Float> MIN_BOUNDING_BOX_HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MinBoundingBoxHeight").getter(DetectionFilter.getter(DetectionFilter::minBoundingBoxHeight)).setter(DetectionFilter.setter(Builder::minBoundingBoxHeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinBoundingBoxHeight").build()}).build();
    private static final SdkField<Float> MIN_BOUNDING_BOX_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MinBoundingBoxWidth").getter(DetectionFilter.getter(DetectionFilter::minBoundingBoxWidth)).setter(DetectionFilter.setter(Builder::minBoundingBoxWidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinBoundingBoxWidth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CONFIDENCE_FIELD, MIN_BOUNDING_BOX_HEIGHT_FIELD, MIN_BOUNDING_BOX_WIDTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float minConfidence;
    private final Float minBoundingBoxHeight;
    private final Float minBoundingBoxWidth;

    private DetectionFilter(BuilderImpl builder) {
        this.minConfidence = builder.minConfidence;
        this.minBoundingBoxHeight = builder.minBoundingBoxHeight;
        this.minBoundingBoxWidth = builder.minBoundingBoxWidth;
    }

    public final Float minConfidence() {
        return this.minConfidence;
    }

    public final Float minBoundingBoxHeight() {
        return this.minBoundingBoxHeight;
    }

    public final Float minBoundingBoxWidth() {
        return this.minBoundingBoxWidth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBoundingBoxHeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBoundingBoxWidth());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectionFilter)) {
            return false;
        }
        DetectionFilter other = (DetectionFilter)obj;
        return Objects.equals(this.minConfidence(), other.minConfidence()) && Objects.equals(this.minBoundingBoxHeight(), other.minBoundingBoxHeight()) && Objects.equals(this.minBoundingBoxWidth(), other.minBoundingBoxWidth());
    }

    public final String toString() {
        return ToString.builder((String)"DetectionFilter").add("MinConfidence", (Object)this.minConfidence()).add("MinBoundingBoxHeight", (Object)this.minBoundingBoxHeight()).add("MinBoundingBoxWidth", (Object)this.minBoundingBoxWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinConfidence": {
                return Optional.ofNullable(clazz.cast(this.minConfidence()));
            }
            case "MinBoundingBoxHeight": {
                return Optional.ofNullable(clazz.cast(this.minBoundingBoxHeight()));
            }
            case "MinBoundingBoxWidth": {
                return Optional.ofNullable(clazz.cast(this.minBoundingBoxWidth()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectionFilter, T> g) {
        return obj -> g.apply((DetectionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float minConfidence;
        private Float minBoundingBoxHeight;
        private Float minBoundingBoxWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectionFilter model) {
            this.minConfidence(model.minConfidence);
            this.minBoundingBoxHeight(model.minBoundingBoxHeight);
            this.minBoundingBoxWidth(model.minBoundingBoxWidth);
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final Float getMinBoundingBoxHeight() {
            return this.minBoundingBoxHeight;
        }

        public final void setMinBoundingBoxHeight(Float minBoundingBoxHeight) {
            this.minBoundingBoxHeight = minBoundingBoxHeight;
        }

        @Override
        public final Builder minBoundingBoxHeight(Float minBoundingBoxHeight) {
            this.minBoundingBoxHeight = minBoundingBoxHeight;
            return this;
        }

        public final Float getMinBoundingBoxWidth() {
            return this.minBoundingBoxWidth;
        }

        public final void setMinBoundingBoxWidth(Float minBoundingBoxWidth) {
            this.minBoundingBoxWidth = minBoundingBoxWidth;
        }

        @Override
        public final Builder minBoundingBoxWidth(Float minBoundingBoxWidth) {
            this.minBoundingBoxWidth = minBoundingBoxWidth;
            return this;
        }

        public DetectionFilter build() {
            return new DetectionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectionFilter> {
        public Builder minConfidence(Float var1);

        public Builder minBoundingBoxHeight(Float var1);

        public Builder minBoundingBoxWidth(Float var1);
    }
}

