/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of computing resources from which an endpoint is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Workgroup implements SdkPojo, Serializable, ToCopyableBuilder<Workgroup.Builder, Workgroup> {
    private static final SdkField<Integer> BASE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("baseCapacity").getter(getter(Workgroup::baseCapacity)).setter(setter(Builder::baseCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCapacity").build()).build();

    private static final SdkField<List<ConfigParameter>> CONFIG_PARAMETERS_FIELD = SdkField
            .<List<ConfigParameter>> builder(MarshallingType.LIST)
            .memberName("configParameters")
            .getter(getter(Workgroup::configParameters))
            .setter(setter(Builder::configParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate")
            .getter(getter(Workgroup::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("customDomainCertificateArn")
            .getter(getter(Workgroup::customDomainCertificateArn))
            .setter(setter(Builder::customDomainCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainCertificateArn").build())
            .build();

    private static final SdkField<Instant> CUSTOM_DOMAIN_CERTIFICATE_EXPIRY_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("customDomainCertificateExpiryTime")
            .getter(getter(Workgroup::customDomainCertificateExpiryTime))
            .setter(setter(Builder::customDomainCertificateExpiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainCertificateExpiryTime")
                    .build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDomainName").getter(getter(Workgroup::customDomainName)).setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()).build();

    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("endpoint").getter(getter(Workgroup::endpoint)).setter(setter(Builder::endpoint))
            .constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enhancedVpcRouting").getter(getter(Workgroup::enhancedVpcRouting))
            .setter(setter(Builder::enhancedVpcRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedVpcRouting").build())
            .build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCapacity").getter(getter(Workgroup::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCapacity").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(Workgroup::namespaceName)).setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("patchVersion").getter(getter(Workgroup::patchVersion)).setter(setter(Builder::patchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchVersion").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(Workgroup::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publiclyAccessible").getter(getter(Workgroup::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(Workgroup::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Workgroup::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(Workgroup::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKGROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupArn").getter(getter(Workgroup::workgroupArn)).setter(setter(Builder::workgroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupArn").build()).build();

    private static final SdkField<String> WORKGROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupId").getter(getter(Workgroup::workgroupId)).setter(setter(Builder::workgroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupId").build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupName").getter(getter(Workgroup::workgroupName)).setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()).build();

    private static final SdkField<String> WORKGROUP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupVersion").getter(getter(Workgroup::workgroupVersion)).setter(setter(Builder::workgroupVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_CAPACITY_FIELD,
            CONFIG_PARAMETERS_FIELD, CREATION_DATE_FIELD, CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD,
            CUSTOM_DOMAIN_CERTIFICATE_EXPIRY_TIME_FIELD, CUSTOM_DOMAIN_NAME_FIELD, ENDPOINT_FIELD, ENHANCED_VPC_ROUTING_FIELD,
            MAX_CAPACITY_FIELD, NAMESPACE_NAME_FIELD, PATCH_VERSION_FIELD, PORT_FIELD, PUBLICLY_ACCESSIBLE_FIELD,
            SECURITY_GROUP_IDS_FIELD, STATUS_FIELD, SUBNET_IDS_FIELD, WORKGROUP_ARN_FIELD, WORKGROUP_ID_FIELD,
            WORKGROUP_NAME_FIELD, WORKGROUP_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer baseCapacity;

    private final List<ConfigParameter> configParameters;

    private final Instant creationDate;

    private final String customDomainCertificateArn;

    private final Instant customDomainCertificateExpiryTime;

    private final String customDomainName;

    private final Endpoint endpoint;

    private final Boolean enhancedVpcRouting;

    private final Integer maxCapacity;

    private final String namespaceName;

    private final String patchVersion;

    private final Integer port;

    private final Boolean publiclyAccessible;

    private final List<String> securityGroupIds;

    private final String status;

    private final List<String> subnetIds;

    private final String workgroupArn;

    private final String workgroupId;

    private final String workgroupName;

    private final String workgroupVersion;

    private Workgroup(BuilderImpl builder) {
        this.baseCapacity = builder.baseCapacity;
        this.configParameters = builder.configParameters;
        this.creationDate = builder.creationDate;
        this.customDomainCertificateArn = builder.customDomainCertificateArn;
        this.customDomainCertificateExpiryTime = builder.customDomainCertificateExpiryTime;
        this.customDomainName = builder.customDomainName;
        this.endpoint = builder.endpoint;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.maxCapacity = builder.maxCapacity;
        this.namespaceName = builder.namespaceName;
        this.patchVersion = builder.patchVersion;
        this.port = builder.port;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroupIds = builder.securityGroupIds;
        this.status = builder.status;
        this.subnetIds = builder.subnetIds;
        this.workgroupArn = builder.workgroupArn;
        this.workgroupId = builder.workgroupId;
        this.workgroupName = builder.workgroupName;
        this.workgroupVersion = builder.workgroupVersion;
    }

    /**
     * <p>
     * The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
     * </p>
     * 
     * @return The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    public final Integer baseCapacity() {
        return baseCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigParameters() {
        return configParameters != null && !(configParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>,
     * <code>datestyle</code>, <code>enable_case_sensitivity_identifier</code>,
     * <code>enable_user_activity_logging</code>, <code>query_group</code>, , <code>search_path</code>, and query
     * monitoring metrics that let you define performance boundaries. For more information about query monitoring rules
     * and available metrics, see <a href=
     * "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
     * > Query monitoring metrics for Amazon Redshift Serverless</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigParameters} method.
     * </p>
     * 
     * @return An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>,
     *         <code>datestyle</code>, <code>enable_case_sensitivity_identifier</code>,
     *         <code>enable_user_activity_logging</code>, <code>query_group</code>, , <code>search_path</code>, and
     *         query monitoring metrics that let you define performance boundaries. For more information about query
     *         monitoring rules and available metrics, see <a href=
     *         "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
     *         > Query monitoring metrics for Amazon Redshift Serverless</a>.
     */
    public final List<ConfigParameter> configParameters() {
        return configParameters;
    }

    /**
     * <p>
     * The creation date of the workgroup.
     * </p>
     * 
     * @return The creation date of the workgroup.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The custom domain name’s certificate Amazon resource name (ARN).
     * </p>
     * 
     * @return The custom domain name’s certificate Amazon resource name (ARN).
     */
    public final String customDomainCertificateArn() {
        return customDomainCertificateArn;
    }

    /**
     * <p>
     * The expiration time for the certificate.
     * </p>
     * 
     * @return The expiration time for the certificate.
     */
    public final Instant customDomainCertificateExpiryTime() {
        return customDomainCertificateExpiryTime;
    }

    /**
     * <p>
     * The custom domain name associated with the workgroup.
     * </p>
     * 
     * @return The custom domain name associated with the workgroup.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * The endpoint that is created from the workgroup.
     * </p>
     * 
     * @return The endpoint that is created from the workgroup.
     */
    public final Endpoint endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon
     * Redshift Serverless to route traffic through your VPC.
     * </p>
     * 
     * @return The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces
     *         Amazon Redshift Serverless to route traffic through your VPC.
     */
    public final Boolean enhancedVpcRouting() {
        return enhancedVpcRouting;
    }

    /**
     * <p>
     * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is
     * specified in RPUs.
     * </p>
     * 
     * @return The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is
     *         specified in RPUs.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The namespace the workgroup is associated with.
     * </p>
     * 
     * @return The namespace the workgroup is associated with.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The patch version of your Amazon Redshift Serverless workgroup. For more information about patch versions, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html">Cluster versions for Amazon
     * Redshift</a>.
     * </p>
     * 
     * @return The patch version of your Amazon Redshift Serverless workgroup. For more information about patch
     *         versions, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html">Cluster
     *         versions for Amazon Redshift</a>.
     */
    public final String patchVersion() {
        return patchVersion;
    }

    /**
     * <p>
     * The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The default
     * is 5439.
     * </p>
     * 
     * @return The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The
     *         default is 5439.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * A value that specifies whether the workgroup can be accessible from a public network
     * </p>
     * 
     * @return A value that specifies whether the workgroup can be accessible from a public network
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of security group IDs to associate with the workgroup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return An array of security group IDs to associate with the workgroup.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The status of the workgroup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkgroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the workgroup.
     * @see WorkgroupStatus
     */
    public final WorkgroupStatus status() {
        return WorkgroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the workgroup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkgroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the workgroup.
     * @see WorkgroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of subnet IDs the workgroup is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return An array of subnet IDs the workgroup is associated with.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that links to the workgroup.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that links to the workgroup.
     */
    public final String workgroupArn() {
        return workgroupArn;
    }

    /**
     * <p>
     * The unique identifier of the workgroup.
     * </p>
     * 
     * @return The unique identifier of the workgroup.
     */
    public final String workgroupId() {
        return workgroupId;
    }

    /**
     * <p>
     * The name of the workgroup.
     * </p>
     * 
     * @return The name of the workgroup.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    /**
     * <p>
     * The Amazon Redshift Serverless version of your workgroup. For more information about Amazon Redshift Serverless
     * versions, see<a href="https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html">Cluster versions
     * for Amazon Redshift</a>.
     * </p>
     * 
     * @return The Amazon Redshift Serverless version of your workgroup. For more information about Amazon Redshift
     *         Serverless versions, see<a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html">Cluster versions for Amazon
     *         Redshift</a>.
     */
    public final String workgroupVersion() {
        return workgroupVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigParameters() ? configParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainCertificateExpiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(patchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workgroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupId());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workgroup)) {
            return false;
        }
        Workgroup other = (Workgroup) obj;
        return Objects.equals(baseCapacity(), other.baseCapacity()) && hasConfigParameters() == other.hasConfigParameters()
                && Objects.equals(configParameters(), other.configParameters())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(customDomainCertificateArn(), other.customDomainCertificateArn())
                && Objects.equals(customDomainCertificateExpiryTime(), other.customDomainCertificateExpiryTime())
                && Objects.equals(customDomainName(), other.customDomainName()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(enhancedVpcRouting(), other.enhancedVpcRouting())
                && Objects.equals(maxCapacity(), other.maxCapacity()) && Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(patchVersion(), other.patchVersion()) && Objects.equals(port(), other.port())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(workgroupArn(), other.workgroupArn())
                && Objects.equals(workgroupId(), other.workgroupId()) && Objects.equals(workgroupName(), other.workgroupName())
                && Objects.equals(workgroupVersion(), other.workgroupVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Workgroup").add("BaseCapacity", baseCapacity())
                .add("ConfigParameters", hasConfigParameters() ? configParameters() : null).add("CreationDate", creationDate())
                .add("CustomDomainCertificateArn", customDomainCertificateArn())
                .add("CustomDomainCertificateExpiryTime", customDomainCertificateExpiryTime())
                .add("CustomDomainName", customDomainName()).add("Endpoint", endpoint())
                .add("EnhancedVpcRouting", enhancedVpcRouting()).add("MaxCapacity", maxCapacity())
                .add("NamespaceName", namespaceName()).add("PatchVersion", patchVersion()).add("Port", port())
                .add("PubliclyAccessible", publiclyAccessible())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("Status", statusAsString())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("WorkgroupArn", workgroupArn())
                .add("WorkgroupId", workgroupId()).add("WorkgroupName", workgroupName())
                .add("WorkgroupVersion", workgroupVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baseCapacity":
            return Optional.ofNullable(clazz.cast(baseCapacity()));
        case "configParameters":
            return Optional.ofNullable(clazz.cast(configParameters()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "customDomainCertificateArn":
            return Optional.ofNullable(clazz.cast(customDomainCertificateArn()));
        case "customDomainCertificateExpiryTime":
            return Optional.ofNullable(clazz.cast(customDomainCertificateExpiryTime()));
        case "customDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "enhancedVpcRouting":
            return Optional.ofNullable(clazz.cast(enhancedVpcRouting()));
        case "maxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "patchVersion":
            return Optional.ofNullable(clazz.cast(patchVersion()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "workgroupArn":
            return Optional.ofNullable(clazz.cast(workgroupArn()));
        case "workgroupId":
            return Optional.ofNullable(clazz.cast(workgroupId()));
        case "workgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        case "workgroupVersion":
            return Optional.ofNullable(clazz.cast(workgroupVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workgroup, T> g) {
        return obj -> g.apply((Workgroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Workgroup> {
        /**
         * <p>
         * The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
         * </p>
         * 
         * @param baseCapacity
         *        The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseCapacity(Integer baseCapacity);

        /**
         * <p>
         * An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>,
         * <code>datestyle</code>, <code>enable_case_sensitivity_identifier</code>,
         * <code>enable_user_activity_logging</code>, <code>query_group</code>, , <code>search_path</code>, and query
         * monitoring metrics that let you define performance boundaries. For more information about query monitoring
         * rules and available metrics, see <a href=
         * "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
         * > Query monitoring metrics for Amazon Redshift Serverless</a>.
         * </p>
         * 
         * @param configParameters
         *        An array of parameters to set for advanced control over a database. The options are
         *        <code>auto_mv</code>, <code>datestyle</code>, <code>enable_case_sensitivity_identifier</code>,
         *        <code>enable_user_activity_logging</code>, <code>query_group</code>, , <code>search_path</code>, and
         *        query monitoring metrics that let you define performance boundaries. For more information about query
         *        monitoring rules and available metrics, see <a href=
         *        "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
         *        > Query monitoring metrics for Amazon Redshift Serverless</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configParameters(Collection<ConfigParameter> configParameters);

        /**
         * <p>
         * An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>,
         * <code>datestyle</code>, <code>enable_case_sensitivity_identifier</code>,
         * <code>enable_user_activity_logging</code>, <code>query_group</code>, , <code>search_path</code>, and query
         * monitoring metrics that let you define performance boundaries. For more information about query monitoring
         * rules and available metrics, see <a href=
         * "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
         * > Query monitoring metrics for Amazon Redshift Serverless</a>.
         * </p>
         * 
         * @param configParameters
         *        An array of parameters to set for advanced control over a database. The options are
         *        <code>auto_mv</code>, <code>datestyle</code>, <code>enable_case_sensitivity_identifier</code>,
         *        <code>enable_user_activity_logging</code>, <code>query_group</code>, , <code>search_path</code>, and
         *        query monitoring metrics that let you define performance boundaries. For more information about query
         *        monitoring rules and available metrics, see <a href=
         *        "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
         *        > Query monitoring metrics for Amazon Redshift Serverless</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configParameters(ConfigParameter... configParameters);

        /**
         * <p>
         * An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>,
         * <code>datestyle</code>, <code>enable_case_sensitivity_identifier</code>,
         * <code>enable_user_activity_logging</code>, <code>query_group</code>, , <code>search_path</code>, and query
         * monitoring metrics that let you define performance boundaries. For more information about query monitoring
         * rules and available metrics, see <a href=
         * "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
         * > Query monitoring metrics for Amazon Redshift Serverless</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #configParameters(List<ConfigParameter>)}.
         * 
         * @param configParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configParameters(java.util.Collection<ConfigParameter>)
         */
        Builder configParameters(Consumer<ConfigParameter.Builder>... configParameters);

        /**
         * <p>
         * The creation date of the workgroup.
         * </p>
         * 
         * @param creationDate
         *        The creation date of the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The custom domain name’s certificate Amazon resource name (ARN).
         * </p>
         * 
         * @param customDomainCertificateArn
         *        The custom domain name’s certificate Amazon resource name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainCertificateArn(String customDomainCertificateArn);

        /**
         * <p>
         * The expiration time for the certificate.
         * </p>
         * 
         * @param customDomainCertificateExpiryTime
         *        The expiration time for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainCertificateExpiryTime(Instant customDomainCertificateExpiryTime);

        /**
         * <p>
         * The custom domain name associated with the workgroup.
         * </p>
         * 
         * @param customDomainName
         *        The custom domain name associated with the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * The endpoint that is created from the workgroup.
         * </p>
         * 
         * @param endpoint
         *        The endpoint that is created from the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(Endpoint endpoint);

        /**
         * <p>
         * The endpoint that is created from the workgroup.
         * </p>
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #endpoint(Endpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(Endpoint)
         */
        default Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return endpoint(Endpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon
         * Redshift Serverless to route traffic through your VPC.
         * </p>
         * 
         * @param enhancedVpcRouting
         *        The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces
         *        Amazon Redshift Serverless to route traffic through your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedVpcRouting(Boolean enhancedVpcRouting);

        /**
         * <p>
         * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is
         * specified in RPUs.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity
         *        is specified in RPUs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * The namespace the workgroup is associated with.
         * </p>
         * 
         * @param namespaceName
         *        The namespace the workgroup is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The patch version of your Amazon Redshift Serverless workgroup. For more information about patch versions,
         * see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html">Cluster versions for
         * Amazon Redshift</a>.
         * </p>
         * 
         * @param patchVersion
         *        The patch version of your Amazon Redshift Serverless workgroup. For more information about patch
         *        versions, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html">Cluster
         *        versions for Amazon Redshift</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchVersion(String patchVersion);

        /**
         * <p>
         * The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The
         * default is 5439.
         * </p>
         * 
         * @param port
         *        The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215.
         *        The default is 5439.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * A value that specifies whether the workgroup can be accessible from a public network
         * </p>
         * 
         * @param publiclyAccessible
         *        A value that specifies whether the workgroup can be accessible from a public network
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * An array of security group IDs to associate with the workgroup.
         * </p>
         * 
         * @param securityGroupIds
         *        An array of security group IDs to associate with the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * An array of security group IDs to associate with the workgroup.
         * </p>
         * 
         * @param securityGroupIds
         *        An array of security group IDs to associate with the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The status of the workgroup.
         * </p>
         * 
         * @param status
         *        The status of the workgroup.
         * @see WorkgroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkgroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the workgroup.
         * </p>
         * 
         * @param status
         *        The status of the workgroup.
         * @see WorkgroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkgroupStatus
         */
        Builder status(WorkgroupStatus status);

        /**
         * <p>
         * An array of subnet IDs the workgroup is associated with.
         * </p>
         * 
         * @param subnetIds
         *        An array of subnet IDs the workgroup is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * An array of subnet IDs the workgroup is associated with.
         * </p>
         * 
         * @param subnetIds
         *        An array of subnet IDs the workgroup is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that links to the workgroup.
         * </p>
         * 
         * @param workgroupArn
         *        The Amazon Resource Name (ARN) that links to the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupArn(String workgroupArn);

        /**
         * <p>
         * The unique identifier of the workgroup.
         * </p>
         * 
         * @param workgroupId
         *        The unique identifier of the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupId(String workgroupId);

        /**
         * <p>
         * The name of the workgroup.
         * </p>
         * 
         * @param workgroupName
         *        The name of the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);

        /**
         * <p>
         * The Amazon Redshift Serverless version of your workgroup. For more information about Amazon Redshift
         * Serverless versions, see<a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html">Cluster versions for Amazon
         * Redshift</a>.
         * </p>
         * 
         * @param workgroupVersion
         *        The Amazon Redshift Serverless version of your workgroup. For more information about Amazon Redshift
         *        Serverless versions, see<a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html">Cluster versions for
         *        Amazon Redshift</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupVersion(String workgroupVersion);
    }

    static final class BuilderImpl implements Builder {
        private Integer baseCapacity;

        private List<ConfigParameter> configParameters = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDate;

        private String customDomainCertificateArn;

        private Instant customDomainCertificateExpiryTime;

        private String customDomainName;

        private Endpoint endpoint;

        private Boolean enhancedVpcRouting;

        private Integer maxCapacity;

        private String namespaceName;

        private String patchVersion;

        private Integer port;

        private Boolean publiclyAccessible;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String workgroupArn;

        private String workgroupId;

        private String workgroupName;

        private String workgroupVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Workgroup model) {
            baseCapacity(model.baseCapacity);
            configParameters(model.configParameters);
            creationDate(model.creationDate);
            customDomainCertificateArn(model.customDomainCertificateArn);
            customDomainCertificateExpiryTime(model.customDomainCertificateExpiryTime);
            customDomainName(model.customDomainName);
            endpoint(model.endpoint);
            enhancedVpcRouting(model.enhancedVpcRouting);
            maxCapacity(model.maxCapacity);
            namespaceName(model.namespaceName);
            patchVersion(model.patchVersion);
            port(model.port);
            publiclyAccessible(model.publiclyAccessible);
            securityGroupIds(model.securityGroupIds);
            status(model.status);
            subnetIds(model.subnetIds);
            workgroupArn(model.workgroupArn);
            workgroupId(model.workgroupId);
            workgroupName(model.workgroupName);
            workgroupVersion(model.workgroupVersion);
        }

        public final Integer getBaseCapacity() {
            return baseCapacity;
        }

        public final void setBaseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
        }

        @Override
        public final Builder baseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        public final List<ConfigParameter.Builder> getConfigParameters() {
            List<ConfigParameter.Builder> result = ConfigParameterListCopier.copyToBuilder(this.configParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigParameters(Collection<ConfigParameter.BuilderImpl> configParameters) {
            this.configParameters = ConfigParameterListCopier.copyFromBuilder(configParameters);
        }

        @Override
        public final Builder configParameters(Collection<ConfigParameter> configParameters) {
            this.configParameters = ConfigParameterListCopier.copy(configParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configParameters(ConfigParameter... configParameters) {
            configParameters(Arrays.asList(configParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configParameters(Consumer<ConfigParameter.Builder>... configParameters) {
            configParameters(Stream.of(configParameters).map(c -> ConfigParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getCustomDomainCertificateArn() {
            return customDomainCertificateArn;
        }

        public final void setCustomDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
        }

        @Override
        public final Builder customDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
            return this;
        }

        public final Instant getCustomDomainCertificateExpiryTime() {
            return customDomainCertificateExpiryTime;
        }

        public final void setCustomDomainCertificateExpiryTime(Instant customDomainCertificateExpiryTime) {
            this.customDomainCertificateExpiryTime = customDomainCertificateExpiryTime;
        }

        @Override
        public final Builder customDomainCertificateExpiryTime(Instant customDomainCertificateExpiryTime) {
            this.customDomainCertificateExpiryTime = customDomainCertificateExpiryTime;
            return this;
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final Endpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getPatchVersion() {
            return patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkgroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getWorkgroupArn() {
            return workgroupArn;
        }

        public final void setWorkgroupArn(String workgroupArn) {
            this.workgroupArn = workgroupArn;
        }

        @Override
        public final Builder workgroupArn(String workgroupArn) {
            this.workgroupArn = workgroupArn;
            return this;
        }

        public final String getWorkgroupId() {
            return workgroupId;
        }

        public final void setWorkgroupId(String workgroupId) {
            this.workgroupId = workgroupId;
        }

        @Override
        public final Builder workgroupId(String workgroupId) {
            this.workgroupId = workgroupId;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        public final String getWorkgroupVersion() {
            return workgroupVersion;
        }

        public final void setWorkgroupVersion(String workgroupVersion) {
            this.workgroupVersion = workgroupVersion;
        }

        @Override
        public final Builder workgroupVersion(String workgroupVersion) {
            this.workgroupVersion = workgroupVersion;
            return this;
        }

        @Override
        public Workgroup build() {
            return new Workgroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
