/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCredentialsRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<GetCredentialsRequest.Builder, GetCredentialsRequest> {
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDomainName").getter(getter(GetCredentialsRequest::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()).build();

    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("dbName")
            .getter(getter(GetCredentialsRequest::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbName").build()).build();

    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("durationSeconds").getter(getter(GetCredentialsRequest::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupName").getter(getter(GetCredentialsRequest::workgroupName))
            .setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DOMAIN_NAME_FIELD,
            DB_NAME_FIELD, DURATION_SECONDS_FIELD, WORKGROUP_NAME_FIELD));

    private final String customDomainName;

    private final String dbName;

    private final Integer durationSeconds;

    private final String workgroupName;

    private GetCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.customDomainName = builder.customDomainName;
        this.dbName = builder.dbName;
        this.durationSeconds = builder.durationSeconds;
        this.workgroupName = builder.workgroupName;
    }

    /**
     * <p>
     * The custom domain name associated with the workgroup. The custom domain name or the workgroup name must be
     * included in the request.
     * </p>
     * 
     * @return The custom domain name associated with the workgroup. The custom domain name or the workgroup name must
     *         be included in the request.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * The name of the database to get temporary authorization to log on to.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 64 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain only uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or
     * hyphen.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not contain a colon ( : ) or slash ( / ).
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot be a reserved word. A list of reserved words can be found in <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words </a> in the Amazon
     * Redshift Database Developer Guide
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the database to get temporary authorization to log on to.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 64 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain only uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol
     *         (@), or hyphen.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not contain a colon ( : ) or slash ( / ).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot be a reserved word. A list of reserved words can be found in <a
     *         href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words </a> in the
     *         Amazon Redshift Database Developer Guide
     *         </p>
     *         </li>
     */
    public final String dbName() {
        return dbName;
    }

    /**
     * <p>
     * The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the maximum
     * is 3600 seconds.
     * </p>
     * 
     * @return The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the
     *         maximum is 3600 seconds.
     */
    public final Integer durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * The name of the workgroup associated with the database.
     * </p>
     * 
     * @return The name of the workgroup associated with the database.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialsRequest)) {
            return false;
        }
        GetCredentialsRequest other = (GetCredentialsRequest) obj;
        return Objects.equals(customDomainName(), other.customDomainName()) && Objects.equals(dbName(), other.dbName())
                && Objects.equals(durationSeconds(), other.durationSeconds())
                && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCredentialsRequest").add("CustomDomainName", customDomainName()).add("DbName", dbName())
                .add("DurationSeconds", durationSeconds()).add("WorkgroupName", workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "dbName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "durationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "workgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCredentialsRequest, T> g) {
        return obj -> g.apply((GetCredentialsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCredentialsRequest> {
        /**
         * <p>
         * The custom domain name associated with the workgroup. The custom domain name or the workgroup name must be
         * included in the request.
         * </p>
         * 
         * @param customDomainName
         *        The custom domain name associated with the workgroup. The custom domain name or the workgroup name
         *        must be included in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * The name of the database to get temporary authorization to log on to.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 64 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain only uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol
         * (@), or hyphen.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not contain a colon ( : ) or slash ( / ).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be a reserved word. A list of reserved words can be found in <a
         * href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words </a> in the Amazon
         * Redshift Database Developer Guide
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbName
         *        The name of the database to get temporary authorization to log on to.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 64 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain only uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at
         *        symbol (@), or hyphen.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not contain a colon ( : ) or slash ( / ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot be a reserved word. A list of reserved words can be found in <a
         *        href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words </a> in the
         *        Amazon Redshift Database Developer Guide
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the
         * maximum is 3600 seconds.
         * </p>
         * 
         * @param durationSeconds
         *        The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and
         *        the maximum is 3600 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        /**
         * <p>
         * The name of the workgroup associated with the database.
         * </p>
         * 
         * @param workgroupName
         *        The name of the workgroup associated with the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private String customDomainName;

        private String dbName;

        private Integer durationSeconds;

        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialsRequest model) {
            super(model);
            customDomainName(model.customDomainName);
            dbName(model.dbName);
            durationSeconds(model.durationSeconds);
            workgroupName(model.workgroupName);
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getDbName() {
            return dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCredentialsRequest build() {
            return new GetCredentialsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
