/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the custom domain name association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Association implements SdkPojo, Serializable, ToCopyableBuilder<Association.Builder, Association> {
    private static final SdkField<String> CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("customDomainCertificateArn")
            .getter(getter(Association::customDomainCertificateArn))
            .setter(setter(Builder::customDomainCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainCertificateArn").build())
            .build();

    private static final SdkField<Instant> CUSTOM_DOMAIN_CERTIFICATE_EXPIRY_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("customDomainCertificateExpiryTime")
            .getter(getter(Association::customDomainCertificateExpiryTime))
            .setter(setter(Builder::customDomainCertificateExpiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainCertificateExpiryTime")
                    .build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDomainName").getter(getter(Association::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupName").getter(getter(Association::workgroupName)).setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD, CUSTOM_DOMAIN_CERTIFICATE_EXPIRY_TIME_FIELD, CUSTOM_DOMAIN_NAME_FIELD,
            WORKGROUP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customDomainCertificateArn;

    private final Instant customDomainCertificateExpiryTime;

    private final String customDomainName;

    private final String workgroupName;

    private Association(BuilderImpl builder) {
        this.customDomainCertificateArn = builder.customDomainCertificateArn;
        this.customDomainCertificateExpiryTime = builder.customDomainCertificateExpiryTime;
        this.customDomainName = builder.customDomainName;
        this.workgroupName = builder.workgroupName;
    }

    /**
     * <p>
     * The custom domain name’s certificate Amazon resource name (ARN).
     * </p>
     * 
     * @return The custom domain name’s certificate Amazon resource name (ARN).
     */
    public final String customDomainCertificateArn() {
        return customDomainCertificateArn;
    }

    /**
     * <p>
     * The expiration time for the certificate.
     * </p>
     * 
     * @return The expiration time for the certificate.
     */
    public final Instant customDomainCertificateExpiryTime() {
        return customDomainCertificateExpiryTime;
    }

    /**
     * <p>
     * The custom domain name associated with the workgroup.
     * </p>
     * 
     * @return The custom domain name associated with the workgroup.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * The name of the workgroup associated with the database.
     * </p>
     * 
     * @return The name of the workgroup associated with the database.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customDomainCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainCertificateExpiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Association)) {
            return false;
        }
        Association other = (Association) obj;
        return Objects.equals(customDomainCertificateArn(), other.customDomainCertificateArn())
                && Objects.equals(customDomainCertificateExpiryTime(), other.customDomainCertificateExpiryTime())
                && Objects.equals(customDomainName(), other.customDomainName())
                && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Association").add("CustomDomainCertificateArn", customDomainCertificateArn())
                .add("CustomDomainCertificateExpiryTime", customDomainCertificateExpiryTime())
                .add("CustomDomainName", customDomainName()).add("WorkgroupName", workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customDomainCertificateArn":
            return Optional.ofNullable(clazz.cast(customDomainCertificateArn()));
        case "customDomainCertificateExpiryTime":
            return Optional.ofNullable(clazz.cast(customDomainCertificateExpiryTime()));
        case "customDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "workgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Association, T> g) {
        return obj -> g.apply((Association) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Association> {
        /**
         * <p>
         * The custom domain name’s certificate Amazon resource name (ARN).
         * </p>
         * 
         * @param customDomainCertificateArn
         *        The custom domain name’s certificate Amazon resource name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainCertificateArn(String customDomainCertificateArn);

        /**
         * <p>
         * The expiration time for the certificate.
         * </p>
         * 
         * @param customDomainCertificateExpiryTime
         *        The expiration time for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainCertificateExpiryTime(Instant customDomainCertificateExpiryTime);

        /**
         * <p>
         * The custom domain name associated with the workgroup.
         * </p>
         * 
         * @param customDomainName
         *        The custom domain name associated with the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * The name of the workgroup associated with the database.
         * </p>
         * 
         * @param workgroupName
         *        The name of the workgroup associated with the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);
    }

    static final class BuilderImpl implements Builder {
        private String customDomainCertificateArn;

        private Instant customDomainCertificateExpiryTime;

        private String customDomainName;

        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(Association model) {
            customDomainCertificateArn(model.customDomainCertificateArn);
            customDomainCertificateExpiryTime(model.customDomainCertificateExpiryTime);
            customDomainName(model.customDomainName);
            workgroupName(model.workgroupName);
        }

        public final String getCustomDomainCertificateArn() {
            return customDomainCertificateArn;
        }

        public final void setCustomDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
        }

        @Override
        public final Builder customDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
            return this;
        }

        public final Instant getCustomDomainCertificateExpiryTime() {
            return customDomainCertificateExpiryTime;
        }

        public final void setCustomDomainCertificateExpiryTime(Instant customDomainCertificateExpiryTime) {
            this.customDomainCertificateExpiryTime = customDomainCertificateExpiryTime;
        }

        @Override
        public final Builder customDomainCertificateExpiryTime(Instant customDomainCertificateExpiryTime) {
            this.customDomainCertificateExpiryTime = customDomainCertificateExpiryTime;
            return this;
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Association build() {
            return new Association(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
