/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.redshiftserverless.model.AccessDeniedException;
import software.amazon.awssdk.services.redshiftserverless.model.ConflictException;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.InsufficientCapacityException;
import software.amazon.awssdk.services.redshiftserverless.model.InternalServerException;
import software.amazon.awssdk.services.redshiftserverless.model.InvalidPaginationException;
import software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessException;
import software.amazon.awssdk.services.redshiftserverless.model.ResourceNotFoundException;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ThrottlingException;
import software.amazon.awssdk.services.redshiftserverless.model.TooManyTagsException;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ValidationException;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsIterable;

/**
 * Service client for accessing Redshift Serverless. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This is an interface reference for Amazon Redshift Serverless. It contains documentation for one of the programming
 * or command line interfaces you can use to manage Amazon Redshift Serverless.
 * </p>
 * <p>
 * Amazon Redshift Serverless automatically provisions data warehouse capacity and intelligently scales the underlying
 * resources based on workload demands. Amazon Redshift Serverless adjusts capacity in seconds to deliver consistently
 * high performance and simplified operations for even the most demanding and volatile workloads. Amazon Redshift
 * Serverless lets you focus on using your data to acquire new insights for your business and customers.
 * </p>
 * <p>
 * To learn more about Amazon Redshift Serverless, see <a
 * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-whatis.html">What is Amazon Redshift
 * Serverless</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RedshiftServerlessClient extends AwsClient {
    String SERVICE_NAME = "redshift-serverless";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "redshift-serverless";

    /**
     * <p>
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html">Working with snapshots
     * and recovery points</a>.
     * </p>
     *
     * @param convertRecoveryPointToSnapshotRequest
     * @return Result of the ConvertRecoveryPointToSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ConvertRecoveryPointToSnapshot
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ConvertRecoveryPointToSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default ConvertRecoveryPointToSnapshotResponse convertRecoveryPointToSnapshot(
            ConvertRecoveryPointToSnapshotRequest convertRecoveryPointToSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, TooManyTagsException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html">Working with snapshots
     * and recovery points</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConvertRecoveryPointToSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link ConvertRecoveryPointToSnapshotRequest#builder()}
     * </p>
     *
     * @param convertRecoveryPointToSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest.Builder}
     *        to create a request.
     * @return Result of the ConvertRecoveryPointToSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ConvertRecoveryPointToSnapshot
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ConvertRecoveryPointToSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default ConvertRecoveryPointToSnapshotResponse convertRecoveryPointToSnapshot(
            Consumer<ConvertRecoveryPointToSnapshotRequest.Builder> convertRecoveryPointToSnapshotRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            TooManyTagsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return convertRecoveryPointToSnapshot(ConvertRecoveryPointToSnapshotRequest.builder()
                .applyMutation(convertRecoveryPointToSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a custom domain association for Amazon Redshift Serverless.
     * </p>
     *
     * @param createCustomDomainAssociationRequest
     * @return Result of the CreateCustomDomainAssociation operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomDomainAssociationResponse createCustomDomainAssociation(
            CreateCustomDomainAssociationRequest createCustomDomainAssociationRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom domain association for Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomDomainAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomDomainAssociationRequest#builder()}
     * </p>
     *
     * @param createCustomDomainAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateCustomDomainAssociation operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomDomainAssociationResponse createCustomDomainAssociation(
            Consumer<CreateCustomDomainAssociationRequest.Builder> createCustomDomainAssociationRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return createCustomDomainAssociation(CreateCustomDomainAssociationRequest.builder()
                .applyMutation(createCustomDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     *
     * @param createEndpointAccessRequest
     * @return Result of the CreateEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEndpointAccessResponse createEndpointAccess(CreateEndpointAccessRequest createEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEndpointAccessRequest#builder()}
     * </p>
     *
     * @param createEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest.Builder} to
     *        create a request.
     * @return Result of the CreateEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEndpointAccessResponse createEndpointAccess(
            Consumer<CreateEndpointAccessRequest.Builder> createEndpointAccessRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return createEndpointAccess(CreateEndpointAccessRequest.builder().applyMutation(createEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Creates a namespace in Amazon Redshift Serverless.
     * </p>
     *
     * @param createNamespaceRequest
     * @return Result of the CreateNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNamespaceResponse createNamespace(CreateNamespaceRequest createNamespaceRequest)
            throws InternalServerException, ConflictException, ValidationException, TooManyTagsException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a namespace in Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNamespaceRequest#builder()}
     * </p>
     *
     * @param createNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest.Builder} to create
     *        a request.
     * @return Result of the CreateNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNamespaceResponse createNamespace(Consumer<CreateNamespaceRequest.Builder> createNamespaceRequest)
            throws InternalServerException, ConflictException, ValidationException, TooManyTagsException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        return createNamespace(CreateNamespaceRequest.builder().applyMutation(createNamespaceRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html"> Working with
     * snapshots and recovery points</a>.
     * </p>
     *
     * @param createSnapshotRequest
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, TooManyTagsException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html"> Working with
     * snapshots and recovery points</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSnapshotResponse createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            TooManyTagsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the
     * returned usage limit identifier.
     * </p>
     *
     * @param createUsageLimitRequest
     * @return Result of the CreateUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUsageLimitResponse createUsageLimit(CreateUsageLimitRequest createUsageLimitRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the
     * returned usage limit identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUsageLimitRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUsageLimitRequest#builder()}
     * </p>
     *
     * @param createUsageLimitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest.Builder} to create
     *        a request.
     * @return Result of the CreateUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUsageLimitResponse createUsageLimit(Consumer<CreateUsageLimitRequest.Builder> createUsageLimitRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return createUsageLimit(CreateUsageLimitRequest.builder().applyMutation(createUsageLimitRequest).build());
    }

    /**
     * <p>
     * Creates an workgroup in Amazon Redshift Serverless.
     * </p>
     *
     * @param createWorkgroupRequest
     * @return Result of the CreateWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InsufficientCapacityException
     *         There is an insufficient capacity to perform the action.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkgroupResponse createWorkgroup(CreateWorkgroupRequest createWorkgroupRequest)
            throws InternalServerException, InsufficientCapacityException, ResourceNotFoundException, ConflictException,
            ValidationException, TooManyTagsException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an workgroup in Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkgroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkgroupRequest#builder()}
     * </p>
     *
     * @param createWorkgroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest.Builder} to create
     *        a request.
     * @return Result of the CreateWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InsufficientCapacityException
     *         There is an insufficient capacity to perform the action.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkgroupResponse createWorkgroup(Consumer<CreateWorkgroupRequest.Builder> createWorkgroupRequest)
            throws InternalServerException, InsufficientCapacityException, ResourceNotFoundException, ConflictException,
            ValidationException, TooManyTagsException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return createWorkgroup(CreateWorkgroupRequest.builder().applyMutation(createWorkgroupRequest).build());
    }

    /**
     * <p>
     * Deletes a custom domain association for Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteCustomDomainAssociationRequest
     * @return Result of the DeleteCustomDomainAssociation operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomDomainAssociationResponse deleteCustomDomainAssociation(
            DeleteCustomDomainAssociationRequest deleteCustomDomainAssociationRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom domain association for Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomDomainAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomDomainAssociationRequest#builder()}
     * </p>
     *
     * @param deleteCustomDomainAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteCustomDomainAssociation operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomDomainAssociationResponse deleteCustomDomainAssociation(
            Consumer<DeleteCustomDomainAssociationRequest.Builder> deleteCustomDomainAssociationRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return deleteCustomDomainAssociation(DeleteCustomDomainAssociationRequest.builder()
                .applyMutation(deleteCustomDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     *
     * @param deleteEndpointAccessRequest
     * @return Result of the DeleteEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEndpointAccessResponse deleteEndpointAccess(DeleteEndpointAccessRequest deleteEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEndpointAccessRequest#builder()}
     * </p>
     *
     * @param deleteEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEndpointAccessResponse deleteEndpointAccess(
            Consumer<DeleteEndpointAccessRequest.Builder> deleteEndpointAccessRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return deleteEndpointAccess(DeleteEndpointAccessRequest.builder().applyMutation(deleteEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final
     * snapshot that has all of the data within the namespace.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final
     * snapshot that has all of the data within the namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNamespaceRequest#builder()}
     * </p>
     *
     * @param deleteNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNamespaceResponse deleteNamespace(Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return deleteNamespace(DeleteNamespaceRequest.builder().applyMutation(deleteNamespaceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a snapshot from Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return Result of the DeleteSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a snapshot from Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSnapshotResponse deleteSnapshot(Consumer<DeleteSnapshotRequest.Builder> deleteSnapshotRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return deleteSnapshot(DeleteSnapshotRequest.builder().applyMutation(deleteSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes a usage limit from Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteUsageLimitRequest
     * @return Result of the DeleteUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUsageLimitResponse deleteUsageLimit(DeleteUsageLimitRequest deleteUsageLimitRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a usage limit from Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUsageLimitRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUsageLimitRequest#builder()}
     * </p>
     *
     * @param deleteUsageLimitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUsageLimitResponse deleteUsageLimit(Consumer<DeleteUsageLimitRequest.Builder> deleteUsageLimitRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return deleteUsageLimit(DeleteUsageLimitRequest.builder().applyMutation(deleteUsageLimitRequest).build());
    }

    /**
     * <p>
     * Deletes a workgroup.
     * </p>
     *
     * @param deleteWorkgroupRequest
     * @return Result of the DeleteWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkgroupResponse deleteWorkgroup(DeleteWorkgroupRequest deleteWorkgroupRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkgroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkgroupRequest#builder()}
     * </p>
     *
     * @param deleteWorkgroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkgroupResponse deleteWorkgroup(Consumer<DeleteWorkgroupRequest.Builder> deleteWorkgroupRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return deleteWorkgroup(DeleteWorkgroupRequest.builder().applyMutation(deleteWorkgroupRequest).build());
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift
     * Serverless.
     * </p>
     * <p>
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900
     * seconds (15 minutes) and 3600 seconds (60 minutes).
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.&lt;/p&gt; &lt;p&gt;If the &lt;code&gt;DbName&lt;/code&gt; parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.&lt;/p&gt; </code>
     * </pre>
     *
     * @param getCredentialsRequest
     * @return Result of the GetCredentials operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCredentialsResponse getCredentials(GetCredentialsRequest getCredentialsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift
     * Serverless.
     * </p>
     * <p>
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900
     * seconds (15 minutes) and 3600 seconds (60 minutes).
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.&lt;/p&gt; &lt;p&gt;If the &lt;code&gt;DbName&lt;/code&gt; parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.&lt;/p&gt; </code>
     * </pre>
     * 
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCredentialsRequest.Builder} avoiding the need to
     * create one manually via {@link GetCredentialsRequest#builder()}
     * </p>
     *
     * @param getCredentialsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest.Builder} to create a
     *        request.
     * @return Result of the GetCredentials operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCredentialsResponse getCredentials(Consumer<GetCredentialsRequest.Builder> getCredentialsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        return getCredentials(GetCredentialsRequest.builder().applyMutation(getCredentialsRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific custom domain association.
     * </p>
     *
     * @param getCustomDomainAssociationRequest
     * @return Result of the GetCustomDomainAssociation operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomDomainAssociationResponse getCustomDomainAssociation(
            GetCustomDomainAssociationRequest getCustomDomainAssociationRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific custom domain association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomDomainAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetCustomDomainAssociationRequest#builder()}
     * </p>
     *
     * @param getCustomDomainAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the GetCustomDomainAssociation operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomDomainAssociationResponse getCustomDomainAssociation(
            Consumer<GetCustomDomainAssociationRequest.Builder> getCustomDomainAssociationRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return getCustomDomainAssociation(GetCustomDomainAssociationRequest.builder()
                .applyMutation(getCustomDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Returns information, such as the name, about a VPC endpoint.
     * </p>
     *
     * @param getEndpointAccessRequest
     * @return Result of the GetEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEndpointAccessResponse getEndpointAccess(GetEndpointAccessRequest getEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information, such as the name, about a VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEndpointAccessRequest.Builder} avoiding the need
     * to create one manually via {@link GetEndpointAccessRequest#builder()}
     * </p>
     *
     * @param getEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest.Builder} to
     *        create a request.
     * @return Result of the GetEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEndpointAccessResponse getEndpointAccess(Consumer<GetEndpointAccessRequest.Builder> getEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return getEndpointAccess(GetEndpointAccessRequest.builder().applyMutation(getEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Returns information about a namespace in Amazon Redshift Serverless.
     * </p>
     *
     * @param getNamespaceRequest
     * @return Result of the GetNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNamespaceResponse getNamespace(GetNamespaceRequest getNamespaceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a namespace in Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNamespaceRequest.Builder} avoiding the need to
     * create one manually via {@link GetNamespaceRequest#builder()}
     * </p>
     *
     * @param getNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest.Builder} to create a
     *        request.
     * @return Result of the GetNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNamespaceResponse getNamespace(Consumer<GetNamespaceRequest.Builder> getNamespaceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        return getNamespace(GetNamespaceRequest.builder().applyMutation(getNamespaceRequest).build());
    }

    /**
     * <p>
     * Returns information about a recovery point.
     * </p>
     *
     * @param getRecoveryPointRequest
     * @return Result of the GetRecoveryPoint operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecoveryPointResponse getRecoveryPoint(GetRecoveryPointRequest getRecoveryPointRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a recovery point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecoveryPointRequest.Builder} avoiding the need
     * to create one manually via {@link GetRecoveryPointRequest#builder()}
     * </p>
     *
     * @param getRecoveryPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointRequest.Builder} to create
     *        a request.
     * @return Result of the GetRecoveryPoint operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecoveryPointResponse getRecoveryPoint(Consumer<GetRecoveryPointRequest.Builder> getRecoveryPointRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return getRecoveryPoint(GetRecoveryPointRequest.builder().applyMutation(getRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Returns a resource policy.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific snapshot.
     * </p>
     *
     * @param getSnapshotRequest
     * @return Result of the GetSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSnapshotResponse getSnapshot(GetSnapshotRequest getSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link GetSnapshotRequest#builder()}
     * </p>
     *
     * @param getSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the GetSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSnapshotResponse getSnapshot(Consumer<GetSnapshotRequest.Builder> getSnapshotRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        return getSnapshot(GetSnapshotRequest.builder().applyMutation(getSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns information about a <code>TableRestoreStatus</code> object.
     * </p>
     *
     * @param getTableRestoreStatusRequest
     * @return Result of the GetTableRestoreStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableRestoreStatusResponse getTableRestoreStatus(GetTableRestoreStatusRequest getTableRestoreStatusRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a <code>TableRestoreStatus</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableRestoreStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param getTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusRequest.Builder} to
     *        create a request.
     * @return Result of the GetTableRestoreStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableRestoreStatusResponse getTableRestoreStatus(
            Consumer<GetTableRestoreStatusRequest.Builder> getTableRestoreStatusRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return getTableRestoreStatus(GetTableRestoreStatusRequest.builder().applyMutation(getTableRestoreStatusRequest).build());
    }

    /**
     * <p>
     * Returns information about a usage limit.
     * </p>
     *
     * @param getUsageLimitRequest
     * @return Result of the GetUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUsageLimitResponse getUsageLimit(GetUsageLimitRequest getUsageLimitRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a usage limit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageLimitRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsageLimitRequest#builder()}
     * </p>
     *
     * @param getUsageLimitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitRequest.Builder} to create a
     *        request.
     * @return Result of the GetUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUsageLimitResponse getUsageLimit(Consumer<GetUsageLimitRequest.Builder> getUsageLimitRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return getUsageLimit(GetUsageLimitRequest.builder().applyMutation(getUsageLimitRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific workgroup.
     * </p>
     *
     * @param getWorkgroupRequest
     * @return Result of the GetWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkgroupResponse getWorkgroup(GetWorkgroupRequest getWorkgroupRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkgroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkgroupRequest#builder()}
     * </p>
     *
     * @param getWorkgroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest.Builder} to create a
     *        request.
     * @return Result of the GetWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkgroupResponse getWorkgroup(Consumer<GetWorkgroupRequest.Builder> getWorkgroupRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        return getWorkgroup(GetWorkgroupRequest.builder().applyMutation(getWorkgroupRequest).build());
    }

    /**
     * <p>
     * Lists custom domain associations for Amazon Redshift Serverless.
     * </p>
     *
     * @param listCustomDomainAssociationsRequest
     * @return Result of the ListCustomDomainAssociations operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListCustomDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomDomainAssociationsResponse listCustomDomainAssociations(
            ListCustomDomainAssociationsRequest listCustomDomainAssociationsRequest) throws InternalServerException,
            InvalidPaginationException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists custom domain associations for Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomDomainAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomDomainAssociationsRequest#builder()}
     * </p>
     *
     * @param listCustomDomainAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListCustomDomainAssociations operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListCustomDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomDomainAssociationsResponse listCustomDomainAssociations(
            Consumer<ListCustomDomainAssociationsRequest.Builder> listCustomDomainAssociationsRequest)
            throws InternalServerException, InvalidPaginationException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return listCustomDomainAssociations(ListCustomDomainAssociationsRequest.builder()
                .applyMutation(listCustomDomainAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists custom domain associations for Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomDomainAssociations(software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsIterable responses = client.listCustomDomainAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsIterable responses = client
     *             .listCustomDomainAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsIterable responses = client.listCustomDomainAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomDomainAssociations(software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomDomainAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListCustomDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomDomainAssociationsIterable listCustomDomainAssociationsPaginator(
            ListCustomDomainAssociationsRequest listCustomDomainAssociationsRequest) throws InternalServerException,
            InvalidPaginationException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        return new ListCustomDomainAssociationsIterable(this, listCustomDomainAssociationsRequest);
    }

    /**
     * <p>
     * Lists custom domain associations for Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomDomainAssociations(software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsIterable responses = client.listCustomDomainAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsIterable responses = client
     *             .listCustomDomainAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsIterable responses = client.listCustomDomainAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomDomainAssociations(software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomDomainAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomDomainAssociationsRequest#builder()}
     * </p>
     *
     * @param listCustomDomainAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListCustomDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomDomainAssociationsIterable listCustomDomainAssociationsPaginator(
            Consumer<ListCustomDomainAssociationsRequest.Builder> listCustomDomainAssociationsRequest)
            throws InternalServerException, InvalidPaginationException, ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return listCustomDomainAssociationsPaginator(ListCustomDomainAssociationsRequest.builder()
                .applyMutation(listCustomDomainAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     *
     * @param listEndpointAccessRequest
     * @return Result of the ListEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointAccessResponse listEndpointAccess(ListEndpointAccessRequest listEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointAccessRequest#builder()}
     * </p>
     *
     * @param listEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest.Builder} to
     *        create a request.
     * @return Result of the ListEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointAccessResponse listEndpointAccess(Consumer<ListEndpointAccessRequest.Builder> listEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return listEndpointAccess(ListEndpointAccessRequest.builder().applyMutation(listEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessIterable responses = client.listEndpointAccessPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessIterable responses = client
     *             .listEndpointAccessPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessIterable responses = client.listEndpointAccessPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEndpointAccessRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointAccessIterable listEndpointAccessPaginator(ListEndpointAccessRequest listEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return new ListEndpointAccessIterable(this, listEndpointAccessRequest);
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessIterable responses = client.listEndpointAccessPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessIterable responses = client
     *             .listEndpointAccessPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessIterable responses = client.listEndpointAccessPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointAccessRequest#builder()}
     * </p>
     *
     * @param listEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointAccessIterable listEndpointAccessPaginator(
            Consumer<ListEndpointAccessRequest.Builder> listEndpointAccessRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return listEndpointAccessPaginator(ListEndpointAccessRequest.builder().applyMutation(listEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     *
     * @param listNamespacesRequest
     * @return Result of the ListNamespaces operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesResponse listNamespaces(ListNamespacesRequest listNamespacesRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest.Builder} to create a
     *        request.
     * @return Result of the ListNamespaces operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesResponse listNamespaces(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return listNamespaces(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesIterable responses = client
     *             .listNamespacesPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNamespacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesIterable listNamespacesPaginator(ListNamespacesRequest listNamespacesRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return new ListNamespacesIterable(this, listNamespacesRequest);
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesIterable responses = client
     *             .listNamespacesPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesIterable listNamespacesPaginator(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return listNamespacesPaginator(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     *
     * @param listRecoveryPointsRequest
     * @return Result of the ListRecoveryPoints operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsResponse listRecoveryPoints(ListRecoveryPointsRequest listRecoveryPointsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecoveryPointsRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest.Builder} to
     *        create a request.
     * @return Result of the ListRecoveryPoints operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsResponse listRecoveryPoints(Consumer<ListRecoveryPointsRequest.Builder> listRecoveryPointsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return listRecoveryPoints(ListRecoveryPointsRequest.builder().applyMutation(listRecoveryPointsRequest).build());
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsIterable responses = client.listRecoveryPointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsIterable responses = client
     *             .listRecoveryPointsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsIterable responses = client.listRecoveryPointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryPointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsIterable listRecoveryPointsPaginator(ListRecoveryPointsRequest listRecoveryPointsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return new ListRecoveryPointsIterable(this, listRecoveryPointsRequest);
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsIterable responses = client.listRecoveryPointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsIterable responses = client
     *             .listRecoveryPointsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsIterable responses = client.listRecoveryPointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecoveryPointsRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsIterable listRecoveryPointsPaginator(
            Consumer<ListRecoveryPointsRequest.Builder> listRecoveryPointsRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return listRecoveryPointsPaginator(ListRecoveryPointsRequest.builder().applyMutation(listRecoveryPointsRequest).build());
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     *
     * @param listSnapshotsRequest
     * @return Result of the ListSnapshots operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnapshotsResponse listSnapshots(ListSnapshotsRequest listSnapshotsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSnapshotsRequest#builder()}
     * </p>
     *
     * @param listSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSnapshots operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnapshotsResponse listSnapshots(Consumer<ListSnapshotsRequest.Builder> listSnapshotsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        return listSnapshots(ListSnapshotsRequest.builder().applyMutation(listSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsIterable responses = client.listSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsIterable responses = client
     *             .listSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsIterable responses = client.listSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnapshotsIterable listSnapshotsPaginator(ListSnapshotsRequest listSnapshotsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        return new ListSnapshotsIterable(this, listSnapshotsRequest);
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsIterable responses = client.listSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsIterable responses = client
     *             .listSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsIterable responses = client.listSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSnapshotsRequest#builder()}
     * </p>
     *
     * @param listSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnapshotsIterable listSnapshotsPaginator(Consumer<ListSnapshotsRequest.Builder> listSnapshotsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        return listSnapshotsPaginator(ListSnapshotsRequest.builder().applyMutation(listSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     *
     * @param listTableRestoreStatusRequest
     * @return Result of the ListTableRestoreStatus operation returned by the service.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableRestoreStatusResponse listTableRestoreStatus(ListTableRestoreStatusRequest listTableRestoreStatusRequest)
            throws InvalidPaginationException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableRestoreStatusRequest.Builder} avoiding the
     * need to create one manually via {@link ListTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param listTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest.Builder} to
     *        create a request.
     * @return Result of the ListTableRestoreStatus operation returned by the service.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableRestoreStatusResponse listTableRestoreStatus(
            Consumer<ListTableRestoreStatusRequest.Builder> listTableRestoreStatusRequest) throws InvalidPaginationException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return listTableRestoreStatus(ListTableRestoreStatusRequest.builder().applyMutation(listTableRestoreStatusRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusIterable responses = client.listTableRestoreStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusIterable responses = client
     *             .listTableRestoreStatusPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusIterable responses = client.listTableRestoreStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTableRestoreStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableRestoreStatusIterable listTableRestoreStatusPaginator(
            ListTableRestoreStatusRequest listTableRestoreStatusRequest) throws InvalidPaginationException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return new ListTableRestoreStatusIterable(this, listTableRestoreStatusRequest);
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusIterable responses = client.listTableRestoreStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusIterable responses = client
     *             .listTableRestoreStatusPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusIterable responses = client.listTableRestoreStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableRestoreStatusRequest.Builder} avoiding the
     * need to create one manually via {@link ListTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param listTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableRestoreStatusIterable listTableRestoreStatusPaginator(
            Consumer<ListTableRestoreStatusRequest.Builder> listTableRestoreStatusRequest) throws InvalidPaginationException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return listTableRestoreStatusPaginator(ListTableRestoreStatusRequest.builder()
                .applyMutation(listTableRestoreStatusRequest).build());
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     *
     * @param listUsageLimitsRequest
     * @return Result of the ListUsageLimits operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsageLimitsResponse listUsageLimits(ListUsageLimitsRequest listUsageLimitsRequest)
            throws InternalServerException, InvalidPaginationException, ResourceNotFoundException, ConflictException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageLimitsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageLimitsRequest#builder()}
     * </p>
     *
     * @param listUsageLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest.Builder} to create
     *        a request.
     * @return Result of the ListUsageLimits operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsageLimitsResponse listUsageLimits(Consumer<ListUsageLimitsRequest.Builder> listUsageLimitsRequest)
            throws InternalServerException, InvalidPaginationException, ResourceNotFoundException, ConflictException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return listUsageLimits(ListUsageLimitsRequest.builder().applyMutation(listUsageLimitsRequest).build());
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsIterable responses = client.listUsageLimitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsIterable responses = client
     *             .listUsageLimitsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsIterable responses = client.listUsageLimitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUsageLimitsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsageLimitsIterable listUsageLimitsPaginator(ListUsageLimitsRequest listUsageLimitsRequest)
            throws InternalServerException, InvalidPaginationException, ResourceNotFoundException, ConflictException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return new ListUsageLimitsIterable(this, listUsageLimitsRequest);
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsIterable responses = client.listUsageLimitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsIterable responses = client
     *             .listUsageLimitsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsIterable responses = client.listUsageLimitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageLimitsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageLimitsRequest#builder()}
     * </p>
     *
     * @param listUsageLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsageLimitsIterable listUsageLimitsPaginator(Consumer<ListUsageLimitsRequest.Builder> listUsageLimitsRequest)
            throws InternalServerException, InvalidPaginationException, ResourceNotFoundException, ConflictException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return listUsageLimitsPaginator(ListUsageLimitsRequest.builder().applyMutation(listUsageLimitsRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     *
     * @param listWorkgroupsRequest
     * @return Result of the ListWorkgroups operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkgroupsResponse listWorkgroups(ListWorkgroupsRequest listWorkgroupsRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkgroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkgroupsRequest#builder()}
     * </p>
     *
     * @param listWorkgroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorkgroups operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkgroupsResponse listWorkgroups(Consumer<ListWorkgroupsRequest.Builder> listWorkgroupsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return listWorkgroups(ListWorkgroupsRequest.builder().applyMutation(listWorkgroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsIterable responses = client.listWorkgroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsIterable responses = client
     *             .listWorkgroupsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsIterable responses = client.listWorkgroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkgroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkgroupsIterable listWorkgroupsPaginator(ListWorkgroupsRequest listWorkgroupsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return new ListWorkgroupsIterable(this, listWorkgroupsRequest);
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsIterable responses = client.listWorkgroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsIterable responses = client
     *             .listWorkgroupsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsIterable responses = client.listWorkgroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkgroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkgroupsRequest#builder()}
     * </p>
     *
     * @param listWorkgroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkgroupsIterable listWorkgroupsPaginator(Consumer<ListWorkgroupsRequest.Builder> listWorkgroupsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return listWorkgroupsPaginator(ListWorkgroupsRequest.builder().applyMutation(listWorkgroupsRequest).build());
    }

    /**
     * <p>
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web
     * Services accounts.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web
     * Services accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Restore the data from a recovery point.
     * </p>
     *
     * @param restoreFromRecoveryPointRequest
     * @return Result of the RestoreFromRecoveryPoint operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.RestoreFromRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreFromRecoveryPointResponse restoreFromRecoveryPoint(
            RestoreFromRecoveryPointRequest restoreFromRecoveryPointRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restore the data from a recovery point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreFromRecoveryPointRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreFromRecoveryPointRequest#builder()}
     * </p>
     *
     * @param restoreFromRecoveryPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest.Builder}
     *        to create a request.
     * @return Result of the RestoreFromRecoveryPoint operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.RestoreFromRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreFromRecoveryPointResponse restoreFromRecoveryPoint(
            Consumer<RestoreFromRecoveryPointRequest.Builder> restoreFromRecoveryPointRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return restoreFromRecoveryPoint(RestoreFromRecoveryPointRequest.builder().applyMutation(restoreFromRecoveryPointRequest)
                .build());
    }

    /**
     * <p>
     * Restores a namespace from a snapshot.
     * </p>
     *
     * @param restoreFromSnapshotRequest
     * @return Result of the RestoreFromSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.RestoreFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreFromSnapshotResponse restoreFromSnapshot(RestoreFromSnapshotRequest restoreFromSnapshotRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a namespace from a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreFromSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link RestoreFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreFromSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest.Builder} to
     *        create a request.
     * @return Result of the RestoreFromSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.RestoreFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreFromSnapshotResponse restoreFromSnapshot(
            Consumer<RestoreFromSnapshotRequest.Builder> restoreFromSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return restoreFromSnapshot(RestoreFromSnapshotRequest.builder().applyMutation(restoreFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to
     * restore tables with <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved">interleaved
     * sort keys</a>.
     * </p>
     *
     * @param restoreTableFromSnapshotRequest
     * @return Result of the RestoreTableFromSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.RestoreTableFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreTableFromSnapshotResponse restoreTableFromSnapshot(
            RestoreTableFromSnapshotRequest restoreTableFromSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to
     * restore tables with <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved">interleaved
     * sort keys</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreTableFromSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreTableFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreTableFromSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest.Builder}
     *        to create a request.
     * @return Result of the RestoreTableFromSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.RestoreTableFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreTableFromSnapshotResponse restoreTableFromSnapshot(
            Consumer<RestoreTableFromSnapshotRequest.Builder> restoreTableFromSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        return restoreTableFromSnapshot(RestoreTableFromSnapshotRequest.builder().applyMutation(restoreTableFromSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Assigns one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, TooManyTagsException, ThrottlingException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, TooManyTagsException,
            ThrottlingException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or set of tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or set of tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless certificate associated with a custom domain.
     * </p>
     *
     * @param updateCustomDomainAssociationRequest
     * @return Result of the UpdateCustomDomainAssociation operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomDomainAssociationResponse updateCustomDomainAssociation(
            UpdateCustomDomainAssociationRequest updateCustomDomainAssociationRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless certificate associated with a custom domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCustomDomainAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCustomDomainAssociationRequest#builder()}
     * </p>
     *
     * @param updateCustomDomainAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateCustomDomainAssociation operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomDomainAssociationResponse updateCustomDomainAssociation(
            Consumer<UpdateCustomDomainAssociationRequest.Builder> updateCustomDomainAssociationRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return updateCustomDomainAssociation(UpdateCustomDomainAssociationRequest.builder()
                .applyMutation(updateCustomDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless managed endpoint.
     * </p>
     *
     * @param updateEndpointAccessRequest
     * @return Result of the UpdateEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEndpointAccessResponse updateEndpointAccess(UpdateEndpointAccessRequest updateEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless managed endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEndpointAccessRequest#builder()}
     * </p>
     *
     * @param updateEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEndpointAccessResponse updateEndpointAccess(
            Consumer<UpdateEndpointAccessRequest.Builder> updateEndpointAccessRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        return updateEndpointAccess(UpdateEndpointAccessRequest.builder().applyMutation(updateEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Updates a namespace with the specified settings. Unless required, you can't update multiple parameters in one
     * request. For example, you must specify both <code>adminUsername</code> and <code>adminUserPassword</code> to
     * update either field, but you can't update both <code>kmsKeyId</code> and <code>logExports</code> in a single
     * request.
     * </p>
     *
     * @param updateNamespaceRequest
     * @return Result of the UpdateNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNamespaceResponse updateNamespace(UpdateNamespaceRequest updateNamespaceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a namespace with the specified settings. Unless required, you can't update multiple parameters in one
     * request. For example, you must specify both <code>adminUsername</code> and <code>adminUserPassword</code> to
     * update either field, but you can't update both <code>kmsKeyId</code> and <code>logExports</code> in a single
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateNamespaceRequest#builder()}
     * </p>
     *
     * @param updateNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNamespaceResponse updateNamespace(Consumer<UpdateNamespaceRequest.Builder> updateNamespaceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return updateNamespace(UpdateNamespaceRequest.builder().applyMutation(updateNamespaceRequest).build());
    }

    /**
     * <p>
     * Updates a snapshot.
     * </p>
     *
     * @param updateSnapshotRequest
     * @return Result of the UpdateSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSnapshotResponse updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSnapshotRequest#builder()}
     * </p>
     *
     * @param updateSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSnapshotResponse updateSnapshot(Consumer<UpdateSnapshotRequest.Builder> updateSnapshotRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return updateSnapshot(UpdateSnapshotRequest.builder().applyMutation(updateSnapshotRequest).build());
    }

    /**
     * <p>
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     * </p>
     *
     * @param updateUsageLimitRequest
     * @return Result of the UpdateUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUsageLimitResponse updateUsageLimit(UpdateUsageLimitRequest updateUsageLimitRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUsageLimitRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateUsageLimitRequest#builder()}
     * </p>
     *
     * @param updateUsageLimitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUsageLimitResponse updateUsageLimit(Consumer<UpdateUsageLimitRequest.Builder> updateUsageLimitRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        return updateUsageLimit(UpdateUsageLimitRequest.builder().applyMutation(updateUsageLimitRequest).build());
    }

    /**
     * <p>
     * Updates a workgroup with the specified configuration settings. You can't update multiple parameters in one
     * request. For example, you can update <code>baseCapacity</code> or <code>port</code> in a single request, but you
     * can't update both in the same request.
     * </p>
     *
     * @param updateWorkgroupRequest
     * @return Result of the UpdateWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InsufficientCapacityException
     *         There is an insufficient capacity to perform the action.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkgroupResponse updateWorkgroup(UpdateWorkgroupRequest updateWorkgroupRequest)
            throws InternalServerException, InsufficientCapacityException, ResourceNotFoundException, ConflictException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a workgroup with the specified configuration settings. You can't update multiple parameters in one
     * request. For example, you can update <code>baseCapacity</code> or <code>port</code> in a single request, but you
     * can't update both in the same request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkgroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateWorkgroupRequest#builder()}
     * </p>
     *
     * @param updateWorkgroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InsufficientCapacityException
     *         There is an insufficient capacity to perform the action.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkgroupResponse updateWorkgroup(Consumer<UpdateWorkgroupRequest.Builder> updateWorkgroupRequest)
            throws InternalServerException, InsufficientCapacityException, ResourceNotFoundException, ConflictException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return updateWorkgroup(UpdateWorkgroupRequest.builder().applyMutation(updateWorkgroupRequest).build());
    }

    /**
     * Create a {@link RedshiftServerlessClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RedshiftServerlessClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RedshiftServerlessClient}.
     */
    static RedshiftServerlessClientBuilder builder() {
        return new DefaultRedshiftServerlessClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default RedshiftServerlessServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
