/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.redshiftserverless.model.AccessDeniedException;
import software.amazon.awssdk.services.redshiftserverless.model.ConflictException;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.InsufficientCapacityException;
import software.amazon.awssdk.services.redshiftserverless.model.InternalServerException;
import software.amazon.awssdk.services.redshiftserverless.model.InvalidPaginationException;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessException;
import software.amazon.awssdk.services.redshiftserverless.model.ResourceNotFoundException;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ThrottlingException;
import software.amazon.awssdk.services.redshiftserverless.model.TooManyTagsException;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ValidationException;
import software.amazon.awssdk.services.redshiftserverless.transform.ConvertRecoveryPointToSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateWorkgroupRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteWorkgroupRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetCredentialsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetTableRestoreStatusRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetWorkgroupRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListNamespacesRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListRecoveryPointsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListTableRestoreStatusRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListUsageLimitsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListWorkgroupsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.RestoreFromRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.RestoreFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.RestoreTableFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateWorkgroupRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link RedshiftServerlessClient}.
 *
 * @see RedshiftServerlessClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRedshiftServerlessClient implements RedshiftServerlessClient {
    private static final Logger log = Logger.loggerFor(DefaultRedshiftServerlessClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final RedshiftServerlessServiceClientConfiguration serviceClientConfiguration;

    protected DefaultRedshiftServerlessClient(RedshiftServerlessServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html">Working with snapshots
     * and recovery points</a>.
     * </p>
     *
     * @param convertRecoveryPointToSnapshotRequest
     * @return Result of the ConvertRecoveryPointToSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ConvertRecoveryPointToSnapshot
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ConvertRecoveryPointToSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ConvertRecoveryPointToSnapshotResponse convertRecoveryPointToSnapshot(
            ConvertRecoveryPointToSnapshotRequest convertRecoveryPointToSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, TooManyTagsException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ConvertRecoveryPointToSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ConvertRecoveryPointToSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                convertRecoveryPointToSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConvertRecoveryPointToSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<ConvertRecoveryPointToSnapshotRequest, ConvertRecoveryPointToSnapshotResponse>()
                            .withOperationName("ConvertRecoveryPointToSnapshot").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(convertRecoveryPointToSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ConvertRecoveryPointToSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     *
     * @param createEndpointAccessRequest
     * @return Result of the CreateEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEndpointAccessResponse createEndpointAccess(CreateEndpointAccessRequest createEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEndpointAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpointAccess");

            return clientHandler.execute(new ClientExecutionParams<CreateEndpointAccessRequest, CreateEndpointAccessResponse>()
                    .withOperationName("CreateEndpointAccess").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createEndpointAccessRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEndpointAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a namespace in Amazon Redshift Serverless.
     * </p>
     *
     * @param createNamespaceRequest
     * @return Result of the CreateNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest createNamespaceRequest) throws InternalServerException,
            ConflictException, ValidationException, TooManyTagsException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateNamespaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNamespace");

            return clientHandler.execute(new ClientExecutionParams<CreateNamespaceRequest, CreateNamespaceResponse>()
                    .withOperationName("CreateNamespace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createNamespaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNamespaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html"> Working with
     * snapshots and recovery points</a>.
     * </p>
     *
     * @param createSnapshotRequest
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, TooManyTagsException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshot");

            return clientHandler.execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                    .withOperationName("CreateSnapshot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the
     * returned usage limit identifier.
     * </p>
     *
     * @param createUsageLimitRequest
     * @return Result of the CreateUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUsageLimitResponse createUsageLimit(CreateUsageLimitRequest createUsageLimitRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUsageLimitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUsageLimitResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUsageLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUsageLimit");

            return clientHandler.execute(new ClientExecutionParams<CreateUsageLimitRequest, CreateUsageLimitResponse>()
                    .withOperationName("CreateUsageLimit").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createUsageLimitRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUsageLimitRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an workgroup in Amazon Redshift Serverless.
     * </p>
     *
     * @param createWorkgroupRequest
     * @return Result of the CreateWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InsufficientCapacityException
     *         There is an insufficient capacity to perform the action.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.CreateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWorkgroupResponse createWorkgroup(CreateWorkgroupRequest createWorkgroupRequest) throws InternalServerException,
            InsufficientCapacityException, ResourceNotFoundException, ConflictException, ValidationException,
            TooManyTagsException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkgroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkgroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkgroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkgroup");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkgroupRequest, CreateWorkgroupResponse>()
                    .withOperationName("CreateWorkgroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createWorkgroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkgroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     *
     * @param deleteEndpointAccessRequest
     * @return Result of the DeleteEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEndpointAccessResponse deleteEndpointAccess(DeleteEndpointAccessRequest deleteEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEndpointAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpointAccess");

            return clientHandler.execute(new ClientExecutionParams<DeleteEndpointAccessRequest, DeleteEndpointAccessResponse>()
                    .withOperationName("DeleteEndpointAccess").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteEndpointAccessRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEndpointAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final
     * snapshot that has all of the data within the namespace.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteNamespaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNamespace");

            return clientHandler.execute(new ClientExecutionParams<DeleteNamespaceRequest, DeleteNamespaceResponse>()
                    .withOperationName("DeleteNamespace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteNamespaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNamespaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                    .withOperationName("DeleteResourcePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a snapshot from Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return Result of the DeleteSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshot");

            return clientHandler.execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                    .withOperationName("DeleteSnapshot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a usage limit from Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteUsageLimitRequest
     * @return Result of the DeleteUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteUsageLimitResponse deleteUsageLimit(DeleteUsageLimitRequest deleteUsageLimitRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUsageLimitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUsageLimitResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUsageLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUsageLimit");

            return clientHandler.execute(new ClientExecutionParams<DeleteUsageLimitRequest, DeleteUsageLimitResponse>()
                    .withOperationName("DeleteUsageLimit").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteUsageLimitRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUsageLimitRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a workgroup.
     * </p>
     *
     * @param deleteWorkgroupRequest
     * @return Result of the DeleteWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.DeleteWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteWorkgroupResponse deleteWorkgroup(DeleteWorkgroupRequest deleteWorkgroupRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkgroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWorkgroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkgroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkgroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkgroupRequest, DeleteWorkgroupResponse>()
                    .withOperationName("DeleteWorkgroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteWorkgroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkgroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift
     * Serverless.
     * </p>
     * <p>
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900
     * seconds (15 minutes) and 3600 seconds (60 minutes).
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.&lt;/p&gt; &lt;p&gt;If the &lt;code&gt;DbName&lt;/code&gt; parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.&lt;/p&gt; </code>
     * </pre>
     *
     * @param getCredentialsRequest
     * @return Result of the GetCredentials operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCredentialsResponse getCredentials(GetCredentialsRequest getCredentialsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCredentialsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCredentialsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCredentialsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCredentials");

            return clientHandler.execute(new ClientExecutionParams<GetCredentialsRequest, GetCredentialsResponse>()
                    .withOperationName("GetCredentials").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getCredentialsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCredentialsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information, such as the name, about a VPC endpoint.
     * </p>
     *
     * @param getEndpointAccessRequest
     * @return Result of the GetEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEndpointAccessResponse getEndpointAccess(GetEndpointAccessRequest getEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEndpointAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEndpointAccess");

            return clientHandler.execute(new ClientExecutionParams<GetEndpointAccessRequest, GetEndpointAccessResponse>()
                    .withOperationName("GetEndpointAccess").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getEndpointAccessRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEndpointAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a namespace in Amazon Redshift Serverless.
     * </p>
     *
     * @param getNamespaceRequest
     * @return Result of the GetNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetNamespaceResponse getNamespace(GetNamespaceRequest getNamespaceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetNamespaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNamespace");

            return clientHandler.execute(new ClientExecutionParams<GetNamespaceRequest, GetNamespaceResponse>()
                    .withOperationName("GetNamespace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getNamespaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetNamespaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a recovery point.
     * </p>
     *
     * @param getRecoveryPointRequest
     * @return Result of the GetRecoveryPoint operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRecoveryPointResponse getRecoveryPoint(GetRecoveryPointRequest getRecoveryPointRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRecoveryPointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecoveryPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecoveryPoint");

            return clientHandler.execute(new ClientExecutionParams<GetRecoveryPointRequest, GetRecoveryPointResponse>()
                    .withOperationName("GetRecoveryPoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRecoveryPointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRecoveryPointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a resource policy.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<GetResourcePolicyRequest, GetResourcePolicyResponse>()
                    .withOperationName("GetResourcePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a specific snapshot.
     * </p>
     *
     * @param getSnapshotRequest
     * @return Result of the GetSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSnapshotResponse getSnapshot(GetSnapshotRequest getSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSnapshot");

            return clientHandler.execute(new ClientExecutionParams<GetSnapshotRequest, GetSnapshotResponse>()
                    .withOperationName("GetSnapshot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a <code>TableRestoreStatus</code> object.
     * </p>
     *
     * @param getTableRestoreStatusRequest
     * @return Result of the GetTableRestoreStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTableRestoreStatusResponse getTableRestoreStatus(GetTableRestoreStatusRequest getTableRestoreStatusRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTableRestoreStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetTableRestoreStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTableRestoreStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTableRestoreStatus");

            return clientHandler.execute(new ClientExecutionParams<GetTableRestoreStatusRequest, GetTableRestoreStatusResponse>()
                    .withOperationName("GetTableRestoreStatus").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getTableRestoreStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTableRestoreStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a usage limit.
     * </p>
     *
     * @param getUsageLimitRequest
     * @return Result of the GetUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetUsageLimitResponse getUsageLimit(GetUsageLimitRequest getUsageLimitRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUsageLimitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUsageLimitResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsageLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsageLimit");

            return clientHandler.execute(new ClientExecutionParams<GetUsageLimitRequest, GetUsageLimitResponse>()
                    .withOperationName("GetUsageLimit").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getUsageLimitRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUsageLimitRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a specific workgroup.
     * </p>
     *
     * @param getWorkgroupRequest
     * @return Result of the GetWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.GetWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWorkgroupResponse getWorkgroup(GetWorkgroupRequest getWorkgroupRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkgroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWorkgroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkgroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkgroup");

            return clientHandler.execute(new ClientExecutionParams<GetWorkgroupRequest, GetWorkgroupResponse>()
                    .withOperationName("GetWorkgroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getWorkgroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWorkgroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     *
     * @param listEndpointAccessRequest
     * @return Result of the ListEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEndpointAccessResponse listEndpointAccess(ListEndpointAccessRequest listEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEndpointAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEndpointAccess");

            return clientHandler.execute(new ClientExecutionParams<ListEndpointAccessRequest, ListEndpointAccessResponse>()
                    .withOperationName("ListEndpointAccess").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listEndpointAccessRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEndpointAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     *
     * @param listNamespacesRequest
     * @return Result of the ListNamespaces operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListNamespacesResponse listNamespaces(ListNamespacesRequest listNamespacesRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNamespacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListNamespacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNamespacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNamespaces");

            return clientHandler.execute(new ClientExecutionParams<ListNamespacesRequest, ListNamespacesResponse>()
                    .withOperationName("ListNamespaces").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listNamespacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListNamespacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     *
     * @param listRecoveryPointsRequest
     * @return Result of the ListRecoveryPoints operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRecoveryPointsResponse listRecoveryPoints(ListRecoveryPointsRequest listRecoveryPointsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRecoveryPointsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRecoveryPointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecoveryPointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecoveryPoints");

            return clientHandler.execute(new ClientExecutionParams<ListRecoveryPointsRequest, ListRecoveryPointsResponse>()
                    .withOperationName("ListRecoveryPoints").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listRecoveryPointsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRecoveryPointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     *
     * @param listSnapshotsRequest
     * @return Result of the ListSnapshots operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSnapshotsResponse listSnapshots(ListSnapshotsRequest listSnapshotsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSnapshotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSnapshots");

            return clientHandler.execute(new ClientExecutionParams<ListSnapshotsRequest, ListSnapshotsResponse>()
                    .withOperationName("ListSnapshots").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listSnapshotsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     *
     * @param listTableRestoreStatusRequest
     * @return Result of the ListTableRestoreStatus operation returned by the service.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTableRestoreStatusResponse listTableRestoreStatus(ListTableRestoreStatusRequest listTableRestoreStatusRequest)
            throws InvalidPaginationException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTableRestoreStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTableRestoreStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTableRestoreStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTableRestoreStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTableRestoreStatusRequest, ListTableRestoreStatusResponse>()
                            .withOperationName("ListTableRestoreStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listTableRestoreStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTableRestoreStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     *
     * @param listUsageLimitsRequest
     * @return Result of the ListUsageLimits operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidPaginationException
     *         The provided pagination token is invalid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListUsageLimitsResponse listUsageLimits(ListUsageLimitsRequest listUsageLimitsRequest) throws InternalServerException,
            InvalidPaginationException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUsageLimitsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListUsageLimitsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsageLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsageLimits");

            return clientHandler.execute(new ClientExecutionParams<ListUsageLimitsRequest, ListUsageLimitsResponse>()
                    .withOperationName("ListUsageLimits").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUsageLimitsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListUsageLimitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     *
     * @param listWorkgroupsRequest
     * @return Result of the ListWorkgroups operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWorkgroupsResponse listWorkgroups(ListWorkgroupsRequest listWorkgroupsRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkgroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWorkgroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkgroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkgroups");

            return clientHandler.execute(new ClientExecutionParams<ListWorkgroupsRequest, ListWorkgroupsResponse>()
                    .withOperationName("ListWorkgroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listWorkgroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWorkgroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web
     * Services accounts.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<PutResourcePolicyRequest, PutResourcePolicyResponse>()
                    .withOperationName("PutResourcePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restore the data from a recovery point.
     * </p>
     *
     * @param restoreFromRecoveryPointRequest
     * @return Result of the RestoreFromRecoveryPoint operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.RestoreFromRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestoreFromRecoveryPointResponse restoreFromRecoveryPoint(
            RestoreFromRecoveryPointRequest restoreFromRecoveryPointRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RestoreFromRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RestoreFromRecoveryPointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreFromRecoveryPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreFromRecoveryPoint");

            return clientHandler
                    .execute(new ClientExecutionParams<RestoreFromRecoveryPointRequest, RestoreFromRecoveryPointResponse>()
                            .withOperationName("RestoreFromRecoveryPoint").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(restoreFromRecoveryPointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RestoreFromRecoveryPointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restores a namespace from a snapshot.
     * </p>
     *
     * @param restoreFromSnapshotRequest
     * @return Result of the RestoreFromSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ServiceQuotaExceededException
     *         The service limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.RestoreFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestoreFromSnapshotResponse restoreFromSnapshot(RestoreFromSnapshotRequest restoreFromSnapshotRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RestoreFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RestoreFromSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreFromSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreFromSnapshot");

            return clientHandler.execute(new ClientExecutionParams<RestoreFromSnapshotRequest, RestoreFromSnapshotResponse>()
                    .withOperationName("RestoreFromSnapshot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(restoreFromSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RestoreFromSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to
     * restore tables with <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved">interleaved
     * sort keys</a>.
     * </p>
     *
     * @param restoreTableFromSnapshotRequest
     * @return Result of the RestoreTableFromSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.RestoreTableFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestoreTableFromSnapshotResponse restoreTableFromSnapshot(
            RestoreTableFromSnapshotRequest restoreTableFromSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RestoreTableFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RestoreTableFromSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreTableFromSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreTableFromSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<RestoreTableFromSnapshotRequest, RestoreTableFromSnapshotResponse>()
                            .withOperationName("RestoreTableFromSnapshot").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(restoreTableFromSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RestoreTableFromSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws TooManyTagsException
     *         The request exceeded the number of tags allowed for a resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, TooManyTagsException, ThrottlingException, AwsServiceException,
            SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a tag or set of tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless managed endpoint.
     * </p>
     *
     * @param updateEndpointAccessRequest
     * @return Result of the UpdateEndpointAccess operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateEndpointAccessResponse updateEndpointAccess(UpdateEndpointAccessRequest updateEndpointAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEndpointAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpointAccess");

            return clientHandler.execute(new ClientExecutionParams<UpdateEndpointAccessRequest, UpdateEndpointAccessResponse>()
                    .withOperationName("UpdateEndpointAccess").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateEndpointAccessRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateEndpointAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a namespace with the specified settings. Unless required, you can't update multiple parameters in one
     * request. For example, you must specify both <code>adminUsername</code> and <code>adminUserPassword</code> to
     * update either field, but you can't update both <code>kmsKeyId</code> and <code>logExports</code> in a single
     * request.
     * </p>
     *
     * @param updateNamespaceRequest
     * @return Result of the UpdateNamespace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateNamespaceResponse updateNamespace(UpdateNamespaceRequest updateNamespaceRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateNamespaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNamespace");

            return clientHandler.execute(new ClientExecutionParams<UpdateNamespaceRequest, UpdateNamespaceResponse>()
                    .withOperationName("UpdateNamespace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateNamespaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateNamespaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a snapshot.
     * </p>
     *
     * @param updateSnapshotRequest
     * @return Result of the UpdateSnapshot operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateSnapshotResponse updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSnapshot");

            return clientHandler.execute(new ClientExecutionParams<UpdateSnapshotRequest, UpdateSnapshotResponse>()
                    .withOperationName("UpdateSnapshot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     * </p>
     *
     * @param updateUsageLimitRequest
     * @return Result of the UpdateUsageLimit operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateUsageLimitResponse updateUsageLimit(UpdateUsageLimitRequest updateUsageLimitRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUsageLimitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateUsageLimitResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUsageLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUsageLimit");

            return clientHandler.execute(new ClientExecutionParams<UpdateUsageLimitRequest, UpdateUsageLimitResponse>()
                    .withOperationName("UpdateUsageLimit").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateUsageLimitRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateUsageLimitRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a workgroup with the specified configuration settings. You can't update multiple parameters in one
     * request. For example, you can update <code>baseCapacity</code> or <code>port</code> in a single request, but you
     * can't update both in the same request.
     * </p>
     *
     * @param updateWorkgroupRequest
     * @return Result of the UpdateWorkgroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InsufficientCapacityException
     *         There is an insufficient capacity to perform the action.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The submitted action has conflicts.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftServerlessClient.UpdateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateWorkgroupResponse updateWorkgroup(UpdateWorkgroupRequest updateWorkgroupRequest) throws InternalServerException,
            InsufficientCapacityException, ResourceNotFoundException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkgroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateWorkgroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkgroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkgroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateWorkgroupRequest, UpdateWorkgroupResponse>()
                    .withOperationName("UpdateWorkgroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateWorkgroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWorkgroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(RedshiftServerlessException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPaginationException")
                                .exceptionBuilderSupplier(InvalidPaginationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientCapacityException")
                                .exceptionBuilderSupplier(InsufficientCapacityException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    @Override
    public final RedshiftServerlessServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
