/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataAsyncClient;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse;
import software.amazon.awssdk.services.redshiftdata.model.StatementData;

public class ListStatementsPublisher
implements SdkPublisher<ListStatementsResponse> {
    private final RedshiftDataAsyncClient client;
    private final ListStatementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStatementsPublisher(RedshiftDataAsyncClient client, ListStatementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStatementsPublisher(RedshiftDataAsyncClient client, ListStatementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStatementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStatementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StatementData> statements() {
        Function<ListStatementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.statements() != null) {
                return response.statements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStatementsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStatementsResponseFetcher
    implements AsyncPageFetcher<ListStatementsResponse> {
        private ListStatementsResponseFetcher() {
        }

        public boolean hasNextPage(ListStatementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStatementsResponse> nextPage(ListStatementsResponse previousPage) {
            if (previousPage == null) {
                return ListStatementsPublisher.this.client.listStatements(ListStatementsPublisher.this.firstRequest);
            }
            return ListStatementsPublisher.this.client.listStatements((ListStatementsRequest)((Object)ListStatementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

