/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNode;
import software.amazon.awssdk.services.redshift.model.ReservedNodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedNodesResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeReservedNodesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReservedNodesResponse.getter(DescribeReservedNodesResponse::marker)).setter(DescribeReservedNodesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReservedNode>> RESERVED_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedNodes").getter(DescribeReservedNodesResponse.getter(DescribeReservedNodesResponse::reservedNodes)).setter(DescribeReservedNodesResponse.setter(Builder::reservedNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodes").build(), ListTrait.builder().memberLocationName("ReservedNode").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNode").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, RESERVED_NODES_FIELD));
    private final String marker;
    private final List<ReservedNode> reservedNodes;

    private DescribeReservedNodesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedNodes = builder.reservedNodes;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasReservedNodes() {
        return this.reservedNodes != null && !(this.reservedNodes instanceof SdkAutoConstructList);
    }

    public final List<ReservedNode> reservedNodes() {
        return this.reservedNodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedNodes() ? this.reservedNodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodesResponse)) {
            return false;
        }
        DescribeReservedNodesResponse other = (DescribeReservedNodesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasReservedNodes() == other.hasReservedNodes() && Objects.equals(this.reservedNodes(), other.reservedNodes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedNodesResponse").add("Marker", (Object)this.marker()).add("ReservedNodes", this.hasReservedNodes() ? this.reservedNodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReservedNodes": {
                return Optional.ofNullable(clazz.cast(this.reservedNodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedNodesResponse, T> g) {
        return obj -> g.apply((DescribeReservedNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedNode> reservedNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodesResponse model) {
            super(model);
            this.marker(model.marker);
            this.reservedNodes(model.reservedNodes);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ReservedNode.Builder> getReservedNodes() {
            List<ReservedNode.Builder> result = ReservedNodeListCopier.copyToBuilder(this.reservedNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedNodes(Collection<ReservedNode.BuilderImpl> reservedNodes) {
            this.reservedNodes = ReservedNodeListCopier.copyFromBuilder(reservedNodes);
        }

        @Override
        public final Builder reservedNodes(Collection<ReservedNode> reservedNodes) {
            this.reservedNodes = ReservedNodeListCopier.copy(reservedNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodes(ReservedNode ... reservedNodes) {
            this.reservedNodes(Arrays.asList(reservedNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodes(Consumer<ReservedNode.Builder> ... reservedNodes) {
            this.reservedNodes(Stream.of(reservedNodes).map(c -> (ReservedNode)((ReservedNode.Builder)ReservedNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedNodesResponse build() {
            return new DescribeReservedNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedNodesResponse> {
        public Builder marker(String var1);

        public Builder reservedNodes(Collection<ReservedNode> var1);

        public Builder reservedNodes(ReservedNode ... var1);

        public Builder reservedNodes(Consumer<ReservedNode.Builder> ... var1);
    }
}

