/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.redshift.DefaultRedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.DefaultRedshiftBaseClientBuilder;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClientBuilder;
import software.amazon.awssdk.services.redshift.RedshiftServiceClientConfiguration;
import software.amazon.awssdk.services.redshift.endpoints.RedshiftEndpointProvider;

@SdkInternalApi
final class DefaultRedshiftAsyncClientBuilder
extends DefaultRedshiftBaseClientBuilder<RedshiftAsyncClientBuilder, RedshiftAsyncClient>
implements RedshiftAsyncClientBuilder {
    DefaultRedshiftAsyncClientBuilder() {
    }

    @Override
    public DefaultRedshiftAsyncClientBuilder endpointProvider(RedshiftEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RedshiftAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRedshiftAsyncClientBuilder.validateClientOptions(clientConfiguration);
        RedshiftServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRedshiftAsyncClient client = new DefaultRedshiftAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RedshiftServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RedshiftServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

