/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.NodeConfigurationOption;

public class DescribeNodeConfigurationOptionsPublisher
implements SdkPublisher<DescribeNodeConfigurationOptionsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeNodeConfigurationOptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNodeConfigurationOptionsPublisher(RedshiftAsyncClient client, DescribeNodeConfigurationOptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNodeConfigurationOptionsPublisher(RedshiftAsyncClient client, DescribeNodeConfigurationOptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNodeConfigurationOptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNodeConfigurationOptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NodeConfigurationOption> nodeConfigurationOptionList() {
        Function<DescribeNodeConfigurationOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodeConfigurationOptionList() != null) {
                return response.nodeConfigurationOptionList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeNodeConfigurationOptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeNodeConfigurationOptionsResponseFetcher
    implements AsyncPageFetcher<DescribeNodeConfigurationOptionsResponse> {
        private DescribeNodeConfigurationOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNodeConfigurationOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeNodeConfigurationOptionsResponse> nextPage(DescribeNodeConfigurationOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNodeConfigurationOptionsPublisher.this.client.describeNodeConfigurationOptions(DescribeNodeConfigurationOptionsPublisher.this.firstRequest);
            }
            return DescribeNodeConfigurationOptionsPublisher.this.client.describeNodeConfigurationOptions((DescribeNodeConfigurationOptionsRequest)((Object)DescribeNodeConfigurationOptionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

