/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rdsdata.DefaultRdsDataAsyncClient;
import software.amazon.awssdk.services.rdsdata.DefaultRdsDataBaseClientBuilder;
import software.amazon.awssdk.services.rdsdata.RdsDataAsyncClient;
import software.amazon.awssdk.services.rdsdata.RdsDataAsyncClientBuilder;
import software.amazon.awssdk.services.rdsdata.RdsDataServiceClientConfiguration;
import software.amazon.awssdk.services.rdsdata.endpoints.RdsDataEndpointProvider;

@SdkInternalApi
final class DefaultRdsDataAsyncClientBuilder
extends DefaultRdsDataBaseClientBuilder<RdsDataAsyncClientBuilder, RdsDataAsyncClient>
implements RdsDataAsyncClientBuilder {
    DefaultRdsDataAsyncClientBuilder() {
    }

    @Override
    public DefaultRdsDataAsyncClientBuilder endpointProvider(RdsDataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RdsDataAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRdsDataAsyncClientBuilder.validateClientOptions(clientConfiguration);
        RdsDataServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRdsDataAsyncClient client = new DefaultRdsDataAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RdsDataServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RdsDataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

