/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rdsdata.DefaultRdsDataBaseClientBuilder;
import software.amazon.awssdk.services.rdsdata.DefaultRdsDataClient;
import software.amazon.awssdk.services.rdsdata.RdsDataClient;
import software.amazon.awssdk.services.rdsdata.RdsDataClientBuilder;
import software.amazon.awssdk.services.rdsdata.RdsDataServiceClientConfiguration;
import software.amazon.awssdk.services.rdsdata.endpoints.RdsDataEndpointProvider;

@SdkInternalApi
final class DefaultRdsDataClientBuilder
extends DefaultRdsDataBaseClientBuilder<RdsDataClientBuilder, RdsDataClient>
implements RdsDataClientBuilder {
    DefaultRdsDataClientBuilder() {
    }

    @Override
    public DefaultRdsDataClientBuilder endpointProvider(RdsDataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RdsDataClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultRdsDataClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        RdsDataServiceClientConfiguration serviceClientConfiguration = RdsDataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultRdsDataClient(serviceClientConfiguration, clientConfiguration);
    }
}

