/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomDbEngineVersionRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateCustomDbEngineVersionRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(CreateCustomDbEngineVersionRequest.getter(CreateCustomDbEngineVersionRequest::engine)).setter(CreateCustomDbEngineVersionRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(CreateCustomDbEngineVersionRequest.getter(CreateCustomDbEngineVersionRequest::engineVersion)).setter(CreateCustomDbEngineVersionRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> DATABASE_INSTALLATION_FILES_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseInstallationFilesS3BucketName").getter(CreateCustomDbEngineVersionRequest.getter(CreateCustomDbEngineVersionRequest::databaseInstallationFilesS3BucketName)).setter(CreateCustomDbEngineVersionRequest.setter(Builder::databaseInstallationFilesS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInstallationFilesS3BucketName").build()}).build();
    private static final SdkField<String> DATABASE_INSTALLATION_FILES_S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseInstallationFilesS3Prefix").getter(CreateCustomDbEngineVersionRequest.getter(CreateCustomDbEngineVersionRequest::databaseInstallationFilesS3Prefix)).setter(CreateCustomDbEngineVersionRequest.setter(Builder::databaseInstallationFilesS3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInstallationFilesS3Prefix").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(CreateCustomDbEngineVersionRequest.getter(CreateCustomDbEngineVersionRequest::imageId)).setter(CreateCustomDbEngineVersionRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyId").getter(CreateCustomDbEngineVersionRequest.getter(CreateCustomDbEngineVersionRequest::kmsKeyId)).setter(CreateCustomDbEngineVersionRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateCustomDbEngineVersionRequest.getter(CreateCustomDbEngineVersionRequest::description)).setter(CreateCustomDbEngineVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Manifest").getter(CreateCustomDbEngineVersionRequest.getter(CreateCustomDbEngineVersionRequest::manifest)).setter(CreateCustomDbEngineVersionRequest.setter(Builder::manifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manifest").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateCustomDbEngineVersionRequest.getter(CreateCustomDbEngineVersionRequest::tags)).setter(CreateCustomDbEngineVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, ENGINE_VERSION_FIELD, DATABASE_INSTALLATION_FILES_S3_BUCKET_NAME_FIELD, DATABASE_INSTALLATION_FILES_S3_PREFIX_FIELD, IMAGE_ID_FIELD, KMS_KEY_ID_FIELD, DESCRIPTION_FIELD, MANIFEST_FIELD, TAGS_FIELD));
    private final String engine;
    private final String engineVersion;
    private final String databaseInstallationFilesS3BucketName;
    private final String databaseInstallationFilesS3Prefix;
    private final String imageId;
    private final String kmsKeyId;
    private final String description;
    private final String manifest;
    private final List<Tag> tags;

    private CreateCustomDbEngineVersionRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.databaseInstallationFilesS3BucketName = builder.databaseInstallationFilesS3BucketName;
        this.databaseInstallationFilesS3Prefix = builder.databaseInstallationFilesS3Prefix;
        this.imageId = builder.imageId;
        this.kmsKeyId = builder.kmsKeyId;
        this.description = builder.description;
        this.manifest = builder.manifest;
        this.tags = builder.tags;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String databaseInstallationFilesS3BucketName() {
        return this.databaseInstallationFilesS3BucketName;
    }

    public final String databaseInstallationFilesS3Prefix() {
        return this.databaseInstallationFilesS3Prefix;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String description() {
        return this.description;
    }

    public final String manifest() {
        return this.manifest;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInstallationFilesS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInstallationFilesS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomDbEngineVersionRequest)) {
            return false;
        }
        CreateCustomDbEngineVersionRequest other = (CreateCustomDbEngineVersionRequest)((Object)obj);
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.databaseInstallationFilesS3BucketName(), other.databaseInstallationFilesS3BucketName()) && Objects.equals(this.databaseInstallationFilesS3Prefix(), other.databaseInstallationFilesS3Prefix()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.manifest(), other.manifest()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomDbEngineVersionRequest").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("DatabaseInstallationFilesS3BucketName", (Object)this.databaseInstallationFilesS3BucketName()).add("DatabaseInstallationFilesS3Prefix", (Object)this.databaseInstallationFilesS3Prefix()).add("ImageId", (Object)this.imageId()).add("KMSKeyId", (Object)this.kmsKeyId()).add("Description", (Object)this.description()).add("Manifest", (Object)this.manifest()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DatabaseInstallationFilesS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.databaseInstallationFilesS3BucketName()));
            }
            case "DatabaseInstallationFilesS3Prefix": {
                return Optional.ofNullable(clazz.cast(this.databaseInstallationFilesS3Prefix()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Manifest": {
                return Optional.ofNullable(clazz.cast(this.manifest()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomDbEngineVersionRequest, T> g) {
        return obj -> g.apply((CreateCustomDbEngineVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String databaseInstallationFilesS3BucketName;
        private String databaseInstallationFilesS3Prefix;
        private String imageId;
        private String kmsKeyId;
        private String description;
        private String manifest;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomDbEngineVersionRequest model) {
            super(model);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.databaseInstallationFilesS3BucketName(model.databaseInstallationFilesS3BucketName);
            this.databaseInstallationFilesS3Prefix(model.databaseInstallationFilesS3Prefix);
            this.imageId(model.imageId);
            this.kmsKeyId(model.kmsKeyId);
            this.description(model.description);
            this.manifest(model.manifest);
            this.tags(model.tags);
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDatabaseInstallationFilesS3BucketName() {
            return this.databaseInstallationFilesS3BucketName;
        }

        public final void setDatabaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName) {
            this.databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName;
        }

        @Override
        public final Builder databaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName) {
            this.databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName;
            return this;
        }

        public final String getDatabaseInstallationFilesS3Prefix() {
            return this.databaseInstallationFilesS3Prefix;
        }

        public final void setDatabaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix) {
            this.databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix;
        }

        @Override
        public final Builder databaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix) {
            this.databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getManifest() {
            return this.manifest;
        }

        public final void setManifest(String manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(String manifest) {
            this.manifest = manifest;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomDbEngineVersionRequest build() {
            return new CreateCustomDbEngineVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomDbEngineVersionRequest> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder databaseInstallationFilesS3BucketName(String var1);

        public Builder databaseInstallationFilesS3Prefix(String var1);

        public Builder imageId(String var1);

        public Builder kmsKeyId(String var1);

        public Builder description(String var1);

        public Builder manifest(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

