/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a set of RDS DB instances, Aurora DB clusters, or both that a proxy can connect to. Currently, each target
 * group is associated with exactly one RDS DB instance or Aurora DB cluster.
 * </p>
 * <p>
 * This data type is used as a response element in the <code>DescribeDBProxyTargetGroups</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBProxyTargetGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<DBProxyTargetGroup.Builder, DBProxyTargetGroup> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBProxyName").getter(getter(DBProxyTargetGroup::dbProxyName)).setter(setter(Builder::dbProxyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()).build();

    private static final SdkField<String> TARGET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetGroupName").getter(getter(DBProxyTargetGroup::targetGroupName))
            .setter(setter(Builder::targetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupName").build()).build();

    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetGroupArn").getter(getter(DBProxyTargetGroup::targetGroupArn))
            .setter(setter(Builder::targetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupArn").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault").getter(getter(DBProxyTargetGroup::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DBProxyTargetGroup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ConnectionPoolConfigurationInfo> CONNECTION_POOL_CONFIG_FIELD = SdkField
            .<ConnectionPoolConfigurationInfo> builder(MarshallingType.SDK_POJO).memberName("ConnectionPoolConfig")
            .getter(getter(DBProxyTargetGroup::connectionPoolConfig)).setter(setter(Builder::connectionPoolConfig))
            .constructor(ConnectionPoolConfigurationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPoolConfig").build())
            .build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(DBProxyTargetGroup::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<Instant> UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedDate").getter(getter(DBProxyTargetGroup::updatedDate)).setter(setter(Builder::updatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD,
            TARGET_GROUP_NAME_FIELD, TARGET_GROUP_ARN_FIELD, IS_DEFAULT_FIELD, STATUS_FIELD, CONNECTION_POOL_CONFIG_FIELD,
            CREATED_DATE_FIELD, UPDATED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbProxyName;

    private final String targetGroupName;

    private final String targetGroupArn;

    private final Boolean isDefault;

    private final String status;

    private final ConnectionPoolConfigurationInfo connectionPoolConfig;

    private final Instant createdDate;

    private final Instant updatedDate;

    private DBProxyTargetGroup(BuilderImpl builder) {
        this.dbProxyName = builder.dbProxyName;
        this.targetGroupName = builder.targetGroupName;
        this.targetGroupArn = builder.targetGroupArn;
        this.isDefault = builder.isDefault;
        this.status = builder.status;
        this.connectionPoolConfig = builder.connectionPoolConfig;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
    }

    /**
     * <p>
     * The identifier for the RDS proxy associated with this target group.
     * </p>
     * 
     * @return The identifier for the RDS proxy associated with this target group.
     */
    public final String dbProxyName() {
        return dbProxyName;
    }

    /**
     * <p>
     * The identifier for the target group. This name must be unique for all target groups owned by your Amazon Web
     * Services account in the specified Amazon Web Services Region.
     * </p>
     * 
     * @return The identifier for the target group. This name must be unique for all target groups owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.
     */
    public final String targetGroupName() {
        return targetGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) representing the target group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) representing the target group.
     */
    public final String targetGroupArn() {
        return targetGroupArn;
    }

    /**
     * <p>
     * Whether this target group is the first one used for connection requests by the associated proxy. Because each
     * proxy is currently associated with a single target group, currently this setting is always <code>true</code>.
     * </p>
     * 
     * @return Whether this target group is the first one used for connection requests by the associated proxy. Because
     *         each proxy is currently associated with a single target group, currently this setting is always
     *         <code>true</code>.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * The current status of this target group. A status of <code>available</code> means the target group is correctly
     * associated with a database. Other values indicate that you must wait for the target group to be ready, or take
     * some action to resolve an issue.
     * </p>
     * 
     * @return The current status of this target group. A status of <code>available</code> means the target group is
     *         correctly associated with a database. Other values indicate that you must wait for the target group to be
     *         ready, or take some action to resolve an issue.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The settings that determine the size and behavior of the connection pool for the target group.
     * </p>
     * 
     * @return The settings that determine the size and behavior of the connection pool for the target group.
     */
    public final ConnectionPoolConfigurationInfo connectionPoolConfig() {
        return connectionPoolConfig;
    }

    /**
     * <p>
     * The date and time when the target group was first created.
     * </p>
     * 
     * @return The date and time when the target group was first created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date and time when the target group was last updated.
     * </p>
     * 
     * @return The date and time when the target group was last updated.
     */
    public final Instant updatedDate() {
        return updatedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(connectionPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(updatedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBProxyTargetGroup)) {
            return false;
        }
        DBProxyTargetGroup other = (DBProxyTargetGroup) obj;
        return Objects.equals(dbProxyName(), other.dbProxyName()) && Objects.equals(targetGroupName(), other.targetGroupName())
                && Objects.equals(targetGroupArn(), other.targetGroupArn()) && Objects.equals(isDefault(), other.isDefault())
                && Objects.equals(status(), other.status())
                && Objects.equals(connectionPoolConfig(), other.connectionPoolConfig())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(updatedDate(), other.updatedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBProxyTargetGroup").add("DBProxyName", dbProxyName()).add("TargetGroupName", targetGroupName())
                .add("TargetGroupArn", targetGroupArn()).add("IsDefault", isDefault()).add("Status", status())
                .add("ConnectionPoolConfig", connectionPoolConfig()).add("CreatedDate", createdDate())
                .add("UpdatedDate", updatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBProxyName":
            return Optional.ofNullable(clazz.cast(dbProxyName()));
        case "TargetGroupName":
            return Optional.ofNullable(clazz.cast(targetGroupName()));
        case "TargetGroupArn":
            return Optional.ofNullable(clazz.cast(targetGroupArn()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ConnectionPoolConfig":
            return Optional.ofNullable(clazz.cast(connectionPoolConfig()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "UpdatedDate":
            return Optional.ofNullable(clazz.cast(updatedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBProxyTargetGroup, T> g) {
        return obj -> g.apply((DBProxyTargetGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBProxyTargetGroup> {
        /**
         * <p>
         * The identifier for the RDS proxy associated with this target group.
         * </p>
         * 
         * @param dbProxyName
         *        The identifier for the RDS proxy associated with this target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyName(String dbProxyName);

        /**
         * <p>
         * The identifier for the target group. This name must be unique for all target groups owned by your Amazon Web
         * Services account in the specified Amazon Web Services Region.
         * </p>
         * 
         * @param targetGroupName
         *        The identifier for the target group. This name must be unique for all target groups owned by your
         *        Amazon Web Services account in the specified Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupName(String targetGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) representing the target group.
         * </p>
         * 
         * @param targetGroupArn
         *        The Amazon Resource Name (ARN) representing the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupArn(String targetGroupArn);

        /**
         * <p>
         * Whether this target group is the first one used for connection requests by the associated proxy. Because each
         * proxy is currently associated with a single target group, currently this setting is always <code>true</code>.
         * </p>
         * 
         * @param isDefault
         *        Whether this target group is the first one used for connection requests by the associated proxy.
         *        Because each proxy is currently associated with a single target group, currently this setting is
         *        always <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The current status of this target group. A status of <code>available</code> means the target group is
         * correctly associated with a database. Other values indicate that you must wait for the target group to be
         * ready, or take some action to resolve an issue.
         * </p>
         * 
         * @param status
         *        The current status of this target group. A status of <code>available</code> means the target group is
         *        correctly associated with a database. Other values indicate that you must wait for the target group to
         *        be ready, or take some action to resolve an issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The settings that determine the size and behavior of the connection pool for the target group.
         * </p>
         * 
         * @param connectionPoolConfig
         *        The settings that determine the size and behavior of the connection pool for the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionPoolConfig(ConnectionPoolConfigurationInfo connectionPoolConfig);

        /**
         * <p>
         * The settings that determine the size and behavior of the connection pool for the target group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionPoolConfigurationInfo.Builder}
         * avoiding the need to create one manually via {@link ConnectionPoolConfigurationInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionPoolConfigurationInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #connectionPoolConfig(ConnectionPoolConfigurationInfo)}.
         * 
         * @param connectionPoolConfig
         *        a consumer that will call methods on {@link ConnectionPoolConfigurationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionPoolConfig(ConnectionPoolConfigurationInfo)
         */
        default Builder connectionPoolConfig(Consumer<ConnectionPoolConfigurationInfo.Builder> connectionPoolConfig) {
            return connectionPoolConfig(ConnectionPoolConfigurationInfo.builder().applyMutation(connectionPoolConfig).build());
        }

        /**
         * <p>
         * The date and time when the target group was first created.
         * </p>
         * 
         * @param createdDate
         *        The date and time when the target group was first created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The date and time when the target group was last updated.
         * </p>
         * 
         * @param updatedDate
         *        The date and time when the target group was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedDate(Instant updatedDate);
    }

    static final class BuilderImpl implements Builder {
        private String dbProxyName;

        private String targetGroupName;

        private String targetGroupArn;

        private Boolean isDefault;

        private String status;

        private ConnectionPoolConfigurationInfo connectionPoolConfig;

        private Instant createdDate;

        private Instant updatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DBProxyTargetGroup model) {
            dbProxyName(model.dbProxyName);
            targetGroupName(model.targetGroupName);
            targetGroupArn(model.targetGroupArn);
            isDefault(model.isDefault);
            status(model.status);
            connectionPoolConfig(model.connectionPoolConfig);
            createdDate(model.createdDate);
            updatedDate(model.updatedDate);
        }

        public final String getDbProxyName() {
            return dbProxyName;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final String getTargetGroupName() {
            return targetGroupName;
        }

        public final void setTargetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
        }

        @Override
        public final Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public final String getTargetGroupArn() {
            return targetGroupArn;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final ConnectionPoolConfigurationInfo.Builder getConnectionPoolConfig() {
            return connectionPoolConfig != null ? connectionPoolConfig.toBuilder() : null;
        }

        public final void setConnectionPoolConfig(ConnectionPoolConfigurationInfo.BuilderImpl connectionPoolConfig) {
            this.connectionPoolConfig = connectionPoolConfig != null ? connectionPoolConfig.build() : null;
        }

        @Override
        public final Builder connectionPoolConfig(ConnectionPoolConfigurationInfo connectionPoolConfig) {
            this.connectionPoolConfig = connectionPoolConfig;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getUpdatedDate() {
            return updatedDate;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        @Override
        public DBProxyTargetGroup build() {
            return new DBProxyTargetGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
