/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreDbClusterToPointInTimeRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, RestoreDbClusterToPointInTimeRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::dbClusterIdentifier)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> RESTORE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreType").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::restoreType)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::restoreType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreType").build()}).build();
    private static final SdkField<String> SOURCE_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDBClusterIdentifier").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::sourceDBClusterIdentifier)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::sourceDBClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterIdentifier").build()}).build();
    private static final SdkField<Instant> RESTORE_TO_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RestoreToTime").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::restoreToTime)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::restoreToTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreToTime").build()}).build();
    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseLatestRestorableTime").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::useLatestRestorableTime)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::useLatestRestorableTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLatestRestorableTime").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::port)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroupName").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::dbSubnetGroupName)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::optionGroupName)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::vpcSecurityGroupIds)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::tags)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::kmsKeyId)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIAMDatabaseAuthentication").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::enableIAMDatabaseAuthentication)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::enableIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BacktrackWindow").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::backtrackWindow)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::backtrackWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()}).build();
    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnableCloudwatchLogsExports").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::enableCloudwatchLogsExports)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::enableCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterParameterGroupName").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::dbClusterParameterGroupName)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::dbClusterParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::deletionProtection)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::copyTagsToSnapshot)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::domain)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainIAMRoleName").getter(RestoreDbClusterToPointInTimeRequest.getter(RestoreDbClusterToPointInTimeRequest::domainIAMRoleName)).setter(RestoreDbClusterToPointInTimeRequest.setter(Builder::domainIAMRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD, RESTORE_TYPE_FIELD, SOURCE_DB_CLUSTER_IDENTIFIER_FIELD, RESTORE_TO_TIME_FIELD, USE_LATEST_RESTORABLE_TIME_FIELD, PORT_FIELD, DB_SUBNET_GROUP_NAME_FIELD, OPTION_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, BACKTRACK_WINDOW_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, DELETION_PROTECTION_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, DOMAIN_FIELD, DOMAIN_IAM_ROLE_NAME_FIELD));
    private final String dbClusterIdentifier;
    private final String restoreType;
    private final String sourceDBClusterIdentifier;
    private final Instant restoreToTime;
    private final Boolean useLatestRestorableTime;
    private final Integer port;
    private final String dbSubnetGroupName;
    private final String optionGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final Boolean enableIAMDatabaseAuthentication;
    private final Long backtrackWindow;
    private final List<String> enableCloudwatchLogsExports;
    private final String dbClusterParameterGroupName;
    private final Boolean deletionProtection;
    private final Boolean copyTagsToSnapshot;
    private final String domain;
    private final String domainIAMRoleName;

    private RestoreDbClusterToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.restoreType = builder.restoreType;
        this.sourceDBClusterIdentifier = builder.sourceDBClusterIdentifier;
        this.restoreToTime = builder.restoreToTime;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.optionGroupName = builder.optionGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.backtrackWindow = builder.backtrackWindow;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.deletionProtection = builder.deletionProtection;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final String restoreType() {
        return this.restoreType;
    }

    public final String sourceDBClusterIdentifier() {
        return this.sourceDBClusterIdentifier;
    }

    public final Instant restoreToTime() {
        return this.restoreToTime;
    }

    public final Boolean useLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public final Integer port() {
        return this.port;
    }

    public final String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public final Long backtrackWindow() {
        return this.backtrackWindow;
    }

    public final boolean hasEnableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports != null && !(this.enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    public final List<String> enableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports;
    }

    public final String dbClusterParameterGroupName() {
        return this.dbClusterParameterGroupName;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreToTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIAMRoleName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbClusterToPointInTimeRequest)) {
            return false;
        }
        RestoreDbClusterToPointInTimeRequest other = (RestoreDbClusterToPointInTimeRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.restoreType(), other.restoreType()) && Objects.equals(this.sourceDBClusterIdentifier(), other.sourceDBClusterIdentifier()) && Objects.equals(this.restoreToTime(), other.restoreToTime()) && Objects.equals(this.useLatestRestorableTime(), other.useLatestRestorableTime()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && Objects.equals(this.backtrackWindow(), other.backtrackWindow()) && this.hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports() && Objects.equals(this.enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports()) && Objects.equals(this.dbClusterParameterGroupName(), other.dbClusterParameterGroupName()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainIAMRoleName(), other.domainIAMRoleName());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreDbClusterToPointInTimeRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("RestoreType", (Object)this.restoreType()).add("SourceDBClusterIdentifier", (Object)this.sourceDBClusterIdentifier()).add("RestoreToTime", (Object)this.restoreToTime()).add("UseLatestRestorableTime", (Object)this.useLatestRestorableTime()).add("Port", (Object)this.port()).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("OptionGroupName", (Object)this.optionGroupName()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyId", (Object)this.kmsKeyId()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("BacktrackWindow", (Object)this.backtrackWindow()).add("EnableCloudwatchLogsExports", this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null).add("DBClusterParameterGroupName", (Object)this.dbClusterParameterGroupName()).add("DeletionProtection", (Object)this.deletionProtection()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("Domain", (Object)this.domain()).add("DomainIAMRoleName", (Object)this.domainIAMRoleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "RestoreType": {
                return Optional.ofNullable(clazz.cast(this.restoreType()));
            }
            case "SourceDBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBClusterIdentifier()));
            }
            case "RestoreToTime": {
                return Optional.ofNullable(clazz.cast(this.restoreToTime()));
            }
            case "UseLatestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.useLatestRestorableTime()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "BacktrackWindow": {
                return Optional.ofNullable(clazz.cast(this.backtrackWindow()));
            }
            case "EnableCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enableCloudwatchLogsExports()));
            }
            case "DBClusterParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroupName()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "DomainIAMRoleName": {
                return Optional.ofNullable(clazz.cast(this.domainIAMRoleName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbClusterToPointInTimeRequest, T> g) {
        return obj -> g.apply((RestoreDbClusterToPointInTimeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String restoreType;
        private String sourceDBClusterIdentifier;
        private Instant restoreToTime;
        private Boolean useLatestRestorableTime;
        private Integer port;
        private String dbSubnetGroupName;
        private String optionGroupName;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private Boolean enableIAMDatabaseAuthentication;
        private Long backtrackWindow;
        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private String dbClusterParameterGroupName;
        private Boolean deletionProtection;
        private Boolean copyTagsToSnapshot;
        private String domain;
        private String domainIAMRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbClusterToPointInTimeRequest model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.restoreType(model.restoreType);
            this.sourceDBClusterIdentifier(model.sourceDBClusterIdentifier);
            this.restoreToTime(model.restoreToTime);
            this.useLatestRestorableTime(model.useLatestRestorableTime);
            this.port(model.port);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.optionGroupName(model.optionGroupName);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.backtrackWindow(model.backtrackWindow);
            this.enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            this.dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            this.deletionProtection(model.deletionProtection);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.domain(model.domain);
            this.domainIAMRoleName(model.domainIAMRoleName);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getRestoreType() {
            return this.restoreType;
        }

        @Override
        public final Builder restoreType(String restoreType) {
            this.restoreType = restoreType;
            return this;
        }

        public final void setRestoreType(String restoreType) {
            this.restoreType = restoreType;
        }

        public final String getSourceDBClusterIdentifier() {
            return this.sourceDBClusterIdentifier;
        }

        @Override
        public final Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
            return this;
        }

        public final void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        }

        public final Instant getRestoreToTime() {
            return this.restoreToTime;
        }

        @Override
        public final Builder restoreToTime(Instant restoreToTime) {
            this.restoreToTime = restoreToTime;
            return this;
        }

        public final void setRestoreToTime(Instant restoreToTime) {
            this.restoreToTime = restoreToTime;
        }

        public final Boolean getUseLatestRestorableTime() {
            return this.useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final Long getBacktrackWindow() {
            return this.backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (this.enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enableCloudwatchLogsExports;
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String ... enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        public final String getDbClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainIAMRoleName() {
            return this.domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbClusterToPointInTimeRequest build() {
            return new RestoreDbClusterToPointInTimeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreDbClusterToPointInTimeRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder restoreType(String var1);

        public Builder sourceDBClusterIdentifier(String var1);

        public Builder restoreToTime(Instant var1);

        public Builder useLatestRestorableTime(Boolean var1);

        public Builder port(Integer var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder optionGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder kmsKeyId(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder backtrackWindow(Long var1);

        public Builder enableCloudwatchLogsExports(Collection<String> var1);

        public Builder enableCloudwatchLogsExports(String ... var1);

        public Builder dbClusterParameterGroupName(String var1);

        public Builder deletionProtection(Boolean var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder domain(String var1);

        public Builder domainIAMRoleName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

