/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rbin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRulesRequest extends RbinRequest implements ToCopyableBuilder<ListRulesRequest.Builder, ListRulesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListRulesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRulesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ListRulesRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("ResourceTags")
            .getter(getter(ListRulesRequest::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOCK_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LockState").getter(getter(ListRulesRequest::lockStateAsString)).setter(setter(Builder::lockState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_TAGS_FIELD, LOCK_STATE_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String resourceType;

    private final List<ResourceTag> resourceTags;

    private final String lockState;

    private ListRulesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.resourceType = builder.resourceType;
        this.resourceTags = builder.resourceTags;
        this.lockState = builder.lockState;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>NextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The resource type retained by the retention rule. Only retention rules that retain the specified resource type
     * are listed. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To list retention rules that
     * retain snapshots, specify <code>EBS_SNAPSHOT</code>. To list retention rules that retain EBS-backed AMIs, specify
     * <code>EC2_IMAGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type retained by the retention rule. Only retention rules that retain the specified resource
     *         type are listed. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To list
     *         retention rules that retain snapshots, specify <code>EBS_SNAPSHOT</code>. To list retention rules that
     *         retain EBS-backed AMIs, specify <code>EC2_IMAGE</code>.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type retained by the retention rule. Only retention rules that retain the specified resource type
     * are listed. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To list retention rules that
     * retain snapshots, specify <code>EBS_SNAPSHOT</code>. To list retention rules that retain EBS-backed AMIs, specify
     * <code>EC2_IMAGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type retained by the retention rule. Only retention rules that retain the specified resource
     *         type are listed. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To list
     *         retention rules that retain snapshots, specify <code>EBS_SNAPSHOT</code>. To list retention rules that
     *         retain EBS-backed AMIs, specify <code>EC2_IMAGE</code>.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resource tags used to identify resources that are retained by the retention rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return Information about the resource tags used to identify resources that are retained by the retention rule.
     */
    public final List<ResourceTag> resourceTags() {
        return resourceTags;
    }

    /**
     * <p>
     * The lock state of the retention rules to list. Only retention rules with the specified lock state are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return The lock state of the retention rules to list. Only retention rules with the specified lock state are
     *         returned.
     * @see LockState
     */
    public final LockState lockState() {
        return LockState.fromValue(lockState);
    }

    /**
     * <p>
     * The lock state of the retention rules to list. Only retention rules with the specified lock state are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return The lock state of the retention rules to list. Only retention rules with the specified lock state are
     *         returned.
     * @see LockState
     */
    public final String lockStateAsString() {
        return lockState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lockStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRulesRequest)) {
            return false;
        }
        ListRulesRequest other = (ListRulesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && hasResourceTags() == other.hasResourceTags() && Objects.equals(resourceTags(), other.resourceTags())
                && Objects.equals(lockStateAsString(), other.lockStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRulesRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ResourceType", resourceTypeAsString()).add("ResourceTags", hasResourceTags() ? resourceTags() : null)
                .add("LockState", lockStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "LockState":
            return Optional.ofNullable(clazz.cast(lockStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRulesRequest, T> g) {
        return obj -> g.apply((ListRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RbinRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRulesRequest> {
        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The resource type retained by the retention rule. Only retention rules that retain the specified resource
         * type are listed. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To list retention
         * rules that retain snapshots, specify <code>EBS_SNAPSHOT</code>. To list retention rules that retain
         * EBS-backed AMIs, specify <code>EC2_IMAGE</code>.
         * </p>
         * 
         * @param resourceType
         *        The resource type retained by the retention rule. Only retention rules that retain the specified
         *        resource type are listed. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To
         *        list retention rules that retain snapshots, specify <code>EBS_SNAPSHOT</code>. To list retention rules
         *        that retain EBS-backed AMIs, specify <code>EC2_IMAGE</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type retained by the retention rule. Only retention rules that retain the specified resource
         * type are listed. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To list retention
         * rules that retain snapshots, specify <code>EBS_SNAPSHOT</code>. To list retention rules that retain
         * EBS-backed AMIs, specify <code>EC2_IMAGE</code>.
         * </p>
         * 
         * @param resourceType
         *        The resource type retained by the retention rule. Only retention rules that retain the specified
         *        resource type are listed. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To
         *        list retention rules that retain snapshots, specify <code>EBS_SNAPSHOT</code>. To list retention rules
         *        that retain EBS-backed AMIs, specify <code>EC2_IMAGE</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * Information about the resource tags used to identify resources that are retained by the retention rule.
         * </p>
         * 
         * @param resourceTags
         *        Information about the resource tags used to identify resources that are retained by the retention
         *        rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<ResourceTag> resourceTags);

        /**
         * <p>
         * Information about the resource tags used to identify resources that are retained by the retention rule.
         * </p>
         * 
         * @param resourceTags
         *        Information about the resource tags used to identify resources that are retained by the retention
         *        rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(ResourceTag... resourceTags);

        /**
         * <p>
         * Information about the resource tags used to identify resources that are retained by the retention rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rbin.model.ResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceTags(List<ResourceTag>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rbin.model.ResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(java.util.Collection<ResourceTag>)
         */
        Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags);

        /**
         * <p>
         * The lock state of the retention rules to list. Only retention rules with the specified lock state are
         * returned.
         * </p>
         * 
         * @param lockState
         *        The lock state of the retention rules to list. Only retention rules with the specified lock state are
         *        returned.
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(String lockState);

        /**
         * <p>
         * The lock state of the retention rules to list. Only retention rules with the specified lock state are
         * returned.
         * </p>
         * 
         * @param lockState
         *        The lock state of the retention rules to list. Only retention rules with the specified lock state are
         *        returned.
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(LockState lockState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RbinRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String resourceType;

        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private String lockState;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRulesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            resourceType(model.resourceType);
            resourceTags(model.resourceTags);
            lockState(model.lockState);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagsCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> ResourceTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getLockState() {
            return lockState;
        }

        public final void setLockState(String lockState) {
            this.lockState = lockState;
        }

        @Override
        public final Builder lockState(String lockState) {
            this.lockState = lockState;
            return this;
        }

        @Override
        public final Builder lockState(LockState lockState) {
            this.lockState(lockState == null ? null : lockState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRulesRequest build() {
            return new ListRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
