/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The feature configuration for an embedded dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisteredUserDashboardFeatureConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<RegisteredUserDashboardFeatureConfigurations.Builder, RegisteredUserDashboardFeatureConfigurations> {
    private static final SdkField<StatePersistenceConfigurations> STATE_PERSISTENCE_FIELD = SdkField
            .<StatePersistenceConfigurations> builder(MarshallingType.SDK_POJO).memberName("StatePersistence")
            .getter(getter(RegisteredUserDashboardFeatureConfigurations::statePersistence))
            .setter(setter(Builder::statePersistence)).constructor(StatePersistenceConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatePersistence").build()).build();

    private static final SdkField<BookmarksConfigurations> BOOKMARKS_FIELD = SdkField
            .<BookmarksConfigurations> builder(MarshallingType.SDK_POJO).memberName("Bookmarks")
            .getter(getter(RegisteredUserDashboardFeatureConfigurations::bookmarks)).setter(setter(Builder::bookmarks))
            .constructor(BookmarksConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bookmarks").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_PERSISTENCE_FIELD,
            BOOKMARKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final StatePersistenceConfigurations statePersistence;

    private final BookmarksConfigurations bookmarks;

    private RegisteredUserDashboardFeatureConfigurations(BuilderImpl builder) {
        this.statePersistence = builder.statePersistence;
        this.bookmarks = builder.bookmarks;
    }

    /**
     * <p>
     * The state persistence settings of an embedded dashboard.
     * </p>
     * 
     * @return The state persistence settings of an embedded dashboard.
     */
    public final StatePersistenceConfigurations statePersistence() {
        return statePersistence;
    }

    /**
     * <p>
     * The bookmarks configuration for an embedded dashboard in Amazon QuickSight.
     * </p>
     * 
     * @return The bookmarks configuration for an embedded dashboard in Amazon QuickSight.
     */
    public final BookmarksConfigurations bookmarks() {
        return bookmarks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statePersistence());
        hashCode = 31 * hashCode + Objects.hashCode(bookmarks());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredUserDashboardFeatureConfigurations)) {
            return false;
        }
        RegisteredUserDashboardFeatureConfigurations other = (RegisteredUserDashboardFeatureConfigurations) obj;
        return Objects.equals(statePersistence(), other.statePersistence()) && Objects.equals(bookmarks(), other.bookmarks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisteredUserDashboardFeatureConfigurations").add("StatePersistence", statePersistence())
                .add("Bookmarks", bookmarks()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatePersistence":
            return Optional.ofNullable(clazz.cast(statePersistence()));
        case "Bookmarks":
            return Optional.ofNullable(clazz.cast(bookmarks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisteredUserDashboardFeatureConfigurations, T> g) {
        return obj -> g.apply((RegisteredUserDashboardFeatureConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisteredUserDashboardFeatureConfigurations> {
        /**
         * <p>
         * The state persistence settings of an embedded dashboard.
         * </p>
         * 
         * @param statePersistence
         *        The state persistence settings of an embedded dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statePersistence(StatePersistenceConfigurations statePersistence);

        /**
         * <p>
         * The state persistence settings of an embedded dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatePersistenceConfigurations.Builder}
         * avoiding the need to create one manually via {@link StatePersistenceConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatePersistenceConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #statePersistence(StatePersistenceConfigurations)}.
         * 
         * @param statePersistence
         *        a consumer that will call methods on {@link StatePersistenceConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statePersistence(StatePersistenceConfigurations)
         */
        default Builder statePersistence(Consumer<StatePersistenceConfigurations.Builder> statePersistence) {
            return statePersistence(StatePersistenceConfigurations.builder().applyMutation(statePersistence).build());
        }

        /**
         * <p>
         * The bookmarks configuration for an embedded dashboard in Amazon QuickSight.
         * </p>
         * 
         * @param bookmarks
         *        The bookmarks configuration for an embedded dashboard in Amazon QuickSight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bookmarks(BookmarksConfigurations bookmarks);

        /**
         * <p>
         * The bookmarks configuration for an embedded dashboard in Amazon QuickSight.
         * </p>
         * This is a convenience method that creates an instance of the {@link BookmarksConfigurations.Builder} avoiding
         * the need to create one manually via {@link BookmarksConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BookmarksConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #bookmarks(BookmarksConfigurations)}.
         * 
         * @param bookmarks
         *        a consumer that will call methods on {@link BookmarksConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bookmarks(BookmarksConfigurations)
         */
        default Builder bookmarks(Consumer<BookmarksConfigurations.Builder> bookmarks) {
            return bookmarks(BookmarksConfigurations.builder().applyMutation(bookmarks).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StatePersistenceConfigurations statePersistence;

        private BookmarksConfigurations bookmarks;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredUserDashboardFeatureConfigurations model) {
            statePersistence(model.statePersistence);
            bookmarks(model.bookmarks);
        }

        public final StatePersistenceConfigurations.Builder getStatePersistence() {
            return statePersistence != null ? statePersistence.toBuilder() : null;
        }

        public final void setStatePersistence(StatePersistenceConfigurations.BuilderImpl statePersistence) {
            this.statePersistence = statePersistence != null ? statePersistence.build() : null;
        }

        @Override
        public final Builder statePersistence(StatePersistenceConfigurations statePersistence) {
            this.statePersistence = statePersistence;
            return this;
        }

        public final BookmarksConfigurations.Builder getBookmarks() {
            return bookmarks != null ? bookmarks.toBuilder() : null;
        }

        public final void setBookmarks(BookmarksConfigurations.BuilderImpl bookmarks) {
            this.bookmarks = bookmarks != null ? bookmarks.build() : null;
        }

        @Override
        public final Builder bookmarks(BookmarksConfigurations bookmarks) {
            this.bookmarks = bookmarks;
            return this;
        }

        @Override
        public RegisteredUserDashboardFeatureConfigurations build() {
            return new RegisteredUserDashboardFeatureConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
