/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The measure type field with numerical type columns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumericalMeasureField implements SdkPojo, Serializable,
        ToCopyableBuilder<NumericalMeasureField.Builder, NumericalMeasureField> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(NumericalMeasureField::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(NumericalMeasureField::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<NumericalAggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField
            .<NumericalAggregationFunction> builder(MarshallingType.SDK_POJO).memberName("AggregationFunction")
            .getter(getter(NumericalMeasureField::aggregationFunction)).setter(setter(Builder::aggregationFunction))
            .constructor(NumericalAggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build())
            .build();

    private static final SdkField<NumberFormatConfiguration> FORMAT_CONFIGURATION_FIELD = SdkField
            .<NumberFormatConfiguration> builder(MarshallingType.SDK_POJO).memberName("FormatConfiguration")
            .getter(getter(NumericalMeasureField::formatConfiguration)).setter(setter(Builder::formatConfiguration))
            .constructor(NumberFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, COLUMN_FIELD,
            AGGREGATION_FUNCTION_FIELD, FORMAT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final ColumnIdentifier column;

    private final NumericalAggregationFunction aggregationFunction;

    private final NumberFormatConfiguration formatConfiguration;

    private NumericalMeasureField(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.column = builder.column;
        this.aggregationFunction = builder.aggregationFunction;
        this.formatConfiguration = builder.formatConfiguration;
    }

    /**
     * <p>
     * The custom field ID.
     * </p>
     * 
     * @return The custom field ID.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The column that is used in the <code>NumericalMeasureField</code>.
     * </p>
     * 
     * @return The column that is used in the <code>NumericalMeasureField</code>.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The aggregation function of the measure field.
     * </p>
     * 
     * @return The aggregation function of the measure field.
     */
    public final NumericalAggregationFunction aggregationFunction() {
        return aggregationFunction;
    }

    /**
     * <p>
     * The format configuration of the field.
     * </p>
     * 
     * @return The format configuration of the field.
     */
    public final NumberFormatConfiguration formatConfiguration() {
        return formatConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(formatConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericalMeasureField)) {
            return false;
        }
        NumericalMeasureField other = (NumericalMeasureField) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(column(), other.column())
                && Objects.equals(aggregationFunction(), other.aggregationFunction())
                && Objects.equals(formatConfiguration(), other.formatConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumericalMeasureField").add("FieldId", fieldId()).add("Column", column())
                .add("AggregationFunction", aggregationFunction()).add("FormatConfiguration", formatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "AggregationFunction":
            return Optional.ofNullable(clazz.cast(aggregationFunction()));
        case "FormatConfiguration":
            return Optional.ofNullable(clazz.cast(formatConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumericalMeasureField, T> g) {
        return obj -> g.apply((NumericalMeasureField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumericalMeasureField> {
        /**
         * <p>
         * The custom field ID.
         * </p>
         * 
         * @param fieldId
         *        The custom field ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The column that is used in the <code>NumericalMeasureField</code>.
         * </p>
         * 
         * @param column
         *        The column that is used in the <code>NumericalMeasureField</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that is used in the <code>NumericalMeasureField</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The aggregation function of the measure field.
         * </p>
         * 
         * @param aggregationFunction
         *        The aggregation function of the measure field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationFunction(NumericalAggregationFunction aggregationFunction);

        /**
         * <p>
         * The aggregation function of the measure field.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericalAggregationFunction.Builder}
         * avoiding the need to create one manually via {@link NumericalAggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericalAggregationFunction.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregationFunction(NumericalAggregationFunction)}.
         * 
         * @param aggregationFunction
         *        a consumer that will call methods on {@link NumericalAggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationFunction(NumericalAggregationFunction)
         */
        default Builder aggregationFunction(Consumer<NumericalAggregationFunction.Builder> aggregationFunction) {
            return aggregationFunction(NumericalAggregationFunction.builder().applyMutation(aggregationFunction).build());
        }

        /**
         * <p>
         * The format configuration of the field.
         * </p>
         * 
         * @param formatConfiguration
         *        The format configuration of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatConfiguration(NumberFormatConfiguration formatConfiguration);

        /**
         * <p>
         * The format configuration of the field.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumberFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link NumberFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumberFormatConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #formatConfiguration(NumberFormatConfiguration)}.
         * 
         * @param formatConfiguration
         *        a consumer that will call methods on {@link NumberFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formatConfiguration(NumberFormatConfiguration)
         */
        default Builder formatConfiguration(Consumer<NumberFormatConfiguration.Builder> formatConfiguration) {
            return formatConfiguration(NumberFormatConfiguration.builder().applyMutation(formatConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private ColumnIdentifier column;

        private NumericalAggregationFunction aggregationFunction;

        private NumberFormatConfiguration formatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericalMeasureField model) {
            fieldId(model.fieldId);
            column(model.column);
            aggregationFunction(model.aggregationFunction);
            formatConfiguration(model.formatConfiguration);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final NumericalAggregationFunction.Builder getAggregationFunction() {
            return aggregationFunction != null ? aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(NumericalAggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(NumericalAggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        public final NumberFormatConfiguration.Builder getFormatConfiguration() {
            return formatConfiguration != null ? formatConfiguration.toBuilder() : null;
        }

        public final void setFormatConfiguration(NumberFormatConfiguration.BuilderImpl formatConfiguration) {
            this.formatConfiguration = formatConfiguration != null ? formatConfiguration.build() : null;
        }

        @Override
        public final Builder formatConfiguration(NumberFormatConfiguration formatConfiguration) {
            this.formatConfiguration = formatConfiguration;
            return this;
        }

        @Override
        public NumericalMeasureField build() {
            return new NumericalMeasureField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
