/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIngestionRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateIngestionRequest.Builder, CreateIngestionRequest> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(CreateIngestionRequest::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()).build();

    private static final SdkField<String> INGESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngestionId").getter(getter(CreateIngestionRequest::ingestionId)).setter(setter(Builder::ingestionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IngestionId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateIngestionRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> INGESTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngestionType").getter(getter(CreateIngestionRequest::ingestionTypeAsString))
            .setter(setter(Builder::ingestionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD,
            INGESTION_ID_FIELD, AWS_ACCOUNT_ID_FIELD, INGESTION_TYPE_FIELD));

    private final String dataSetId;

    private final String ingestionId;

    private final String awsAccountId;

    private final String ingestionType;

    private CreateIngestionRequest(BuilderImpl builder) {
        super(builder);
        this.dataSetId = builder.dataSetId;
        this.ingestionId = builder.ingestionId;
        this.awsAccountId = builder.awsAccountId;
        this.ingestionType = builder.ingestionType;
    }

    /**
     * <p>
     * The ID of the dataset used in the ingestion.
     * </p>
     * 
     * @return The ID of the dataset used in the ingestion.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * An ID for the ingestion.
     * </p>
     * 
     * @return An ID for the ingestion.
     */
    public final String ingestionId() {
        return ingestionId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The type of ingestion that you want to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionType}
     * will return {@link IngestionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionTypeAsString}.
     * </p>
     * 
     * @return The type of ingestion that you want to create.
     * @see IngestionType
     */
    public final IngestionType ingestionType() {
        return IngestionType.fromValue(ingestionType);
    }

    /**
     * <p>
     * The type of ingestion that you want to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionType}
     * will return {@link IngestionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionTypeAsString}.
     * </p>
     * 
     * @return The type of ingestion that you want to create.
     * @see IngestionType
     */
    public final String ingestionTypeAsString() {
        return ingestionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngestionRequest)) {
            return false;
        }
        CreateIngestionRequest other = (CreateIngestionRequest) obj;
        return Objects.equals(dataSetId(), other.dataSetId()) && Objects.equals(ingestionId(), other.ingestionId())
                && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(ingestionTypeAsString(), other.ingestionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIngestionRequest").add("DataSetId", dataSetId()).add("IngestionId", ingestionId())
                .add("AwsAccountId", awsAccountId()).add("IngestionType", ingestionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "IngestionId":
            return Optional.ofNullable(clazz.cast(ingestionId()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "IngestionType":
            return Optional.ofNullable(clazz.cast(ingestionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIngestionRequest, T> g) {
        return obj -> g.apply((CreateIngestionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIngestionRequest> {
        /**
         * <p>
         * The ID of the dataset used in the ingestion.
         * </p>
         * 
         * @param dataSetId
         *        The ID of the dataset used in the ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * An ID for the ingestion.
         * </p>
         * 
         * @param ingestionId
         *        An ID for the ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionId(String ingestionId);

        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The type of ingestion that you want to create.
         * </p>
         * 
         * @param ingestionType
         *        The type of ingestion that you want to create.
         * @see IngestionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionType
         */
        Builder ingestionType(String ingestionType);

        /**
         * <p>
         * The type of ingestion that you want to create.
         * </p>
         * 
         * @param ingestionType
         *        The type of ingestion that you want to create.
         * @see IngestionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionType
         */
        Builder ingestionType(IngestionType ingestionType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String dataSetId;

        private String ingestionId;

        private String awsAccountId;

        private String ingestionType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIngestionRequest model) {
            super(model);
            dataSetId(model.dataSetId);
            ingestionId(model.ingestionId);
            awsAccountId(model.awsAccountId);
            ingestionType(model.ingestionType);
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getIngestionId() {
            return ingestionId;
        }

        public final void setIngestionId(String ingestionId) {
            this.ingestionId = ingestionId;
        }

        @Override
        public final Builder ingestionId(String ingestionId) {
            this.ingestionId = ingestionId;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getIngestionType() {
            return ingestionType;
        }

        public final void setIngestionType(String ingestionType) {
            this.ingestionType = ingestionType;
        }

        @Override
        public final Builder ingestionType(String ingestionType) {
            this.ingestionType = ingestionType;
            return this;
        }

        @Override
        public final Builder ingestionType(IngestionType ingestionType) {
            this.ingestionType(ingestionType == null ? null : ingestionType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIngestionRequest build() {
            return new CreateIngestionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
