/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A text box.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetTextBox implements SdkPojo, Serializable, ToCopyableBuilder<SheetTextBox.Builder, SheetTextBox> {
    private static final SdkField<String> SHEET_TEXT_BOX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SheetTextBoxId").getter(getter(SheetTextBox::sheetTextBoxId)).setter(setter(Builder::sheetTextBoxId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetTextBoxId").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(SheetTextBox::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_TEXT_BOX_ID_FIELD,
            CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sheetTextBoxId;

    private final String content;

    private SheetTextBox(BuilderImpl builder) {
        this.sheetTextBoxId = builder.sheetTextBoxId;
        this.content = builder.content;
    }

    /**
     * <p>
     * The unique identifier for a text box. This identifier must be unique within the context of a dashboard, template,
     * or analysis. Two dashboards, analyses, or templates can have text boxes that share identifiers.
     * </p>
     * 
     * @return The unique identifier for a text box. This identifier must be unique within the context of a dashboard,
     *         template, or analysis. Two dashboards, analyses, or templates can have text boxes that share identifiers.
     */
    public final String sheetTextBoxId() {
        return sheetTextBoxId;
    }

    /**
     * <p>
     * The content that is displayed in the text box.
     * </p>
     * 
     * @return The content that is displayed in the text box.
     */
    public final String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sheetTextBoxId());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetTextBox)) {
            return false;
        }
        SheetTextBox other = (SheetTextBox) obj;
        return Objects.equals(sheetTextBoxId(), other.sheetTextBoxId()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SheetTextBox").add("SheetTextBoxId", sheetTextBoxId()).add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SheetTextBoxId":
            return Optional.ofNullable(clazz.cast(sheetTextBoxId()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SheetTextBox, T> g) {
        return obj -> g.apply((SheetTextBox) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetTextBox> {
        /**
         * <p>
         * The unique identifier for a text box. This identifier must be unique within the context of a dashboard,
         * template, or analysis. Two dashboards, analyses, or templates can have text boxes that share identifiers.
         * </p>
         * 
         * @param sheetTextBoxId
         *        The unique identifier for a text box. This identifier must be unique within the context of a
         *        dashboard, template, or analysis. Two dashboards, analyses, or templates can have text boxes that
         *        share identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetTextBoxId(String sheetTextBoxId);

        /**
         * <p>
         * The content that is displayed in the text box.
         * </p>
         * 
         * @param content
         *        The content that is displayed in the text box.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);
    }

    static final class BuilderImpl implements Builder {
        private String sheetTextBoxId;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetTextBox model) {
            sheetTextBoxId(model.sheetTextBoxId);
            content(model.content);
        }

        public final String getSheetTextBoxId() {
            return sheetTextBoxId;
        }

        public final void setSheetTextBoxId(String sheetTextBoxId) {
            this.sheetTextBoxId = sheetTextBoxId;
        }

        @Override
        public final Builder sheetTextBoxId(String sheetTextBoxId) {
            this.sheetTextBoxId = sheetTextBoxId;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public SheetTextBox build() {
            return new SheetTextBox(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
