/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a <code>RadarChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RadarChartConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RadarChartConfiguration.Builder, RadarChartConfiguration> {
    private static final SdkField<RadarChartFieldWells> FIELD_WELLS_FIELD = SdkField
            .<RadarChartFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(RadarChartConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(RadarChartFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<RadarChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<RadarChartSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(RadarChartConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(RadarChartSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<String> SHAPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Shape")
            .getter(getter(RadarChartConfiguration::shapeAsString)).setter(setter(Builder::shape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shape").build()).build();

    private static final SdkField<RadarChartSeriesSettings> BASE_SERIES_SETTINGS_FIELD = SdkField
            .<RadarChartSeriesSettings> builder(MarshallingType.SDK_POJO).memberName("BaseSeriesSettings")
            .getter(getter(RadarChartConfiguration::baseSeriesSettings)).setter(setter(Builder::baseSeriesSettings))
            .constructor(RadarChartSeriesSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseSeriesSettings").build())
            .build();

    private static final SdkField<Double> START_ANGLE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StartAngle").getter(getter(RadarChartConfiguration::startAngle)).setter(setter(Builder::startAngle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartAngle").build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(RadarChartConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final SdkField<String> ALTERNATE_BAND_COLORS_VISIBILITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AlternateBandColorsVisibility")
            .getter(getter(RadarChartConfiguration::alternateBandColorsVisibilityAsString))
            .setter(setter(Builder::alternateBandColorsVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateBandColorsVisibility")
                    .build()).build();

    private static final SdkField<String> ALTERNATE_BAND_EVEN_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlternateBandEvenColor").getter(getter(RadarChartConfiguration::alternateBandEvenColor))
            .setter(setter(Builder::alternateBandEvenColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateBandEvenColor").build())
            .build();

    private static final SdkField<String> ALTERNATE_BAND_ODD_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlternateBandOddColor").getter(getter(RadarChartConfiguration::alternateBandOddColor))
            .setter(setter(Builder::alternateBandOddColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateBandOddColor").build())
            .build();

    private static final SdkField<AxisDisplayOptions> CATEGORY_AXIS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryAxis")
            .getter(getter(RadarChartConfiguration::categoryAxis)).setter(setter(Builder::categoryAxis))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryAxis").build()).build();

    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryLabelOptions")
            .getter(getter(RadarChartConfiguration::categoryLabelOptions)).setter(setter(Builder::categoryLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build())
            .build();

    private static final SdkField<AxisDisplayOptions> COLOR_AXIS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("ColorAxis")
            .getter(getter(RadarChartConfiguration::colorAxis)).setter(setter(Builder::colorAxis))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorAxis").build()).build();

    private static final SdkField<ChartAxisLabelOptions> COLOR_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("ColorLabelOptions")
            .getter(getter(RadarChartConfiguration::colorLabelOptions)).setter(setter(Builder::colorLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorLabelOptions").build()).build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(RadarChartConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, SHAPE_FIELD, BASE_SERIES_SETTINGS_FIELD, START_ANGLE_FIELD, VISUAL_PALETTE_FIELD,
            ALTERNATE_BAND_COLORS_VISIBILITY_FIELD, ALTERNATE_BAND_EVEN_COLOR_FIELD, ALTERNATE_BAND_ODD_COLOR_FIELD,
            CATEGORY_AXIS_FIELD, CATEGORY_LABEL_OPTIONS_FIELD, COLOR_AXIS_FIELD, COLOR_LABEL_OPTIONS_FIELD, LEGEND_FIELD));

    private static final long serialVersionUID = 1L;

    private final RadarChartFieldWells fieldWells;

    private final RadarChartSortConfiguration sortConfiguration;

    private final String shape;

    private final RadarChartSeriesSettings baseSeriesSettings;

    private final Double startAngle;

    private final VisualPalette visualPalette;

    private final String alternateBandColorsVisibility;

    private final String alternateBandEvenColor;

    private final String alternateBandOddColor;

    private final AxisDisplayOptions categoryAxis;

    private final ChartAxisLabelOptions categoryLabelOptions;

    private final AxisDisplayOptions colorAxis;

    private final ChartAxisLabelOptions colorLabelOptions;

    private final LegendOptions legend;

    private RadarChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.shape = builder.shape;
        this.baseSeriesSettings = builder.baseSeriesSettings;
        this.startAngle = builder.startAngle;
        this.visualPalette = builder.visualPalette;
        this.alternateBandColorsVisibility = builder.alternateBandColorsVisibility;
        this.alternateBandEvenColor = builder.alternateBandEvenColor;
        this.alternateBandOddColor = builder.alternateBandOddColor;
        this.categoryAxis = builder.categoryAxis;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.colorAxis = builder.colorAxis;
        this.colorLabelOptions = builder.colorLabelOptions;
        this.legend = builder.legend;
    }

    /**
     * <p>
     * The field well configuration of a <code>RadarChartVisual</code>.
     * </p>
     * 
     * @return The field well configuration of a <code>RadarChartVisual</code>.
     */
    public final RadarChartFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a <code>RadarChartVisual</code>.
     * </p>
     * 
     * @return The sort configuration of a <code>RadarChartVisual</code>.
     */
    public final RadarChartSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The shape of the radar chart.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shape} will return
     * {@link RadarChartShape#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shapeAsString}.
     * </p>
     * 
     * @return The shape of the radar chart.
     * @see RadarChartShape
     */
    public final RadarChartShape shape() {
        return RadarChartShape.fromValue(shape);
    }

    /**
     * <p>
     * The shape of the radar chart.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shape} will return
     * {@link RadarChartShape#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shapeAsString}.
     * </p>
     * 
     * @return The shape of the radar chart.
     * @see RadarChartShape
     */
    public final String shapeAsString() {
        return shape;
    }

    /**
     * <p>
     * The base sreies settings of a radar chart.
     * </p>
     * 
     * @return The base sreies settings of a radar chart.
     */
    public final RadarChartSeriesSettings baseSeriesSettings() {
        return baseSeriesSettings;
    }

    /**
     * <p>
     * The start angle of a radar chart's axis.
     * </p>
     * 
     * @return The start angle of a radar chart's axis.
     */
    public final Double startAngle() {
        return startAngle;
    }

    /**
     * <p>
     * The palette (chart color) display setup of the visual.
     * </p>
     * 
     * @return The palette (chart color) display setup of the visual.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    /**
     * <p>
     * Determines the visibility of the colors of alternatign bands in a radar chart.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #alternateBandColorsVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #alternateBandColorsVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the colors of alternatign bands in a radar chart.
     * @see Visibility
     */
    public final Visibility alternateBandColorsVisibility() {
        return Visibility.fromValue(alternateBandColorsVisibility);
    }

    /**
     * <p>
     * Determines the visibility of the colors of alternatign bands in a radar chart.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #alternateBandColorsVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #alternateBandColorsVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the colors of alternatign bands in a radar chart.
     * @see Visibility
     */
    public final String alternateBandColorsVisibilityAsString() {
        return alternateBandColorsVisibility;
    }

    /**
     * <p>
     * The color of the even-numbered alternate bands of a radar chart.
     * </p>
     * 
     * @return The color of the even-numbered alternate bands of a radar chart.
     */
    public final String alternateBandEvenColor() {
        return alternateBandEvenColor;
    }

    /**
     * <p>
     * The color of the odd-numbered alternate bands of a radar chart.
     * </p>
     * 
     * @return The color of the odd-numbered alternate bands of a radar chart.
     */
    public final String alternateBandOddColor() {
        return alternateBandOddColor;
    }

    /**
     * <p>
     * The category axis of a radar chart.
     * </p>
     * 
     * @return The category axis of a radar chart.
     */
    public final AxisDisplayOptions categoryAxis() {
        return categoryAxis;
    }

    /**
     * <p>
     * The category label options of a radar chart.
     * </p>
     * 
     * @return The category label options of a radar chart.
     */
    public final ChartAxisLabelOptions categoryLabelOptions() {
        return categoryLabelOptions;
    }

    /**
     * <p>
     * The color axis of a radar chart.
     * </p>
     * 
     * @return The color axis of a radar chart.
     */
    public final AxisDisplayOptions colorAxis() {
        return colorAxis;
    }

    /**
     * <p>
     * The color label options of a radar chart.
     * </p>
     * 
     * @return The color label options of a radar chart.
     */
    public final ChartAxisLabelOptions colorLabelOptions() {
        return colorLabelOptions;
    }

    /**
     * <p>
     * The legend display setup of the visual.
     * </p>
     * 
     * @return The legend display setup of the visual.
     */
    public final LegendOptions legend() {
        return legend;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(shapeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(baseSeriesSettings());
        hashCode = 31 * hashCode + Objects.hashCode(startAngle());
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(alternateBandColorsVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(alternateBandEvenColor());
        hashCode = 31 * hashCode + Objects.hashCode(alternateBandOddColor());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAxis());
        hashCode = 31 * hashCode + Objects.hashCode(categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(colorAxis());
        hashCode = 31 * hashCode + Objects.hashCode(colorLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RadarChartConfiguration)) {
            return false;
        }
        RadarChartConfiguration other = (RadarChartConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(shapeAsString(), other.shapeAsString())
                && Objects.equals(baseSeriesSettings(), other.baseSeriesSettings())
                && Objects.equals(startAngle(), other.startAngle()) && Objects.equals(visualPalette(), other.visualPalette())
                && Objects.equals(alternateBandColorsVisibilityAsString(), other.alternateBandColorsVisibilityAsString())
                && Objects.equals(alternateBandEvenColor(), other.alternateBandEvenColor())
                && Objects.equals(alternateBandOddColor(), other.alternateBandOddColor())
                && Objects.equals(categoryAxis(), other.categoryAxis())
                && Objects.equals(categoryLabelOptions(), other.categoryLabelOptions())
                && Objects.equals(colorAxis(), other.colorAxis())
                && Objects.equals(colorLabelOptions(), other.colorLabelOptions()) && Objects.equals(legend(), other.legend());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RadarChartConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("Shape", shapeAsString())
                .add("BaseSeriesSettings", baseSeriesSettings()).add("StartAngle", startAngle())
                .add("VisualPalette", visualPalette())
                .add("AlternateBandColorsVisibility", alternateBandColorsVisibilityAsString())
                .add("AlternateBandEvenColor", alternateBandEvenColor()).add("AlternateBandOddColor", alternateBandOddColor())
                .add("CategoryAxis", categoryAxis()).add("CategoryLabelOptions", categoryLabelOptions())
                .add("ColorAxis", colorAxis()).add("ColorLabelOptions", colorLabelOptions()).add("Legend", legend()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "Shape":
            return Optional.ofNullable(clazz.cast(shapeAsString()));
        case "BaseSeriesSettings":
            return Optional.ofNullable(clazz.cast(baseSeriesSettings()));
        case "StartAngle":
            return Optional.ofNullable(clazz.cast(startAngle()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        case "AlternateBandColorsVisibility":
            return Optional.ofNullable(clazz.cast(alternateBandColorsVisibilityAsString()));
        case "AlternateBandEvenColor":
            return Optional.ofNullable(clazz.cast(alternateBandEvenColor()));
        case "AlternateBandOddColor":
            return Optional.ofNullable(clazz.cast(alternateBandOddColor()));
        case "CategoryAxis":
            return Optional.ofNullable(clazz.cast(categoryAxis()));
        case "CategoryLabelOptions":
            return Optional.ofNullable(clazz.cast(categoryLabelOptions()));
        case "ColorAxis":
            return Optional.ofNullable(clazz.cast(colorAxis()));
        case "ColorLabelOptions":
            return Optional.ofNullable(clazz.cast(colorLabelOptions()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RadarChartConfiguration, T> g) {
        return obj -> g.apply((RadarChartConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RadarChartConfiguration> {
        /**
         * <p>
         * The field well configuration of a <code>RadarChartVisual</code>.
         * </p>
         * 
         * @param fieldWells
         *        The field well configuration of a <code>RadarChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(RadarChartFieldWells fieldWells);

        /**
         * <p>
         * The field well configuration of a <code>RadarChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RadarChartFieldWells.Builder} avoiding
         * the need to create one manually via {@link RadarChartFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RadarChartFieldWells.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldWells(RadarChartFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link RadarChartFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(RadarChartFieldWells)
         */
        default Builder fieldWells(Consumer<RadarChartFieldWells.Builder> fieldWells) {
            return fieldWells(RadarChartFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a <code>RadarChartVisual</code>.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a <code>RadarChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(RadarChartSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a <code>RadarChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RadarChartSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link RadarChartSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RadarChartSortConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sortConfiguration(RadarChartSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link RadarChartSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(RadarChartSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<RadarChartSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(RadarChartSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The shape of the radar chart.
         * </p>
         * 
         * @param shape
         *        The shape of the radar chart.
         * @see RadarChartShape
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RadarChartShape
         */
        Builder shape(String shape);

        /**
         * <p>
         * The shape of the radar chart.
         * </p>
         * 
         * @param shape
         *        The shape of the radar chart.
         * @see RadarChartShape
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RadarChartShape
         */
        Builder shape(RadarChartShape shape);

        /**
         * <p>
         * The base sreies settings of a radar chart.
         * </p>
         * 
         * @param baseSeriesSettings
         *        The base sreies settings of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseSeriesSettings(RadarChartSeriesSettings baseSeriesSettings);

        /**
         * <p>
         * The base sreies settings of a radar chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link RadarChartSeriesSettings.Builder}
         * avoiding the need to create one manually via {@link RadarChartSeriesSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RadarChartSeriesSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #baseSeriesSettings(RadarChartSeriesSettings)}.
         * 
         * @param baseSeriesSettings
         *        a consumer that will call methods on {@link RadarChartSeriesSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baseSeriesSettings(RadarChartSeriesSettings)
         */
        default Builder baseSeriesSettings(Consumer<RadarChartSeriesSettings.Builder> baseSeriesSettings) {
            return baseSeriesSettings(RadarChartSeriesSettings.builder().applyMutation(baseSeriesSettings).build());
        }

        /**
         * <p>
         * The start angle of a radar chart's axis.
         * </p>
         * 
         * @param startAngle
         *        The start angle of a radar chart's axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAngle(Double startAngle);

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * 
         * @param visualPalette
         *        The palette (chart color) display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }

        /**
         * <p>
         * Determines the visibility of the colors of alternatign bands in a radar chart.
         * </p>
         * 
         * @param alternateBandColorsVisibility
         *        Determines the visibility of the colors of alternatign bands in a radar chart.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder alternateBandColorsVisibility(String alternateBandColorsVisibility);

        /**
         * <p>
         * Determines the visibility of the colors of alternatign bands in a radar chart.
         * </p>
         * 
         * @param alternateBandColorsVisibility
         *        Determines the visibility of the colors of alternatign bands in a radar chart.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder alternateBandColorsVisibility(Visibility alternateBandColorsVisibility);

        /**
         * <p>
         * The color of the even-numbered alternate bands of a radar chart.
         * </p>
         * 
         * @param alternateBandEvenColor
         *        The color of the even-numbered alternate bands of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateBandEvenColor(String alternateBandEvenColor);

        /**
         * <p>
         * The color of the odd-numbered alternate bands of a radar chart.
         * </p>
         * 
         * @param alternateBandOddColor
         *        The color of the odd-numbered alternate bands of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateBandOddColor(String alternateBandOddColor);

        /**
         * <p>
         * The category axis of a radar chart.
         * </p>
         * 
         * @param categoryAxis
         *        The category axis of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryAxis(AxisDisplayOptions categoryAxis);

        /**
         * <p>
         * The category axis of a radar chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #categoryAxis(AxisDisplayOptions)}.
         * 
         * @param categoryAxis
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryAxis(AxisDisplayOptions)
         */
        default Builder categoryAxis(Consumer<AxisDisplayOptions.Builder> categoryAxis) {
            return categoryAxis(AxisDisplayOptions.builder().applyMutation(categoryAxis).build());
        }

        /**
         * <p>
         * The category label options of a radar chart.
         * </p>
         * 
         * @param categoryLabelOptions
         *        The category label options of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions);

        /**
         * <p>
         * The category label options of a radar chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #categoryLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param categoryLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryLabelOptions(ChartAxisLabelOptions)
         */
        default Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return categoryLabelOptions(ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions).build());
        }

        /**
         * <p>
         * The color axis of a radar chart.
         * </p>
         * 
         * @param colorAxis
         *        The color axis of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorAxis(AxisDisplayOptions colorAxis);

        /**
         * <p>
         * The color axis of a radar chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #colorAxis(AxisDisplayOptions)}.
         * 
         * @param colorAxis
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorAxis(AxisDisplayOptions)
         */
        default Builder colorAxis(Consumer<AxisDisplayOptions.Builder> colorAxis) {
            return colorAxis(AxisDisplayOptions.builder().applyMutation(colorAxis).build());
        }

        /**
         * <p>
         * The color label options of a radar chart.
         * </p>
         * 
         * @param colorLabelOptions
         *        The color label options of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorLabelOptions(ChartAxisLabelOptions colorLabelOptions);

        /**
         * <p>
         * The color label options of a radar chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #colorLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param colorLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorLabelOptions(ChartAxisLabelOptions)
         */
        default Builder colorLabelOptions(Consumer<ChartAxisLabelOptions.Builder> colorLabelOptions) {
            return colorLabelOptions(ChartAxisLabelOptions.builder().applyMutation(colorLabelOptions).build());
        }

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * 
         * @param legend
         *        The legend display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RadarChartFieldWells fieldWells;

        private RadarChartSortConfiguration sortConfiguration;

        private String shape;

        private RadarChartSeriesSettings baseSeriesSettings;

        private Double startAngle;

        private VisualPalette visualPalette;

        private String alternateBandColorsVisibility;

        private String alternateBandEvenColor;

        private String alternateBandOddColor;

        private AxisDisplayOptions categoryAxis;

        private ChartAxisLabelOptions categoryLabelOptions;

        private AxisDisplayOptions colorAxis;

        private ChartAxisLabelOptions colorLabelOptions;

        private LegendOptions legend;

        private BuilderImpl() {
        }

        private BuilderImpl(RadarChartConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            shape(model.shape);
            baseSeriesSettings(model.baseSeriesSettings);
            startAngle(model.startAngle);
            visualPalette(model.visualPalette);
            alternateBandColorsVisibility(model.alternateBandColorsVisibility);
            alternateBandEvenColor(model.alternateBandEvenColor);
            alternateBandOddColor(model.alternateBandOddColor);
            categoryAxis(model.categoryAxis);
            categoryLabelOptions(model.categoryLabelOptions);
            colorAxis(model.colorAxis);
            colorLabelOptions(model.colorLabelOptions);
            legend(model.legend);
        }

        public final RadarChartFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(RadarChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(RadarChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final RadarChartSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(RadarChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(RadarChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final String getShape() {
            return shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        @Override
        public final Builder shape(RadarChartShape shape) {
            this.shape(shape == null ? null : shape.toString());
            return this;
        }

        public final RadarChartSeriesSettings.Builder getBaseSeriesSettings() {
            return baseSeriesSettings != null ? baseSeriesSettings.toBuilder() : null;
        }

        public final void setBaseSeriesSettings(RadarChartSeriesSettings.BuilderImpl baseSeriesSettings) {
            this.baseSeriesSettings = baseSeriesSettings != null ? baseSeriesSettings.build() : null;
        }

        @Override
        public final Builder baseSeriesSettings(RadarChartSeriesSettings baseSeriesSettings) {
            this.baseSeriesSettings = baseSeriesSettings;
            return this;
        }

        public final Double getStartAngle() {
            return startAngle;
        }

        public final void setStartAngle(Double startAngle) {
            this.startAngle = startAngle;
        }

        @Override
        public final Builder startAngle(Double startAngle) {
            this.startAngle = startAngle;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final String getAlternateBandColorsVisibility() {
            return alternateBandColorsVisibility;
        }

        public final void setAlternateBandColorsVisibility(String alternateBandColorsVisibility) {
            this.alternateBandColorsVisibility = alternateBandColorsVisibility;
        }

        @Override
        public final Builder alternateBandColorsVisibility(String alternateBandColorsVisibility) {
            this.alternateBandColorsVisibility = alternateBandColorsVisibility;
            return this;
        }

        @Override
        public final Builder alternateBandColorsVisibility(Visibility alternateBandColorsVisibility) {
            this.alternateBandColorsVisibility(alternateBandColorsVisibility == null ? null : alternateBandColorsVisibility
                    .toString());
            return this;
        }

        public final String getAlternateBandEvenColor() {
            return alternateBandEvenColor;
        }

        public final void setAlternateBandEvenColor(String alternateBandEvenColor) {
            this.alternateBandEvenColor = alternateBandEvenColor;
        }

        @Override
        public final Builder alternateBandEvenColor(String alternateBandEvenColor) {
            this.alternateBandEvenColor = alternateBandEvenColor;
            return this;
        }

        public final String getAlternateBandOddColor() {
            return alternateBandOddColor;
        }

        public final void setAlternateBandOddColor(String alternateBandOddColor) {
            this.alternateBandOddColor = alternateBandOddColor;
        }

        @Override
        public final Builder alternateBandOddColor(String alternateBandOddColor) {
            this.alternateBandOddColor = alternateBandOddColor;
            return this;
        }

        public final AxisDisplayOptions.Builder getCategoryAxis() {
            return categoryAxis != null ? categoryAxis.toBuilder() : null;
        }

        public final void setCategoryAxis(AxisDisplayOptions.BuilderImpl categoryAxis) {
            this.categoryAxis = categoryAxis != null ? categoryAxis.build() : null;
        }

        @Override
        public final Builder categoryAxis(AxisDisplayOptions categoryAxis) {
            this.categoryAxis = categoryAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return categoryLabelOptions != null ? categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getColorAxis() {
            return colorAxis != null ? colorAxis.toBuilder() : null;
        }

        public final void setColorAxis(AxisDisplayOptions.BuilderImpl colorAxis) {
            this.colorAxis = colorAxis != null ? colorAxis.build() : null;
        }

        @Override
        public final Builder colorAxis(AxisDisplayOptions colorAxis) {
            this.colorAxis = colorAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getColorLabelOptions() {
            return colorLabelOptions != null ? colorLabelOptions.toBuilder() : null;
        }

        public final void setColorLabelOptions(ChartAxisLabelOptions.BuilderImpl colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions != null ? colorLabelOptions.build() : null;
        }

        @Override
        public final Builder colorLabelOptions(ChartAxisLabelOptions colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        @Override
        public RadarChartConfiguration build() {
            return new RadarChartConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
