/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The option that determines the text display size.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FontSize implements SdkPojo, Serializable, ToCopyableBuilder<FontSize.Builder, FontSize> {
    private static final SdkField<String> RELATIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Relative").getter(getter(FontSize::relativeAsString)).setter(setter(Builder::relative))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relative").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String relative;

    private FontSize(BuilderImpl builder) {
        this.relative = builder.relative;
    }

    /**
     * <p>
     * The lexical name for the text size, proportional to its surrounding context.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relative} will
     * return {@link RelativeFontSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #relativeAsString}.
     * </p>
     * 
     * @return The lexical name for the text size, proportional to its surrounding context.
     * @see RelativeFontSize
     */
    public final RelativeFontSize relative() {
        return RelativeFontSize.fromValue(relative);
    }

    /**
     * <p>
     * The lexical name for the text size, proportional to its surrounding context.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relative} will
     * return {@link RelativeFontSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #relativeAsString}.
     * </p>
     * 
     * @return The lexical name for the text size, proportional to its surrounding context.
     * @see RelativeFontSize
     */
    public final String relativeAsString() {
        return relative;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relativeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FontSize)) {
            return false;
        }
        FontSize other = (FontSize) obj;
        return Objects.equals(relativeAsString(), other.relativeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FontSize").add("Relative", relativeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Relative":
            return Optional.ofNullable(clazz.cast(relativeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FontSize, T> g) {
        return obj -> g.apply((FontSize) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FontSize> {
        /**
         * <p>
         * The lexical name for the text size, proportional to its surrounding context.
         * </p>
         * 
         * @param relative
         *        The lexical name for the text size, proportional to its surrounding context.
         * @see RelativeFontSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelativeFontSize
         */
        Builder relative(String relative);

        /**
         * <p>
         * The lexical name for the text size, proportional to its surrounding context.
         * </p>
         * 
         * @param relative
         *        The lexical name for the text size, proportional to its surrounding context.
         * @see RelativeFontSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelativeFontSize
         */
        Builder relative(RelativeFontSize relative);
    }

    static final class BuilderImpl implements Builder {
        private String relative;

        private BuilderImpl() {
        }

        private BuilderImpl(FontSize model) {
            relative(model.relative);
        }

        public final String getRelative() {
            return relative;
        }

        public final void setRelative(String relative) {
            this.relative = relative;
        }

        @Override
        public final Builder relative(String relative) {
            this.relative = relative;
            return this;
        }

        @Override
        public final Builder relative(RelativeFontSize relative) {
            this.relative(relative == null ? null : relative.toString());
            return this;
        }

        @Override
        public FontSize build() {
            return new FontSize(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
