/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The display options of a control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateTimePickerControlDisplayOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DateTimePickerControlDisplayOptions.Builder, DateTimePickerControlDisplayOptions> {
    private static final SdkField<LabelOptions> TITLE_OPTIONS_FIELD = SdkField.<LabelOptions> builder(MarshallingType.SDK_POJO)
            .memberName("TitleOptions").getter(getter(DateTimePickerControlDisplayOptions::titleOptions))
            .setter(setter(Builder::titleOptions)).constructor(LabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleOptions").build()).build();

    private static final SdkField<String> DATE_TIME_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateTimeFormat").getter(getter(DateTimePickerControlDisplayOptions::dateTimeFormat))
            .setter(setter(Builder::dateTimeFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_OPTIONS_FIELD,
            DATE_TIME_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final LabelOptions titleOptions;

    private final String dateTimeFormat;

    private DateTimePickerControlDisplayOptions(BuilderImpl builder) {
        this.titleOptions = builder.titleOptions;
        this.dateTimeFormat = builder.dateTimeFormat;
    }

    /**
     * <p>
     * The options to configure the title visibility, name, and font size.
     * </p>
     * 
     * @return The options to configure the title visibility, name, and font size.
     */
    public final LabelOptions titleOptions() {
        return titleOptions;
    }

    /**
     * <p>
     * Customize how dates are formatted in controls.
     * </p>
     * 
     * @return Customize how dates are formatted in controls.
     */
    public final String dateTimeFormat() {
        return dateTimeFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(titleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dateTimeFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimePickerControlDisplayOptions)) {
            return false;
        }
        DateTimePickerControlDisplayOptions other = (DateTimePickerControlDisplayOptions) obj;
        return Objects.equals(titleOptions(), other.titleOptions()) && Objects.equals(dateTimeFormat(), other.dateTimeFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateTimePickerControlDisplayOptions").add("TitleOptions", titleOptions())
                .add("DateTimeFormat", dateTimeFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TitleOptions":
            return Optional.ofNullable(clazz.cast(titleOptions()));
        case "DateTimeFormat":
            return Optional.ofNullable(clazz.cast(dateTimeFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateTimePickerControlDisplayOptions, T> g) {
        return obj -> g.apply((DateTimePickerControlDisplayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateTimePickerControlDisplayOptions> {
        /**
         * <p>
         * The options to configure the title visibility, name, and font size.
         * </p>
         * 
         * @param titleOptions
         *        The options to configure the title visibility, name, and font size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleOptions(LabelOptions titleOptions);

        /**
         * <p>
         * The options to configure the title visibility, name, and font size.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelOptions.Builder} avoiding the need
         * to create one manually via {@link LabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #titleOptions(LabelOptions)}.
         * 
         * @param titleOptions
         *        a consumer that will call methods on {@link LabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #titleOptions(LabelOptions)
         */
        default Builder titleOptions(Consumer<LabelOptions.Builder> titleOptions) {
            return titleOptions(LabelOptions.builder().applyMutation(titleOptions).build());
        }

        /**
         * <p>
         * Customize how dates are formatted in controls.
         * </p>
         * 
         * @param dateTimeFormat
         *        Customize how dates are formatted in controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeFormat(String dateTimeFormat);
    }

    static final class BuilderImpl implements Builder {
        private LabelOptions titleOptions;

        private String dateTimeFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimePickerControlDisplayOptions model) {
            titleOptions(model.titleOptions);
            dateTimeFormat(model.dateTimeFormat);
        }

        public final LabelOptions.Builder getTitleOptions() {
            return titleOptions != null ? titleOptions.toBuilder() : null;
        }

        public final void setTitleOptions(LabelOptions.BuilderImpl titleOptions) {
            this.titleOptions = titleOptions != null ? titleOptions.build() : null;
        }

        @Override
        public final Builder titleOptions(LabelOptions titleOptions) {
            this.titleOptions = titleOptions;
            return this;
        }

        public final String getDateTimeFormat() {
            return dateTimeFormat;
        }

        public final void setDateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
        }

        @Override
        public final Builder dateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        @Override
        public DateTimePickerControlDisplayOptions build() {
            return new DateTimePickerControlDisplayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
