/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The required parameters that are needed to connect to a Databricks data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabricksParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabricksParameters.Builder, DatabricksParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(DatabricksParameters::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(DatabricksParameters::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> SQL_ENDPOINT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SqlEndpointPath").getter(getter(DatabricksParameters::sqlEndpointPath))
            .setter(setter(Builder::sqlEndpointPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlEndpointPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD,
            SQL_ENDPOINT_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String host;

    private final Integer port;

    private final String sqlEndpointPath;

    private DatabricksParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.sqlEndpointPath = builder.sqlEndpointPath;
    }

    /**
     * <p>
     * The host name of the Databricks data source.
     * </p>
     * 
     * @return The host name of the Databricks data source.
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The port for the Databricks data source.
     * </p>
     * 
     * @return The port for the Databricks data source.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The HTTP path of the Databricks data source.
     * </p>
     * 
     * @return The HTTP path of the Databricks data source.
     */
    public final String sqlEndpointPath() {
        return sqlEndpointPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(sqlEndpointPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabricksParameters)) {
            return false;
        }
        DatabricksParameters other = (DatabricksParameters) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(port(), other.port())
                && Objects.equals(sqlEndpointPath(), other.sqlEndpointPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabricksParameters").add("Host", host()).add("Port", port())
                .add("SqlEndpointPath", sqlEndpointPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "SqlEndpointPath":
            return Optional.ofNullable(clazz.cast(sqlEndpointPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabricksParameters, T> g) {
        return obj -> g.apply((DatabricksParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabricksParameters> {
        /**
         * <p>
         * The host name of the Databricks data source.
         * </p>
         * 
         * @param host
         *        The host name of the Databricks data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The port for the Databricks data source.
         * </p>
         * 
         * @param port
         *        The port for the Databricks data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The HTTP path of the Databricks data source.
         * </p>
         * 
         * @param sqlEndpointPath
         *        The HTTP path of the Databricks data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlEndpointPath(String sqlEndpointPath);
    }

    static final class BuilderImpl implements Builder {
        private String host;

        private Integer port;

        private String sqlEndpointPath;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabricksParameters model) {
            host(model.host);
            port(model.port);
            sqlEndpointPath(model.sqlEndpointPath);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getSqlEndpointPath() {
            return sqlEndpointPath;
        }

        public final void setSqlEndpointPath(String sqlEndpointPath) {
            this.sqlEndpointPath = sqlEndpointPath;
        }

        @Override
        public final Builder sqlEndpointPath(String sqlEndpointPath) {
            this.sqlEndpointPath = sqlEndpointPath;
            return this;
        }

        @Override
        public DatabricksParameters build() {
            return new DatabricksParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
