/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The format of the comparison.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComparisonFormatConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComparisonFormatConfiguration.Builder, ComparisonFormatConfiguration> {
    private static final SdkField<NumberDisplayFormatConfiguration> NUMBER_DISPLAY_FORMAT_CONFIGURATION_FIELD = SdkField
            .<NumberDisplayFormatConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("NumberDisplayFormatConfiguration")
            .getter(getter(ComparisonFormatConfiguration::numberDisplayFormatConfiguration))
            .setter(setter(Builder::numberDisplayFormatConfiguration))
            .constructor(NumberDisplayFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberDisplayFormatConfiguration")
                    .build()).build();

    private static final SdkField<PercentageDisplayFormatConfiguration> PERCENTAGE_DISPLAY_FORMAT_CONFIGURATION_FIELD = SdkField
            .<PercentageDisplayFormatConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PercentageDisplayFormatConfiguration")
            .getter(getter(ComparisonFormatConfiguration::percentageDisplayFormatConfiguration))
            .setter(setter(Builder::percentageDisplayFormatConfiguration))
            .constructor(PercentageDisplayFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PercentageDisplayFormatConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_DISPLAY_FORMAT_CONFIGURATION_FIELD, PERCENTAGE_DISPLAY_FORMAT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final NumberDisplayFormatConfiguration numberDisplayFormatConfiguration;

    private final PercentageDisplayFormatConfiguration percentageDisplayFormatConfiguration;

    private ComparisonFormatConfiguration(BuilderImpl builder) {
        this.numberDisplayFormatConfiguration = builder.numberDisplayFormatConfiguration;
        this.percentageDisplayFormatConfiguration = builder.percentageDisplayFormatConfiguration;
    }

    /**
     * <p>
     * The number display format.
     * </p>
     * 
     * @return The number display format.
     */
    public final NumberDisplayFormatConfiguration numberDisplayFormatConfiguration() {
        return numberDisplayFormatConfiguration;
    }

    /**
     * <p>
     * The percentage display format.
     * </p>
     * 
     * @return The percentage display format.
     */
    public final PercentageDisplayFormatConfiguration percentageDisplayFormatConfiguration() {
        return percentageDisplayFormatConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberDisplayFormatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(percentageDisplayFormatConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparisonFormatConfiguration)) {
            return false;
        }
        ComparisonFormatConfiguration other = (ComparisonFormatConfiguration) obj;
        return Objects.equals(numberDisplayFormatConfiguration(), other.numberDisplayFormatConfiguration())
                && Objects.equals(percentageDisplayFormatConfiguration(), other.percentageDisplayFormatConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComparisonFormatConfiguration")
                .add("NumberDisplayFormatConfiguration", numberDisplayFormatConfiguration())
                .add("PercentageDisplayFormatConfiguration", percentageDisplayFormatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberDisplayFormatConfiguration":
            return Optional.ofNullable(clazz.cast(numberDisplayFormatConfiguration()));
        case "PercentageDisplayFormatConfiguration":
            return Optional.ofNullable(clazz.cast(percentageDisplayFormatConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComparisonFormatConfiguration, T> g) {
        return obj -> g.apply((ComparisonFormatConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComparisonFormatConfiguration> {
        /**
         * <p>
         * The number display format.
         * </p>
         * 
         * @param numberDisplayFormatConfiguration
         *        The number display format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberDisplayFormatConfiguration(NumberDisplayFormatConfiguration numberDisplayFormatConfiguration);

        /**
         * <p>
         * The number display format.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumberDisplayFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link NumberDisplayFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumberDisplayFormatConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #numberDisplayFormatConfiguration(NumberDisplayFormatConfiguration)}.
         * 
         * @param numberDisplayFormatConfiguration
         *        a consumer that will call methods on {@link NumberDisplayFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numberDisplayFormatConfiguration(NumberDisplayFormatConfiguration)
         */
        default Builder numberDisplayFormatConfiguration(
                Consumer<NumberDisplayFormatConfiguration.Builder> numberDisplayFormatConfiguration) {
            return numberDisplayFormatConfiguration(NumberDisplayFormatConfiguration.builder()
                    .applyMutation(numberDisplayFormatConfiguration).build());
        }

        /**
         * <p>
         * The percentage display format.
         * </p>
         * 
         * @param percentageDisplayFormatConfiguration
         *        The percentage display format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageDisplayFormatConfiguration(PercentageDisplayFormatConfiguration percentageDisplayFormatConfiguration);

        /**
         * <p>
         * The percentage display format.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PercentageDisplayFormatConfiguration.Builder} avoiding the need to create one manually via
         * {@link PercentageDisplayFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PercentageDisplayFormatConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #percentageDisplayFormatConfiguration(PercentageDisplayFormatConfiguration)}.
         * 
         * @param percentageDisplayFormatConfiguration
         *        a consumer that will call methods on {@link PercentageDisplayFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #percentageDisplayFormatConfiguration(PercentageDisplayFormatConfiguration)
         */
        default Builder percentageDisplayFormatConfiguration(
                Consumer<PercentageDisplayFormatConfiguration.Builder> percentageDisplayFormatConfiguration) {
            return percentageDisplayFormatConfiguration(PercentageDisplayFormatConfiguration.builder()
                    .applyMutation(percentageDisplayFormatConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NumberDisplayFormatConfiguration numberDisplayFormatConfiguration;

        private PercentageDisplayFormatConfiguration percentageDisplayFormatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparisonFormatConfiguration model) {
            numberDisplayFormatConfiguration(model.numberDisplayFormatConfiguration);
            percentageDisplayFormatConfiguration(model.percentageDisplayFormatConfiguration);
        }

        public final NumberDisplayFormatConfiguration.Builder getNumberDisplayFormatConfiguration() {
            return numberDisplayFormatConfiguration != null ? numberDisplayFormatConfiguration.toBuilder() : null;
        }

        public final void setNumberDisplayFormatConfiguration(
                NumberDisplayFormatConfiguration.BuilderImpl numberDisplayFormatConfiguration) {
            this.numberDisplayFormatConfiguration = numberDisplayFormatConfiguration != null ? numberDisplayFormatConfiguration
                    .build() : null;
        }

        @Override
        public final Builder numberDisplayFormatConfiguration(NumberDisplayFormatConfiguration numberDisplayFormatConfiguration) {
            this.numberDisplayFormatConfiguration = numberDisplayFormatConfiguration;
            return this;
        }

        public final PercentageDisplayFormatConfiguration.Builder getPercentageDisplayFormatConfiguration() {
            return percentageDisplayFormatConfiguration != null ? percentageDisplayFormatConfiguration.toBuilder() : null;
        }

        public final void setPercentageDisplayFormatConfiguration(
                PercentageDisplayFormatConfiguration.BuilderImpl percentageDisplayFormatConfiguration) {
            this.percentageDisplayFormatConfiguration = percentageDisplayFormatConfiguration != null ? percentageDisplayFormatConfiguration
                    .build() : null;
        }

        @Override
        public final Builder percentageDisplayFormatConfiguration(
                PercentageDisplayFormatConfiguration percentageDisplayFormatConfiguration) {
            this.percentageDisplayFormatConfiguration = percentageDisplayFormatConfiguration;
            return this;
        }

        @Override
        public ComparisonFormatConfiguration build() {
            return new ComparisonFormatConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
