/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field well configuration of a waterfall visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaterfallChartAggregatedFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<WaterfallChartAggregatedFieldWells.Builder, WaterfallChartAggregatedFieldWells> {
    private static final SdkField<List<DimensionField>> CATEGORIES_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Categories")
            .getter(getter(WaterfallChartAggregatedFieldWells::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> VALUES_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(WaterfallChartAggregatedFieldWells::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionField>> BREAKDOWNS_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Breakdowns")
            .getter(getter(WaterfallChartAggregatedFieldWells::breakdowns))
            .setter(setter(Builder::breakdowns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Breakdowns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORIES_FIELD,
            VALUES_FIELD, BREAKDOWNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DimensionField> categories;

    private final List<MeasureField> values;

    private final List<DimensionField> breakdowns;

    private WaterfallChartAggregatedFieldWells(BuilderImpl builder) {
        this.categories = builder.categories;
        this.values = builder.values;
        this.breakdowns = builder.breakdowns;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The category field wells of a waterfall visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return The category field wells of a waterfall visual.
     */
    public final List<DimensionField> categories() {
        return categories;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value field wells of a waterfall visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The value field wells of a waterfall visual.
     */
    public final List<MeasureField> values() {
        return values;
    }

    /**
     * For responses, this returns true if the service returned a value for the Breakdowns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBreakdowns() {
        return breakdowns != null && !(breakdowns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The breakdown field wells of a waterfall visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBreakdowns} method.
     * </p>
     * 
     * @return The breakdown field wells of a waterfall visual.
     */
    public final List<DimensionField> breakdowns() {
        return breakdowns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBreakdowns() ? breakdowns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaterfallChartAggregatedFieldWells)) {
            return false;
        }
        WaterfallChartAggregatedFieldWells other = (WaterfallChartAggregatedFieldWells) obj;
        return hasCategories() == other.hasCategories() && Objects.equals(categories(), other.categories())
                && hasValues() == other.hasValues() && Objects.equals(values(), other.values())
                && hasBreakdowns() == other.hasBreakdowns() && Objects.equals(breakdowns(), other.breakdowns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaterfallChartAggregatedFieldWells").add("Categories", hasCategories() ? categories() : null)
                .add("Values", hasValues() ? values() : null).add("Breakdowns", hasBreakdowns() ? breakdowns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Breakdowns":
            return Optional.ofNullable(clazz.cast(breakdowns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WaterfallChartAggregatedFieldWells, T> g) {
        return obj -> g.apply((WaterfallChartAggregatedFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaterfallChartAggregatedFieldWells> {
        /**
         * <p>
         * The category field wells of a waterfall visual.
         * </p>
         * 
         * @param categories
         *        The category field wells of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<DimensionField> categories);

        /**
         * <p>
         * The category field wells of a waterfall visual.
         * </p>
         * 
         * @param categories
         *        The category field wells of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(DimensionField... categories);

        /**
         * <p>
         * The category field wells of a waterfall visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #categories(List<DimensionField>)}.
         * 
         * @param categories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(java.util.Collection<DimensionField>)
         */
        Builder categories(Consumer<DimensionField.Builder>... categories);

        /**
         * <p>
         * The value field wells of a waterfall visual.
         * </p>
         * 
         * @param values
         *        The value field wells of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<MeasureField> values);

        /**
         * <p>
         * The value field wells of a waterfall visual.
         * </p>
         * 
         * @param values
         *        The value field wells of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(MeasureField... values);

        /**
         * <p>
         * The value field wells of a waterfall visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #values(List<MeasureField>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<MeasureField>)
         */
        Builder values(Consumer<MeasureField.Builder>... values);

        /**
         * <p>
         * The breakdown field wells of a waterfall visual.
         * </p>
         * 
         * @param breakdowns
         *        The breakdown field wells of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder breakdowns(Collection<DimensionField> breakdowns);

        /**
         * <p>
         * The breakdown field wells of a waterfall visual.
         * </p>
         * 
         * @param breakdowns
         *        The breakdown field wells of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder breakdowns(DimensionField... breakdowns);

        /**
         * <p>
         * The breakdown field wells of a waterfall visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #breakdowns(List<DimensionField>)}.
         * 
         * @param breakdowns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #breakdowns(java.util.Collection<DimensionField>)
         */
        Builder breakdowns(Consumer<DimensionField.Builder>... breakdowns);
    }

    static final class BuilderImpl implements Builder {
        private List<DimensionField> categories = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> values = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionField> breakdowns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WaterfallChartAggregatedFieldWells model) {
            categories(model.categories);
            values(model.values);
            breakdowns(model.breakdowns);
        }

        public final List<DimensionField.Builder> getCategories() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<DimensionField.BuilderImpl> categories) {
            this.categories = DimensionFieldListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<DimensionField> categories) {
            this.categories = DimensionFieldListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(DimensionField... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<DimensionField.Builder>... categories) {
            categories(Stream.of(categories).map(c -> DimensionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getValues() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<MeasureField.BuilderImpl> values) {
            this.values = MeasureFieldListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<MeasureField> values) {
            this.values = MeasureFieldListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(MeasureField... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<MeasureField.Builder>... values) {
            values(Stream.of(values).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getBreakdowns() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.breakdowns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBreakdowns(Collection<DimensionField.BuilderImpl> breakdowns) {
            this.breakdowns = DimensionFieldListCopier.copyFromBuilder(breakdowns);
        }

        @Override
        public final Builder breakdowns(Collection<DimensionField> breakdowns) {
            this.breakdowns = DimensionFieldListCopier.copy(breakdowns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder breakdowns(DimensionField... breakdowns) {
            breakdowns(Arrays.asList(breakdowns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder breakdowns(Consumer<DimensionField.Builder>... breakdowns) {
            breakdowns(Stream.of(breakdowns).map(c -> DimensionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public WaterfallChartAggregatedFieldWells build() {
            return new WaterfallChartAggregatedFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
