/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the null value format configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NullValueFormatConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NullValueFormatConfiguration.Builder, NullValueFormatConfiguration> {
    private static final SdkField<String> NULL_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullString").getter(getter(NullValueFormatConfiguration::nullString))
            .setter(setter(Builder::nullString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NULL_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nullString;

    private NullValueFormatConfiguration(BuilderImpl builder) {
        this.nullString = builder.nullString;
    }

    /**
     * <p>
     * Determines the null string of null values.
     * </p>
     * 
     * @return Determines the null string of null values.
     */
    public final String nullString() {
        return nullString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nullString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NullValueFormatConfiguration)) {
            return false;
        }
        NullValueFormatConfiguration other = (NullValueFormatConfiguration) obj;
        return Objects.equals(nullString(), other.nullString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NullValueFormatConfiguration")
                .add("NullString", nullString() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NullString":
            return Optional.ofNullable(clazz.cast(nullString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NullValueFormatConfiguration, T> g) {
        return obj -> g.apply((NullValueFormatConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NullValueFormatConfiguration> {
        /**
         * <p>
         * Determines the null string of null values.
         * </p>
         * 
         * @param nullString
         *        Determines the null string of null values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullString(String nullString);
    }

    static final class BuilderImpl implements Builder {
        private String nullString;

        private BuilderImpl() {
        }

        private BuilderImpl(NullValueFormatConfiguration model) {
            nullString(model.nullString);
        }

        public final String getNullString() {
            return nullString;
        }

        public final void setNullString(String nullString) {
            this.nullString = nullString;
        }

        @Override
        public final Builder nullString(String nullString) {
            this.nullString = nullString;
            return this;
        }

        @Override
        public NullValueFormatConfiguration build() {
            return new NullValueFormatConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
