/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data path that needs to be sorted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPathValue implements SdkPojo, Serializable, ToCopyableBuilder<DataPathValue.Builder, DataPathValue> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(DataPathValue::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<String> FIELD_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldValue").getter(getter(DataPathValue::fieldValue)).setter(setter(Builder::fieldValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD,
            FIELD_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final String fieldValue;

    private DataPathValue(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.fieldValue = builder.fieldValue;
    }

    /**
     * <p>
     * The field ID of the field that needs to be sorted.
     * </p>
     * 
     * @return The field ID of the field that needs to be sorted.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The actual value of the field that needs to be sorted.
     * </p>
     * 
     * @return The actual value of the field that needs to be sorted.
     */
    public final String fieldValue() {
        return fieldValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(fieldValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPathValue)) {
            return false;
        }
        DataPathValue other = (DataPathValue) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(fieldValue(), other.fieldValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPathValue").add("FieldId", fieldId())
                .add("FieldValue", fieldValue() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "FieldValue":
            return Optional.ofNullable(clazz.cast(fieldValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataPathValue, T> g) {
        return obj -> g.apply((DataPathValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPathValue> {
        /**
         * <p>
         * The field ID of the field that needs to be sorted.
         * </p>
         * 
         * @param fieldId
         *        The field ID of the field that needs to be sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The actual value of the field that needs to be sorted.
         * </p>
         * 
         * @param fieldValue
         *        The actual value of the field that needs to be sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldValue(String fieldValue);
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private String fieldValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPathValue model) {
            fieldId(model.fieldId);
            fieldValue(model.fieldValue);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getFieldValue() {
            return fieldValue;
        }

        public final void setFieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        @Override
        public final Builder fieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
            return this;
        }

        @Override
        public DataPathValue build() {
            return new DataPathValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
