/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJournalS3ExportsForLedgerResponse extends QldbResponse implements
        ToCopyableBuilder<ListJournalS3ExportsForLedgerResponse.Builder, ListJournalS3ExportsForLedgerResponse> {
    private static final SdkField<List<JournalS3ExportDescription>> JOURNAL_S3_EXPORTS_FIELD = SdkField
            .<List<JournalS3ExportDescription>> builder(MarshallingType.LIST)
            .memberName("JournalS3Exports")
            .getter(getter(ListJournalS3ExportsForLedgerResponse::journalS3Exports))
            .setter(setter(Builder::journalS3Exports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JournalS3Exports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JournalS3ExportDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(JournalS3ExportDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListJournalS3ExportsForLedgerResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOURNAL_S3_EXPORTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<JournalS3ExportDescription> journalS3Exports;

    private final String nextToken;

    private ListJournalS3ExportsForLedgerResponse(BuilderImpl builder) {
        super(builder);
        this.journalS3Exports = builder.journalS3Exports;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the JournalS3Exports property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJournalS3Exports() {
        return journalS3Exports != null && !(journalS3Exports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The journal export jobs that are currently associated with the specified ledger.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJournalS3Exports} method.
     * </p>
     * 
     * @return The journal export jobs that are currently associated with the specified ledger.
     */
    public final List<JournalS3ExportDescription> journalS3Exports() {
        return journalS3Exports;
    }

    /**
     * <ul>
     * <li>
     * <p>
     * If <code>NextToken</code> is empty, then the last page of results has been processed and there are no more
     * results to be retrieved.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>NextToken</code> is <i>not</i> empty, then there are more results available. To retrieve the next page
     * of results, use the value of <code>NextToken</code> in a subsequent <code>ListJournalS3ExportsForLedger</code>
     * call.
     * </p>
     * </li>
     * </ul>
     * 
     * @return <li>
     *         <p>
     *         If <code>NextToken</code> is empty, then the last page of results has been processed and there are no
     *         more results to be retrieved.
     *         </p>
     *         </li> <li>
     *         <p>
     *         If <code>NextToken</code> is <i>not</i> empty, then there are more results available. To retrieve the
     *         next page of results, use the value of <code>NextToken</code> in a subsequent
     *         <code>ListJournalS3ExportsForLedger</code> call.
     *         </p>
     *         </li>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJournalS3Exports() ? journalS3Exports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJournalS3ExportsForLedgerResponse)) {
            return false;
        }
        ListJournalS3ExportsForLedgerResponse other = (ListJournalS3ExportsForLedgerResponse) obj;
        return hasJournalS3Exports() == other.hasJournalS3Exports()
                && Objects.equals(journalS3Exports(), other.journalS3Exports()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJournalS3ExportsForLedgerResponse")
                .add("JournalS3Exports", hasJournalS3Exports() ? journalS3Exports() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JournalS3Exports":
            return Optional.ofNullable(clazz.cast(journalS3Exports()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJournalS3ExportsForLedgerResponse, T> g) {
        return obj -> g.apply((ListJournalS3ExportsForLedgerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListJournalS3ExportsForLedgerResponse> {
        /**
         * <p>
         * The journal export jobs that are currently associated with the specified ledger.
         * </p>
         * 
         * @param journalS3Exports
         *        The journal export jobs that are currently associated with the specified ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journalS3Exports(Collection<JournalS3ExportDescription> journalS3Exports);

        /**
         * <p>
         * The journal export jobs that are currently associated with the specified ledger.
         * </p>
         * 
         * @param journalS3Exports
         *        The journal export jobs that are currently associated with the specified ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journalS3Exports(JournalS3ExportDescription... journalS3Exports);

        /**
         * <p>
         * The journal export jobs that are currently associated with the specified ledger.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qldb.model.JournalS3ExportDescription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qldb.model.JournalS3ExportDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qldb.model.JournalS3ExportDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #journalS3Exports(List<JournalS3ExportDescription>)}.
         * 
         * @param journalS3Exports
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qldb.model.JournalS3ExportDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #journalS3Exports(java.util.Collection<JournalS3ExportDescription>)
         */
        Builder journalS3Exports(Consumer<JournalS3ExportDescription.Builder>... journalS3Exports);

        /**
         * <ul>
         * <li>
         * <p>
         * If <code>NextToken</code> is empty, then the last page of results has been processed and there are no more
         * results to be retrieved.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>NextToken</code> is <i>not</i> empty, then there are more results available. To retrieve the next
         * page of results, use the value of <code>NextToken</code> in a subsequent
         * <code>ListJournalS3ExportsForLedger</code> call.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nextToken
         *        <li>
         *        <p>
         *        If <code>NextToken</code> is empty, then the last page of results has been processed and there are no
         *        more results to be retrieved.
         *        </p>
         *        </li> <li>
         *        <p>
         *        If <code>NextToken</code> is <i>not</i> empty, then there are more results available. To retrieve the
         *        next page of results, use the value of <code>NextToken</code> in a subsequent
         *        <code>ListJournalS3ExportsForLedger</code> call.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QldbResponse.BuilderImpl implements Builder {
        private List<JournalS3ExportDescription> journalS3Exports = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJournalS3ExportsForLedgerResponse model) {
            super(model);
            journalS3Exports(model.journalS3Exports);
            nextToken(model.nextToken);
        }

        public final List<JournalS3ExportDescription.Builder> getJournalS3Exports() {
            List<JournalS3ExportDescription.Builder> result = JournalS3ExportListCopier.copyToBuilder(this.journalS3Exports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJournalS3Exports(Collection<JournalS3ExportDescription.BuilderImpl> journalS3Exports) {
            this.journalS3Exports = JournalS3ExportListCopier.copyFromBuilder(journalS3Exports);
        }

        @Override
        public final Builder journalS3Exports(Collection<JournalS3ExportDescription> journalS3Exports) {
            this.journalS3Exports = JournalS3ExportListCopier.copy(journalS3Exports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder journalS3Exports(JournalS3ExportDescription... journalS3Exports) {
            journalS3Exports(Arrays.asList(journalS3Exports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder journalS3Exports(Consumer<JournalS3ExportDescription.Builder>... journalS3Exports) {
            journalS3Exports(Stream.of(journalS3Exports).map(c -> JournalS3ExportDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJournalS3ExportsForLedgerResponse build() {
            return new ListJournalS3ExportsForLedgerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
